PlayerBuffs = AsheylaLib:NewModule("PlayerBuffs","TimerLib","SpellLib","GUILib","KBLib","TimerLibGUI")

local defaultsettings
local hasenchant1,hasenchant2

local bufftarget = {
	target = "Buffs",
	text = "Buffs",
	sex = 0,
	level = 0,
	icon = 0,
	type = "player",
	priority = 0,
	norepeat = 1,
}

function PlayerBuffs:OnLoad()
	this:RegisterEvent("PLAYER_ENTERING_WORLD")
	self.updatebuffer = 5
end

function PlayerBuffs:OnEvent(event)
	if event == "PLAYER_ENTERING_WORLD" then self:Startup() -- when you first log in
	elseif self:HasRegisteredSettings() and self:Get("status") then
		self:ScanBuffs()
	end
end

function PlayerBuffs:ToggleBlizzFrames()
	if self:Get("status") then
		BuffFrame:Hide()
		TemporaryEnchantFrame:Hide()
		self:ScanBuffs()
	else
		BuffFrame:Show()
		TemporaryEnchantFrame:Show()
	end
end

function PlayerBuffs:CheckModule()
	local oldmodule = (self:Get("integrated") and self or PlayerDebuffs)
	local newmodule = (self:Get("integrated") and PlayerDebuffs or self)
	if oldmodule then
		local i = oldmodule:ReturnTargetTable("Buffs",0,0,self)
		if i then
			local targettable = {}
			self:PasteTable(targettable,bufftarget)
			targettable.module = self
			if not (newmodule == self) then targettable.priority = 1 end
			local targetindex = newmodule:AddTarget(targettable,nil,self)
			for id = 1,oldmodule:GetNumTimers(i) do
				local timer = oldmodule:GetTimer(i,id)
				local entry = self:AcquireTable(1)
				entry.spell = timer.spell
				entry.rank = timer.rank
				entry.texture = timer.texture
				entry.duration = timer.duration
				entry.time = timer.time
				entry.type = timer.type
				entry.infotype = timer.infotype
				entry.infoid = timer.infoid
				entry.english = timer.english
				entry.timeadded = 0
				entry.index = timer.index
				newmodule:AddTimer(targetindex,entry,1,self)
			end
			oldmodule:RemoveTarget(i) 
		end
	end
	for i = 1,newmodule:GetNumTargets() do
		for id = 1,newmodule:GetNumTimers(i) do
			local timer = newmodule:GetTimer(i,id)
			if timer.module == self then
				if string.find(timer.type,"buff") then
					timer.type = (timer.duration == 0 or self:Get("flagnoexp",string.lower(timer.spell))) and "buffnoexp" or "buff"
				else
					timer.type = (self:Get("flagnoexp",string.lower(timer.spell))) and "enchantnoexp" or "enchant"
				end
				timer.priority = self:GetPriority(timer.type)
			end
		end
	end
	newmodule:CreateInterface(1)
end

function PlayerBuffs:Startup() --called on first login per session, creates the default settings if needed or else just hides the interface and sets the scale
	self.frame = this
	self.frame:SetScript("OnUpdate",function(self,elapsed) PlayerBuffs:OnUpdate(elapsed) end)
	self:RegisterSettings()
	self:AddDefaultSettings(defaultsettings)
	ProfileLib:RegisterForProfiles(self)
	self:AddSettingsUpdateScript(function() PlayerBuffs:ToggleBlizzFrames() end)
	self:AddSettingsUpdateScript(function() PlayerBuffs:CheckModule() end)
	self:MakeSlashCmd("/playerbuffs","/pb")
	self:CreateTimerInstance()
	self:SetScript("OnDragClick",function(arg1) 
		PlayerBuffs:ProcessClick("Drag Icon",arg1)
	end)
	self:SetClickAction("Drag Icon","Addon Info",function()
		PlayerBuffs:Print("This is the |cff00ffffPlayerBuffs|r anchor.  Access |cff00ffffPlayerBuffs|r's menu by typing '|cff00ff00/pb|r'.  Hide me by checking the '|cff00ff00Locked|r' checkbutton in the menu.")
	end)
	self:SetScript("OnTimerClick",function(i,id,module,arg1)
		PlayerBuffs:ProcessClick("Timer",arg1,i,id,module)
	end)
	self:SetClickAction("Timer","Announce",function(i,id,module)
		PlayerBuffs:ToChat(module:GetTimer(i,id))
	end)
	self:SetClickAction("Timer","Hide",function(i,id,module)
		local timer = module:GetTimer(i,id)
		local frame = StaticPopup_Show("PlayerBuffs",timer.spell)
		frame.data = timer
		frame.data2 = module
	end)
	self:SetClickAction("Timer","Remove",function(i,id,module)
		local timer = module:GetTimer(i,id)
		if timer.index then
			if timer.type == "enchant" then
				CancelItemTempEnchantment(timer.index - 15)
			else
				CancelPlayerBuff(timer.index)
			end
		end
	end)
	self:SetScript("OnTimerEnter",function(i,id,module,this) 
		self:CreateTimerTooltip(module:GetTimer(i,id),this) 
	end)
	StaticPopupDialogs["PlayerBuffs"] = {
		text = "Are you sure you want to hide the timer for %s?",
		button1 = "Yes",
		button2 = "No",
		OnAccept = function(timer,module) timer.module:Set("hidden",string.lower(timer.spell),1); module:UpdateSettings() end,
		whileDead = 1,
		hideOnEscape = 1,
		timeout = 0,
	}
	self:CreateTimerGroup(
		"enchant",true,true,true,true,1,{
			begin = {
				r = .2,
				g = 1.0,
				b = .2,
			},
			half = {
				r = 1.0,
				g = 1.0,
				b = .2,
			},
			final = {
				r = 1.0,
				g = .2,
				b = .2,
			},
		}
	)
	self:CreateTimerGroup(
		"enchantnoexp",true,false,false,true,.5,{
			begin = {
				r = .2,
				g = 1.0,
				b = .2,
			},
			half = {
				r = .2,
				g = 1.0,
				b = .2,
			},
			final = {
				r = .2,
				g = 1.0,
				b = .2,
			},
		}
	)
	self:CreateTimerGroup(
		"buffnoexp",true,false,false,true,.5,{
			begin = {
				r = .2,
				g = 1.0,
				b = .2,
			},
			half = {
				r = .2,
				g = 1.0,
				b = .2,
			},
			final = {
				r = .2,
				g = 1.0,
				b = .2,
			},
		}
	)
	self:CreateTimerGroup(
		"buff",true,true,true,true,1,{
			begin = {
				r = .2,
				g = 1.0,
				b = .2,
			},
			half = {
				r = 1.0,
				g = 1.0,
				b = .2,
			},
			final = {
				r = 1.0,
				g = .2,
				b = .2,
			},
		}
	)
	self:Hook(self,"UpdateTimers","post",function()
		local time = GetTime()
		local refresh
		for i = 1,self:GetNumTargets() do
			for id = 1,self:GetNumTimers(i) do
				local timer = self:GetTimer(i,id)
				if (not string.find(timer.type,"enchant")) and (not timer.finished) then
					local timeleft = GetPlayerBuffTimeLeft(timer.index)
					if not (math.abs((timer.duration - time + timer.time) - timeleft) <= .1) then
						timer.time = time
						timer.duration = timeleft
						timer.displayed = nil
						refresh = true
					end
				end
			end
		end
		if refresh then self:CreateInterface() end
	end)
	this:UnregisterEvent("PLAYER_ENTERING_WORLD")
	this:RegisterEvent("PLAYER_AURAS_CHANGED")
	self:ToggleBlizzFrames()
end

function PlayerBuffs:OnUpdate(elapsed)
	self.updatebuffer = self.updatebuffer - elapsed
	if self.updatebuffer <= 0 then
		self.updatebuffer = 5
		local module = self:Get("integrated") and PlayerDebuffs or self
		local refresh
		local hasMainHandEnchant, mainHandExpiration, mainHandCharges, hasOffHandEnchant, offHandExpiration, offHandCharges = GetWeaponEnchantInfo()
		local i = module:ReturnTargetTable("Buffs",0,0,self)
		if hasMainHandEnchant then
			local adding = true
			local timeleft = mainHandExpiration / 1000
			if i then
				for id = 1,module:GetNumTimers(i) do
					local timer = module:GetTimer(i,id)
					if timer.module == self and (timer.type == "enchant" or timer.type == "enchantnoexp") and timer.index == 16 then 
						self:ResetTimerFlags(timer)
						adding = false
						timer.stack = mainHandCharges
						if not (math.abs((timer.duration - GetTime() + timer.time) - timeleft) <= .1) then
							timer.time = GetTime()
							timer.duration = timeleft
							timer.displayed = nil
							refresh = true
						end
					end
				end
			end
			if adding then
				hasenchant1 = true
				local spelltable = self:AcquireTable(1)
				spelltable.spell = GetItemInfo(GetInventoryItemLink("player",16))
				spelltable.rank = ""
				spelltable.type = self:Get("flagnoexp",string.lower(spelltable.spell)) and "enchantnoexp" or "enchant"
				spelltable.texture = GetInventoryItemTexture("player",16)
				spelltable.duration = timeleft
				spelltable.time = GetTime()
				spelltable.stack = mainHandCharges
				spelltable.validated = true
				spelltable.index = 16
				spelltable.priority = self:GetPriority(spelltable.type)
				if not i then
					local targettable = self:AcquireTable(1)
					self:PasteTable(targettable,bufftarget)
					targettable.module = self
					if not (module == self) then targettable.priority = 1 end
					i = module:AddTarget(targettable,nil,self)
				end
				module:AddTimer(i,spelltable,1,self)
				refresh = true
			end
		else
			if hasenchant1 and i then
				for id = 1,module:GetNumTimers(i) do
					local timer = module:GetTimer(i,id)
					if timer.type == "enchant" and timer.index == 16 then 
						refresh = true
						module:RemoveTimer(i,id,"broke",1) 
						hasenchant1 = false
						break 
					end
				end
			end
		end
		if hasOffHandEnchant then
			local adding = true
			local timeleft = offHandExpiration / 1000
			if i then
				for id = 1,module:GetNumTimers(i) do
					local timer = module:GetTimer(i,id)
					if timer.module == self and (timer.type == "enchant" or timer.type == "enchantnoexp") and timer.index == 17 then 
						self:ResetTimerFlags(timer)
						adding = false
						timer.stack = offHandCharges
						if not (math.abs((timer.duration - GetTime() + timer.time) - timeleft) <= .1) then
							timer.time = GetTime()
							timer.duration = timeleft
							timer.displayed = nil
							refresh = true
						end
					end
				end
			end
			if adding then
				hasenchant2 = true
				local spelltable = self:AcquireTable(1)
				spelltable.spell = GetItemInfo(GetInventoryItemLink("player",17))
				spelltable.rank = ""
				spelltable.type = self:Get("flagnoexp",string.lower(spelltable.spell)) and "enchantnoexp" or "enchant"
				spelltable.texture = GetInventoryItemTexture("player",17)
				spelltable.duration = timeleft
				spelltable.time = GetTime()
				spelltable.stack = offHandCharges
				spelltable.validated = true
				spelltable.index = 17
				spelltable.priority = self:GetPriority(spelltable.type)
				if not i then
					local targettable = self:AcquireTable(1)
					self:PasteTable(targettable,bufftarget)
					targettable.module = self
					if not (module == self) then targettable.priority = 1 end
					i = module:AddTarget(targettable,nil,self)
				end
				module:AddTimer(i,spelltable,1,self)
				refresh = true
			end
		else
			if hasenchant2 and i then
				for id = 1,module:GetNumTimers(i) do
					local timer = module:GetTimer(i,id)
					if timer.type == "enchant" and timer.index == 17 then 
						refresh = true
						module:RemoveTimer(i,id,"broke",1) 
						hasenchant2 = false
						break 
					end
				end
			end
		end
		if refresh then module:CreateInterface(1) end
	end
end

function PlayerBuffs:ScanBuffs()
	local timertable
	local refresh
	local targettable
	local module = self:Get("integrated") and PlayerDebuffs or self
	local targetindex = module:ReturnTargetTable("Buffs",0,0,self)
	if targetindex then
		for id = 1,module:GetNumTimers(targetindex) do
			local timer = module:GetTimer(targetindex,id)
			if timer.module == self and (timer.type == "buff" or timer.type == "buffnoexp") then
				timer.validated = nil
			end
		end
		targettable = module:GetTarget(targetindex)
	end
	local i = 1
	local buff = GetPlayerBuff(i,"HELPFUL")
	while buff > 0 do
		local name,rank = GetPlayerBuffName(buff)
		local timeleft = GetPlayerBuffTimeLeft(buff)
		local count = GetPlayerBuffApplications(buff)
		local adding = true
		local timertype = ((timeleft == 0 or self:Get("flagnoexp",string.lower(name))) and "buffnoexp" or "buff")
		if targetindex then
			for id = 1,module:GetNumTimers(targetindex) do
				local timer = module:GetTimer(targetindex,id)
				if timer.spell == name and timer.module == self and timer.type == timertype then
					timer.validated = true
					timer.index = buff
					adding = false
					self:ResetTimerFlags(timer)
					if not (math.abs((timer.duration - GetTime() + timer.time) - timeleft) <= .1) then
						timer.time = GetTime()
						timer.duration = timeleft
						timer.displayed = nil
						refresh = true
					end
					if not (count == timer.stack) then
						timer.stack = count
					end
					break
				end
			end
		end
		if adding then
			if not targettable then
				targettable = self:AcquireTable(1)
				self:PasteTable(targettable,bufftarget)
				targettable.module = self
				if not (module == self) then targettable.priority = 1 end
			end
			local spelltable = self:AcquireTable(1)
			spelltable.spell = name
			spelltable.rank = rank
			spelltable.texture = GetPlayerBuffTexture(buff)
			spelltable.duration = timeleft
			spelltable.time = GetTime()
			spelltable.type = timertype
			spelltable.stack = count
			spelltable.validated = true
			spelltable.index = buff
			spelltable.priority = self:GetPriority(timertype)
			if not timertable then timertable = self:AcquireTable() end
			table.insert(timertable,spelltable)
		end
		i = i + 1
		buff = GetPlayerBuff(i,"HELPFUL")
	end
	if targetindex then
		for id = module:GetNumTimers(targetindex),1,-1 do
			local timer = module:GetTimer(targetindex,id)
			if timer then
				if timer.module == self and (timer.type == "buff" or timer.type == "buffnoexp") and not timer.validated then
					refresh = true
					module:RemoveTimer(targetindex,id,"broke",1)
				end
			end
		end
		if timertable then
			for i,v in ipairs(timertable) do 
				module:AddTimer(targetindex,v,1,self) 
			end
			local flag = refresh
			refresh = false
			module:CreateInterface(flag)
		end
	elseif targettable then 
		targetindex = module:AddTarget(targettable,nil,self)
		for i,v in ipairs(timertable) do
			module:AddTimer(targetindex,v,1,self) 
		end
		local flag = refresh
		refresh = false
		module:CreateInterface(flag)
	end
	if refresh then module:CreateInterface(1) end
end

function PlayerBuffs:CreateTimerTooltip(d,frame)
	if self:Get("tooltips") and d.index then
		GameTooltip:SetOwner(frame,"ANCHOR_RIGHT")
		if d.type == "enchant" then
			GameTooltip:SetInventoryItem("player",d.index)
		else
			GameTooltip:SetPlayerBuff(d.index)
		end
		GameTooltip:AddLine(" ",1,1,1,1)
		GameTooltip:AddLine(self:GetKeyBinding("Timer","Announce").." to announce.",1,1,1,1)
		GameTooltip:AddLine(self:GetKeyBinding("Timer","Remove").." to remove.",1,1,1,1)
		GameTooltip:AddLine(self:GetKeyBinding("Timer","Hide").." to hide.",1,1,1,1)
		GameTooltip:Show()
	end
end

local chatsubentries = {}
function PlayerBuffs:ToChat(d)
	for i,v in pairs(chatsubentries) do chatsubentries[i] = nil end
	local displayed = d.displayed
	local spell = d.spell
	local rank = d.rank
	if (spell and rank) then
		local unsubbedmsg
		if (d.type == "buffnoexp" or d.type == "enchantnoexp") then
			chatsubentries["%s"] = spell
			chatsubentries["%r"] = rank
			unsubbedmsg = self:Get("chatmsgnoexpire")	
		elseif d.type == "enchant" then
			displayed = self:ReturnFormattedDuration(displayed)
			chatsubentries["%d"] = displayed
			chatsubentries["%s"] = spell
			chatsubentries["%r"] = rank
			unsubbedmsg = self:Get("chatmsgwep")	
		else
			displayed = self:ReturnFormattedDuration(displayed)
			chatsubentries["%d"] = displayed
			chatsubentries["%s"] = spell
			chatsubentries["%r"] = rank
			unsubbedmsg = self:Get("chatmsgnormal")
		end
		local chat = "SAY"
		if GetNumRaidMembers() > 0 then chat = "RAID" elseif GetNumPartyMembers() > 0 then chat = "PARTY" end
		local msg = string.gsub(unsubbedmsg,"(%%%a)",function(a) return chatsubentries[a] or "" end)
		msg = string.gsub(msg,"%(%)","")
		SendChatMessage(msg,chat)
	end
end

function PlayerBuffs:GetPriority(type)
	local p1 = self:Get("priority1")
	local p2 = self:Get("priority2")
	local p3 = self:Get("priority3")
	if p1 == "none" then return 0 
	elseif p1 == "No Duration" and (type == "buffnoexp" or type == "enchantnoexp") then return 0
	elseif p1 == "Standard Buff" and type == "buff" then return 0
	elseif p1 == "Weapon Enchant" and type == "enchant" then return 0
	elseif p2 == "none" then return 1
	elseif p2 == "No Duration" and (type == "buffnoexp" or type == "enchantnoexp") then return 1
	elseif p2 == "Standard Buff" and type == "buff" then return 1
	elseif p2 == "Weapon Enchant" and type == "enchant" then return 1
	elseif p3 == "none" then return 2
	elseif p3 == "No Duration" and (type == "buffnoexp" or type == "enchantnoexp") then return 2
	elseif p3 == "Standard Buff" and type == "buff" then return 2
	elseif p3 == "Weapon Enchant" and type == "enchant" then return 2
	else return 3 --should never hit this.
	end
end

function PlayerBuffs:Commands() --governs the /command
	self:ShowGUI()
end

defaultsettings = {
	tooltips = true,
	chatmsgnormal = "My %s will expire in %d.",
	chatmsgnoexpire = "I currently have the '%s' buff.",
	chatmsgwep = "My %s's enchant will expire in %d.",
	keybindings = {
		["Drag Icon"] = {
			["Addon Info"] = "1",
		},
		["Timer"] = {
			["Announce"] = "1",
			["Remove"] = "2",
			["Hide"] = "s-2",
		},
	},
	integrated = false,
	priority1 = "none", --valid strings: "none", "Weapon Enchant", "Standard Buff", "No Duration"
	priority2 = "none",
	priority3 = "none",
	flagnoexp = {},
	names = false,
	status = false,
	raidicons = false,
}
