local scripts = {
	checkbutton = {
		OnShow = function() this:SetChecked(this.self:Get(this.setting)) end,
		OnClick = function() this.self:Set(this.setting,this:GetChecked() and true or false); this.self:UpdateSettings() end,
	},
	checkbutton2 = {
		OnShow = function() this:SetChecked(this.self:Get(this.setting)) end,
		OnClick = function() this.self:Set(this.setting,this:GetChecked() and true or false); Notifications:ToggleCombatRegX() end,
	},
	slider = {
		OnValueChanged = function()
			local value = this:GetValue()
			local formatstring
			if math.floor(value) == value then 
				formatstring = "%d"
			else
				formatstring = "%.2f"
			end
			getglobal(this:GetName().."Value"):SetText(string.format(formatstring,value))
		end,
	},
	editbox = {
		OnEditFocusGained = function() this:HighlightText() end,
		OnEditFocusLost = function() this:HighlightText(0,0) end,
		OnEscapePressed = function()
			local text = this:GetText()
			if text == "" then
				this:ClearFocus()
			else
				this:SetText("")
			end
		end,
		OnEnterPressed = function() this:ClearFocus() end,
	},
	dropdown = {
		OnShow = function()
			getglobal(this:GetName().."Text"):SetText(this.text)
		end,
	},
}

local action
local function dropdown()
	local DROPDOWNLIB_MENU_LEVEL = DropDownLib:MenuLevel()
	local DROPDOWNLIB_MENU_VALUE = DropDownLib:MenuValue()
	if DROPDOWNLIB_MENU_LEVEL == 1 then
		local info = DropDownLib:GetTable()
		info.notCheckable = 1
		info.hasArrow = 1
		info.value = "create"
		info.text = "Create New"
		DropDownLib:AddButton(info,1)
		info = DropDownLib:GetTable()
		info.notCheckable = 1
		info.hasArrow = 1
		info.value = "manage"
		info.text = "Manage Existing"
		DropDownLib:AddButton(info,1)
	else
		if DROPDOWNLIB_MENU_LEVEL == 2 then action = DROPDOWNLIB_MENU_VALUE end
		if action == "create" then
			Notifications:DropDownCreate()
		elseif action == "manage" then
			Notifications:DropDownManage()
		end
	end
end

local function colordropdown()
	local info
	local DROPDOWNLIB_MENU_LEVEL = DropDownLib:MenuLevel()
	local DROPDOWNLIB_MENU_VALUE = DropDownLib:MenuValue()
	if DROPDOWNLIB_MENU_LEVEL == 2 then
		local subtype = DROPDOWNLIB_MENU_VALUE
		for index,value in ipairs({"begin","half","final"}) do
			info = DropDownLib:GetTable()
			info.text = value
			info.notCheckable = 1
			info.hasColorSwatch = 1
			info.r = Notifications:Get("colors",category,subcat,value,"r") or Notifications:GetTimerData()[subcat].colors[value]["r"]
			info.g = Notifications:Get("colors",category,subcat,value,"g") or Notifications:GetTimerData()[subcat].colors[value]["g"]
			info.b = Notifications:Get("colors",category,subcat,value,"b") or Notifications:GetTimerData()[subcat].colors[value]["b"]
			info.swatchFunc = function()
				local r,g,b = DropDownLibColorPicker:GetColorRGB()
				Notifications:Set("colors",category,subcat,value,"r",r)
				Notifications:Set("colors",category,subcat,value,"g",g)
				Notifications:Set("colors",category,subcat,value,"b",b)
				for i,v in ipairs({"begin","half","final"}) do
					if not Notifications:Get("colors",category,subcat,v) then
						Notifications:Set("colors",category,subcat,v,"r",Notifications:GetTimerData()[subcat].colors[v]["r"])
						Notifications:Set("colors",category,subcat,v,"g",Notifications:GetTimerData()[subcat].colors[v]["g"])
						Notifications:Set("colors",category,subcat,v,"b",Notifications:GetTimerData()[subcat].colors[v]["b"])
					end
				end
				Notifications:UpdateSettings()
			end
			DropDownLib:AddButton(info,2)
		end
	elseif DROPDOWNLIB_MENU_LEVEL == 1 then
		info = DropDownLib:GetTable()
		info.text = "All Timers"
		local checked
		if Notifications:Get("colors","type","default") then checked = 1 end
		info.checked = checked
		info.value = "default"
		info.hasArrow = 1
		info.func = function() 
			if checked then 
				Notifications:Set("colors","type","default",nil) 
				Notifications:UpdateSettings()
			end 
		end
		DropDownLib:AddButton(info,1)
	end
end

local barmsgcodes = {
	["%s"] = "spell name",
	["%d"] = "time remaining",
	["%t"] = "spell's target",
}

local guitable = {
	title = "Notifications Main Menu",
	name = "NotificationsMenuFrame",
	scripts = {
		OnShow = function() Notifications:ClearData() end,
	},
	{ --column 1
		{
			title = "Begin Here!",
			type = "dropdown",
			tooltiptext = "Choose an action.",
			func = dropdown,
			scripts = scripts.dropdown,
			data = {
				text = "Choose..."
			},
		},
		{
			{
				title = "Trigger",
				name = "NotificationsTriggerEditBox",
				type = "editbox",
				tooltiptext = "Enter here the name of the spell, item, debuff, or buff you want to be the trigger.  Enter 'all' to make anything trigger it.",
				scripts = scripts.editbox,
				overridescripts = {
					OnTextChanged = function() 
						local text = this:GetText() 
						if text == "all" or Notifications:GetCurrent("event") == "Combat Log" then 
							NotificationsPartialCheckButton:Hide()
						else 
							NotificationsPartialCheckButton:Show() 
						end 
					end,
				},
			},
			{
				title = "Stat Amount",
				name = "NotificationsStatEditBox",
				type = "editbox",
				tooltiptext = "Enter here amount of health or mana/energy/rage you want to trigger the Notification.  Prefix the number with a '+' if you want it sent after the stat INCREASES to that amount, or a '-' for when it DECREASES to that amount.  Append the number with a '%' to make the number act as a percentage.",
				scripts = scripts.editbox,
			},
		},
		{
			title = "Usage",
			type = "slider",
			name = "NotificationsUsageSlider",
			tooltiptext = "Set to 0 for this Notification to be sent all the time, or a positive number for it to be picked from randomly amongst all others you select as positive numbers for this event+trigger pair.  The actual number represents the percent chance a random Notification is sent at all (100 for one to be picked all the time, 5 for 5% of the time, etc.).",
			scripts = {
				OnValueChanged = function()
					local value = this:GetValue()
					local text
					if value == 0 then
						text = "all"
					else
						text = string.format("Rand (%d)",value)
					end
					getglobal(this:GetName().."Value"):SetText(text)
				end,
			},
			lowval = 0,
			highval = 100,
			step = 5,
		},
		{
			{
				title = "Message",
				name = "NotificationsFormatEditBox",
				type = "editbox",
				tooltiptext = "Enter here the message you want sent.  Use %s for the trigger, %t for the target (if applicable), and %d for amount of damage (if applicable).",
				scripts = scripts.editbox,
			},
			{
				title = "Timer Info",
				name = "NotificationsTimerEditBox",
				type = "editbox",
				tooltiptext = "Enter here information about the timer you want created.  It must be in this format: 'Target:... Spell:... Duration:...', where you put whatever you want in the '...'s.  E.g.:'Target:Oh Noes! Spell:%s Duration:5m30s'.  They must be in the proper order and properly capitalized!  If you do not want a target name, set it to 'NONE', e.g. 'Target:NONE'.  ",
				scripts = scripts.editbox,
			},
			{
				title = "Sound File",
				name = "NotificationsSoundEditBox",
				type = "editbox",
				tooltiptext = "Enter here sound file that should be played.  This file should be placed in the 'Files' folder of the 'Ash_Core' addon. The only default sound is expalert.wav.",
				scripts = scripts.editbox,
			},
		},
		{
			{
				title = "Chat Channel",
				name = "NotificationsChatEditBox",
				type = "editbox",
				tooltiptext = "Enter here the chat you want your message sent to. Type 'auto' for auto selection of 'raid' or 'party' (if not grouped, no msg will be sent), a number or the channel name for a specific chat channel, 'whisper' for it to be sent as a whisper to the target, 'raid_warning' for a raid warning, 'emote' for an emote (a single-word entry will attempt to do a /emote; multiple words will do /me <msg>).",
				scripts = scripts.editbox,
				overridescripts = {
					OnTextChanged = function() 
						local text = this:GetText() 
						if text == "whisper" then 
							NotificationsWhisperTargetEditBox:Show()
						else 
							NotificationsWhisperTargetEditBox:Show() 
						end 
					end,
				},
			},
			{
				title = "Offset",
				type = "slider",
				name = "NotificationsAlertLocSlider",
				tooltiptext = "Enter here the offset from the center of your screen you want your alert to appear.  Positive means up, negative means down.",
				scripts = scripts.slider,
				lowval = -150,
				highval = 150,
				step = 5,
			},
		},
		{
			{
				title = "Time",
				name = "NotificationsTimeEditBox",
				type = "editbox",
				tooltiptext = "Enter here how many seconds you want to remain on the timer when this event is sent.  Only integer amounts are accepted.  This will map to '%d' if your type has a message.  You can use 's','m','h', or 'd' to represent seconds, minutes, hours, or days, e.g. '5m 2s'.",
				scripts = scripts.editbox,
			},
			{
				title = "Target",
				name = "NotificationsWhisperTargetEditBox",
				type = "editbox",
				tooltiptext = "Enter here the name of the person you want your whisper sent to (leaving this field blank is the same as setting it to '%t').",
				scripts = scripts.editbox,
			},
		},
	},
	{ --column 2
		{
			title = "Enabled",
			type = "checkbutton",
			tooltiptext = "Check this to enable the addon; uncheck to disable.",
			scripts = scripts.checkbutton,
			data = {
				setting = "status",
			},
		},
		{
			title = "Combat RegX",
			type = "checkbutton",
			tooltiptext = "Check this to enable combat log scanning; uncheck to disable.",
			scripts = scripts.checkbutton2,
			data = {
				setting = "combatregx",
			},
		},
		{
			title = "Colors",
			type = "dropdown",
			tooltiptext = "Lets you set the color of timers.",
			func = colordropdown,
			scripts = scripts.dropdown,
			data = {
				text = "Choose...",
			},
		},
		{
			title = "Key Bindings",
			type = "dropdown",
			tooltiptext = [[
				Lets you customize the keybindings for certain actions.
				
				If you are attempting to change the keybinding, just click on the final selection to finish (e.g., click 'Left Click' to just set to left-click, or if you want shift-leftclick move your mouse to the 'Shift' selection that appeared, etc.)]],
			func = function() Notifications:KBDropDown() end,
			scripts = scripts.dropdown,
			data = {
				text = "Choose...",
			},
		},
		"BREAK",
		{
			title = "Color",
			name = "NotificationsColorSwatch",
			type = "colorselect",
			tooltiptext = "Click this icon to choose the color for the message being sent.",
		},
		{
			title = "Partial Matches",
			name = "NotificationsPartialCheckButton",
			type = "checkbutton",
			tooltiptext = "Check this to look for partial matches of the text you entered for the trigger; uncheck to look for an exact match.",
		},
		{
			title = "Create!",
			name = "NotificationsDoneButton",
			type = "button",
			tooltiptext = "Creates the Notification.",
			scripts = {
				OnClick = function() Notifications:ParseMenu() end,
			},
		},
		{
			title = "Profiles",
			type = "button",
			tooltiptext = "Opens the Profile Creator menu.",
			buffer = 10,
			scripts = {
				OnClick = function() ProfileLib:ShowGUI() end,
			},
		},
		{
			title = "Timer Settings",
			type = "button",
			tooltiptext = "Opens the options window for customizing the timers that can be made.",
			scripts = {
				OnClick = function() Notifications:ShowTimerGUI(barmsgcodes,nil,nil,"Hidden Timers","Hide All","Hidden Types","Raid Icons","Max Targets"); end,
			},
		},
		{
			title = "Close",
			type = "button",
			tooltiptext = "Closes this window.",
			scripts = {
				OnClick = function() this.holder.place.column.menu:Hide() end,
			},
		},
	},
}

function Notifications:ShowGUI()
	if not NotificationsMenuFrame then
		Notifications:CreateGUI(guitable)
		local f = NotificationsMenuFrame:CreateFontString("NotificationsMenuFrameInfo")
		f:SetPoint("TOPLEFT","NotificationsMenuFrame","BOTTOMLEFT",9,0)
		f:SetFontObject(GameFontHighlight)
		f:SetJustifyH("LEFT")
	end
	NotificationsMenuFrame:Show()
end
