local scripts = {
	checkbutton = {
		OnShow = function() this:SetChecked(this.self:Get(this.setting)) end,
		OnClick = function() this.self:Set(this.setting,this:GetChecked() and true or false); this.self:UpdateSettings() end,
	},
	slider = {
		OnShow = function() this.real = false this:SetValue(this.self:Get(this.setting)) this.real = true end,
		OnValueChanged = function()
			local value = this:GetValue()
			local formatstring
			if math.floor(value) == value then 
				formatstring = "%d"
			else
				formatstring = "%.2f"
			end
			getglobal(this:GetName().."Value"):SetText(string.format(formatstring,value))
			if this.real then
				this.self:Set(this.setting,value)
				this.self:UpdateSettings()
			end
		end,
	},
	editbox1 = { --initialized with a string
		OnEditFocusGained = function() this:SetText(this.self:Get(this.setting) or ""); this:HighlightText() end,
		OnEditFocusLost = function() this:HighlightText(0,0) end,
		OnShow = function() this:SetText(this.self:Get(this.setting) or "") end,
		OnEscapePressed = function()
			local text = this:GetText()
			if text == "" then
				this:ClearFocus()
			else
				this:SetText("")
			end
		end,
		OnEnterPressed = function() 
			local text = this:GetText()
			this.self:Print("|cff00ffff",this.self:GetName(),"|r: New setting: ",text)
			this.self:Set(this.setting,text); this.self:UpdateSettings(); this:ClearFocus() 
		end,
	},
	editbox2 = { --left blank, OnEnterPressed and OnEnter will be defined elsewhere
		OnEditFocusGained = function() this:SetText("") end,
		OnEditFocusLost = function() this:SetText("") end,
		OnEscapePressed = function()
			local text = this:GetText()
			if text == "" then
				this:ClearFocus()
			else
				this:SetText("")
			end
		end,
	},
	dropdown = {
		OnShow = function()
			getglobal(this:GetName().."Text"):SetText(this.text)
		end,
	},
}

local sortingtable = {}
local function sorttable(pretable)
	for index,value in pairs(sortingtable) do sortingtable[index] = nil end
	for index,value in pairs(pretable) do table.insert(sortingtable,index) end
	table.sort(sortingtable)
	return sortingtable
end

local types = {
	["Harmful"] = "debuff",
	["Helpful"] = "buff",
	["No Target"] = "notarget",
}

local orderedtypes = {
	"Harmful",
	"Helpful",
	"No Target",
}

local barmsgcodes = {
	["%s"] = "spell name",
	["%r"] = "spell rank",
	["%d"] = "time remaining",
	["%c"] = "spell count (number of applications)",
	["%t"] = "spell's target",
	["%l"] = "target's level",
}

local category

local function colordropdown()
	local info
	local DROPDOWNLIB_MENU_LEVEL = DropDownLib:MenuLevel()
	local DROPDOWNLIB_MENU_VALUE = DropDownLib:MenuValue()
	if DROPDOWNLIB_MENU_LEVEL == 4 then
		local subcat = DROPDOWNLIB_MENU_VALUE
		for index,value in ipairs({"begin","half","final"}) do
			info = DropDownLib:GetTable()
			info.text = value
			info.notCheckable = 1
			info.hasColorSwatch = 1
			info.r = DoTimer:Get("colors",category,subcat,value,"r") or 1
			info.g = DoTimer:Get("colors",category,subcat,value,"g") or 1
			info.b = DoTimer:Get("colors",category,subcat,value,"b") or 1
			info.swatchFunc = function()
				local r,g,b = DropDownLibColorPicker:GetColorRGB()
				DoTimer:Set("colors",category,subcat,value,"r",r)
				DoTimer:Set("colors",category,subcat,value,"g",g)
				DoTimer:Set("colors",category,subcat,value,"b",b)
				for i,v in ipairs({"begin","half","final"}) do
					if not DoTimer:Get("colors",category,subcat,v) then
						DoTimer:Set("colors",category,subcat,v,"r",r)
						DoTimer:Set("colors",category,subcat,v,"g",g)
						DoTimer:Set("colors",category,subcat,v,"b",b)
					end
				end
				DoTimer:UpdateSettings()
			end
			DropDownLib:AddButton(info,4)
		end
	elseif DROPDOWNLIB_MENU_LEVEL == 3 then
		if category == "timer" then
			local entries = DoTimer:AcquireTable()
			local tab = DROPDOWNLIB_MENU_VALUE
			for i = 1,GetNumSpellTabs() do
				local name,_,offset,numspells = GetSpellTabInfo(i)
				if name == tab then
					for id = offset + 1,offset + numspells do
						local spell = GetSpellName(id,BOOKTYPE_SPELL)
						entries[spell] = 1
					end
					break
				end
			end
			local seductionname = DoTimer:ToLocale("Seduction")
			if not (seductionname == "unknown") then entries[seductionname] = 1 end
			entries = sorttable(entries)
			for index,value in ipairs(entries) do
				info = DropDownLib:GetTable()
				info.text = value
				local checked
				if DoTimer:Get("colors","timer",value) then checked = 1 end
				info.checked = checked
				info.value = value
				info.hasArrow = 1
				info.func = function() 
					if checked then 
						DoTimer:Set("colors","timer",value,nil) 
						DoTimer:UpdateSettings()
					end 
				end
				DropDownLib:AddButton(info,3)
			end
		elseif category == "type" then
			local subcat = DROPDOWNLIB_MENU_VALUE
			for index,value in ipairs({"begin","half","final"}) do
				info = DropDownLib:GetTable()
				info.text = value
				info.notCheckable = 1
				info.hasColorSwatch = 1
				info.r = DoTimer:Get("colors",category,subcat,value,"r") or DoTimer:GetTimerData()[subcat].colors[value]["r"]
				info.g = DoTimer:Get("colors",category,subcat,value,"g") or DoTimer:GetTimerData()[subcat].colors[value]["g"]
				info.b = DoTimer:Get("colors",category,subcat,value,"b") or DoTimer:GetTimerData()[subcat].colors[value]["b"]
				info.swatchFunc = function()
					local r,g,b = DropDownLibColorPicker:GetColorRGB()
					DoTimer:Set("colors",category,subcat,value,"r",r)
					DoTimer:Set("colors",category,subcat,value,"g",g)
					DoTimer:Set("colors",category,subcat,value,"b",b)
					for i,v in ipairs({"begin","half","final"}) do
						if not DoTimer:Get("colors",category,subcat,v) then
							DoTimer:Set("colors",category,subcat,v,"r",DoTimer:GetTimerData()[subcat].colors[v]["r"])
							DoTimer:Set("colors",category,subcat,v,"g",DoTimer:GetTimerData()[subcat].colors[v]["g"])
							DoTimer:Set("colors",category,subcat,v,"b",DoTimer:GetTimerData()[subcat].colors[v]["b"])
						end
					end
					DoTimer:UpdateSettings()
				end
				DropDownLib:AddButton(info,3)
			end
		end
	elseif DROPDOWNLIB_MENU_LEVEL == 2 then
		category = DROPDOWNLIB_MENU_VALUE
		if category == "timer" then
			for i = 1,GetNumSpellTabs() do
				local name = GetSpellTabInfo(i)
				info = DropDownLib:GetTable()
				info.text = name
				info.value = name
				info.hasArrow = 1
				info.notCheckable = 1
				DropDownLib:AddButton(info,2)
			end
		elseif category == "type" then
			for index,value in ipairs(orderedtypes) do
				info = DropDownLib:GetTable()
				info.text = value
				local timertype = types[value]
				local checked
				if DoTimer:Get("colors","type",timertype) then checked = 1 end
				info.checked = checked
				info.value = timertype
				info.hasArrow = 1
				info.func = function() 
					if checked then 
						DoTimer:Set("colors","type",timertype,nil) 
						DoTimer:UpdateSettings()
					end 
				end
				DropDownLib:AddButton(info,2)
			end
		end
	elseif DROPDOWNLIB_MENU_LEVEL == 1 then
		info = DropDownLib:GetTable()
		info.text = "Specific Timer"
		info.notCheckable = 1
		info.hasArrow = 1
		info.value = "timer"
		DropDownLib:AddButton(info,1)
		info = DropDownLib:GetTable()
		info.text = "Timer Type"
		info.notCheckable = 1
		info.hasArrow = 1
		info.value = "type"
		DropDownLib:AddButton(info,1)
	end
end

local guitable = {
	title = "DoTimer Main Menu",
	name = "DoTimerMenuFrame",
	{ --column 1
		{
			title = "Enabled",
			type = "checkbutton",
			tooltiptext = "Turns the addon on or off, default state: on.",
			scripts = scripts.checkbutton,
			data = {
				setting = "status",
			},
		},
		{
			title = "Levels",
			type = "checkbutton",
			tooltiptext = "Determines if the level of the target will be displayed, default state: shown.",
			scripts = scripts.checkbutton,
			data = {
				setting = "levels",
			},
		},
		{
			title = "Tooltips",
			type = "checkbutton",
			tooltiptext = "Determines if tooltips will be shown when you mouse over timers, default state: on.",
			scripts = scripts.checkbutton,
			data = {
				setting = "tooltips",
			},
		},
		{
			title = "On Yourself",
			type = "checkbutton",
			tooltiptext = "Determines if timers representing buffs on yourself will be created, default state: no.",
			scripts = scripts.checkbutton,
			data = {
				setting = "playertimers",
			},
		},
		{
			title = "Show Only Target",
			type = "checkbutton",
			tooltiptext = "Determines if only timers for your current target will be shown (the others will be tracked, but hidden), default state: off.",
			scripts = scripts.checkbutton,
			data = {
				setting = "onlytarget",
			},
		},
		{
			title = "Sort Target",
			type = "checkbutton",
			tooltiptext = "Determines if the table for the current target will be automatically sorted to the first position, default state: off.",
			scripts = scripts.checkbutton,
			data = {
				setting = "sorttarget",
			},
		},
		{
			title = "Show Only Focus",
			type = "checkbutton",
			tooltiptext = "Determines if only timers for your current focus will be shown (the others will be tracked, but hidden).  Note that this and 'Show Only Target' can be used together, with the latter being sorted first, default state: off.",
			scripts = scripts.checkbutton,
			data = {
				setting = "onlyfocus",
			},
		},
		{
			title = "Sort Focus",
			type = "checkbutton",
			tooltiptext = "Determines if the table for the current target will be automatically sorted to the first position.  Note that this and 'Sort Target' can be used together, with the latter being sorted first, default state: off.",
			scripts = scripts.checkbutton,
			data = {
				setting = "sortfocus",
			},
		},
	},
	{ --column 2
		{
			title = "Max Buff Duration",
			type = "slider",
			tooltiptext = "Determines the maximum duration, in minutes, of buffs you cast can last to be made a timer (0 means no limit), default 1.",
			scripts = scripts.slider,
			lowval = 0,
			highval = 15,
			step = 1,
			data = {
				setting = "maxbuffduration",
			},
		},
		{
			title = "Colors",
			type = "dropdown",
			tooltiptext = "Lets you set the color of specific timers and timer types.",
			func = colordropdown,
			scripts = scripts.dropdown,
			data = {
				text = "Choose...",
			},
		},
		{
			title = "Key Bindings",
			type = "dropdown",
			tooltiptext = [[
				Lets you customize the keybindings for certain actions.
				
				If you are attempting to change the keybinding, just click on the final selection to finish (e.g., click 'Left Click' to just set to left-click, or if you want shift-leftclick move your mouse to the 'Shift' selection that appeared, etc.)]],
			func = function() DoTimer:KBDropDown() end,
			scripts = scripts.dropdown,
			data = {
				text = "Choose...",
			},
		},
		{
			title = "Debugging",
			type = "editbox",
			tooltiptext = "Sets debug messages.  \"off\" for none, \"on\" for default frame, or a number representing the chat frame to send the messages.  Press ENTER when done typing.",
			scripts = scripts.editbox1,
			data = {
				setting = "debugchannel",
			},
		},
		{
			title = "Chat Msg",
			type = "editbox",
			tooltiptext = [[
				Allows you to customize the chat message sent when left-clicking a timer.

				Valid formatting codes:
				%s: spell name
				%r: spell rank
				%d: time remaining
				%t: spell's target
				%l: target's level

				Normal: %s,%r,%d,%t,%l
				No Target: %s,%r,%d

				Prefix with one of [normal,notarget] followed by a ":" to set the msg for that type.
				Example: "normal: My %s will expire in %d."
				
				Press ENTER when finished typing.
				
				Current strings:]],
			scripts = scripts.editbox2,
			overridescripts = {
				OnEnterPressed = function() 
					local text = this:GetText()
					if not (text == "") then 
						local _,_,output,msg = string.find(text,"(%a+)%:%s?(.+)")
						if output then 
							output = string.lower(output)
							DoTimer:Set("chatmsg"..output,msg)
							DoTimer:UpdateSettings()
							this:SetText("") 
							DoTimer:Print("|cff00ffffDoTimer|r: ",output," chat msg set to: ",msg)
						else
							DoTimer:Print("|cff00ffffDoTimer|r: Setting failed being set. (Reason: unable to parse)")
						end
					end
				end,
				OnEnter = function() 
					if this.tooltipText then
						local text = this.tooltipText
						text = text.."\nNormal: "..DoTimer:Get("chatmsgnormal")
						text = text.."\nNo Target: "..DoTimer:Get("chatmsgnotarget")
						GameTooltip:SetOwner(this, "ANCHOR_RIGHT");
						GameTooltip:SetText(text, nil, nil, nil, nil, 1);
					end
				end,
			},
		},
	},
	{ --column 3
		{
			title = "Reset",
			type = "button",
			tooltiptext = "Resets all settings to their default value.",
			buffer = 10,
			scripts = {
				OnClick = function() 
					this.self:ClearSettings() 
					DoTimerMenuFrame:Hide()
					DoTimerMenuFrame:Show()
				end,
			},
		},
		{
			title = "Author Info",
			type = "button",
			tooltiptext = "Prints in the chat frame information about the current version and about the author.",
			buffer = 10,
			scripts = {
				OnClick = function() DoTimer:AddAuthorInfo() end,
			},
		},
		{
			title = "Profiles",
			type = "button",
			tooltiptext = "Opens the Profile Creator menu.",
			buffer = 10,
			scripts = {
				OnClick = function() ProfileLib:ShowGUI() end,
			},
		},
		"BREAK",
		{
			title = "Timer Settings",
			type = "button",
			tooltiptext = "Opens the options window for customizing the timers that can be made.",
			scripts = {
				OnClick = function() this.self:ShowTimerGUI(barmsgcodes,orderedtypes,types) end,
			},
		},
		{
			title = "Close",
			type = "button",
			tooltiptext = "Closes this window.",
			scripts = {
				OnClick = function() this.holder.place.column.menu:Hide() end,
			},
		},
	},
}

function DoTimer:ShowGUI()
	if not DoTimerMenuFrame then
		DoTimer:CreateGUI(guitable)
	end
	DoTimerMenuFrame:Show()
end
