local TimerLibGUI = {}

local scripts = {
	checkbutton = {
		OnShow = function() this:SetChecked(this.self:Get(this.setting)) end,
		OnClick = function() this.self:Set(this.setting,this:GetChecked() and true or false); this.self:UpdateSettings() end,
	},
	slider = {
		OnShow = function() this.real = false this:SetValue(this.self:Get(this.setting)) this.real = true end,
		OnValueChanged = function()
			local value = this:GetValue()
			local formatstring
			if math.floor(value) == value then 
				formatstring = "%d"
			else
				formatstring = "%.2f"
			end
			getglobal(this:GetName().."Value"):SetText(string.format(formatstring,value))
			if this.real then
				this.self:Set(this.setting,value)
				this.self:UpdateSettings()
			end
		end,
	},
	editbox1 = { --initialized with a string
		OnEditFocusGained = function() this:SetText(this.self:Get(this.setting) or ""); this:HighlightText() end,
		OnEditFocusLost = function() this:HighlightText(0,0) end,
		OnShow = function() this:SetText(this.self:Get(this.setting) or "") end,
		OnEscapePressed = function()
			local text = this:GetText()
			if text == "" then
				this:ClearFocus()
			else
				this:SetText("")
			end
		end,
		OnEnterPressed = function() 
			local text = this:GetText()
			this.self:Print("|cff00ffff",this.self:GetName(),"|r: New setting: ",text)
			this.self:Set(this.setting,text); this.self:UpdateSettings(); this:ClearFocus() 
		end,
	},
	editbox2 = { --controls a table
		OnEditFocusGained = function() this:SetText("") end,
		OnEditFocusLost = function() this:SetText("") end,
		OnEscapePressed = function()
			local text = this:GetText()
			if text == "" then
				this:ClearFocus()
			else
				this.self:Set(this.setting,string.lower(text),nil)
				this.self:Print("|cff00ffff",this.self:GetName(),"|r: Removed from list: ",text)
				this.self:UpdateSettings()
				this:SetText("")
			end
		end,
		OnEnterPressed = function()
			local text = this:GetText()
			if not (text == "") then
				this.self:Set(this.setting,string.lower(text),1)
				this.self:Print("|cff00ffff",this.self:GetName(),"|r: Added to list: ",text)
				this.self:UpdateSettings()
				this:SetText("")
			end
		end,
		OnEnter = function()
			if this.tooltipText then
				local text = this.tooltipText
				for index,value in pairs(this.self:Get(this.setting)) do
					text = text.."\n"..index
				end
				GameTooltip:SetOwner(this, "ANCHOR_RIGHT");
				GameTooltip:SetText(text, nil, nil, nil, nil, 1);
			end
		end,
	},
	dropdown = {
		OnShow = function()
			getglobal(this:GetName().."Text"):SetText(this.self:Get(this.setting))
		end,
	},
	dropdown2 = {
		OnShow = function()
			getglobal(this:GetName().."Text"):SetText(this.text)
		end,
	},
}

local function dropdown(self,frame,setting,values)
	local info
	for index,value in ipairs(values) do
		info = DropDownLib:GetTable()
		info.text = value
		info.checked = (self:Get(setting) == value) and 1
		info.func = function() 
			self:Set(setting,value) 
			self:UpdateSettings() 
			getglobal(frame:GetName().."Text"):SetText(value)
			DropDownLib:CloseDropDownMenus()
		end
		DropDownLib:AddButton(info,1)
	end
end

local function colordropdown(self)
	local info
	local DROPDOWNLIB_MENU_LEVEL = DropDownLib:MenuLevel()
	local DROPDOWNLIB_MENU_VALUE = DropDownLib:MenuValue()
	if DROPDOWNLIB_MENU_LEVEL == 1 then
		info = DropDownLib:GetTable()
		info.text = "Bar Text"
		local colors = self:Get("bartextcolor")
		info.r = colors.r
		info.g = colors.g
		info.b = colors.b
		info.hasColorSwatch = 1
		local checked
		local currcolor = self:Get("bartextcolor")
		local defcolor = self:GetDefault("bartextcolor")
		if not (currcolor.r == defcolor.r and currcolor.g == defcolor.g and currcolor.b == defcolor.b) then checked = 1 end
		info.checked = checked
		info.func = function() if checked then self:Set("bartextcolor",nil) self:UpdateSettings() end end
		info.swatchFunc = function()
			local r,g,b = DropDownLibColorPicker:GetColorRGB()
			self:Set("bartextcolor","r",r)
			self:Set("bartextcolor","g",g)
			self:Set("bartextcolor","b",b)
			self:UpdateSettings()
		end
		DropDownLib:AddButton(info,1)
		info = DropDownLib:GetTable()
		info.text = "Ghost Timers"
		local colors = self:Get("ghostcolor")
		info.r = colors.r
		info.g = colors.g
		info.b = colors.b
		info.hasColorSwatch = 1
		local checked
		local currcolor = self:Get("ghostcolor")
		local defcolor = self:GetDefault("ghostcolor")
		if not (currcolor.r == defcolor.r and currcolor.g == defcolor.g and currcolor.b == defcolor.b) then checked = 1 end
		info.checked = checked
		info.func = function() if checked then self:Set("ghostcolor",nil) self:UpdateSettings() end end
		info.swatchFunc = function()
			local r,g,b = DropDownLibColorPicker:GetColorRGB()
			self:Set("ghostcolor","r",r)
			self:Set("ghostcolor","g",g)
			self:Set("ghostcolor","b",b)
			self:UpdateSettings()
		end
		DropDownLib:AddButton(info,1)
		info = DropDownLib:GetTable()
		info.text = "Bar Background"
		local colors = self:Get("barbackgroundcolor")
		info.r = colors.r
		info.g = colors.g
		info.b = colors.b
		info.hasColorSwatch = 1
		local checked
		local currcolor = self:Get("barbackgroundcolor")
		local defcolor = self:GetDefault("barbackgroundcolor")
		if not (currcolor.r == defcolor.r and currcolor.g == defcolor.g and currcolor.b == defcolor.b) then checked = 1 end
		info.checked = checked
		info.func = function() if checked then self:Set("barbackgroundcolor",nil) self:UpdateSettings() end end
		info.swatchFunc = function()
			local r,g,b = DropDownLibColorPicker:GetColorRGB()
			self:Set("barbackgroundcolor","r",r)
			self:Set("barbackgroundcolor","g",g)
			self:Set("barbackgroundcolor","b",b)
			self:UpdateSettings()
		end
		DropDownLib:AddButton(info,1)
		info = DropDownLib:GetTable()
		info.text = "Target Name"
		local colors = self:Get("targettextcolor")
		info.r = colors.r
		info.g = colors.g
		info.b = colors.b
		info.hasColorSwatch = 1
		local checked
		local currcolor = self:Get("targettextcolor")
		local defcolor = self:GetDefault("targettextcolor")
		if not (currcolor.r == defcolor.r and currcolor.g == defcolor.g and currcolor.b == defcolor.b) then checked = 1 end
		info.checked = checked
		info.func = function() if checked then self:Set("targettextcolor",nil) self:UpdateSettings() end end
		info.swatchFunc = function()
			local r,g,b = DropDownLibColorPicker:GetColorRGB()
			self:Set("targettextcolor","r",r)
			self:Set("targettextcolor","g",g)
			self:Set("targettextcolor","b",b)
			self:UpdateSettings()
		end
		DropDownLib:AddButton(info,1)
	end
end

local function otherdropdown(self)
	local frame = this:GetParent()
	if frame.setting and frame.values then 
		dropdown(self,frame,frame.setting,frame.values) 
	end 
end

local function barmsgtooltip(codes)
	local tooltip = "Allows you to customize the text \ninside the bar / shown in 'text only' format.\n\nValid formatting codes:\n\n"
	for i,v in pairs(codes) do
		tooltip = tooltip..string.format("%s: %s",i,v).."\n"
	end
	tooltip = tooltip.."\nNormally, the text is anchored to the left.  \nHowever, if you want to display some or all of the \ntext anchored to the right, this is how you do it:"
	tooltip = tooltip.."\n\nAdd '&' with a ':' on EITHER (NOT BOTH) side of it.  \nThe ':' governs which side is given preference if the \nbar length is too short to display the entire message."
	tooltip = tooltip.."\n\nExample: '%s&:%d', on a short bar: |Cool Ti... 0:15|"
	tooltip = tooltip.."\n\nPress ENTER when finished typing."
	return tooltip
end

local function hiddentypesdropdown(self,orderedtypes,types)
	local info
	if orderedtypes and types then
		for index,value in ipairs(orderedtypes) do
			info = DropDownLib:GetTable()
			local type = string.lower(types[value])
			local checked
			if self:Get("hiddentypes",type) then checked = 1 end
			info.checked = checked
			info.text = value
			info.func = function() if checked then self:Set("hiddentypes",type,nil) else self:Set("hiddentypes",type,1) end self:UpdateSettings() end
			DropDownLib:AddButton(info,1)
		end
	end
end

local noinclude = {}
function TimerLibGUI:SpawnTimerGUI(barmsgformatcodes,orderedtypes,types,...)
	self:ClearTable(noinclude)
	for i = 1,select("#",...) do
		noinclude[(select(i,...))] = 1
	end
	local guitable = {
		title = self:GetName().." Timer Settings",
		name = self:GetName().."TimerMenuFrame",
		{ --column 1
			{
				title = "Locked",
				type = "checkbutton",
				tooltiptext = "Locks the addon, hiding the drag icon, default state: unlocked.",
				scripts = scripts.checkbutton,
				data = {
					setting = "locked",
				},
				noexists = noinclude["Locked"],
			},
			{
				title = "Headers",
				type = "checkbutton",
				tooltiptext = "Toggles the showing of headers on targets, default state: shown.",
				scripts = scripts.checkbutton,
				data = {
					setting = "names",
				},
				noexists = noinclude["Names"],
			},
			{
				title = "Raid Icons",
				type = "checkbutton",
				tooltiptext = "Determines if raid icons will be overlayed over target names.  Note that 'Names' can be turned off to only have raid icons shown, default state: on.",
				scripts = scripts.checkbutton,
				data = {
					setting = "raidicons",
				},
				noexists = noinclude["Raid Icons"],
			},
			{
				title = "Move Target Name",
				type = "checkbutton",
				tooltiptext = "Determines if the target name will be moved to a more vertically-oriented position when Target Layout is up or down, default state: true.",
				scripts = scripts.checkbutton,
				data = {
					setting = "movetargetname",
				},
				noexists = noinclude["Move Target Name"],
			},
			{
				title = "Clickable",
				type = "checkbutton",
				tooltiptext = "Determines if timers can be clicked: rightclick to remove, default state: on.",
				scripts = scripts.checkbutton,
				data = {
					setting = "clickable",
				},
				noexists = noinclude["Clickable"],
			},
			{
				title = "Show Tenths",
				type = "checkbutton",
				tooltiptext = "Determines if the displayed duration on timers is accurate to .1 second, else to 1 second, default state: off.",
				scripts = scripts.checkbutton,
				data = {
					setting = "tenths",
				},
				noexists = noinclude["Show Tenths"],
			},
			{
				title = "Icons",
				type = "checkbutton",
				tooltiptext = "Determines if the icons in the bar format will be shown, default state: shown.",
				scripts = scripts.checkbutton,
				data = {
					setting = "icons",
				},
				noexists = noinclude["Icons"],
			},
			{
				title = "Reversed",
				type = "checkbutton",
				tooltiptext = "Determines if the timers in 'bar' format will grow instead of shrink, default state: off.",
				scripts = scripts.checkbutton,
				data = {
					setting = "reversed",
				},
				noexists = noinclude["Reversed"],
			},
			{
				title = "Expire Alert",
				type = "checkbutton",
				tooltiptext = "Determines if the timer icon (in icons format) highlights for 2 seconds at less than 5 seconds remaining, default state: on.",
				scripts = scripts.checkbutton,
				data = {
					setting = "expalert",
				},
				noexists = noinclude["Expire Alert"],
			},
			{
				title = "Play Sounds",
				type = "checkbutton",
				tooltiptext = "Determines if a sound will be played when a timer hits five seconds left, default state: off.",
				scripts = scripts.checkbutton,
				data = {
					setting = "playsound",
				},
				noexists = noinclude["Play Sounds"],
			},
			{
				title = "Ghost Timers",
				type = "checkbutton",
				tooltiptext = "Determines if ghost timers will be created or not.  Ghost timers are created when timers expire, default state: on.",
				scripts = scripts.checkbutton,
				data = {
					setting = "ghosts",
				},
				noexists = noinclude["Ghost Timers"],
			},
			{
				title = "Hide All",
				type = "checkbutton",
				tooltiptext = "Determines if all timers will be hidden from view, default state: off.",
				scripts = scripts.checkbutton,
				data = {
					setting = "hideall",
				},
				noexists = noinclude["Hide All"],
			},
			{
				title = "Show Only Target",
				type = "checkbutton",
				tooltiptext = "Determines if only timers for your current target will be shown (the others will be tracked, but hidden), default state: off.",
				scripts = scripts.checkbutton,
				data = {
					setting = "onlytarget",
				},
				noexists = noinclude["Show Only Target"],
			},
			{
				title = "Sort Target",
				type = "checkbutton",
				tooltiptext = "Determines if the table for the current target will be automatically sorted to the first position, default state: off.",
				scripts = scripts.checkbutton,
				data = {
					setting = "sorttarget",
				},
				noexists = noinclude["Sort Target"],
			},
			{
				title = "Show Only Focus",
				type = "checkbutton",
				tooltiptext = "Determines if only timers for your current focus will be shown (the others will be tracked, but hidden).  Note that this and 'Show Only Target' can be used together, with the latter being sorted first, default state: off.",
				scripts = scripts.checkbutton,
				data = {
					setting = "onlyfocus",
				},
				noexists = noinclude["Show Only Focus"],
			},
			{
				title = "Sort Focus",
				type = "checkbutton",
				tooltiptext = "Determines if the table for the current target will be automatically sorted to the first position.  Note that this and 'Sort Target' can be used together, with the latter being sorted first, default state: off.",
				scripts = scripts.checkbutton,
				data = {
					setting = "sortfocus",
				},
				noexists = noinclude["Sort Focus"],
			},
		},
		{ --column 2
			{
				title = "Scale",
				type = "slider",
				tooltiptext = "Changes the relative size of the interface, default value: 1.",
				scripts = scripts.slider,
				lowval = .5,
				highval = 2,
				step = .05,
				data = {
					setting = "scale",
				},
				noexists = noinclude["Scale"],
			},
			{
				title = "Timer Scale",
				type = "slider",
				tooltiptext = "Changes the relative size of the debuff icons of the interface, default value: 1.",
				scripts = scripts.slider,
				lowval = .5,
				highval = 2,
				step = .05,
				data = {
					setting = "buttonscale",
				},
				noexists = noinclude["Timer Scale"],
			},
			{
				title = "Bar Length",
				type = "slider",
				tooltiptext = "Determines how long the bar are in Bars format, or how much text is shown in Text format, default 175.",
				scripts = scripts.slider,
				lowval = 50,
				highval = 250,
				step = 5,
				data = {
					setting = "barlength",
				},
				noexists = noinclude["Bar Length"],
			},
			{
				title = "Timer Spacing",
				type = "slider",
				tooltiptext = "Determines how spaced out the timers are from each other, default 5.",
				scripts = scripts.slider,
				lowval = 0,
				highval = 20,
				step = 1,
				data = {
					setting = "timerspacing",
				},
				noexists = noinclude["Timer Spacing"],
			},
			{
				title = "Target Spacing",
				type = "slider",
				tooltiptext = "Determines how spaced out the targets are from each other, default 15.",
				scripts = scripts.slider,
				lowval = 0,
				highval = 30,
				step = 1,
				data = {
					setting = "targetspacing",
				},
				noexists = noinclude["Target Spacing"],
			},
			{
				title = "Alpha",
				type = "slider",
				tooltiptext = "Determines the overall alpha of the timers.  1 means fully opaque; 0 means completely translucent, default 1.",
				scripts = scripts.slider,
				lowval = 0,
				highval = 1,
				step = .05,
				data = {
					setting = "alpha",
				},
				noexists = noinclude["Alpha"],
			},
			{
				title = "Ghost Duration",
				type = "slider",
				tooltiptext = "Determines how long, in seconds, ghost timers will stay on the screen, default 5.",
				scripts = scripts.slider,
				lowval = 1,
				highval = 30,
				step = 1,
				data = {
					setting = "ghostdata",
				},
				noexists = noinclude["Ghost Duration"],
			},
			{
				title = "Bar Texture",
				type = "slider",
				tooltiptext = "Determines the index of which bar texture will be used, default 4.",
				scripts = scripts.slider,
				lowval = 1,
				highval = 30,
				step = 1,
				data = {
					setting = "bartexture",
				},
				noexists = noinclude["Bar Texture"],
			},
			{
				title = "Fade In Time",
				type = "slider",
				tooltiptext = "Determines how long, in seconds, timers will take to fade in, default 1.",
				scripts = scripts.slider,
				lowval = 0,
				highval = 5,
				step = 1,
				data = {
					setting = "fadeintime",
				},
				noexists = noinclude["Fade In Time"],
			},
			{
				title = "Fade Out Time",
				type = "slider",
				tooltiptext = "Determines how long, in seconds, timers will take to fade out, default 3.",
				scripts = scripts.slider,
				lowval = 0,
				highval = 5,
				step = 1,
				data = {
					setting = "fadeouttime",
				},
				noexists = noinclude["Fade Out Time"],
			},
			{
				title = "Max Targets",
				type = "slider",
				tooltiptext = "Determines the maximum number of targets that will be created (0 means no limit), default 0.",
				scripts = scripts.slider,
				lowval = 0,
				highval = 10,
				step = 1,
				data = {
					setting = "maxtargets",
				},
				noexists = noinclude["Max Targets"],
			},
			{
				title = "Bar Msg",
				type = "editbox",
				tooltiptext = barmsgtooltip(barmsgformatcodes),
				scripts = scripts.editbox1,
				data = {
					setting = "barmsg",
				},
				noexists = noinclude["Bar Msg"],
			},
			{
				title = "Hidden Timers",
				type = "editbox",
				tooltiptext = "Allows timers to be hidden upon creation.  Press ENTER after typing in a name to add it to the list, or ESCAPE to remove it.  \n\nCurrent List:",
				scripts = scripts.editbox2,
				data = {
					setting = "hidden",
				},
				noexists = noinclude["Hidden Timers"],
			},
		},
		{ --column 3
			{
				title = "Reset Position",
				type = "button",
				tooltiptext = "Resets the position of the drag icon to the middle of the screen.",
				buffer = 10,
				scripts = {
					OnClick = function() this.self:Set("offsetX",nil); this.self:UpdateSettings() end,
				},
				noexists = noinclude["Reset Position"],
			},
			{
				title = "Show Preview",
				type = "button",
				tooltiptext = "Shows the interface for the current settings for 3 targets and 4 debuffs.",
				buffer = 10,
				scripts = {
					OnClick = function() this.self:ShowTimers(3,4) end,
				},
				noexists = noinclude["Show Preview"],
			},
			{
				title = "Hide Preview",
				type = "button",
				tooltiptext = "Hides the preview created from the above button, as well as any other timers.",
				buffer = 10,
				scripts = {
					OnClick = function() this.self:RemoveAllTimers() end,
				},
				noexists = noinclude["Hide Preview"],
			},
			{
				title = "Timer Format",
				type = "dropdown",
				tooltiptext = "Determines if the timers will be displayed as bars, icons, or text, default bars.",
				func = function() otherdropdown(self) end,
				scripts = scripts.dropdown,
				data = {
					setting = "format",
					values = {"bars","icons","text"},
				},
				noexists = noinclude["Timer Format"],
			},
			{
				title = "Target Layout",
				type = "dropdown",
				tooltiptext = "Sets the direction in which new target tables are added, default value: left.",
				func = function() otherdropdown(self) end,
				scripts = scripts.dropdown,
				data = {
					setting = "targetlayout",
					values = {"up","down","left","right"},
				},
				noexists = noinclude["Target Layout"],
			},
			{
				title = "Timer Layout",
				type = "dropdown",
				tooltiptext = "Sets the direction in which new debuff timers are added, default value: down.",
				func = function() otherdropdown(self) end,
				scripts = scripts.dropdown,
				data = {
					setting = "timerlayout",
					values = {"up","down","left","right"},
				},
				noexists = noinclude["Timer Layout"],
			},
			{
				title = "Sorting Method",
				type = "dropdown",
				tooltiptext = "Sets the manner in which timers are sorted: time added or time remaining or alphabetical, and ascending or descending, default value: remaining (D).",
				func = function() otherdropdown(self) end,
				scripts = scripts.dropdown,
				data = {
					setting = "sortmethod",
					values = {"added (A)","added (D)","remaining (A)","remaining (D)","alphabetical (A)","alphabetical (D)"},
				},
				noexists = noinclude["Sorting Method"],
			},
			{
				title = "Target Sorting",
				type = "dropdown",
				tooltiptext = "Sets the manner in which targets are sorted: time added or alphabetical, and ascending or descending, default value: added (D).",
				func = function() otherdropdown(self) end,
				scripts = scripts.dropdown,
				data = {
					setting = "targetsort",
					values = {"added (A)","added (D)","alphabetical (A)","alphabetical (D)"},
				},
				noexists = noinclude["Target Sorting"],
			},
			{
				title = "Seconds Format",
				type = "dropdown",
				tooltiptext = "Sets the manner in which the time string is displayed when less than 1 minute remains on the timer. '##s' and '##s abbv affect the time string for all times, changing it to '5m 10s', etc.  '##s abbv' would display '5m 10s' as '5m', etc., adding tenths of a second at < 10 seconds.",
				func = function() otherdropdown(self) end,
				scripts = scripts.dropdown,
				data = {
					setting = "secondsformat",
					values = {"##",":##","0:##","##s","##s abbv"},
				},
				noexists = noinclude["Seconds Format"],
			},
			{
				title = "Colors",
				type = "dropdown",
				tooltiptext = "Lets you set the color of various timer elements.",
				func = function() colordropdown(self) end,
				scripts = scripts.dropdown2,
				data = {
					text = "Choose...",
				},
				noexists = noinclude["Colors"],
			},
			{
				title = "Hidden Types",
				type = "dropdown",
				tooltiptext = "Lets you hide entire timer types from appearing onscreen.",
				func = function() hiddentypesdropdown(self,orderedtypes,types) end,
				scripts = scripts.dropdown2,
				data = {
					text = "Choose...",
				},
				noexists = noinclude["Hidden Types"],
			},
			"BREAK",
			{
				title = "Return",
				type = "button",
				tooltiptext = "Returns to the previous GUI.",
				scripts = {
					OnClick = function() this.self:ShowGUI(); end,
				},
				noexists = noinclude["Return"],
			},
			{
				title = "Close",
				type = "button",
				tooltiptext = "Closes this window.",
				scripts = {
					OnClick = function() this.holder.place.column.menu:Hide() end,
				},
				noexists = noinclude["Close"],
			},
		},
	}
	return guitable
end

function TimerLibGUI:ShowTimerGUI(barmsgformatcodes,orderedtypes,types,...)
	if not getglobal(self:GetName().."TimerMenuFrame") then
		self:CreateGUI(self:SpawnTimerGUI(barmsgformatcodes,orderedtypes,types,...))
	end
	getglobal(self:GetName().."TimerMenuFrame"):Show()
end

AsheylaLib:CreateLibrary("TimerLibGUI",TimerLibGUI)
