local TimerLib = {}
local defaultsettings
local defaulttimerdata
local defaulttarget
local defaulttimer
local defaultghostdata
local defaulthiddendata
local defaultblankdata
local listofmodules = {}
local timerdatametatable
local timermetatable
local targetmetatable
local bartextures
local counter = 1
local timerstring_spacing = 3
local updatebuffer = 0

function TimerLib:CreateTimerInstance(targetframe,timerframe,anchorframe,positionframe)
	table.insert(listofmodules,self)
	local frame = CreateFrame("Frame")
	targetframe = targetframe or "TimerLibInstance"..counter.."Target"
	positionframe = positionframe or "TimerLibPositionFrame"..counter
	timerframe = timerframe or "Timer"
	anchorframe = anchorframe or "TimerLibAnchorFrame"..counter
	self.libraries["TimerLib"].frame = frame
	self.libraries["TimerLib"].datatable = {}
	self.libraries["TimerLib"].frames = {}
	self.libraries["TimerLib"].targetframe = targetframe
	self.libraries["TimerLib"].timerframe = timerframe
	self.libraries["TimerLib"].timerdata = self.libraries["TimerLib"].timerdata or {}
	self.libraries["TimerLib"].anchorframe = anchorframe
	self.libraries["TimerLib"].positionframe = positionframe
	self.libraries["TimerLib"].totaltargets = 0
	self.libraries["TimerLib"].totaltimers = 0
	frame.buffer = updatebuffer
	self.libraries["TimerLib"].updatefunc = function(frame,elapsed) frame.buffer = frame.buffer - elapsed if frame.buffer <= 0 then frame.buffer = updatebuffer self:UpdateTimers(elapsed) end end
	counter = counter + 1
	self:RegisterSettings()
	self:AddDefaultSettings(defaultsettings)
	setmetatable(self.libraries["TimerLib"].timerdata,timerdatametatable)
	--make the position frame
	local position = CreateFrame("Button",positionframe,UIParent,"TimerLibPositionFrameTemplate")
	getglobal(positionframe.."Icon"):SetTexture(AsheylaLib:GetPath().."\\Ash_Core\\Files\\DragButton")
	--make the anchorframe
	position.self = self
	local anchor = CreateFrame("Frame",anchorframe,UIParent,"TimerLibAnchorFrameTemplate")
	anchor:ClearAllPoints()
	anchor:SetPoint("CENTER",positionframe,"CENTER")
	anchor.self = self
	self:CreateFrames(1,1)
	self:AddSettingsUpdateScript(self.UpdateInterface)
	self:UpdateInterface()
end

function TimerLib:UpdateInterface()
	--expects:
	-- .locked
	-- .status
	-- .scale
	local anchor = getglobal(self.libraries["TimerLib"].anchorframe)
	local position = getglobal(self.libraries["TimerLib"].positionframe)
	if self:Get("locked") then position:Hide() else position:Show() end
	if self:Get("status") then 
		anchor:Show() 
	else 
		anchor:Hide() 
		position:Hide() 
		self:RemoveAllTimers()
	end
	anchor:SetScale(self:Get("scale"))
	position:ClearAllPoints()
	if self:Get("offsetX") then
		position:SetPoint("BOTTOMLEFT","UIParent","BOTTOMLEFT",self:Get("offsetX"),self:Get("offsetY"))
	else
		position:SetPoint("CENTER","UIParent","CENTER",math.random(0,5),math.random(0,5))
	end
	self:DefineFormat()
	self:DefineInterface()
	local hideall = self:Get("hideall")
	for i = 1,self:GetNumTargets() do
		for id = 1,self:GetNumTimers(i) do
			local timer = self:GetTimer(i,id)
			if timer.forcehide then
				timer.hidden = true
			else
				if (not (timer.hidden)) and (hideall or timer.module:Get("hidden",string.lower(timer.spell)) or (timer.module:Get("hiddentypes",string.lower(timer.type)))) then
					timer.hidden = true
				elseif (timer.hidden) and (not hideall) and (not timer.module:Get("hidden",string.lower(timer.spell))) and (not timer.module:Get("hiddentypes",string.lower(timer.type))) then
					timer.hidden = false
				end
			end
		end
	end
	self:CreateInterface(1,1)
end

function TimerLib:AddTarget(t,nocheck,module)
	if self.libraries["TimerLib"].frozen then return end
	if self:Get("status") then
		t = t or self:AcquireTable(1)
		t.module = module or self
		t.time = GetTime()
		t.text = t.text or t.target
		setmetatable(t,targetmetatable)
		local i = self:ReturnTargetTable(t.target,t.level,t.sex,t.module)
		if nocheck then i = nil end
		local casted = self.libraries["TimerLib"].datatable
		if not i then
			table.insert(casted,t) 
			i = #(casted)
		end
		return i
	end
end

function TimerLib:AddTimer(target,d,suppress,module,targetmodule)
	if self.libraries["TimerLib"].frozen then return end
	if self:Get("status") then
		target = target or self:AcquireTable(1)
		d = d or self:AcquireTable(1)
		setmetatable(d,timermetatable)
		d.time = d.time or GetTime()
		d.english = d.english or d.spell
		d.module = d.module or module or self
		d.self = d.self or self
		d.exists = true
		d.timeadded = d.timeadded or GetTime()
		if d.forcehide or self:Get("hideall") or (d.module:Get("hidden",string.lower(d.spell))) or (d.module:Get("hiddentypes",string.lower(d.type))) then 
			d.hidden = true
		end
		local i
		local casted = self.libraries["TimerLib"].datatable
		if type(target) == "number" then
			i = target
		elseif type(target) == "table" then
			i = self:AddTarget(target,nil,targetmodule)
		end
		if i and casted[i] then
			for id = #(casted[i]),1,-1 do
				local timer = casted[i][id]
				if timer.module == d.module and timer.spell == d.spell and ((timer.time + timer.duration <= GetTime()) or casted[i].norepeat) then self:RemoveTimer(i,id,"replaced",1,1) end
			end
			table.insert(casted[i],d)
			if not suppress then self:CreateInterface() end
		end
	end
end

function TimerLib:GetTimerData()
	return self.libraries["TimerLib"].timerdata
end

function TimerLib:GetTarget(i)
	return self.libraries["TimerLib"].datatable[i]
end

function TimerLib:GetTimer(i,id)
	return self.libraries["TimerLib"].datatable[i][id]
end

function TimerLib:CreateFrames(targets,timers)
	targets = math.max(targets,self.libraries["TimerLib"].totaltargets)
	timers = math.max(timers,self.libraries["TimerLib"].totaltargets)
	local changed
	local anchor = getglobal(self.libraries["TimerLib"].anchorframe)
	local targetframe = self.libraries["TimerLib"].targetframe
	local timerframe = self.libraries["TimerLib"].timerframe
	for i = self.libraries["TimerLib"].totaltargets + 1,targets do
		--make the targets
		changed = 1
		local targetstr = targetframe..i
		local target
		if not getglobal(targetstr) then
			target = CreateFrame("Frame",targetstr,anchor,"TimerLibTargetFrameTemplate")
			--set IDs
			self.libraries["TimerLib"].frames[i] = target
			target:SetID(i)
			target:Hide()
			target.Name = getglobal(targetstr.."Name")
			target.Name.Text = getglobal(targetstr.."NameText")
			target.Name.Icon = getglobal(targetstr.."NameIcon")
			target.Name.self = self
		end
		for id = 1,self.libraries["TimerLib"].totaltimers do
			--make the timers
			local timerstr = targetstr..timerframe..id
			local timer
			if not getglobal(timerstr) then
				timer = CreateFrame("Frame",timerstr,target,"TimerLibTimerFrameTemplate")
				--set IDs
				self.libraries["TimerLib"].frames[i][id] = timer
				timer:SetID(id)
				timer:Hide()
				timer.Bar = getglobal(timerstr.."Bar")
				timer.Bar.Button = getglobal(timerstr.."BarButton")
				timer.Bar.Button.Texture = getglobal(timerstr.."BarButtonTexture")
				timer.Bar.Button.Stack = getglobal(timerstr.."BarButtonStack")
				timer.Bar.Button.Border = getglobal(timerstr.."BarButtonBorder") --flag
				timer.Bar.Status = getglobal(timerstr.."BarStatus")
				timer.Bar.Status.Front = getglobal(timerstr.."BarStatusFront")
				timer.Bar.Status.Front.Spark = getglobal(timerstr.."BarStatusFrontSpark")
				timer.Bar.Status.Background = getglobal(timerstr.."BarStatusBackground")
				timer.Bar.Status.Time = getglobal(timerstr.."BarStatusTime")
				timer.Bar.Status.TimeRight = getglobal(timerstr.."BarStatusTimeRight")
				timer.Icon = getglobal(timerstr.."Icon")
				timer.Icon.Time = getglobal(timerstr.."IconTime")
				timer.Icon.Button = getglobal(timerstr.."IconButton")
				timer.Icon.Button.Texture = getglobal(timerstr.."IconButtonTexture")
				timer.Icon.Button.Stack = getglobal(timerstr.."IconButtonStack")
				timer.Icon.Button.Border = getglobal(timerstr.."IconButtonBorder")
				timer.Text = getglobal(timerstr.."Text")
				timer.Text.Button = getglobal(timerstr.."TextButton")
				timer.Text.Button.Time = getglobal(timerstr.."TextButtonTime")
				timer.Text.Button.TimeRight = getglobal(timerstr.."TextButtonTimeRight")
				timer.Bar.Button.self = self
				timer.Icon.Button.self = self
				timer.Text.Button.self = self
				timer.Icon.Time:SetFont((GameFontNormal:GetFont()),10)
				local timestr = timer.Bar.Status.Time
				timestr:ClearAllPoints()
				timestr:SetPoint("TOPLEFT",timer.Bar.Status.Front:GetName(),"TOPLEFT",3,0)
				timestr = timer.Bar.Status.TimeRight
				timestr:ClearAllPoints()
				timestr:SetPoint("TOPRIGHT",timer.Bar.Status.Front:GetName(),"TOPRIGHT",-3,0)
			end
		end
	end
	for i = 1,targets do
		local targetstr = targetframe..i
		local target = getglobal(targetstr)
		for id = self.libraries["TimerLib"].totaltimers + 1,timers do
			changed = 1
			--make the timers
			local timerstr = targetstr..timerframe..id
			local timer
			if not getglobal(timerstr) then
				timer = CreateFrame("Frame",timerstr,target,"TimerLibTimerFrameTemplate")
				--set IDs
				self.libraries["TimerLib"].frames[i][id] = timer
				timer:SetID(id)
				timer:Hide()
				timer.Bar = getglobal(timerstr.."Bar")
				timer.Bar.Button = getglobal(timerstr.."BarButton")
				timer.Bar.Button.Texture = getglobal(timerstr.."BarButtonTexture")
				timer.Bar.Button.Stack = getglobal(timerstr.."BarButtonStack")
				timer.Bar.Button.Border = getglobal(timerstr.."BarButtonBorder") --flag
				timer.Bar.Status = getglobal(timerstr.."BarStatus")
				timer.Bar.Status.Front = getglobal(timerstr.."BarStatusFront")
				timer.Bar.Status.Front.Spark = getglobal(timerstr.."BarStatusFrontSpark")
				timer.Bar.Status.Background = getglobal(timerstr.."BarStatusBackground")
				timer.Bar.Status.Time = getglobal(timerstr.."BarStatusTime")
				timer.Bar.Status.TimeRight = getglobal(timerstr.."BarStatusTimeRight")
				timer.Icon = getglobal(timerstr.."Icon")
				timer.Icon.Time = getglobal(timerstr.."IconTime")
				timer.Icon.Button = getglobal(timerstr.."IconButton")
				timer.Icon.Button.Texture = getglobal(timerstr.."IconButtonTexture")
				timer.Icon.Button.Stack = getglobal(timerstr.."IconButtonStack")
				timer.Icon.Button.Border = getglobal(timerstr.."IconButtonBorder")
				timer.Text = getglobal(timerstr.."Text")
				timer.Text.Button = getglobal(timerstr.."TextButton")
				timer.Text.Button.Time = getglobal(timerstr.."TextButtonTime")
				timer.Text.Button.TimeRight = getglobal(timerstr.."TextButtonTimeRight")
				timer.Bar.Button.self = self
				timer.Icon.Button.self = self
				timer.Text.Button.self = self
				timer.Icon.Time:SetFont((GameFontNormal:GetFont()),10)
				local timestr = timer.Bar.Status.Time
				timestr:ClearAllPoints()
				timestr:SetPoint("TOPLEFT",timer.Bar.Status.Front:GetName(),"TOPLEFT",3,0)
				timestr = timer.Bar.Status.TimeRight
				timestr:ClearAllPoints()
				timestr:SetPoint("TOPRIGHT",timer.Bar.Status.Front:GetName(),"TOPRIGHT",-3,0)
			end
		end
	end
	if changed then 
		self.libraries["TimerLib"].totaltargets = targets
		self.libraries["TimerLib"].totaltimers = timers
		self:DefineInterface()
		self:DefineFormat()
	end
	return self.libraries["TimerLib"].totaltargets,self.libraries["TimerLib"].totaltimers
end

function TimerLib:OnTimerEvent(event,i,id,...)
	if i and id then
		local casted = self.libraries["TimerLib"].datatable
		if casted[i] and casted[i][id] then
			local module = casted[i][id].module
			AsheylaLib:CallScript(module,event,i,id,self,...)
		end
	elseif i then
		local casted = self.libraries["TimerLib"].datatable
		if casted[i] then
			local module = casted[i].module
			AsheylaLib:CallScript(module,event,i,self,...)
		end	
	else
		AsheylaLib:CallScript(self,event,...)
	end
end

function TimerLib:CreateInterface(redraw,external) --defines the major portion of writing to the screen; it is called when something drastic has to happen to the interface (i.e., not just updating a timer)
	--expects:
	-- .names
	-- .raidicons
	-- .format
	-- .maxtargets
	-- .expalert
	-- .alpha
	-- .buttonscale
	-- .clickable
	if self.libraries["TimerLib"].frozen then return end
	self:Debug("redoing interface")
	for i = #(self.libraries["TimerLib"].datatable),1,-1 do
		if #(self.libraries["TimerLib"].datatable[i]) == 0 then self:RemoveTarget(i,1) end
	end
	local timerlib = self.libraries["TimerLib"]
	local datatable = timerlib.datatable
	for i,v in ipairs(datatable) do v.hidden = false end
	self:SortTimers()
	local time = GetTime()
	if #(datatable) == 0 then timerlib.frame:SetScript("OnUpdate",nil) end 
	if #(datatable) >= 1 then timerlib.frame:SetScript("OnUpdate",timerlib.updatefunc) end --restoring that OnUpdate
	local maxtargets = datatable.numvisible
	local maxtimers = 0
	for index,value in ipairs(datatable) do
		local query = value.numvisible
		if query > maxtimers then maxtimers = query end
	end	
	self:CreateFrames(maxtargets,maxtimers)
	local names = self:Get("names")
	local raidicons = self:Get("raidicons")
	local timerformat = self:Get("format")
	local alpha = self:Get("alpha")
	local clickable = self:Get("clickable")
	local reversed = self:Get("reversed")
	local buttonscale = self:Get("buttonscale")
	local expalert = self:Get("expalert")
	local barmsg = self:Get("barmsg")
	local timerlayout = self:Get("timerlayout")
	local ghosts = self:Get("ghosts")
	local barlength = self:Get("barlength")
	local targetcolor = self:Get("targettextcolor")
	local timerspacing = self:Get("timerspacing")
	for i = 1,maxtargets do --displaying the information onscreen for each target
		local targettable = datatable[i]
		local targetframe = timerlib.frames[i]
		targetframe:Show()
		targettable.frame = targetframe
		if names or raidicons then --set the target name if you have them on, else hide it
			local flag
			targetframe.Name:Show()
			if names then
				targetframe.Name.Text:SetText(targettable.text)
				targetframe.Name.Text:SetTextColor(targetcolor.r,targetcolor.g,targetcolor.b)
			else
				targetframe.Name.Text:SetText("")
			end
			if targettable.icon > 0 and raidicons then
				targetframe.Name.Icon:Show()
				SetRaidTargetIconTexture(targetframe.Name.Icon,targettable.icon)
			else
				flag = true
				targetframe.Name.Icon:Hide()
			end
			if names then
				targetframe.Name:SetHeight(targetframe.Name.Text:GetHeight())
				targetframe.Name:SetWidth(targetframe.Name.Text:GetWidth())
			else
				if flag then
					targetframe.Name:SetHeight(1)
					targetframe.Name:SetWidth(1)
				else
					targetframe.Name:SetHeight(targetframe.Name.Icon:GetHeight())
					targetframe.Name:SetWidth(targetframe.Name.Icon:GetWidth())
				end
			end
		else
			targetframe.Name:Hide()
		end
		for id = 1,targettable.numvisible do --for each timer on the target
			local timerframe = timerlib.frames[i][id]
			local timer = targettable[id]
			local timerdata = timer.module.libraries["TimerLib"].timerdata[timer.type]
			if redraw or not (timerframe.data and timerframe.data == timer) then
				timerframe.data = timer
				timer.frame = timerframe
				timer.datachanged = nil
				timerframe:Show()
				timerframe:SetAlpha(timer.alpha or 1)
				local type = timer.type
				local remaining = timer.duration - time + timer.time
				if timerformat == "icons" then
					local iconframe = timerframe.Icon
					iconframe.Button:UnlockHighlight()
					iconframe.Button.Texture:SetTexture(timer.texture) --setting the icon
					if timerdata.disptimer then
						local text = self:ReturnFormattedDuration(remaining)
						if remaining <= 0 then text = "" end
						iconframe.Time:SetText(text)
						local displayed = timer.displayed
						if (displayed and displayed <= 5 and displayed > 3) and expalert then iconframe.Button:LockHighlight() end
					else
						iconframe.Time:SetText("")
					end	
					local r,g,b = timer.module:GetTimerColor(timer)
					iconframe.Time:SetTextColor(r,g,b)
					iconframe.Button.Border:SetVertexColor(r,g,b)
					iconframe.Button:SetScale(buttonscale)
					if timerdata.total then 
						iconframe:SetAlpha(timerdata.alpha * alpha) 
						iconframe.Button.Texture:SetAlpha(1)
						iconframe.Button.Border:SetAlpha(1)
					else
						iconframe.Button.Texture:SetAlpha(timerdata.alpha * alpha)
						iconframe.Button.Border:SetAlpha(timerdata.alpha * alpha)
						iconframe:SetAlpha(1) 
					end
					iconframe.Button:EnableMouse(clickable and timerdata.clickable)
					local timerwidth,timerheight
					if timerlayout == "left" or timerlayout == "right" then
						timerwidth = math.max(24 * buttonscale,iconframe.Time:GetWidth() - timerspacing)
						timerheight = (24 * buttonscale) + timerstring_spacing + iconframe.Time:GetHeight()
					else
						timerheight = math.max(24 * buttonscale,iconframe.Time:GetHeight())
						timerwidth = (24 * buttonscale) + timerstring_spacing + iconframe.Time:GetWidth()
					end
					iconframe:SetWidth(timerwidth)
					iconframe:SetHeight(timerheight)
					timerframe:SetWidth(timerwidth)
					timerframe:SetHeight(timerheight)
				elseif timerformat == "bars" then
					local barframe = timerframe.Bar
					barframe.Button.Texture:SetTexture(timer.texture) --setting the icon
					if timerdata.disptimer then
						local value = (timer.duration - time + timer.time) / timer.duration
						local text,middle,right = self:FormatBarText(i,id)
						barframe.Status.Front.Spark:Show()
						if reversed then value = 1 - value end
						if remaining <= 0 then 
							value = (ghosts or reversed) and 1 or 0
							text = string.find(barmsg,"%%s") and timer.spell or ""
							middle,right = nil,nil
							barframe.Status.Front.Spark:Hide()
						end
						barframe.Status.Front:SetValue(value)
						barframe.Status.Time:SetText(text)
						if middle and right then
							barframe.Status.TimeRight:SetText(right)
							barframe.Status.Time:SetWidth(barlength - 6)
							barframe.Status.TimeRight:SetWidth(barlength - 6)
							local leftwidth = math.min(barframe.Status.Time:GetStringWidth() + 5,barlength - 6)
							local rightwidth = math.min(barframe.Status.TimeRight:GetStringWidth() + 5,barlength - 6)
							if middle == ":&" then
								barframe.Status.Time:SetWidth(leftwidth)
								barframe.Status.TimeRight:SetWidth(barlength - 6 - leftwidth)
							elseif middle == "&:" or middle == "&" or middle == ":&:" then
								barframe.Status.Time:SetWidth(barlength - 6 - rightwidth)
								barframe.Status.TimeRight:SetWidth(rightwidth)
							end
						else
							barframe.Status.TimeRight:SetText("")
							barframe.Status.Time:SetWidth(barlength - 6)
						end
					else
						barframe.Status.Front.Spark:Hide()
						barframe.Status.Front:SetValue(1)
						barframe.Status.Time:SetText(string.find(barmsg,"%%s") and timer.spell or "")
						barframe.Status.TimeRight:SetText("")
					end
					local r,g,b = timer.module:GetTimerColor(timer)
					barframe.Status.Front:SetStatusBarColor(r,g,b)
					barframe.Button.Border:SetVertexColor(r,g,b)
					timerframe:SetScale(buttonscale)
					if timerdata.total then 
						barframe:SetAlpha(timerdata.alpha * alpha) 
						barframe.Button.Texture:SetAlpha(1)
						barframe.Status.Front:SetAlpha(1)
						barframe.Status.Background:SetAlpha(.5)
						barframe.Button.Border:SetAlpha(1)
					else
						barframe:SetAlpha(1) 
						barframe.Button.Texture:SetAlpha(timerdata.alpha * alpha)
						barframe.Status.Front:SetAlpha(timerdata.alpha * alpha)
						barframe.Status.Background:SetAlpha(timerdata.alpha * alpha / 2)
						barframe.Button.Border:SetAlpha(timerdata.alpha * alpha)
					end						
					barframe.Button:EnableMouse(clickable and timerdata.clickable)
				elseif timerformat == "text" then
					local textframe = timerframe.Text
					if timerdata.disptimer then
						local text,middle,right = self:FormatBarText(i,id)
						if remaining <= 0 then 
							text = string.find(barmsg,"%%s") and timer.spell or "" 
							middle,right = nil,nil
						end
						textframe.Button.Time:SetText(text)
						if middle and right then
							textframe.Button.TimeRight:SetText(right)
							textframe.Button.Time:SetWidth(barlength)
							textframe.Button.TimeRight:SetWidth(barlength)
							local leftwidth = math.min(textframe.Button.Time:GetStringWidth() + 5,barlength)
							local rightwidth = math.min(textframe.Button.TimeRight:GetStringWidth() + 5,barlength)
							if middle == ":&" then
								textframe.Button.Time:SetWidth(leftwidth)
								textframe.Button.TimeRight:SetWidth(barlength - leftwidth)
							elseif middle == "&:" or middle == "&" or middle == ":&:" then
								textframe.Button.Time:SetWidth(barlength - rightwidth)
								textframe.Button.TimeRight:SetWidth(rightwidth)
							end
						else
							textframe.Button.TimeRight:SetText("")
							textframe.Button.Time:SetWidth(barlength)
						end
					else
						textframe.Button.Time:SetText(string.find(barmsg,"%%s") and timer.spell or "")
						textframe.Button.TimeRight:SetText("")
					end	
					local r,g,b = timer.module:GetTimerColor(timer)
					textframe.Button.Time:SetTextColor(r,g,b)	
					textframe.Button.TimeRight:SetTextColor(r,g,b)	
					timerframe:SetScale(buttonscale)
					textframe.Button:SetAlpha(timerdata.alpha * alpha)
					textframe.Button:EnableMouse(clickable and timerdata.clickable)
				end
			end
		end
	end
	for i = 1,timerlib.totaltargets do
		if i > datatable.numvisible then
			timerlib.frames[i]:Hide() --hiding unused targets
			for id = 1,timerlib.totaltimers do
				timerlib.frames[i][id].data = nil
			end
		else
			for id = datatable[i].numvisible + 1,timerlib.totaltimers do
				local timerframe = timerlib.frames[i][id]
				timerframe:Hide() --hiding unused timers in used targets
				timerframe.data = nil
			end
		end
	end
	self:ResizeInterface()
end

function TimerLib:SortTimers()
	local casted = self.libraries["TimerLib"].datatable
	local time = GetTime()
	local method,letter = string.match(self:Get("sortmethod"),"(%a+) %((%a)%)")
	for i = 1,#(casted) do
		table.sort(casted[i],function(a,b)
			if a.hidden then
				return false
			elseif b.hidden then
				return true
			else
				local firstpriority = a.priority
				local secondpriority = b.priority
				if firstpriority == secondpriority then
					if (a.type == b.type) then
						if not a.module.libraries["TimerLib"].timerdata[a.type].disptimer then return ((letter == "A" and (a.spell < b.spell)) or (letter == "D" and (a.spell > b.spell))) end
						local val1 = ((method == "remaining" and (a.duration - time + a.time)) or (method == "added" and (a.time)) or (method == "alphabetical" and (a.spell)))
						local val2 = ((method == "remaining" and (b.duration - time + b.time)) or (method == "added" and (b.time)) or (method == "alphabetical" and (b.spell)))
						if letter == "A" then
							return (val1 < val2)
						elseif letter == "D" then
							return (val1 > val2)
						end	
					else
						local nohastimer1 = not a.module.libraries["TimerLib"].timerdata[a.type].hastimer
						local nohastimer2 = not b.module.libraries["TimerLib"].timerdata[b.type].hastimer
						local val1 = ((method == "remaining" and (nohastimer1 and math.huge or (a.duration - time + a.time))) or (method == "added" and (a.time)) or (method == "alphabetical" and (a.spell)))
						local val2 = ((method == "remaining" and (nohastimer2 and math.huge or (b.duration - time + b.time))) or (method == "added" and (b.time)) or (method == "alphabetical" and (b.spell)))
						if letter == "A" then
							return (val1 < val2)
						elseif letter == "D" then
							return (val1 > val2)
						end	
					end
				else
					return (math.abs(firstpriority or 0) < math.abs(secondpriority or 0))
				end
			end
		end)
	end
	for i,v in ipairs(casted) do
		v.numvisible = #(v)
		for id = 1,#(v) do
			if v[id].hidden then
				v.numvisible = id - 1
				break
			end
		end
	end
	local maxtargetnum = self:Get("maxtargets")
	for i = 1,#(casted) do
		local target = casted[i]
		if target.forceshow then target.hidden = false end
		if target.numvisible == 0 or (maxtargetnum > 0 and i > maxtargetnum) then
			target.hidden = true
		end
		if target.hidden then target.numvisible = 0 end
	end
	method,letter = string.match(self:Get("targetsort"),"(%a+) %((%a)%)")
	table.sort(casted,function(a,b)
		local isfirsthidden = a.hidden
		local issecondhidden = b.hidden
		if (isfirsthidden == issecondhidden) then
			local firstpriority = a.priority
			local secondpriority = b.priority
			if firstpriority == secondpriority then
				local val1 = ((method == "added" and (a.time)) or (method == "alphabetical" and (a.target)))
				local val2 = ((method == "added" and (b.time)) or (method == "alphabetical" and (b.target)))
				if letter == "A" then
					return (val1 < val2)
				elseif letter == "D" then
					return (val1 > val2)
				end	
				return (a.time > b.time)
			else
				return (math.abs(firstpriority or 0) < math.abs(secondpriority or 0))
			end
		else
			return issecondhidden
		end
	end)
	casted.numvisible = #(casted)
	for i = 1,#(casted) do
		if casted[i].hidden then 
			casted.numvisible = i - 1
			break
		end
	end
end

function TimerLib:ReturnTimerdataIndex(entry)
	for index,value in ipairs(self.libraries["TimerLib"].timerdata) do if value == entry then return index end end
	return #(self.libraries["TimerLib"].timerdata) + 1
end

function TimerLib:ReturnAnchors()
	local targetsetup = self:Get("targetlayout")
	local timersetup = self:Get("timerlayout")
	local timerspacing = self:Get("timerspacing")
	local targetspacing = self:Get("targetspacing")
	local movetarget = self:Get("movetargetname")
	local ref1,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,ref10
	local num1,num2,num3,num4,num5,num6,num7,num8,num9,num10
	--ref1/2: name string to target frame: the name is anchored by (1) to the target's (2)
	--ref3/4: time string to timer texture: the timer is anchored by (3) to the texture's (4)
	--ref5/6 the anchor corner/its opposite: the 1st target is anchored by (5) to the drag icon's (6)
	--ref7: corner for the other targets: the next target is anchored by (5) to the current's (7)
	--ref8/9: anchors for the timers: the next timer is anchored by its (9) to the previous's (8) (reversed order than usual)
	--num1/2: dist. between name string and target: you go left (1) and up (2) to go from target to name
	--num3/4: dist. between time string and texture: you go left (3) and up (4) to go from texture to timer
	--num5/6: dist. between timers: you go left (5) and up (6) to go from one timerlayout to the next
	--num7/8: dist. between targets: you go left (7) and up (8) to go from one target to the next
	--num9/10: from main frame to 1st target, for a bit of room: you go left (9) and up (10) to go from main frame to 1st target
	if targetsetup == "up" and timersetup == "left" then
		ref1,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,ref10 = (movetarget and "TOPRIGHT" or "TOPLEFT"),(movetarget and "BOTTOMRIGHT" or "TOPRIGHT"),"TOP","BOTTOM","BOTTOMRIGHT","TOPLEFT","TOPRIGHT","TOPLEFT","TOPRIGHT","BOTTOMRIGHT"
		num1,num2,num3,num4,num5,num6,num7,num8,num9,num10 = (movetarget and 0 or 5),(movetarget and -5 or 0),0,-timerstring_spacing,-timerspacing,0,0,targetspacing,-5,5
	elseif targetsetup == "down" and timersetup == "left" then
		ref1,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,ref10 = (movetarget and "BOTTOMRIGHT" or "TOPLEFT"),(movetarget and "TOPRIGHT" or "TOPRIGHT"),"TOP","BOTTOM","TOPRIGHT","BOTTOMLEFT","BOTTOMRIGHT","TOPLEFT","TOPRIGHT","TOPRIGHT"
		num1,num2,num3,num4,num5,num6,num7,num8,num9,num10 = (movetarget and 0 or 5),(movetarget and 5 or 0),0,-timerstring_spacing,-timerspacing,0,0,-targetspacing,-5,-5
	elseif targetsetup == "left" and timersetup == "up" then
		ref1,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,ref10 = "TOP","BOTTOM","LEFT","RIGHT","BOTTOMRIGHT","TOPLEFT","BOTTOMLEFT","TOPLEFT","BOTTOMLEFT","BOTTOM"
		num1,num2,num3,num4,num5,num6,num7,num8,num9,num10 = 0,-5,timerstring_spacing,0,0,timerspacing,-targetspacing,0,-5,5
	elseif targetsetup == "right" and timersetup == "up" then
		ref1,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,ref10 = "TOP","BOTTOM","LEFT","RIGHT","BOTTOMLEFT","TOPRIGHT","BOTTOMRIGHT","TOPLEFT","BOTTOMLEFT","BOTTOMLEFT"
		num1,num2,num3,num4,num5,num6,num7,num8,num9,num10 = 0,-5,timerstring_spacing,0,0,timerspacing,targetspacing,0,5,5
	elseif targetsetup == "up" and timersetup == "right" then
		ref1,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,ref10 = (movetarget and "TOPLEFT" or "TOPRIGHT"),(movetarget and "BOTTOMLEFT" or "TOPLEFT"),"TOP","BOTTOM","BOTTOMLEFT","TOPRIGHT","TOPLEFT","TOPRIGHT","TOPLEFT","LEFT"
		num1,num2,num3,num4,num5,num6,num7,num8,num9,num10 = (movetarget and 0 or -5),(movetarget and -5 or 0),0,-timerstring_spacing,timerspacing,0,0,targetspacing,5,5
	elseif targetsetup == "down" and timersetup == "right" then
		ref1,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,ref10 = (movetarget and "BOTTOMLEFT" or "TOPRIGHT"),(movetarget and "TOPLEFT" or "TOPLEFT"),"TOP","BOTTOM","TOPLEFT","BOTTOMRIGHT","BOTTOMLEFT","TOPRIGHT","TOPLEFT","TOPLEFT"
		num1,num2,num3,num4,num5,num6,num7,num8,num9,num10 = (movetarget and 0 or -5),(movetarget and 5 or 0),0,-timerstring_spacing,timerspacing,0,0,-targetspacing,5,-5
	elseif targetsetup == "left" and timersetup == "down" then
		ref1,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,ref10 = "BOTTOM","TOP","LEFT","RIGHT","TOPRIGHT","BOTTOMLEFT","TOPLEFT","BOTTOMLEFT","TOPLEFT","TOP"
		num1,num2,num3,num4,num5,num6,num7,num8,num9,num10 = 0,5,timerstring_spacing,0,0,-timerspacing,-targetspacing,0,-5,-5
	elseif targetsetup == "right" and timersetup == "down" then
		ref1,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,ref10 = "BOTTOM","TOP","LEFT","RIGHT","TOPLEFT","BOTTOMRIGHT","TOPRIGHT","BOTTOMLEFT","TOPLEFT","TOPLEFT"
		num1,num2,num3,num4,num5,num6,num7,num8,num9,num10 = 0,5,timerstring_spacing,0,0,-timerspacing,targetspacing,0,5,-5
	elseif targetsetup == "right" and timersetup == "right" then
		ref1,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,ref10 = "BOTTOMLEFT","TOPLEFT","TOP","BOTTOM","TOPLEFT","BOTTOMRIGHT","TOPRIGHT","TOPRIGHT","TOPLEFT","TOPLEFT"
		num1,num2,num3,num4,num5,num6,num7,num8,num9,num10 = 0,5,0,-timerstring_spacing,timerspacing,0,targetspacing,0,5,-5
	elseif targetsetup == "down" and timersetup == "down" then
		ref1,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,ref10 = (movetarget and "BOTTOM" or "TOPRIGHT"),(movetarget and "TOP" or "TOPLEFT"),"LEFT","RIGHT","TOPLEFT","BOTTOMRIGHT","BOTTOMLEFT","BOTTOMLEFT","TOPLEFT","TOPLEFT"
		num1,num2,num3,num4,num5,num6,num7,num8,num9,num10 = (movetarget and 0 or -5),(movetarget and 5 or 0),timerstring_spacing,0,0,-timerspacing,0,-targetspacing,5,-5
	elseif targetsetup == "left" and timersetup == "left" then
		ref1,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,ref10 = "BOTTOMRIGHT","TOPRIGHT","TOP","BOTTOM","TOPRIGHT","BOTTOMLEFT","TOPLEFT","TOPLEFT","TOPRIGHT","TOPRIGHT"
		num1,num2,num3,num4,num5,num6,num7,num8,num9,num10 = 0,5,0,-timerstring_spacing,-timerspacing,0,-targetspacing,0,-5,-5
	elseif targetsetup == "up" and timersetup == "up" then
		ref1,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,ref10 = (movetarget and "TOP" or "BOTTOMRIGHT"),(movetarget and "BOTTOM" or "BOTTOMLEFT"),"LEFT","RIGHT","BOTTOMLEFT","TOPRIGHT","TOPLEFT","TOPLEFT","BOTTOMLEFT","BOTTOMLEFT"
		num1,num2,num3,num4,num5,num6,num7,num8,num9,num10 = (movetarget and 0 or -5),(movetarget and -5 or 0),timerstring_spacing,0,0,timerspacing,0,targetspacing,5,5
	elseif targetsetup == "up" and timersetup == "down" then
		ref1,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,ref10 = (movetarget and "TOP" or "TOPRIGHT"),(movetarget and "BOTTOM" or "TOPLEFT"),"LEFT","RIGHT","BOTTOMLEFT","TOPRIGHT","TOPLEFT","BOTTOMLEFT","TOPLEFT","TOPLEFT"
		num1,num2,num3,num4,num5,num6,num7,num8,num9,num10 = (movetarget and 0 or -5),(movetarget and -5 or 0),timerstring_spacing,0,0,-timerspacing,0,targetspacing,5,5
	elseif targetsetup == "down" and timersetup == "up" then
		ref1,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,ref10 = (movetarget and "BOTTOM" or "BOTTOMRIGHT"),(movetarget and "TOP" or "BOTTOMLEFT"),"LEFT","RIGHT","TOPLEFT","BOTTOMRIGHT","BOTTOMLEFT","TOPLEFT","BOTTOMLEFT","BOTTOMLEFT"
		num1,num2,num3,num4,num5,num6,num7,num8,num9,num10 = (movetarget and 0 or -5),(movetarget and 5 or 0),timerstring_spacing,0,0,timerspacing,0,-targetspacing,5,-5
	elseif targetsetup == "left" and timersetup == "right" then
		ref1,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,ref10 = "BOTTOMLEFT","TOPLEFT","TOP","BOTTOM","TOPRIGHT","BOTTOMLEFT","TOPLEFT","TOPRIGHT","TOPLEFT","TOPLEFT"
		num1,num2,num3,num4,num5,num6,num7,num8,num9,num10 = 0,5,0,-timerstring_spacing,timerspacing,0,-targetspacing,0,5,-5
	elseif targetsetup == "right" and timersetup == "left" then
		ref1,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,ref10 = "BOTTOMRIGHT","TOPRIGHT","TOP","BOTTOM","TOPLEFT","BOTTOMRIGHT","TOPRIGHT","TOPLEFT","TOPRIGHT","TOPRIGHT"
		num1,num2,num3,num4,num5,num6,num7,num8,num9,num10 = 0,5,0,-timerstring_spacing,-timerspacing,0,targetspacing,0,-5,-5
	else
		return
	end
	return ref1,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,ref10,num1,num2,num3,num4,num5,num6,num7,num8,num9,num10
end

function TimerLib:DefineInterface() --the controller behind the 16 different interface layouts
	--expects:
	-- .targetlayout
	-- .timerlayout
	-- .targetspacing
	-- .timerspacing
	local ref1,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,ref10,num1,num2,num3,num4,num5,num6,num7,num8,num9,num10 = self:ReturnAnchors()
	for i = 1,self.libraries["TimerLib"].totaltargets do
		local targetframe = self.libraries["TimerLib"].frames[i]
		targetframe:ClearAllPoints()
		targetframe.Name:ClearAllPoints()
		targetframe.Name:SetPoint(ref1,targetframe:GetName(),ref2,num1,num2)
		for id = 1,self.libraries["TimerLib"].totaltimers do
			local timerframe =self.libraries["TimerLib"].frames[i][id]
			timerframe:ClearAllPoints()
			timerframe.Icon.Time:ClearAllPoints()
			timerframe.Icon.Time:SetPoint(ref3,timerframe.Icon.Button:GetName(),ref4,num3,num4)
		end
	end
	for i = 1,self.libraries["TimerLib"].totaltargets do
		self.libraries["TimerLib"].frames[i][1]:SetPoint(ref10,self.libraries["TimerLib"].targetframe..i,ref10)
		for id = 2,self.libraries["TimerLib"].totaltimers do
			self.libraries["TimerLib"].frames[i][id]:SetPoint(ref9,self.libraries["TimerLib"].targetframe..i..self.libraries["TimerLib"].timerframe..(id-1),ref8,num5,num6)
		end
	end
	self.libraries["TimerLib"].frames[1]:SetPoint(ref5,self.libraries["TimerLib"].positionframe,ref6,num9,num10)
	for i = 2,self.libraries["TimerLib"].totaltargets do
		self.libraries["TimerLib"].frames[i]:SetPoint(ref5,self.libraries["TimerLib"].targetframe..(i-1),ref7,num7,num8)
	end
end

function TimerLib:ResizeInterface(target) --resizes the frames that hold the timers so that they are more tightly compacted on the screen
	local timerformat = self:Get("format")
	local timerlayout = self:Get("timerlayout")
	local targetlayout = self:Get("targetlayout")
	local timerspacing = self:Get("timerspacing")
	local barlength = self:Get("barlength")
	local buttonscale = self:Get("buttonscale")
	local hasname = self:Get("names") or self:Get("raidicons")
	local offset = self:Get("icons") and 16 or 0
	if self.libraries["TimerLib"].datatable then
		for i = 1,self.libraries["TimerLib"].datatable.numvisible do
			if (not target) or (i == target) then
				local totalwidth,totalheight = 0,0
				local numvisible = self.libraries["TimerLib"].datatable[i].numvisible
				if timerlayout == "down" or timerlayout == "up" then
					if timerformat == "icons" then
						local maxwidth,maxheight = 0,0
						for id = 1,numvisible do
							local timer = self.libraries["TimerLib"].frames[i][id].Icon
							maxheight = math.max(timer:GetHeight(),maxheight)
							maxwidth = math.max(timer:GetWidth(),maxwidth)
						end
						totalheight = (numvisible * (maxheight + timerspacing)) - timerspacing
						totalwidth = maxwidth
					elseif timerformat == "bars" then
						totalheight = (numvisible * (16 + timerspacing) * buttonscale) - (timerspacing * buttonscale)
						totalwidth = (barlength + offset) * buttonscale
					elseif timerformat == "text" then
						totalheight = (numvisible * (15 + timerspacing) * buttonscale) - (timerspacing * buttonscale)
						totalwidth = barlength * buttonscale
					end
				else
					if timerformat == "icons" then
						local maxwidth,maxheight = 0,0
						for id = 1,numvisible do
							local timer = self.libraries["TimerLib"].frames[i][id].Icon
							maxheight = math.max(timer:GetHeight(),maxheight)
							totalwidth = totalwidth + timer:GetWidth() + timerspacing
						end
						totalheight = maxheight
						totalwidth = totalwidth - timerspacing
					elseif timerformat == "bars" then
						totalheight = 16 * buttonscale
						totalwidth = (numvisible * ((barlength + offset) + timerspacing) * buttonscale) - (timerspacing * buttonscale)
					elseif timerformat == "text" then
						totalheight = 15 * buttonscale
						totalwidth = (numvisible * (barlength + timerspacing) * buttonscale) - (timerspacing * buttonscale)
					end
				end
				local targetheight,targetwidth
				local targetframe = self.libraries["TimerLib"].frames[i]
				local adjustoffset
				local namewidth,nameheight
				if hasname then
					namewidth = targetframe.Name:GetWidth()
					nameheight = targetframe.Name:GetHeight()
					if (targetlayout == "down" or targetlayout == "up") then
						--height
						if self:Get("movetargetname") then
							targetheight = totalheight
							targetwidth = totalwidth
							adjustoffset = true
						else
							targetheight = math.max(totalheight,nameheight)
							targetwidth = totalwidth
						end
					else
						targetheight = totalheight
						targetwidth = math.max(totalwidth,namewidth)
					end
				else
					targetheight = totalheight
					targetwidth = totalwidth
				end
				local ref1,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,ref10,num1,num2,num3,num4,num5,num6,num7,num8,num9,num10 = self:ReturnAnchors()
				if adjustoffset then
					local add = nameheight + 5
					if targetlayout == "down" then num8 = num8 - add else num8 = num8 + add end
				end
				if i > 1 then targetframe:SetPoint(ref5,self.libraries["TimerLib"].targetframe..(i-1),ref7,num7,num8) end
				targetframe:SetWidth(targetwidth)
				targetframe:SetHeight(targetheight)
			end
		end
	end
end

function TimerLib:DefineFormat()
	--expects:
	-- .format
	-- .icons
	-- .barlength
	if self:Get("format") == "icons" then
		for i = 1,self.libraries["TimerLib"].totaltargets do
			for id = 1,self.libraries["TimerLib"].totaltimers do
				local timerframe = self.libraries["TimerLib"].frames[i][id]
				timerframe.Icon:Show()
				timerframe.Bar:Hide()
				timerframe.Text:Hide()
				timerframe:SetScale(1)
			end
		end
	elseif self:Get("format") == "bars" then
		for i = 1,self.libraries["TimerLib"].totaltargets do
			for id = 1,self.libraries["TimerLib"].totaltimers do
				local timerframe = self.libraries["TimerLib"].frames[i][id]
				timerframe.Icon:Hide()
				timerframe.Bar:Show()
				timerframe.Text:Hide()
				local barframe = timerframe.Bar
				local offset
				if self:Get("icons") then
					offset = 16
					barframe.Button.Texture:Show()
					barframe.Button.Border:Show()
				else
					offset = 0
					barframe.Button.Texture:Hide()
					barframe.Button.Border:Hide()
				end
				local barlength = self:Get("barlength")
				local texture = self:Get("bartexture")
				barframe.Status.Front:ClearAllPoints()
				barframe.Status.Front:SetPoint("TOPLEFT",barframe:GetName(),"TOPLEFT",offset,0)
				barframe:SetWidth(barlength + offset)
				barframe:SetHeight(16)
				timerframe:SetWidth(barlength + offset)
				timerframe:SetHeight(16)
				local color = self:Get("bartextcolor")
				barframe.Status.Time:SetTextColor(color.r,color.g,color.b)
				color = self:Get("barbackgroundcolor")
				barframe.Status.Background:SetStatusBarColor(color.r,color.g,color.b)
				barframe.Button:SetWidth(barlength + offset)
				barframe.Status.Front:SetWidth(barlength)
				barframe.Status.Front:SetStatusBarTexture(bartextures[texture])
				barframe.Status.Background:SetWidth(barlength)
				barframe.Status.Background:SetStatusBarTexture(bartextures[texture])
			end
		end
	elseif self:Get("format") == "text" then
		for i = 1,self.libraries["TimerLib"].totaltargets do
			for id = 1,self.libraries["TimerLib"].totaltimers do
				local timerframe = self.libraries["TimerLib"].frames[i][id]
				timerframe.Icon:Hide()
				timerframe.Bar:Hide()
				timerframe.Text:Show()
				local textframe = timerframe.Text
				local barlength = self:Get("barlength")
				textframe:SetWidth(barlength)
				textframe:SetHeight(15)
				timerframe:SetWidth(barlength)
				timerframe:SetHeight(15)
				textframe.Button.Time:SetWidth(barlength)
				textframe.Button:SetWidth(barlength)
			end
		end
	end
end

local blanktimer = {
	spell = "Blank Spot", 
	rank = "", 
	texture = "No Texture", 
	duration = 0, 
	time = 0, 
	type = "blank", 
	english = "Blank Spot",
}

function TimerLib:InsertBlankTimer(i,id)
	self:AddTimer(i,blanktimer,1,nil,nil,id)
end

local secondsformats = {
	["##"] = "%d%s",
	[":##"] = ":%.2d%s",
	["0:##"] = "0:%.2d%s",
}

function TimerLib:ReturnFormattedDuration(time) --modifies the time remaining on the timer into a format suitable for the screen
	--expects:
	-- .tenths
	local secondsformat = self:Get("secondsformat")
	if secondsformat == "##s" or secondsformat == "##s abbv" then return self:NumToTime(time,self:Get("tenths"),secondsformat) end
	local minutes = math.floor(time / 60)
	local seconds = math.floor(time - (60 * minutes))
	local remaining = time - (60 * minutes) - (seconds)
	local decimal
	if (self:Get("tenths") and time < 10) then decimal = "."..string.format("%d",remaining * 10) else decimal = "" end
	if minutes == 0 then
		return string.format(secondsformats[secondsformat],seconds,decimal)
	else
		if minutes < 60 then
			return string.format("%d:%.2d%s",minutes,seconds,decimal)
		else
			local hours = math.floor(minutes / 60)
			minutes = minutes - (60 * hours)
			if hours < 24 then
				return string.format("%d:%d:%.2d%s",hours,minutes,seconds,decimal)
			else
				local days = math.floor(hours / 24)
				hours = hours - (24 * days)
				return string.format("%d:%d:%d:%.2d%s",days,hours,minutes,seconds,decimal)
			end
		end
	end
end

function TimerLib:UpdateTimers(elapsed) --updating the timers onscreen, as well as checking for any finished timers
	--expects:
	-- .tenths
	-- .format
	-- .playsound
	-- .expalert
	local timerformat = self:Get("format")
	local barmsg = self:Get("barmsg")
	local ghosts = self:Get("ghosts")
	local ghostduration = self:Get("ghostdata")
	local tenths = self:Get("tenths")
	local playsound = self:Get("playsound")
	local expalert = self:Get("expalert")
	local reversed = self:Get("reversed")
	local barlength = self:Get("barlength")
	local fadeintime = self:Get("fadeintime")
	local fadeouttime = self:Get("fadeouttime")
	local background = self:Get("barbackgroundcolor")
	local timerspacing = self:Get("timerspacing")
	local timerlayout = self:Get("timerlayout")
	local targetlayout = self:Get("targetlayout")
	local buttonscale = self:Get("buttonscale")
	local timerlib = self.libraries["TimerLib"]
	local datatable = timerlib.datatable
	if #(datatable) == 0 then timerlib.frame:SetScript("OnUpdate",nil) end
	local isoperating = false
	local time = GetTime()
	for i = #(datatable),1,-1 do --scanning all the timers to see if they are done
		for id = #(datatable[i]),1,-1 do
			if datatable[i] and datatable[i][id] then
				local timer = datatable[i][id]
				local drawing = (id <= datatable[i].numvisible)
				local timerdata = timer.module.libraries["TimerLib"].timerdata[timer.type]
				local timerframe
				if drawing then
					timerframe = timerlib.frames[i][id]
					timerframe:SetAlpha(1)
				end
				if timerdata.hastimer then
					isoperating = true
					timer.alpha = nil
					if time >= timer.time + timer.duration then --yep it's done all right
						if not timer.finished then self:RemoveTimer(i,id,"finished") end
						if drawing then
							if not timer.datachanged then
								timer.datachanged = true
								local r,g,b = timer.module:GetTimerColor(timer)
								if timerformat == "bars" then
									timerframe.Bar.Status.Time:SetWidth(barlength - 6)
									timerframe.Bar.Status.Time:SetText(string.find(barmsg,"%%s") and timer.spell or "")
									timerframe.Bar.Status.TimeRight:SetText("")
									timerframe.Bar.Status.Front:SetValue((ghosts or reversed) and 1 or 0)
									timerframe.Bar.Status.Front.Spark:Hide()
									timerframe.Bar.Status.Front:SetStatusBarColor(r,g,b)
									if ghosts or reversed then
										timerframe.Bar.Button.Border:SetVertexColor(r,g,b)
									else
										timerframe.Bar.Button.Border:SetVertexColor(background.r,background.g,background.b)
									end
									timerframe.Bar.Button.Stack:SetText("")
								elseif timerformat == "icons" then
									timerframe.Icon.Time:SetText("")
									timerframe.Icon.Time:SetTextColor(r,g,b)
									timerframe.Icon.Button.Stack:SetText("")
									timerframe.Icon.Button.Border:SetVertexColor(r,g,b)
									timerframe.Icon:SetWidth(24 * buttonscale)
									timerframe.Icon:SetHeight(24 * buttonscale)
									timerframe:SetWidth(24 * buttonscale)
									timerframe:SetHeight(24 * buttonscale)
									self:ResizeInterface(i)
								elseif timerformat == "text" then
									timerframe.Text.Button.Time:SetWidth(barlength - 6)
									timerframe.Text.Button.Time:SetText(string.find(barmsg,"%%s") and timer.spell or "")
									timerframe.Text.Button.TimeRight:SetText("")
									timerframe.Text.Button.Time:SetTextColor(r,g,b)
									timerframe.Text.Button.TimeRight:SetTextColor(r,g,b)
								end
							end
							local dtype = timer.type
							local fadingout
							local moddedduration = 0
							if ghosts then 
								if time >= timer.time + timer.duration + ghostduration then
									fadingout = true
									moddedduration = ghostduration
								end
							else
								fadingout = true
							end
							if fadingout then
								if (fadeouttime == 0) or (time >= timer.time + timer.duration + moddedduration + fadeouttime) then
									self:RemoveTimer(i,id,"fadedout")
								else
									local alpha = 1 - ((time - timer.time - timer.duration - moddedduration) / fadeouttime)
									timer.alpha = alpha
									timer.frame:SetAlpha(alpha)
								end
							end
						else
							self:RemoveTimer(i,id,"fadedout")
						end
					else
						local timeremaining = timer.duration - time + timer.time
						if drawing then
							local timeelapsed = time - timer.timeadded
							local fadingtime = math.min(fadeintime,timer.duration - 1)
							if fadingtime > 0 then
								if timeelapsed <= fadingtime then
									local alpha = timeelapsed / fadingtime
									timerframe:SetAlpha(alpha)
									timer.alpha = alpha
								end
							end
						end
						if timerdata.disptimer then
							if drawing then
								local remaining = tonumber(string.format((tenths and timeremaining < 10) and "%.1f" or "%d",timeremaining)) --modifying the displayed time if it needs changing
								if timerformat == "icons" then
									local r,g,b = timer.module:GetTimerColor(timer)
									if (not timer.r) or (not (timer.r == r and timer.g == g and timer.b == b)) then
										timerframe.Icon.Time:SetTextColor(r,g,b)
										timerframe.Icon.Button.Border:SetVertexColor(r,g,b)
										timer.r = r
										timer.g = g
										timer.b = b
									end
									if (not timer.displayed) or (remaining < timer.displayed) then
										timerframe.Icon.Time:SetText(self:ReturnFormattedDuration(timeremaining)) --updating the time if they aren't done
										if (timer.stack and timer.stack > 1) then timerframe.Icon.Button.Stack:SetText(timer.stack) else timerframe.Icon.Button.Stack:SetText("") end
										if remaining == 5 then
											if playsound then PlaySoundFile(AsheylaLib:GetPath().."\\Ash_Core\\Files\\expalert.wav") end
											if expalert then timerframe.Icon.Button:LockHighlight() end
										elseif remaining == 3 then
											if expalert then timerframe.Icon.Button:UnlockHighlight() end
										end
										local timerwidth,timerheight
										local resizing = false
										if timerlayout == "left" or timerlayout == "right" then
											local oldwidth = timerframe:GetWidth()
											timerwidth = math.max(oldwidth,math.max(24 * buttonscale,timerframe.Icon.Time:GetWidth()))
											if not (oldwidth == timerwidth) then resizing = true end
											timerheight = (24 * buttonscale) + timerstring_spacing + timerframe.Icon.Time:GetHeight()
											timerframe.Icon:SetWidth(timerwidth)
											timerframe.Icon:SetHeight(timerheight)
											timerframe:SetWidth(timerwidth)
											timerframe:SetHeight(timerheight)
											if resizing then self:ResizeInterface(i) end
										elseif (targetlayout == "left" or targetlayout == "right") then
											local oldwidth = timerframe:GetWidth()
											timerwidth = math.max(oldwidth,(24 * buttonscale) + timerstring_spacing + timerframe.Icon.Time:GetWidth())
											if not (oldwidth == timerwidth) then resizing = true end
											timerheight = math.max((24 * buttonscale),timerframe.Icon.Time:GetHeight())
											timerframe.Icon:SetWidth(timerwidth)
											timerframe.Icon:SetHeight(timerheight)
											timerframe:SetWidth(timerwidth)
											timerframe:SetHeight(timerheight)
											if resizing then self:ResizeInterface(i) end
										end
										timer.displayed = remaining
									end
								elseif timerformat == "bars" then
									local barvalue = timeremaining / timer.duration
									if reversed then barvalue = 1 - barvalue end
									timerframe.Bar.Status.Front:SetValue(barvalue)
									local r,g,b = timer.module:GetTimerColor(timer)
									if (not timer.r) or (not (timer.r == r and timer.g == g and timer.b == b)) then
										timerframe.Bar.Status.Front:SetStatusBarColor(r,g,b)
										timerframe.Bar.Button.Border:SetVertexColor(r,g,b) --flag
										timer.r = r
										timer.g = g
										timer.b = b
									end
									if (not timer.displayed) or (remaining < timer.displayed) then
										local text,middle,right = self:FormatBarText(i,id)
										timerframe.Bar.Status.Time:SetText(text) --updating the time if they aren't done
										timerframe.Bar.Status.Time:SetWidth(barlength - 6)
										timerframe.Bar.Status.TimeRight:SetWidth(barlength - 6)
										if middle and right then
											timerframe.Bar.Status.TimeRight:SetText(right)
											local leftwidth = math.min(timerframe.Bar.Status.Time:GetStringWidth() + 5,barlength - 6)
											local rightwidth = math.min(timerframe.Bar.Status.TimeRight:GetStringWidth() + 5,barlength - 6)
											if middle == ":&" then
												timerframe.Bar.Status.Time:SetWidth(leftwidth)
												timerframe.Bar.Status.TimeRight:SetWidth(barlength - 6 - leftwidth)
											elseif middle == "&:" or middle == "&" or middle == ":&:" then
												timerframe.Bar.Status.Time:SetWidth(barlength - 6 - rightwidth)
												timerframe.Bar.Status.TimeRight:SetWidth(rightwidth)
											end
										else
											timerframe.Bar.Status.TimeRight:SetText("")
											timerframe.Bar.Status.Time:SetWidth(barlength - 6)
										end
										if (timer.stack and timer.stack > 1) then timerframe.Bar.Button.Stack:SetText(timer.stack) else timerframe.Bar.Button.Stack:SetText("") end
										if remaining == 5 then
											if playsound then PlaySoundFile(AsheylaLib:GetPath().."\\Ash_Core\\Files\\expalert.wav") end
										end
										timer.displayed = remaining
									end
									timerframe.Bar.Status.Front.Spark:ClearAllPoints()
									timerframe.Bar.Status.Front.Spark:SetPoint("CENTER",timerframe.Bar.Status.Front:GetName(),"LEFT",(barvalue * barlength),0)
								elseif timerformat == "text" then	
									local r,g,b = timer.module:GetTimerColor(timer)
									if (not timer.r) or (not (timer.r == r and timer.g == g and timer.b == b)) then
										timerframe.Text.Button.Time:SetTextColor(r,g,b)
										timerframe.Text.Button.TimeRight:SetTextColor(r,g,b)
										timer.r = r
										timer.g = g
										timer.b = b
									end
									if (not timer.displayed) or (remaining < timer.displayed) then
										local text,middle,right = self:FormatBarText(i,id)
										timerframe.Text.Button.Time:SetText(text) --updating the time if they aren't done
										if middle and right then
											timerframe.Text.Button.TimeRight:SetText(right)
											timerframe.Text.Button.Time:SetWidth(barlength)
											timerframe.Text.Button.TimeRight:SetWidth(barlength)
											local leftwidth = math.min(timerframe.Text.Button.Time:GetStringWidth() + 5,barlength)
											local rightwidth = math.min(timerframe.Text.Button.TimeRight:GetStringWidth() + 5,barlength)
											if middle == ":&" then
												timerframe.Text.Button.Time:SetWidth(leftwidth)
												timerframe.Text.Button.TimeRight:SetWidth(barlength - leftwidth)
											elseif middle == "&:" or middle == "&" or middle == ":&:" then
												timerframe.Text.Button.Time:SetWidth(barlength - rightwidth)
												timerframe.Text.Button.TimeRight:SetWidth(rightwidth)
											end
										else
											timerframe.Text.Button.TimeRight:SetText("")
											timerframe.Text.Button.Time:SetWidth(barlength)
										end
										if remaining == 5 then
											if playsound then PlaySoundFile(AsheylaLib:GetPath().."\\Ash_Core\\Files\\expalert.wav") end
										end
										timer.displayed = remaining
									end
								end
							end
						end
					end
				else
					if timer.finished then
						isoperating = true
						if not timer.resettime then
							timer.resettime = true
							timer.time = GetTime()
						end
						if drawing then
							if not timer.datachanged then
								timer.datachanged = true
								local r,g,b = timer.module:GetTimerColor(timer)
								if timerformat == "bars" then
									timerframe.Bar.Status.Time:SetText(string.find(barmsg,"%%s") and timer.spell or "")
									timerframe.Bar.Status.Front:SetValue((ghosts or reversed) and 1 or 0)
									timerframe.Bar.Status.Front.Spark:Hide()
									timerframe.Bar.Status.Front:SetStatusBarColor(r,g,b)
									if ghosts or reversed then
										timerframe.Bar.Button.Border:SetVertexColor(r,g,b)
									else
										timerframe.Bar.Button.Border:SetVertexColor(background.r,background.g,background.b)
									end
									timerframe.Bar.Button.Stack:SetText("")
								elseif timerformat == "icons" then
									timerframe.Icon.Time:SetText("")
									timerframe.Icon.Time:SetTextColor(r,g,b)
									timerframe.Icon.Button.Stack:SetText("")
									timerframe.Icon.Button.Border:SetVertexColor(r,g,b)
								elseif timerformat == "text" then
									timerframe.Text.Button.Time:SetText(string.find(barmsg,"%%s") and timer.spell or "")
									timerframe.Text.Button.Time:SetTextColor(r,g,b)
									timerframe.Text.Button.TimeRight:SetTextColor(r,g,b)
								end
							end
							local dtype = timer.type
							local fadingout
							local moddedduration = 0
							if ghosts then 
								if time >= timer.time + timer.duration + ghostduration then
									fadingout = true
									moddedduration = ghostduration
								end
							else
								fadingout = true
							end
							if fadingout then
								if (fadeouttime == 0) or (time >= timer.time + timer.duration + moddedduration + fadeouttime) then
									self:RemoveTimer(i,id,"fadedout")
								else
									local alpha = 1 - ((time - timer.time - timer.duration - moddedduration) / fadeouttime)
									timer.alpha = alpha
									timer.frame:SetAlpha(alpha)
								end
							end
						else
							self:RemoveTimer(i,id,"fadedout")
						end
					else
						if drawing then
							local timeelapsed = time - timer.timeadded
							if fadeintime > 0 then
								if timeelapsed <= fadeintime then
									isoperating = true
									local alpha = timeelapsed / fadeintime
									timerframe:SetAlpha(alpha)
									timer.alpha = alpha
								end
							end
							local r,g,b = timer.module:GetTimerColor(timer)
							if (not timer.r) or (not (timer.r == r and timer.g == g and timer.b == b)) then
								--update color
								if timerformat == "bars" then
									timerframe.Bar.Status.Front:SetStatusBarColor(r,g,b)
								elseif timerformat == "icons" then
									timerframe.Icon.Button.Border:SetVertexColor(r,g,b)
								elseif timerformat == "text" then
									timerframe.Text.Button.Time:SetTextColor(r,g,b)
									timerframe.Text.Button.TimeRight:SetTextColor(r,g,b)
								end
							end
						end
					end
				end
			end
		end
	end
	if not isoperating then timerlib.frame:SetScript("OnUpdate",nil) end
end

function TimerLib:ReturnTargetTable(target,sex,level,module) --returns the timer table for the corresponding target/sex/level information
	local casted = self.libraries["TimerLib"].datatable
	for i = 1,#(casted) do
		if casted[i].target == target and casted[i].sex == sex and casted[i].level == level and ((not module) or casted[i].module == module) then return i end
	end
end

function TimerLib:ReturnTargetType(unit)
	if (UnitIsPlayer(unit) or UnitPlayerControlled(unit)) then return "player" end
	return "mob"
end

function TimerLib:HasDebuff(spell,unit)
	unit = unit or "target"
	spell = string.gsub(spell,"(%p)","%%%1")
	local i = 1
	local debuff,rank,icon,count,debuffType,duration,timeleft = UnitDebuff(unit,1)
	while debuff do
		if string.find(debuff,spell) and duration and timeleft then return duration,timeleft end
		i = i + 1
		debuff,rank,icon,count,debuffType,duration,timeleft = UnitDebuff(unit,i)
	end
end

function TimerLib:HasBuff(spell,unit)
	unit = unit or "target"
	spell = string.gsub(spell,"(%p)","%%%1")
	local i = 1
	local buff,rank,icon,count,duration,timeleft = UnitBuff(unit,1)
	while buff do
		if string.find(buff,spell) and duration and timeleft then return duration,timeleft end
		i = i + 1
		buff,rank,icon,count,duration,timeleft = UnitBuff(unit,i)
	end
end

function TimerLib:FindUnitTargetTable(unit)
	local name = UnitName(unit)
	local sex = UnitSex(unit)
	local level = UnitLevel(unit)
	local time = GetTime()
	for i = 1,self:GetNumTargets() do
		local target = self:GetTarget(i)
		if target.target == name and target.sex == sex and target.level == level then
			for id = 1,self:GetNumTimers(i) do
				local timer = self:GetTimer(i,id)
				local duration,timeleft
				if timer.type == "debuff" then
					duration,timeleft = self:HasDebuff(timer.spell,unit)
				elseif timer.type == "buff" then
					duration,timeleft = self:HasBuff(timer.spell,unit)
				end
				if (duration and timeleft) and (math.abs(timeleft - (timer.duration - time + timer.time)) <= .1) and (math.abs(duration - timer.duration) <= .1) then return i end
			end
		end
	end
end

function TimerLib:ReturnUnitTargetTable(unit)
	local unitflag = (UnitIsUnit(unit,"target") and "target") or (UnitIsUnit(unit,"focus") and "focus")
	if unitflag then unit = unitflag end
	local ttype = self:ReturnTargetType(unit)
	if unit == "target" or unit == "focus" then
		for i = 1,self:GetNumTargets() do
			local target = self:GetTarget(i)
			if target.unit and target.unit == unit then return i end
		end
	end
	if ttype == "player" then
		for i = 1,self:GetNumTargets() do
			local target = self:GetTarget(i)
			if ttype == target.type and target.target == UnitName(unit) then return i end
		end
	end
	local i = self:FindUnitTargetTable(unit)
	if i then
		if unitflag then self:GetTarget(i).unit = unit end
		return i
	end
end

local subentries = {}
function TimerLib:FormatBarText(i,id)
	--expects:
	-- .barmsg
	for k,v in pairs(subentries) do subentries[k] = nil end
	local datatable = self.libraries["TimerLib"].datatable[i]
	local displayed = datatable[id].duration - GetTime() + self.libraries["TimerLib"].datatable[i][id].time
	local count = (datatable[id].stack and datatable[id].stack > 1 and datatable[id].stack or "")
	local spell = datatable[id].spell
	local rank = datatable[id].rank
	local target = datatable.target
	local level = datatable.level
	subentries["%d"] = self:ReturnFormattedDuration(displayed)
	subentries["%s"] = spell
	subentries["%c"] = count
	subentries["%r"] = rank
	subentries["%t"] = target
	subentries["%l"] = level
	local msg = string.gsub(self:Get("barmsg"),"(%%%a)",function(a) return subentries[a] or "" end)
	msg = string.gsub(msg,"[%(%[%<%{][%)%]%>%}]","")
	if string.find(msg,"&") then
		local left,middle,right = string.match(msg,"(.+)(:?&:?)(.+)")
		return left,middle,right
	end
	return msg
end

function TimerLib:CreateTimerGroup(name,isreal,hastimer,disptimer,clickable,alpha,colors,total)
	self.libraries["TimerLib"].timerdata = self.libraries["TimerLib"].timerdata or {}
	self.libraries["TimerLib"].timerdata[name] = {
		isreal = isreal,
		hastimer = hastimer,
		disptimer = disptimer,
		clickable = clickable,
		alpha = alpha,
		colors = colors,
		total = total,
	}
	table.insert(self.libraries["TimerLib"].timerdata,name)
end

function TimerLib:RemoveTimer(i,id,reason,suppress,nofade) --deletes a timer onscreen from existence
	--expects:
	-- .ghosts
	--possible reasons: finished, broke, replaced, target, full, clicked,inaccurate
	if self.libraries["TimerLib"].frozen then return end
	reason = reason or "unknown"
	if self.libraries["TimerLib"].datatable[i] and self.libraries["TimerLib"].datatable[i][id] then
		local timer = self:GetTimer(i,id)
		local remaining = timer.duration - GetTime() + timer.time
		if (reason == "fadedout" or reason == "clicked") or nofade or (remaining > (timer.duration / 20)) then --if less than 5% remains, it will be left alone to fade out.
			if reason == "broke" then reason = "finished" end
			local timer = self.libraries["TimerLib"].datatable[i][id]
			table.remove(self.libraries["TimerLib"].datatable[i],id)
			self:Debug("the timer for "..timer.spell.." has been removed, reason: "..reason)
			self:ReleaseTable(timer)
			if not suppress then self:CreateInterface() end
		else
			timer.finished = true
		end
	end
end

function TimerLib:GetTimerColor(timer)
	local remaining = timer.duration - GetTime() + timer.time
	local half = timer.duration / 2
	local colors
	local r,g,b
	colors = self:Get("colors","timer",timer.spell)
	if not colors then colors = self:Get("colors","timer",string.lower(timer.spell)) end
	if not colors then colors = self:Get("colors","type",timer.type) end
	if not colors then colors = self.libraries["TimerLib"].timerdata[timer.type].colors end
	if self.libraries["TimerLib"].timerdata[timer.type].disptimer then
		if remaining <= 0 and self:Get("ghosts") then
			local color = self:Get("ghostcolor")
			r,g,b = color.r,color.g,color.b
		elseif remaining <= 5 then
			local color = colors["final"]
			r,g,b = color.r,color.g,color.b
		elseif remaining <= 7 then
			local fadefromcolor
			if remaining > half then
				fadefromcolor = colors["begin"]
			else
				fadefromcolor = colors["half"]
			end
			local fadetocolor = colors["final"]
			local elapsed = (7 - remaining) / 2
			r = fadefromcolor.r + ((fadetocolor.r - fadefromcolor.r) * elapsed)
			g = fadefromcolor.g + ((fadetocolor.g - fadefromcolor.g) * elapsed)
			b = fadefromcolor.b + ((fadetocolor.b - fadefromcolor.b) * elapsed)
		elseif remaining <= half then
			local color = colors["half"]
			r,g,b = color.r,color.g,color.b
		elseif remaining <= half + 2 then
			local fadefromcolor = colors["begin"]
			local fadetocolor = colors["half"]
			local elapsed = (half + 2 - remaining) / 2
			r = fadefromcolor.r + ((fadetocolor.r - fadefromcolor.r) * elapsed)
			g = fadefromcolor.g + ((fadetocolor.g - fadefromcolor.g) * elapsed)
			b = fadefromcolor.b + ((fadetocolor.b - fadefromcolor.b) * elapsed)
		else
			local color = colors["begin"]
			r,g,b = color.r,color.g,color.b
		end
	else
		if timer.finished then
			local color = self:Get("ghostcolor")
			r,g,b = color.r,color.g,color.b
		else
			local color = colors["begin"]
			r,g,b = color.r,color.g,color.b
		end
	end
	return r,g,b
end

function TimerLib:RemoveTarget(targetindex,norefresh)
	if self.libraries["TimerLib"].frozen then return end
	self:Debug("a target table has been removed")
	local target = self.libraries["TimerLib"].datatable[targetindex]
	for id = #(target),1,-1 do self:RemoveTimer(targetindex,id,"target",1,1) end
	table.remove(self.libraries["TimerLib"].datatable,targetindex)
	self:ReleaseTable(target)
	if not norefresh then self:CreateInterface() end
end

function TimerLib:RemoveAllTimers()
	if self.libraries["TimerLib"].frozen then return end
	self:Debug("the interface has been cleared")
	for i = #(self.libraries["TimerLib"].datatable),1,-1 do
		self:RemoveTarget(i,1)
	end
	self:CreateInterface()
end

function TimerLib:ShowTimers(numtargets,numtimers) --used to view different interface layouts
	--self:RemoveAllTimers()
	numtargets = numtargets or self.libraries["TimerLib"].totaltargets
	numtimers = numtimers or self.libraries["TimerLib"].totaltimers
	local time = GetTime()
	local stagger = 0
	local numcurrenttargets = self:GetNumTargets()
	for i = 1 + numcurrenttargets,numtargets + numcurrenttargets do
		local target = self:AcquireTable(1)
		target.target = "Scary Mob "..i
		self:AddTarget(target)
		for id = 1,numtimers do
			local timer = self:AcquireTable(1)
			timer.spell = "Cool Timer"
			timer.duration = 20
			timer.time = time - stagger
			self:AddTimer(target,timer,1)
			stagger = stagger + .5
		end
		self:CreateInterface()
	end
end

local ttnmatches = {
	["s"] = 1,
	["m"] = 60,
	["h"] = 3600,
	["d"] = 86400,
}
function TimerLib:TimeToNum(time)
	local test = tonumber(time)
	if test then return test end
	local usages = {self:ParseString(time,"(%d+[smhd])")}
	if usages[1] == false then return end
	local seconds = 0
	for index,value in ipairs(usages) do
		local num,str = string.match(value,"(%d+)(%a)")
		seconds = seconds + (num * (ttnmatches[str] or 0))
	end
	return seconds
end

local nttmatches = {
	{len = 86400,letter = "d"},
	{len = 3600,letter = "h"},
	{len = 60,letter = "m"},
	{len = 1,letter = "s"},
}
function TimerLib:NumToTime(num,tenths,secondsformat)
	local str = ""
	local oldnum = num
	if num == 0 then return "0s" end
	if num < 1 then
		if tenths then
			return string.format("0.%ds",math.floor(num * 10))
		else
			return "0s"
		end
	else
		for index,value in ipairs(nttmatches) do
			local total = 0
			while num >= value.len do
				total = total + 1
				num = num - value.len
			end
			if total > 0 then 
				str = strconcat(str,total,value.letter," ") 
				if secondsformat == "##s abbv" then break end
			end
		end
		if tenths and string.find(str,"s") and (not (secondsformat == "##s abbv" and oldnum >= 10)) then 
			str = string.gsub(str,"s",strconcat(".",math.floor(10 * num),"s")) 
		end
		str = string.sub(str,1,-2)
	end
	return str
end

function TimerLib:GetNumTargets()
	return #self.libraries["TimerLib"].datatable
end

function TimerLib:GetNumTimers(i)
	return #self.libraries["TimerLib"].datatable[i]
end

function TimerLib:FreezeTimers()
	self.libraries["TimerLib"].frame:SetScript("OnUpdate",nil)
	self.libraries["TimerLib"].frozen = true
	local time = GetTime()
	for i = 1,self:GetNumTargets() do
		for id = 1,self:GetNumTimers(i) do
			self:GetTimer(i,id).elapsed = time - self:GetTimer(i,id).time
		end
	end
end

function TimerLib:UnFreezeTimers()
	if self:GetNumTargets() > 0 then self.libraries["TimerLib"].frame:SetScript("OnUpdate",self.libraries["TimerLib"].updatefunc) end
	local time = GetTime()
	for i = 1,self:GetNumTargets() do
		for id = 1,self:GetNumTimers(i) do
			self:GetTimer(i,id).time = time - self:GetTimer(i,id).elapsed
		end
	end
	self.libraries["TimerLib"].frozen = false
end

function TimerLib:ResetTimerFlags(timer)
	timer.finished = nil
	timer.resettime = nil
	timer.datachanged = nil
end

local f = CreateFrame("Frame")
f:RegisterEvent("PLAYER_ENTERING_WORLD")
f:SetScript("OnEvent",function(self,event) for _,module in ipairs(listofmodules) do module:CreateInterface(1) end end)

defaulttimerdata = {
	isreal = true,
	hastimer = true,
	disptimer = true,
	clickable = true,
	alpha = 1,
	colors = {
		begin = {
			r = .2,
			g = 1.0,
			b = .2,
		},
		half = {
			r = 1.0,
			g = 1.0,
			b = .2,
		},
		final = {
			r = 1.0,
			g = .2,
			b = .2,
		},
	}
}
defaulttarget = {
	target = "Target",
	text = "Target",
	type = "player",
	sex = 0,
	level = 0,
	icon = 0,
	id = 0,
}
defaulttimer = {
	spell = "Spell",
	rank = "",
	texture = "Interface\\Icons\\Spell_Lightning_LightningBolt01",
	duration = 10,
	type = "default",
}
bartextures = {
	"Interface\\TargetingFrame\\UI-StatusBar",
	"Interface\\TargetingFrame\\UI-TargetingFrame-BarFill",
	"Interface\\PaperDollInfoFrame\\UI-Character-Skills-Bar",
	AsheylaLib:GetPath().."\\Ash_Core\\Files\\Banto",
	AsheylaLib:GetPath().."\\Ash_Core\\Files\\Charcoal",
	AsheylaLib:GetPath().."\\Ash_Core\\Files\\Cilo",
	AsheylaLib:GetPath().."\\Ash_Core\\Files\\Cool",
	AsheylaLib:GetPath().."\\Ash_Core\\Files\\Elven",
	AsheylaLib:GetPath().."\\Ash_Core\\Files\\Futuristic",
	AsheylaLib:GetPath().."\\Ash_Core\\Files\\Futuristic_3d",
	AsheylaLib:GetPath().."\\Ash_Core\\Files\\Glaze",
	AsheylaLib:GetPath().."\\Ash_Core\\Files\\Gloss",
	AsheylaLib:GetPath().."\\Ash_Core\\Files\\Grunge",
	AsheylaLib:GetPath().."\\Ash_Core\\Files\\Halycon",
	AsheylaLib:GetPath().."\\Ash_Core\\Files\\Measurement",
	AsheylaLib:GetPath().."\\Ash_Core\\Files\\Metal",
	AsheylaLib:GetPath().."\\Ash_Core\\Files\\Moonmaster",
	AsheylaLib:GetPath().."\\Ash_Core\\Files\\OtraviCB",
	AsheylaLib:GetPath().."\\Ash_Core\\Files\\Perl",
	AsheylaLib:GetPath().."\\Ash_Core\\Files\\Smooth",
	AsheylaLib:GetPath().."\\Ash_Core\\Files\\Solid",
	AsheylaLib:GetPath().."\\Ash_Core\\Files\\Steel",
	AsheylaLib:GetPath().."\\Ash_Core\\Files\\Stone",
	AsheylaLib:GetPath().."\\Ash_Core\\Files\\Striped",
	AsheylaLib:GetPath().."\\Ash_Core\\Files\\Healbot",
	AsheylaLib:GetPath().."\\Ash_Core\\Files\\LiteStep",
	AsheylaLib:GetPath().."\\Ash_Core\\Files\\Rocks",
	AsheylaLib:GetPath().."\\Ash_Core\\Files\\Runes",
	AsheylaLib:GetPath().."\\Ash_Core\\Files\\Xeon",
	AsheylaLib:GetPath().."\\Ash_Core\\Files\\Frost",
}

defaultsettings = {
	["ghosts"] = true,
	["status"] = true,
	["barlength"] = 175,
	["barmsg"] = "%s&:%d",
	["icons"] = true,
	["raidicons"] = true,
	["targetlayout"] = "down",
	["targetspacing"] = 15,
	["scale"] = 1,
	["buttonscale"] = 1,
	["sortmethod"] = "remaining (D)",
	["names"] = true,
	["clickable"] = true,
	["tenths"] = false,
	["playsound"] = false,
	["alpha"] = 1,
	["reverse"] = false,
	["expalert"] = true,
	["timerlayout"] = "down",
	["ghostdata"] = 2,
	["locked"] = false,
	["format"] = "bars",
	["timerspacing"] = 5,
	["hideall"] = false,
	["hidden"] = {},
	["hiddentypes"] = {},
	["colors"] = {},
	["bartexture"] = 4,
	["bartextcolor"] = {r = .85, g = .85, b = .85},
	["ghostcolor"] = {r = .25, g = .25, b = 1},
	["barbackgroundcolor"] = {r = .1, g = .6, b = .8},
	["targettextcolor"] = {r = 1, g = .82, b = 0},
	["fadeintime"] = 1,
	["fadeouttime"] = 3,
	["secondsformat"] = "##s abbv",
	["movetargetname"] = true,
	["maxtargets"] = 0,
	["targetsort"] = "added (D)",
}

timerdatametatable = {__index = function() return defaulttimerdata end}
targetmetatable = {__index = defaulttarget}
timermetatable = {__index = defaulttimer}

AsheylaLib:CreateLibrary("TimerLib",TimerLib)
