local KBLib = {}

function KBLib:ProcessClick(group,button,...)
	local potentials = self:Get("keybindings",group)
	if potentials then
		local num
		if button == "LeftButton" then num = 1
		elseif button == "RightButton" then num = 2
		elseif button == "MiddleButton" then num = 3
		else num = tonumber(string.match(button,"(%d+)"))
		end
		if not num then return end
		local modifierstate = self:GetModifierState()
		for i,v in pairs(potentials) do
			local modifiers,mouse = string.match(v,"(.-)-?(%d+)$")
			mouse = tonumber(mouse)
			if mouse == num and modifiers == modifierstate then 
				self:PerformClickAction(group,i,...)
				break
			end
		end
	end
end

local states = {
	["000"] = "",
	["100"] = "s",
	["010"] = "c",
	["001"] = "a",
	["110"] = "s-c",
	["101"] = "s-a",
	["011"] = "c-a",
	["111"] = "s-c-a",
}
function KBLib:GetModifierState()
	return states[(IsShiftKeyDown() and "1" or "0")..(IsControlKeyDown() and "1" or "0")..(IsAltKeyDown() and "1" or "0")]
end

function KBLib:SetClickAction(group,action,func)
	local potential = self:Get("keybindings",group,action)
	if potential then
		local kblib = self.libraries["KBLib"]
		kblib.actions = kblib.actions or {}
		kblib.actions[group] = kblib.actions[group] or kblib.actions[group] or {}
		kblib.actions[group][action] = func
	end
end

function KBLib:PerformClickAction(group,action,...)
	local kblib = self.libraries["KBLib"]
	if kblib.actions and kblib.actions[group] and kblib.actions[group][action] then
		kblib.actions[group][action](...)
	end
end

function KBLib:GetKeyBinding(group,action)
	local kb = self:Get("keybindings",group,action)
	kb = string.gsub(kb,"s%-","Shift-")
	kb = string.gsub(kb,"c%-","Control-")
	kb = string.gsub(kb,"a%-","Alt-")
	kb = string.gsub(kb,"1","LeftClick")
	kb = string.gsub(kb,"2","RightClick")
	kb = string.gsub(kb,"3","MiddleClick")
	return kb
end

local group,action,mouse,isshift,isalt,isctrl

local function kbclickfunc(self)
	local level = DropDownLib:MenuLevel()
	local str = ""
	if isshift then str = str.."s-" end
	if isctrl then str = str.."c-" end
	if isalt then str = str.."a-" end
	str = str..mouse
	local otheractions = self:Get("keybindings",group)
	for act,kb in pairs(otheractions) do
		if not (action == act) then
			if kb == str then
				self:HeaderPrint("Unable to set keybinding (another action is already using it).")
				return
			end
		end
	end
	self:Set("keybindings",group,action,str)
	DropDownLib:CloseDropDownMenus()
end

function KBLib:KBDropDown()
	local info
	local DROPDOWNLIB_MENU_LEVEL = DropDownLib:MenuLevel()
	local DROPDOWNLIB_MENU_VALUE = DropDownLib:MenuValue()
	if DROPDOWNLIB_MENU_LEVEL == 6 or DROPDOWNLIB_MENU_LEVEL == 7 or DROPDOWNLIB_MENU_LEVEL == 8 then
		local value = DROPDOWNLIB_MENU_LEVEL - 1
		if (isshift or 0) >= value then isshift = nil end
		if (isctrl or 0) >= value then isctrl = nil end
		if (isalt or 0) >= value then isalt = nil end
		if DROPDOWNLIB_MENU_VALUE == "shift" then isshift = value
		elseif DROPDOWNLIB_MENU_VALUE == "alt" then isalt = value
		elseif DROPDOWNLIB_MENU_VALUE == "ctrl" then isctrl = value
		end
		if not isshift then
			info = DropDownLib:GetTable()
			info.text = "Shift"
			info.value = "shift"
			info.hasArrow = (DROPDOWNLIB_MENU_LEVEL == 8 and nil or 1)
			info.notCheckable = 1
			info.func = function() isshift = DROPDOWNLIB_MENU_VALUE kbclickfunc(self) end
			DropDownLib:AddButton(info)
		end
		if not isctrl then
			info = DropDownLib:GetTable()
			info.text = "Control"
			info.value = "ctrl"
			info.hasArrow = (DROPDOWNLIB_MENU_LEVEL == 8 and nil or 1)
			info.notCheckable = 1
			info.func = function() isctrl = DROPDOWNLIB_MENU_VALUE kbclickfunc(self) end
			DropDownLib:AddButton(info)
		end
		if not isalt then
			info = DropDownLib:GetTable()
			info.text = "Alt"
			info.value = "alt"
			info.hasArrow = (DROPDOWNLIB_MENU_LEVEL == 8 and nil or 1)
			info.notCheckable = 1
			info.func = function() isalt = DROPDOWNLIB_MENU_VALUE kbclickfunc(self) end
			DropDownLib:AddButton(info)
		end
	elseif DROPDOWNLIB_MENU_LEVEL == 5 then
		local value = DROPDOWNLIB_MENU_LEVEL - 1
		if (isshift or 0) >= value then isshift = nil end
		if (isctrl or 0) >= value then isctrl = nil end
		if (isalt or 0) >= value then isalt = nil end
		mouse = DROPDOWNLIB_MENU_VALUE
		info = DropDownLib:GetTable()
		info.text = "Shift"
		info.value = "shift"
		info.hasArrow = 1
		info.notCheckable = 1
		info.func = function() isshift = 5 kbclickfunc(self) end
		DropDownLib:AddButton(info)
		info = DropDownLib:GetTable()
		info.text = "Control"
		info.value = "ctrl"
		info.hasArrow = 1
		info.notCheckable = 1
		info.func = function() isctrl = 5 kbclickfunc(self) end
		DropDownLib:AddButton(info)
		info = DropDownLib:GetTable()
		info.text = "Alt"
		info.value = "alt"
		info.hasArrow = 1
		info.notCheckable = 1
		info.func = function() isalt = 5 kbclickfunc(self) end
		DropDownLib:AddButton(info)
	elseif DROPDOWNLIB_MENU_LEVEL == 4 then
		isshift,isctrl,isalt = nil,nil,nil
		info = DropDownLib:GetTable()
		info.text = "Left Click"
		info.value = 1
		info.hasArrow = 1
		info.notCheckable = 1
		info.func = function() mouse = 1 kbclickfunc(self) end
		DropDownLib:AddButton(info)
		info = DropDownLib:GetTable()
		info.text = "Right Click"
		info.value = 2
		info.hasArrow = 1
		info.notCheckable = 1
		info.func = function() mouse = 2 kbclickfunc(self) end
		DropDownLib:AddButton(info)
		info = DropDownLib:GetTable()
		info.text = "Middle Click"
		info.value = 1
		info.hasArrow = 1
		info.notCheckable = 1
		info.func = function() mouse = 3 kbclickfunc(self) end
		DropDownLib:AddButton(info)
	elseif DROPDOWNLIB_MENU_LEVEL == 3 then
		action = DROPDOWNLIB_MENU_VALUE
		info = DropDownLib:GetTable()
		info.text = "Current Keybinding"
		info.notCheckable = 1
		info.isTitle = 1
		DropDownLib:AddButton(info)
		info = DropDownLib:GetTable()
		info.text = self:GetKeyBinding(group,action)
		info.notClickable = 1
		info.notCheckable = 1
		DropDownLib:AddButton(info)
		info = DropDownLib:GetTable()
		info.text = ""
		info.notClickable = 1
		DropDownLib:AddButton(info)
		info = DropDownLib:GetTable()
		info.text = "Change Keybinding"
		info.hasArrow = 1
		info.notCheckable = 1
		DropDownLib:AddButton(info)
	elseif DROPDOWNLIB_MENU_LEVEL == 2 then
		group = DROPDOWNLIB_MENU_VALUE
		local actions = self:Get("keybindings",group)
		for i,v in pairs(actions) do
			info = DropDownLib:GetTable()
			info.text = i
			info.hasArrow = 1
			info.notCheckable = 1
			info.value = i
			DropDownLib:AddButton(info)
		end
	elseif DROPDOWNLIB_MENU_LEVEL == 1 then
		local groups = self:Get("keybindings")
		for i,v in pairs(groups) do
			info = DropDownLib:GetTable()
			info.notCheckable = 1
			info.text = i
			info.value = i
			info.hasArrow = 1
			DropDownLib:AddButton(info)
		end
	end
end

AsheylaLib:CreateLibrary("KBLib",KBLib)
