local scripts = {
	checkbutton = {
		OnShow = function() this:SetChecked(this.self:Get(this.setting)) end,
		OnClick = function() this.self:Set(this.setting,this:GetChecked() and true or false); this.self:UpdateSettings() end,
	},
	slider = {
		OnShow = function() this.real = false this:SetValue(this.self:Get(this.setting)) this.real = true end,
		OnValueChanged = function()
			local value = this:GetValue()
			local formatstring
			if math.floor(value) == value then 
				formatstring = "%d"
			else
				formatstring = "%.2f"
			end
			getglobal(this:GetName().."Value"):SetText(string.format(formatstring,value))
			if this.real then
				this.self:Set(this.setting,value)
				this.self:UpdateSettings()
			end
		end,
	},
	editbox = { --left blank, OnEnterPressed and OnEnter will be defined elsewhere
		OnEditFocusGained = function() this:SetText("") end,
		OnEditFocusLost = function() this:SetText("") end,
		OnEscapePressed = function()
			local text = this:GetText()
			if text == "" then
				this:ClearFocus()
			else
				this:SetText("")
			end
		end,
	},
	dropdown = {
		OnShow = function()
			getglobal(this:GetName().."Text"):SetText(this.text)
		end,
	},
}

local barmsgcodes = {
	["%s"] = "spell name",
	["%d"] = "time remaining",
	["%t"] = "Soulstone's target",
}

local sortingtable = {}
local function sorttable(pretable)
	for index,value in pairs(sortingtable) do sortingtable[index] = nil end
	for index,value in pairs(pretable) do table.insert(sortingtable,index) end
	table.sort(sortingtable)
	return sortingtable
end

local types = {
	["Cooldown"] = "cooldown",
}

local orderedtypes = {
	"Cooldown",
}

local category

local function colordropdown()
	local info
	local DROPDOWNLIB_MENU_LEVEL = DropDownLib:MenuLevel()
	local DROPDOWNLIB_MENU_VALUE = DropDownLib:MenuValue()
	if DROPDOWNLIB_MENU_LEVEL == 4 then
		local subcat = DROPDOWNLIB_MENU_VALUE
		for index,value in ipairs({"begin","half","final"}) do
			info = DropDownLib:GetTable()
			info.text = value
			info.notCheckable = 1
			info.hasColorSwatch = 1
			info.r = Cooldowns:Get("colors",category,subcat,value,"r") or 1
			info.g = Cooldowns:Get("colors",category,subcat,value,"g") or 1
			info.b = Cooldowns:Get("colors",category,subcat,value,"b") or 1
			info.swatchFunc = function()
				local r,g,b = DropDownLibColorPicker:GetColorRGB()
				Cooldowns:Set("colors",category,subcat,value,"r",r)
				Cooldowns:Set("colors",category,subcat,value,"g",g)
				Cooldowns:Set("colors",category,subcat,value,"b",b)
				for i,v in ipairs({"begin","half","final"}) do
					if not Cooldowns:Get("colors",category,subcat,v) then
						Cooldowns:Set("colors",category,subcat,v,"r",r)
						Cooldowns:Set("colors",category,subcat,v,"g",g)
						Cooldowns:Set("colors",category,subcat,v,"b",b)
					end
				end
				Cooldowns:UpdateSettings()
				DoTimer:UpdateSettings()
			end
			DropDownLib:AddButton(info,4)
		end
	elseif DROPDOWNLIB_MENU_LEVEL == 3 then
		local entries = Cooldowns:AcquireTable()
		if string.sub(DROPDOWNLIB_MENU_VALUE,1,5) == "spell" then
			local tab = string.sub(DROPDOWNLIB_MENU_VALUE,6)
			for i = 1,GetNumSpellTabs() do
				local name,_,offset,numspells = GetSpellTabInfo(i)
				if name == tab then
					for id = offset + 1,offset + numspells do
						local spell = GetSpellName(id,BOOKTYPE_SPELL)
						entries[spell] = 1
					end
					break
				end
			end
		elseif string.sub(DROPDOWNLIB_MENU_VALUE,1,4) == "item" then
			local itemloc = string.sub(DROPDOWNLIB_MENU_VALUE,5)
			if itemloc == "Inventory" then
				for i = 1,19 do
					local name = GetItemInfo(GetInventoryItemLink("player",i) or "")
					if name then
						entries[name] = 1
					end
				end
			else
				local _,bagid
				if itemloc == "Backpack" then
					bagid = 0
				else
					_,_,bagid = string.find(itemloc,"(%d)")
				end
				for i = 1,GetContainerNumSlots(bagid) do
					local name = GetItemInfo(GetContainerItemLink(bagid,i) or "")
					if name then
						entries[name] = 1
					end	
				end
			end
		elseif string.sub(DROPDOWNLIB_MENU_VALUE,1,5) == "other" then
			entries["Global Cooldown"] = 1
			entries["Spell Locked"] = 1
		end
		entries = sorttable(entries)
		for index,value in ipairs(entries) do
			info = DropDownLib:GetTable()
			info.text = value
			local checked
			if Cooldowns:Get("colors","timer",value) then checked = 1 end
			info.checked = checked
			info.value = value
			info.hasArrow = 1
			info.func = function() 
				if checked then 
					Cooldowns:Set("colors","timer",value,nil) 
					Cooldowns:UpdateSettings()
					DoTimer:UpdateSettings()
				end 
			end
			DropDownLib:AddButton(info,3)
		end
	elseif DROPDOWNLIB_MENU_LEVEL == 2 then
		category = DROPDOWNLIB_MENU_VALUE
		if category == "timer" then
			local nextentries = {"Inventory","Backpack","Bag 1","Bag 2","Bag 3","Bag 4","Other"}
			local nexttypes = {"item","item","item","item","item","item","other"}
			local counter = 1
			for i = 1,GetNumSpellTabs() do
				local name = GetSpellTabInfo(i)
				table.insert(nextentries,counter,name)
				table.insert(nexttypes,counter,"spell")
				counter = counter + 1
			end
			for index,value in ipairs(nextentries) do
				info = DropDownLib:GetTable()
				info.text = value
				info.value = nexttypes[index]..value
				info.hasArrow = 1
				info.notCheckable = 1
				DropDownLib:AddButton(info,2)
			end
		elseif category == "type" then
			local subcat = "cooldown"
			for index,value in ipairs({"begin","half","final"}) do
				info = DropDownLib:GetTable()
				info.text = value
				info.notCheckable = 1
				info.hasColorSwatch = 1
				info.r = Cooldowns:Get("colors",category,subcat,value,"r") or Cooldowns:GetTimerData()[subcat].colors[value]["r"]
				info.g = Cooldowns:Get("colors",category,subcat,value,"g") or Cooldowns:GetTimerData()[subcat].colors[value]["g"]
				info.b = Cooldowns:Get("colors",category,subcat,value,"b") or Cooldowns:GetTimerData()[subcat].colors[value]["b"]
				info.swatchFunc = function()
					local r,g,b = DropDownLibColorPicker:GetColorRGB()
					Cooldowns:Set("colors",category,subcat,value,"r",r)
					Cooldowns:Set("colors",category,subcat,value,"g",g)
					Cooldowns:Set("colors",category,subcat,value,"b",b)
					for i,v in ipairs({"begin","half","final"}) do
						if not Cooldowns:Get("colors",category,subcat,v) then
							Cooldowns:Set("colors",category,subcat,v,"r",Cooldowns:GetTimerData()[subcat].colors[v]["r"])
							Cooldowns:Set("colors",category,subcat,v,"g",Cooldowns:GetTimerData()[subcat].colors[v]["g"])
							Cooldowns:Set("colors",category,subcat,v,"b",Cooldowns:GetTimerData()[subcat].colors[v]["b"])
						end
					end
					Cooldowns:UpdateSettings()
					DoTimer:UpdateSettings()
				end
				DropDownLib:AddButton(info,2)
			end
		end
	elseif DROPDOWNLIB_MENU_LEVEL == 1 then
		info = DropDownLib:GetTable()
		info.text = "Specific Timer"
		info.notCheckable = 1
		info.hasArrow = 1
		info.value = "timer"
		DropDownLib:AddButton(info,1)
		info = DropDownLib:GetTable()
		info.text = "All Timers"
		info.notCheckable = 1
		info.hasArrow = 1
		info.value = "type"
		DropDownLib:AddButton(info,1)
	end
end

local guitable = {
	title = "Cooldowns Main Menu",
	name = "CooldownsMenuFrame",
	{ --column 1
		{
			title = "Enabled",
			type = "checkbutton",
			tooltiptext = "Turns the addon on or off, default state: on.",
			scripts = scripts.checkbutton,
			data = {
				setting = "status",
			},
		},
		{
			title = "Integrated",
			type = "checkbutton",
			tooltiptext = "Determines if the timers are integrated into DoTimer, default state: off.",
			scripts = scripts.checkbutton,
			data = {
				setting = "dotimer",
			},
		},
		{
			title = "Tooltips",
			type = "checkbutton",
			tooltiptext = "Determines if tooltips will be shown when you mouse over timers, default state: on.",
			scripts = scripts.checkbutton,
			data = {
				setting = "tooltips",
			},
		},
		{
			title = "Min Cooldown",
			type = "slider",
			tooltiptext = "Determines the minimum length of a cooldown, in seconds, for a timer to be made, default 2.",
			scripts = scripts.slider,
			lowval = 0,
			highval = 10,
			step = 1,
			data = {
				setting = "mincd",
			},
		},
		{
			title = "Max Cooldown",
			type = "slider",
			tooltiptext = "Determines the maximum length of a cooldown, in hours, for a timer to be made (0 means no limit), default 1.",
			scripts = scripts.slider,
			lowval = 0,
			highval = 12,
			step = 1,
			data = {
				setting = "maxcd",
			},
		},
		{
			title = "Colors",
			type = "dropdown",
			tooltiptext = "Lets you set the color of specific timers and timer types.",
			func = colordropdown,
			scripts = scripts.dropdown,
			data = {
				text = "Choose...",
			},
		},
		{
			title = "Key Bindings",
			type = "dropdown",
			tooltiptext = [[
				Lets you customize the keybindings for certain actions.
				
				If you are attempting to change the keybinding, just click on the final selection to finish (e.g., click 'Left Click' to just set to left-click, or if you want shift-leftclick move your mouse to the 'Shift' selection that appeared, etc.)]],
			func = function() Cooldowns:KBDropDown() end,
			scripts = scripts.dropdown,
			data = {
				text = "Choose...",
			},
		},
		{
			title = "Chat Msg",
			type = "editbox",
			tooltiptext = [[
				Allows you to customize the chat message sent when left-clicking a timer.

				Valid formatting codes:
				%s: spell name
				%d: time remaining
				%t: Soulstone's target

				Normal: %s,%d
				No Target: %s,%d,%t

				Prefix with one of [normal,soulstone] followed by a ":" to set the msg for that type.
				Example: "normal: My %s will expire in %d."
				
				Press ENTER when finished typing.
				
				Current strings:]],
			scripts = scripts.editbox,
			overridescripts = {
				OnEnterPressed = function() 
					local text = this:GetText()
					if not (text == "") then 
						local _,_,output,msg = string.find(text,"(%a+)%:%s?(.+)")
						if output then 
							output = string.lower(output)
							Cooldowns:Set("chatmsg"..output,msg)
							Cooldowns:UpdateSettings()
							this:SetText("") 
							Cooldowns:Print("|cff00ffffCooldowns|r: ",output," chat msg set to: ",msg)
						else
							Cooldowns:Print("|cff00ffffCooldowns|r: Setting failed being set. (Reason: unable to parse)")
						end
					end
				end,
				OnEnter = function() 
					if this.tooltipText then
						local text = this.tooltipText
						text = text.."\nNormal: "..Cooldowns:Get("chatmsgnormal")
						text = text.."\nSoulstone: "..Cooldowns:Get("chatmsgsoulstone")
						GameTooltip:SetOwner(this, "ANCHOR_RIGHT");
						GameTooltip:SetText(text, nil, nil, nil, nil, 1);
					end
				end,
			},
		},
	},
	{ --column 2
		{
			title = "Reset",
			type = "button",
			tooltiptext = "Resets all settings to their default value.",
			buffer = 10,
			scripts = {
				OnClick = function() 
					this.self:ClearSettings() 
					CooldownsMenuFrame:Hide()
					CooldownsMenuFrame:Show()
				end,
			},
		},
		{
			title = "Author Info",
			type = "button",
			tooltiptext = "Prints in the chat frame information about the current version and about the author.",
			buffer = 10,
			scripts = {
				OnClick = function() Cooldowns:AddAuthorInfo() end,
			},
		},
		{
			title = "Profiles",
			type = "button",
			tooltiptext = "Opens the Profile Creator menu.",
			buffer = 10,
			scripts = {
				OnClick = function() ProfileLib:ShowGUI() end,
			},
		},
		"BREAK",
		{
			title = "Timer Settings",
			type = "button",
			tooltiptext = "Opens the options window for customizing the timers that can be made.",
			scripts = {
				OnClick = function() Cooldowns:ShowTimerGUI(barmsgcodes,nil,nil,"Hidden Types","Raid Icons","Max Targets","Target Layout","Target Spacing","Target Sorting"); end,
			},
		},
		{
			title = "Close",
			type = "button",
			tooltiptext = "Closes this window.",
			scripts = {
				OnClick = function() this.holder.place.column.menu:Hide() end,
			},
		},
	},
}

function Cooldowns:ShowGUI()
	if not CooldownsMenuFrame then
		Cooldowns:CreateGUI(guitable)
	end
	CooldownsMenuFrame:Show()
end
