Cooldowns = AsheylaLib:NewModule("Cooldowns","TimerLib","SpellLib","GUILib","KBLib","TimerLibGUI")
local cooldownstarget = {
	target = "Cooldowns ", --the space is in case some player named "Cooldowns" exists
	sex = 0,
	level = 0,
	icon = 0,
	type = "player",
	text = "Cooldowns",
	norepeat = 1,
}
local cooldownsdata 
local loaded
local defaultsettings
local lastusedspell
local lastuseditem
local lastusedequippeditem
local spelltarget = {}

function Cooldowns:OnLoad()
	this:RegisterEvent("PLAYER_ENTERING_WORLD")
end

function Cooldowns:OnEvent(event)
	if event == "PLAYER_ENTERING_WORLD" then 
		if loaded then 
			if self:Get("status") then self:CheckAllCooldowns() end
		else
			self:Startup() 
		end
	elseif self:HasRegisteredSettings() and self:Get("status") then
		if event == "UNIT_SPELLCAST_SUCCEEDED" and arg1 == "player" then self:PotentialCooldown()
		elseif event == "UNIT_SPELLCAST_SENT" then spelltarget[arg2] = arg4
		else self:CheckForCooldowns(event)
		end
	end
end

function Cooldowns:CheckModule()
	self:Set("targetlayout",(self:Get("timerlayout") == "up" and "up" or "down"))
	local oldmodule = (self:Get("dotimer") and self or DoTimer)
	local newmodule = (self:Get("dotimer") and DoTimer or self)
	if oldmodule then
		local i = oldmodule:ReturnTargetTable("Cooldowns ",0,0,self)
		if i then
			for id = 1,oldmodule:GetNumTimers(i) do
				local timer = oldmodule:GetTimer(i,id)
				local entry = self:AcquireTable(1)
				entry.spell = timer.spell
				entry.rank = timer.rank
				entry.texture = timer.texture
				entry.duration = timer.duration
				entry.time = timer.time
				entry.type = timer.type
				entry.infotype = timer.infotype
				entry.infoid = timer.infoid
				entry.english = timer.english
				entry.timeadded = 0
				self:CreateCooldown(entry,1)
			end
			oldmodule:RemoveTarget(i) 
		end
	end
	newmodule:CreateInterface(1)
end

function Cooldowns:Startup() --called on first login per session, creates the default settings if needed or else just hides the interface and sets the scale
	self:RegisterSettings()
	self:AddDefaultSettings(defaultsettings)
	ProfileLib:RegisterForProfiles(self)
	self:AddSettingsUpdateScript(function() Cooldowns:CheckModule() end)
	self:MakeSlashCmd("/cooldowns","/cd")
	self:CreateTimerInstance()
	self:SetScript("OnDragClick",function(arg1) 
		Cooldowns:ProcessClick("Drag Icon",arg1)
	end)
	self:SetClickAction("Drag Icon","Addon Info",function()
		DoTimer:Print("This is the |cff00ffffCooldowns|r anchor.  Access |cff00ffffCooldowns|r's menu by typing '|cff00ff00/cd|r'.  Hide me by checking the '|cff00ff00Locked|r' checkbutton in the menu.")
	end)
	self:SetClickAction("Drag Icon","Remove All Timers",function()
		Cooldowns:RemoveAllTimers()
	end)
	self:SetScript("OnTargetClick",function(i,module,arg1) 
		Cooldowns:ProcessClick("Target",arg1,i,module)
	end)
	self:SetClickAction("Target","Remove",function(i,module)
		module:RemoveTarget(i)
	end)
	self:SetScript("OnTimerClick",function(i,id,module,arg1)
		Cooldowns:ProcessClick("Timer",arg1,i,id,module)
	end)
	self:SetClickAction("Timer","Announce",function(i,id,module)
		Cooldowns:ToChat(module:GetTimer(i,id))
	end)
	self:SetClickAction("Timer","Hide",function(i,id,module)
		local timer = module:GetTimer(i,id)
		local frame = StaticPopup_Show("COOLDOWNS",timer.spell)
		frame.data = timer
		frame.data2 = module
	end)
	self:SetClickAction("Timer","Remove",function(i,id,module)
		module:RemoveTimer(i,id,"clicked")
	end)
	self:SetScript("OnTimerEnter",function(i,id,module,this) 
		Cooldowns:CreateTimerTooltip(module:GetTimer(i,id),this) 
	end)
	StaticPopupDialogs["COOLDOWNS"] = {
		text = "Are you sure you want to hide the timer for %s?",
		button1 = "Yes",
		button2 = "No",
		OnAccept = function(timer,module) timer.module:Set("hidden",string.lower(timer.spell),1); module:UpdateSettings() end,
		whileDead = 1,
		hideOnEscape = 1,
		timeout = 0,
	}
	cooldownsdata = Cooldowns:DefineSpells()
	local f = CreateFrame("Frame")
	f:SetScript("OnUpdate",function(self) Cooldowns:CheckAllCooldowns() self:SetScript("OnUpdate",nil) end)
	this:RegisterEvent("ACTIONBAR_UPDATE_COOLDOWN")
	this:RegisterEvent("BAG_UPDATE_COOLDOWN")
	this:RegisterEvent("PET_BAR_UPDATE_COOLDOWN")
	this:RegisterEvent("SPELL_UPDATE_COOLDOWN")
	this:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED")
	this:RegisterEvent("UNIT_SPELLCAST_SENT")
	loaded = true
end

function Cooldowns:PotentialCooldown()
	local texture,book,id = self:FindSpellInfo(arg2,arg3,"item")
	if cooldownsdata[texture] then
		local spell = self:AcquireTable(1)
		spell.spell = arg2
		spell.texture = texture
		if book and id then
			spell.infotype = book
			spell.infoid = id
		end
		spell.type = "cooldown"
		spell.duration = cooldownsdata[texture].duration
		spell.time = GetTime()
		spell.english = cooldownsdata[texture].name
		if spell.english == "Soulstone" then spell.rank = (spelltarget[arg2] or "") else spell.rank = "" end
		self:CreateCooldown(spell)
	else
		if texture then
			if IsEquippedItem(arg2) then
				lastusedequippeditem = arg2
			else
				lastuseditem = arg2
			end
		else
			lastusedspell = arg2
		end
	end
end

function Cooldowns:CheckAllCooldowns()
	self:CheckForCooldowns("ACTIONBAR_UPDATE_COOLDOWN")
	self:CheckForCooldowns("BAG_UPDATE_COOLDOWN")
	self:CheckForCooldowns("SPELL_UPDATE_COOLDOWN")
	self:CheckForCooldowns("PET_BAR_UPDATE_COOLDOWN")
end

function Cooldowns:CheckForCooldowns(event)
	local mincd = self:Get("mincd")
	local maxcd = self:Get("maxcd") * 3600
	if event == "ACTIONBAR_UPDATE_COOLDOWN" then
		local lastitemcd = 0
		if lastusedequippeditem then
			lastitemcd = select(2,GetItemCooldown(lastusedequippeditem))
		end
		for i = 1,19 do
			local spellname = GetItemInfo(GetInventoryItemLink("player",i) or "")
			local texture = GetInventoryItemTexture("player",i)
			if spellname and (not cooldownsdata[texture]) then
				local start,duration,real = GetInventoryItemCooldown("player",i)
				if start > 0 and duration >= mincd and (duration <= maxcd or maxcd == 0) and real == 1 and self:TimerIsRelevent(start,duration,(spellname == lastusedequippeditem)) then
					local entry = self:AcquireTable(1)
					entry.spell = spellname
					entry.rank = ""
					entry.texture = texture
					entry.duration = duration
					entry.time = start
					entry.type = "cooldown"
					entry.english = spellname
					entry.infotype = "item"
					entry.infoid = self:GetItemID(GetInventoryItemLink("player",i))
					self:CreateCooldown(entry)
				elseif start == 0 then
					self:RemoveCooldown(spellname,"item")
				end
			end
		end
		lastusedequippeditem = nil
	elseif event == "BAG_UPDATE_COOLDOWN" then
		local lastitemcd = 0
		if lastuseditem then
			lastitemcd = select(2,GetItemCooldown(lastuseditem))
		end
		for b = 0,4 do
			for s = 1,GetContainerNumSlots(b) do
				local spellname = GetItemInfo(GetContainerItemLink(b,s) or "")	
				local texture = GetContainerItemInfo(b,s)				
				if spellname and (not cooldownsdata[texture]) then
					local start,duration,real = GetContainerItemCooldown(b,s)
					if start > 0 and duration >= mincd and (duration <= maxcd or maxcd == 0) and real == 1 and self:TimerIsRelevent(start,duration,(spellname == lastuseditem)) then
						local entry = self:AcquireTable(1)
						entry.spell = spellname
						entry.rank = ""
						entry.texture = texture
						entry.duration = duration
						entry.time = start
						entry.type = "cooldown"
						entry.infotype = "item"
						entry.infoid = self:GetItemID(GetContainerItemLink(b,s))
						self:CreateCooldown(entry)
					elseif start == 0 then
						self:RemoveCooldown(spellname,"item")
					end
				end
			end
		end
		lastuseditem = nil
	elseif event == "SPELL_UPDATE_COOLDOWN" then
		local numtabs = GetNumSpellTabs()
		local _,_,offset,num = GetSpellTabInfo(numtabs)
		local numspells = offset + num
		local lastspellcd = 0
		if lastusedspell then
			lastspellcd = select(2,GetSpellCooldown(lastusedspell))
		end
		local lastscannedspell
		for i = numspells,1,-1 do
			local spellname = GetSpellName(i,BOOKTYPE_SPELL)
			local texture = GetSpellTexture(i,BOOKTYPE_SPELL)
			if spellname and (not (lastscannedspell == spellname)) and (not cooldownsdata[texture]) then
				lastscannedspell = spellname
				local start,duration,real = GetSpellCooldown(i,BOOKTYPE_SPELL)
				if start > 0 and duration >= mincd and (duration <= maxcd or maxcd == 0) and real == 1 and self:TimerIsRelevent(start,duration,(spellname == lastusedspell)) then
					local entry = self:AcquireTable(1)
					entry.spell = spellname
					entry.rank = ""
					entry.texture = texture
					entry.duration = duration
					entry.time = start
					entry.type = "cooldown"
					entry.english = spellname
					entry.infotype = BOOKTYPE_SPELL
					entry.infoid = i
					if duration <= 1.5 then
						entry.spell = "Global Cooldown"
						entry.texture = "Interface\\Icons\\Spell_Lightning_LightningBolt01"
					end
					self:CreateCooldown(entry)
				elseif start == 0 then
					self:RemoveCooldown(spellname,"spell")
				end
			end
		end
		lastusedspell = nil
	elseif event == "PET_BAR_UPDATE_COOLDOWN" then
		for i = 1,10 do
			local spellname = GetPetActionInfo(i)
			local _,_,texture = GetPetActionInfo(i)
			if spellname and (not cooldownsdata[texture]) then
				local start,duration,real = GetPetActionCooldown(i)
				if start > 0 and duration >= mincd and (duration <= maxcd or maxcd == 0) and real == 1 and self:TimerIsRelevent(start,duration) then
					local entry = self:AcquireTable(1)
					entry.spell = spellname
					entry.rank = ""
					entry.texture = texture
					entry.duration = duration
					entry.time = start
					entry.type = "cooldown"
					entry.english = spellname
					entry.infotype = BOOKTYPE_PET
					entry.infoid = Cooldowns:ReturnPetID(spellname)
					self:CreateCooldown(entry)
				elseif start == 0 then
					self:RemoveCooldown(spellname,"spell")
				end
			end
		end
	end
end

function Cooldowns:TimerIsRelevent(start,duration,waslastcast)
	local module = (self:Get("dotimer") and DoTimer or Cooldowns)
	local i = module:ReturnTargetTable("Cooldowns ",0,0,self)
	if i then
		for id = module:GetNumTimers(i),1,-1 do
			local timer = module:GetTimer(i,id)
			if timer then
				if math.abs(timer.duration - duration) <= .1 and (math.abs(timer.time - start) <= .1) then 
					if timer.spell == "Global Cooldown" then return false end
					if waslastcast then
						module:RemoveTimer(i,id,"replaced")
						return true
					else
						return false
					end
				end
			end
		end
	end
	return true
end

function Cooldowns:CreateCooldown(spelltable,norefresh)
	local module = (Cooldowns:Get("dotimer") and DoTimer or Cooldowns)
	local i = module:ReturnTargetTable("Cooldowns ",0,0,self)
	if i then
		for id = module:GetNumTimers(i),1,-1 do
			local timer = module:GetTimer(i,id)
			if timer.spell == spelltable.spell then
				module:RemoveTimer(i,id,"inaccurate",1)
			end
		end
	end
	local cooldownsindex = module:ReturnTargetTable("Cooldowns ",0,0,self)
	if not cooldownsindex then 
		local cooldownstable = self:AcquireTable(1)
		self:PasteTable(cooldownstable,cooldownstarget)
		cooldownstable.module = self
		cooldownstable.priority = (module == self and 0 or 2)
		if module == DoTimer then cooldownstable.forceshow = 1 end
		cooldownsindex = module:AddTarget(cooldownstable,nil,self) 
	end
	module:AddTimer(cooldownsindex,spelltable,norefresh,self)
end

function Cooldowns:RemoveCooldown(spell,type)
	local time = GetTime()
	local module = (self:Get("dotimer") and DoTimer or Cooldowns)
	local i = module:ReturnTargetTable("Cooldowns ",0,0,self)
	if i then
		for id = module:GetNumTimers(i),1,-1 do
			local timer = module:GetTimer(i,id)
			if timer.spell == spell and time <= timer.time + timer.duration and timer.infotype == type and timer.module == self then
				module:RemoveTimer(i,id,"finished")
			end
		end
	end
end

function Cooldowns:CreateTimerTooltip(c,frame)
	if self:Get("tooltips") then
		GameTooltip:SetOwner(frame,"ANCHOR_RIGHT")
		if c.infotype then
			local type = c.infotype
			if type == BOOKTYPE_SPELL then
				GameTooltip:SetSpell(c.infoid,BOOKTYPE_SPELL)
			elseif type == "item" then
				GameTooltip:SetHyperlink(Cooldowns:ReturnItemLink(c.infoid))
			elseif type == BOOKTYPE_PET then
				GameTooltip:SetSpell(c.infoid,BOOKTYPE_PET)
			end
		else
			GameTooltip:AddLine(c.spell,1,1,1)
		end
		if c.english == "Soulstone" then GameTooltip:AppendText(string.format(" (%s)",c.rank)) end
		GameTooltip:AddLine(" ",1,1,1,1)
		GameTooltip:AddLine(self:GetKeyBinding("Timer","Announce").." to announce.",1,1,1,1)
		GameTooltip:AddLine(self:GetKeyBinding("Timer","Remove").." to remove.",1,1,1,1)
		GameTooltip:AddLine(self:GetKeyBinding("Timer","Hide").." to hide.",1,1,1,1)
		GameTooltip:Show()
	end
end

function Cooldowns:Commands() --governs the /command
	self:ShowGUI()
end

local chatsubentries = {}
function Cooldowns:ToChat(c)
	for i,v in pairs(chatsubentries) do chatsubentries[i] = nil end
	local displayed = c.displayed
	local spell = c.spell
	local rank = c.rank
	if (displayed and spell and rank) then
		displayed = self:ReturnFormattedDuration(displayed)
		local unsubbedmsg
		if c.english == "Soulstone" then
			chatsubentries["%d"] = displayed
			chatsubentries["%s"] = spell
			chatsubentries["%t"] = rank
			unsubbedmsg = self:Get("chatmsgsoulstone")
		else
			chatsubentries["%d"] = displayed
			chatsubentries["%s"] = spell
			unsubbedmsg = self:Get("chatmsgnormal")
		end
		local chat = "SAY"
		if GetNumRaidMembers() > 0 then chat = "RAID" elseif GetNumPartyMembers() > 0 then chat = "PARTY" end
		local msg = string.gsub(unsubbedmsg,"(%%%a)",function(a) return chatsubentries[a] or "" end)
		msg = string.gsub(msg,"%(%)","")
		SendChatMessage(msg,chat)
	end
end

defaultsettings = {
	dotimer = false,
	targetlayout = "down",
	mincd = 2,
	maxcd = 1,
	chatmsgnormal = "My cooldown for %s will complete in %d.",
	chatmsgsoulstone = "My soulstone on %t will expire in %d.",
	tooltips = true,
	maxtargets = 1,
	keybindings = {
		["Drag Icon"] = {
			["Addon Info"] = "1",
			["Remove All Timers"] = "2",
		},
		["Target"] = {
			["Remove"] = "2",
		},
		["Timer"] = {
			["Announce"] = "1",
			["Remove"] = "2",
			["Hide"] = "s-2",
		},
	},
}
