Communication = AsheylaLib:NewModule("Communication")

local defaultsettings

function Communication:OnLoad()
	this:RegisterEvent("PLAYER_ENTERING_WORLD")
	this:RegisterEvent("CHAT_MSG_ADDON")
	this:RegisterEvent("PARTY_MEMBERS_CHANGED")
	this:RegisterEvent("RAID_ROSTER_UPDATE")
end

function Communication:OnEvent(event,...)
	if event == "PLAYER_ENTERING_WORLD" then self:Startup() -- when you first log in
	elseif self:HasRegisteredSettings() then
		if event == "PARTY_MEMBERS_CHANGED" then self:Ask("PARTY")
		elseif event == "RAID_ROSTER_UPDATE" then self:Ask("RAID")
		elseif event == "CHAT_MSG_ADDON" then
			local version = self:Get("version")
			local pre,msg,loc = ...
			if pre == "DTMR" then
				if msg == "request" then
					SendAddonMessage("DTMR","version:"..version,loc)
				else
					local compver = string.match(msg,"version%:(.+)")
					if (compver) and (compver > version) then
						self:AlertUser(compver)
						self:Set("version",compver)
					end
				end
			end
		end
	end
end

function Communication:Startup() --called on first login per session, creates the default settings if needed or else just hides the interface and sets the scale
	self:RegisterSettings()
	self:AddDefaultSettings(defaultsettings)
	self:Ask("GUILD")
	StaticPopupDialogs["COMMUNICATION"] = {
		text = "There is a new version of DoTimer available: %s.  You will not be alerted for this version again.",
		button1 = "OK",
		whileDead = 1,
		hideOnEscape = 1,
		timeout = 10,
	}
end

function Communication:Ask(loc)
	SendAddonMessage("DTMR","request",loc)
end

function Communication:AlertUser(newver)
	StaticPopup_Show("COMMUNICATION",newver)
end

defaultsettings = {
	version = AsheylaLib:ReturnVersion(),
}
