local L = AceLibrary("AceLocale-2.2"):new("DisqoDice")

local options = { 
    type='group',
    args = {
        width = {
            type = 'range',
            name = 'Bar Width',
            desc = L["help_width"],
            min = 100,
		max = 500,
            get = "GetWidth",
            set = "SetWidth",
        },
        scale = {
            type = 'range',
            name = 'Bar Scale',
            desc = L["help_scale"],
            min = .25,
		max = 3,
            get = "GetScale",
            set = "SetScale",
        },
        reset = {
            type = 'execute',
            name = 'Reset',
            desc = L["help_reset"],
		func = "ResetAll",
        },
        testbar = {
            type = 'execute',
            name = 'Test Bar',
            desc = L["help_testbar"],
		func = "WFProcBar",
        },
        display = {
            type = 'toggle',
            name = 'Display Frames',
            desc = L["help_display"],
            usage = "<Your message here>",
            get = "BarShowWut",
            set = "ShowHideBars",
        },
        SS = {
            type = 'toggle',
            name = 'Display Stormstrike bar',
            desc = L["help_ss"],
            usage = "<Your message here>",
            get = "SSWut",
            set = "ActivateSS",
        },
        twist = {
            type = 'toggle',
            name = 'Display totem twisting bar',
            desc = L["help_twist"],
            usage = "<Your message here>",
            get = "twistWut",
            set = "ActivateTwist",
        },
        shock = {
            type = 'toggle',
            name = 'Display shock bar',
            desc = L["help_shock"],
            usage = "<Your message here>",
            get = "shockWut",
            set = "ActivateShock",
        },
	wshieldbar = {
            type = 'toggle',
            name = 'Display watershield bar',
            desc = L["help_wsshield"],
            usage = "<Your message here>",
            get = "waterWut",
            set = "ActivateWS",
	},
	arena = {
            type = 'toggle',
            name = 'Use 4 piece arena bonus',
            desc = L["help_arena"],
            usage = "<Your message here>",
            get = "arenaWut",
            set = "ActivateArena",
	},
        wsalpha = {
            type = 'range',
            name = 'Water Shield Alpha',
            desc = L["help_width"],
            min = 0,
		max = 1,
            get = "GetWSalpha",
            set = "SetWSalpha",
        },
	},
}

DisqoDice = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceEvent-2.0", "AceDB-2.0")
DisqoDice:RegisterChatCommand("/DisqoDice", "/dqd", options)

local DisqoDiceBaseFrame = CreateFrame("Frame","DiscoDiceBase",UIParent)
-- local DisqoDiceBar1 = CreateFrame("Frame","DiscoDiceBar1",UIParent)
local f1 = CreateFrame("Frame","DiscoDiceBar1Status",DisqoDiceBaseFrame)
local f2 = CreateFrame("Frame","DiscoDiceBar2Status",DisqoDiceBaseFrame)
local f3 = CreateFrame("Frame","DiscoDiceBar3Status",DisqoDiceBaseFrame)
local f4 = CreateFrame("Frame","DiscoDiceBar4Status",DisqoDiceBaseFrame)
local f5 = CreateFrame("Frame","DiscoDiceBar5Status",DisqoDiceBaseFrame)
local texture = "Interface\\TargetingFrame\\UI-StatusBar"
local SSMin, SSMax, TotemMin, TotemMax, ShockMin, ShockMax, WFPMin, WFPMax, WSMin, WSMax
local gogogoSS = false
local gogogoTotem = false
local gogogoShock = false
local gogogoWFProc = false
local gogogoWS = false
local WFProcTime = 0
local SSTime = 0
local ShockTime
local TotTime = 0
local WSTime = 0

DisqoDice:RegisterDB("DisqoDiceDBPC")
DisqoDice:RegisterDefaults("char", {
	message = "Welcome Home!",
	barshow = true,
	relativeTo = "UIParent",
	relativePoint = "CENTER",
	point = "CENTER",
	xOfs = 0,
	yOfs = 0,
	fWidth = 300,
	fHeight = 100,
	resetOn = true,
	scale = 1,
	ShockPercent = .6,
	shockshow = true,
	ssshow = true,
	twistshow = false,
	wsshow = true,
	wsalpha = .3,
	arena = false,
	SSlen = 10,
	}
)


local wftotem_cast = L["WF_Totem"]
local stormstrike_cast = L["Stormstrike"]
local earthshock_cast = L["Earth_Shock"]
local flameshock_cast = L["Flame_Shock"]
local frostshock_cast = L["Frost_Shock"]
local WindfuryCombatLog = L["WF_Attack"]
local GoA_Tot = L["GoA_Totem"]
local Gnd_Tot = L["Gnd_Totem"]
local Sent_Tot = L["Sent_Totem"]
local NR_Tot = L["NR_Totem"]
local WW_Tot = L["WW_Totem"]
local Trq_Tot = L["Trq_Totem"]
local WoA_Tot = L["WoA_Totem"]
local Tot_Call = L["Totem_Call"]
local WS_Shld_Cast = L["WS_Shield"]
local playerName=UnitName("player");

-- Event names for scheduling and unscheduling
local totemevent = "TotemBar"
local killtotem = "TotemExpire"
local ssevent = "DisqoDice_SSCooldown"
local wsevent = "DisqoDice_WSExpire"

function DisqoDice:DisqoDice_WSExpire()
	-- DisqoDice:CancelScheduledEvent("WindfuryRepeater")
end

function DisqoDice:TotemExpire()
	DisqoDice:CancelScheduledEvent("WindfuryRepeater")
end

function DisqoDice:DisqoDice_SSCooldown()
	self:Print("SS is up")
end

function DisqoDice:OnInitialize()
    self:Print("DisqoDice Loaded.")
end

function DisqoDice:OnDisable()
    -- Called when the addon is disabled
end

function DisqoDice:OnEnable()
	self:RegisterEvent("PLAYER_DEAD")
	self:RegisterEvent("PLAYER_AURAS_CHANGED")
	self:RegisterEvent("PLAYER_ENTERING_WORLD")
	self:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED")
	self:RegisterEvent(totemevent)
	self:RegisterEvent(killtotem)
	self:RegisterEvent(wsevent)
	self:RegisterEvent("CHAT_MSG_SPELL_SELF_DAMAGE")
	self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
	self:RegisterEvent("UNIT_MANA")
	self:CreateBaseFrame()
	self:RegisterEvent("PLAYER_ENTERING_WORLD")
end


function DisqoDice:UNIT_MANA()
	if self.db.char.wsshow then
		local dqd_mana = UnitMana("player");
		local dqd_maxmana = UnitManaMax("player");
		-- self:Print(dqd_mana .. " " .. dqd_maxmana)
		if not gogogoWS then
			if dqd_mana == dqd_maxmana then
				f5.statusbar:SetStatusBarColor(1, 0, 0, .2)
				f5:SetBackdropBorderColor(1, 1, 1, .2);
			else
				f5.statusbar:SetStatusBarColor(1, 0, 0, 1)
				f5:SetBackdropBorderColor(1, 1, 1, 1);
			end
		end
	end
end


function DisqoDice:PLAYER_DEAD()
	self:TotemExpire()
end

function DisqoDice:PLAYER_ENTERING_WORLD()
	self:TotemExpire()
	if self.db.char.wsshow then
		f5:Show()
	end
end

function DisqoDice:PLAYER_AURAS_CHANGED()
	if self.db.char.wsshow then
		if not DisqoDice:IsWaterShieldActive() then
			gogogoWS = false
			local dqd_mana = UnitMana("player");
			local dqd_maxmana = UnitManaMax("player");
			-- self:Print(dqd_mana .. " " .. dqd_maxmana)
			if not gogogoWS then
				if dqd_mana == dqd_maxmana then
					f5.statusbar:SetStatusBarColor(1, 0, 0, .2)
					f5:SetBackdropBorderColor(1, 1, 1, .2);
				else		
					f5.statusbar:SetStatusBarColor(1, 0, 0, 1)
					f5:SetBackdropBorderColor(1, 1, 1, 1);
				end
			end
			f5.spark:Hide()
			f5.statusbar:SetValue(600)
			-- f5:Hide()
			f5:Show()
		end
	end
end

function DisqoDice:CHAT_MSG_SPELL_SELF_DAMAGE(arg1)
	if self.db.char.ssshow then
		if strfind(arg1, WindfuryCombatLog) then
			self:WFProcBar()
		end
	end
end


function DisqoDice:COMBAT_LOG_EVENT_UNFILTERED(...)
	if self.db.char.ssshow then
		--	local timestamp, eventtype, srcGUID, srcName, srcFlags, dstGUID, dstName, dstFlags, _, spname = select(1, ...) or "nil";
		local srcName2 = select(2, ...);
		local srcName4 = select(4, ...);
		local srcName9 = select(9, ...);
		local srcName10 = select(10, ...);
		if (srcName4 == playerName) then
			if (srcName9==25504 or srcName9==33750) then -- note that 25504 is a MH WF proc, 33750 is an OH proc
				self:WFProcBar()
			end
		end
	end
end




function DisqoDice:UNIT_SPELLCAST_SUCCEEDED(arg1, arg2, arg3)
	if self.db.char.ssshow then
		if arg2 == stormstrike_cast then
			self:SSBar()
		end
	end
	if self.db.char.wsshow then
		if arg2 == WS_Shld_Cast then
			self:WSBar()
		end
	end	
	if self.db.char.shockshow then
		if arg2 == earthshock_cast then
			f3.statusbar:SetStatusBarColor(0, 1, .3, .9)
			self:ShockBar()
		elseif arg2 == flameshock_cast then
			f3.statusbar:SetStatusBarColor(1, .6, .2, .9)
			self:ShockBar()
		elseif arg2 == frostshock_cast then
			f3.statusbar:SetStatusBarColor(.6, .6, 1, .9)
			self:ShockBar()
		end
	end
	if self.db.char.twistshow then
		if arg2 == wftotem_cast then
			f1.statusbar:SetStatusBarColor(1, .5, 1, .9)
			self:TotemBar()
			self:ScheduleRepeatingEvent("WindfuryRepeater", totemevent, 5, self)
			self:ScheduleEvent("TotemKiller", killtotem, 111, self)
		elseif arg2 == "Grace of Air Totem" then
			f1.statusbar:SetStatusBarColor(1, 1, 1, .9)
			self:TotemExpire()
		elseif arg2 == GoA_Tot then
			f1.statusbar:SetStatusBarColor(1, 1, 1, .9)
			self:TotemExpire()
		elseif arg2 == NR_Tot then
			f1.statusbar:SetStatusBarColor(1, 1, 1, .9)
			self:TotemExpire()
		elseif arg2 == Gnd_Tot then
			f1.statusbar:SetStatusBarColor(1, 1, 1, .9)
			self:TotemExpire()
		elseif arg2 == Sent_Tot then
			f1.statusbar:SetStatusBarColor(1, 1, 1, .9)
			self:TotemExpire()
		elseif arg2 == WW_Tot then
			f1.statusbar:SetStatusBarColor(1, 1, 1, .9)
			self:TotemExpire()
		elseif arg2 == WoA_Tot then
			f1.statusbar:SetStatusBarColor(1, 1, 1, .9)
			self:TotemExpire()
		elseif arg2 == Trq_Tot then
			f1.statusbar:SetStatusBarColor(1, 1, 1, .9)
			self:TotemExpire()
		elseif arg2 == Tot_Call then
			self:TotemExpire()
		end
	end
end

-- This function below directly from Rava's Watershield mod - thanks!
function DisqoDice:IsWaterShieldActive()
	local index = 1
	while GetPlayerBuff(index, "HELPFUL")>0 do
		local buffIndex = GetPlayerBuff(index, "HELPFUL")
		local name = GetPlayerBuffName(buffIndex)
		if name == WS_Shld_Cast then
			return true
		end
		index = index + 1
	end
	return false
end

function DisqoDice:ActivateTwist()
	self.db.char.twistshow = not self.db.char.twistshow
end

function DisqoDice:ActivateSS()
	self.db.char.ssshow = not self.db.char.ssshow
end

function DisqoDice:ActivateShock()
	self.db.char.shockshow = not self.db.char.shockshow
end

function DisqoDice:ActivateWS()
	self.db.char.wsshow = not self.db.char.wsshow
	if not self.db.char.wsshow then
		f5:Hide()
	end
end

function DisqoDice:ActivateArena()
	self.db.char.arena = not self.db.char.arena
		if self.db.char.arena then
			self.db.char.SSlen = 9
		else
			self.db.char.SSlen = 10
		end
end

function DisqoDice:ShowHideBars()
	self.db.char.barshow = not self.db.char.barshow
	if self.db.char.barshow then
		DisqoDiceBaseFrame:EnableMouse(1);
		f1.statusbar:SetWidth(self.db.char.fWidth - 6)
		f1.statusbar:SetValue(self.db.char.fWidth - 6)
		f1.spark:SetPoint("CENTER",f1.statusbar,"LEFT",self.db.char.fWidth - 3,-1)
		f5.statusbar:SetWidth(self.db.char.fWidth - 6)
		f5.statusbar:SetValue(self.db.char.fWidth - 6)
		f5.spark:SetPoint("CENTER",f5.statusbar,"LEFT",self.db.char.fWidth - 3,-1)
		f2.statusbar:SetWidth(self.db.char.fWidth - 6)
		f2.statusbar:SetValue(self.db.char.fWidth - 6)
		f2.spark:SetPoint("CENTER",f2.statusbar,"LEFT",self.db.char.fWidth - 3,-1)
		f3.statusbar:SetWidth(self.db.char.fWidth * self.db.char.ShockPercent - 6)
		f3.statusbar:SetValue(self.db.char.fWidth * self.db.char.ShockPercent - 6)
		f3.spark:SetPoint("CENTER",f3.statusbar,"LEFT",self.db.char.fWidth * self.db.char.ShockPercent - 3,-1)
		f4.statusbar:SetValue(self.db.char.fWidth * .3 - 6)
		f4.spark:SetPoint("CENTER",f4.statusbar,"LEFT",self.db.char.fWidth * .3 - 3,-1)
		f1:Show()
		f2:Show()
		f3:Show()
		f4:Show()
		f5:Show()
		DisqoDiceBaseFrame:SetScript("OnDragStart", 
			function()
				DisqoDiceBaseFrame:StartMoving();
			end );
		DisqoDiceBaseFrame:SetScript("OnDragStop",
			function()
				DisqoDiceBaseFrame:StopMovingOrSizing();
				DisqoDiceBaseFrame:SetScript("OnUpdate", nil);
				self:FinishedMoving();
			end );
	else
		DisqoDiceBaseFrame:EnableMouse(0);
		-- DisqoDiceBaseFrame:Hide()
		f1:Hide()
		f2:Hide()
		f3:Hide()
		f4:Hide()
		f5:Hide()
	end
end

function DisqoDice:FinishedMoving()
	local point, relativeTo, relativePoint, xOfs, yOfs = DisqoDiceBaseFrame:GetPoint();
	DisqoDice.db.char.point = point
	DisqoDice.db.char.relativeTo = relativeTo
	DisqoDice.db.char.relativePoint = relativePoint
	DisqoDice.db.char.xOfs = xOfs
	DisqoDice.db.char.yOfs = yOfs
end

function DisqoDice:BarShowWut()
	return self.db.char.barshow
end

function DisqoDice:twistWut()
	return self.db.char.twistshow
end

function DisqoDice:SSWut()
	return self.db.char.ssshow
end

function DisqoDice:shockWut()
	return self.db.char.shockshow
end

function DisqoDice:waterWut()
	return self.db.char.wsshow
end

function DisqoDice:arenaWut()
	return self.db.char.arena
end

function DisqoDice:GetWidth()
    return self.db.char.fWidth
end

function DisqoDice:GetScale()
    return self.db.char.scale
end

function DisqoDice:GetWSalpha()
    return self.db.char.wsalpha
end

function DisqoDice:SetWidth(newValue)
	self.db.char.fWidth = newValue
	DisqoDiceBaseFrame:SetWidth(self.db.char.fWidth)
	f1.statusbar:SetWidth(self.db.char.fWidth - 6)
	f1:SetWidth(self.db.char.fWidth)
	f1.statusbar:SetValue(self.db.char.fWidth - 6)
	f1.spark:SetPoint("CENTER",f1.statusbar,"LEFT",self.db.char.fWidth - 3,-1)
	f2.statusbar:SetWidth(self.db.char.fWidth - 6)
	f2:SetWidth(self.db.char.fWidth)
	f2.statusbar:SetValue(self.db.char.fWidth - 6)
	f2.spark:SetPoint("CENTER",f2.statusbar,"LEFT",self.db.char.fWidth - 3,-1)
	f3.statusbar:SetWidth(self.db.char.fWidth * self.db.char.ShockPercent - 6)
	f3:SetWidth(self.db.char.fWidth * self.db.char.ShockPercent)
	f3.statusbar:SetValue(self.db.char.fWidth * self.db.char.ShockPercent - 6)
	f3.spark:SetPoint("CENTER",f3.statusbar,"LEFT",self.db.char.fWidth * self.db.char.ShockPercent - 3,-1)
	f4.statusbar:SetWidth(self.db.char.fWidth * .3 - 6)
	f4:SetWidth((self.db.char.fWidth - 6)*.3)
	f4.spark:SetPoint("CENTER",f4.statusbar,"LEFT",self.db.char.fWidth * .3 - 3,-1)
	f5.statusbar:SetWidth(self.db.char.fWidth - 6)
	f5:SetWidth(self.db.char.fWidth)
	f5.statusbar:SetValue(self.db.char.fWidth - 6)
	f5.spark:SetPoint("CENTER",f5.statusbar,"LEFT",self.db.char.fWidth - 3,-1)
end

function DisqoDice:SetScale(newValue)
	self.db.char.scale = newValue
	DisqoDiceBaseFrame:SetScale(self.db.char.scale)
end

function DisqoDice:SetWSalpha(newValue)
	if self.db.char.wsshow then
		self.db.char.wsalpha = newValue
		f5:SetBackdropColor(0, 0, 0, self.db.char.wsalpha * .2);
		f5:SetBackdropBorderColor( 1, 1, 1, self.db.char.wsalpha);
		f5.statusbar:SetStatusBarColor(.6, .6, 1, self.db.char.wsalpha)
	end
end


function DisqoDice:GetMessage()
    return self.db.char.message
end

function DisqoDice:SetMessage(newValue)
    self.db.char.message = newValue
end

function DisqoDice:CreateBaseFrame()
		DisqoDiceBaseFrame:SetScale(self.db.char.scale)
		DisqoDiceBaseFrame:SetFrameStrata("BACKGROUND")
		DisqoDiceBaseFrame:SetWidth(self.db.char.fWidth)
		DisqoDiceBaseFrame:SetHeight(self.db.char.fHeight)
		DisqoDiceBaseFrame:SetBackdrop({
			bgFile = "Interface/Tooltips/UI-Tooltip-Background",
			-- edgeFile = "Interface/AddOns/ButtonFacade_Apathy/Textures/Border",
			tile = false, tileSize = 0, edgeSize = 12,
			insets = { left = 0, right = 0, top = 0, bottom = 0 }
		});
		DisqoDiceBaseFrame:SetBackdropColor(1, 1, 1, 0);
		-- DisqoDiceBaseFrame:SetBackdropBorderColor( 1, 1, 1, 1);
		-- DisqoDiceBaseFrame:EnableMouse(1);
		DisqoDiceBaseFrame:SetMovable(true);
		DisqoDiceBaseFrame:RegisterForDrag("LeftButton");
		DisqoDiceBaseFrame:SetPoint(self.db.char.point, self.db.char.relativeTo, self.db.char.relativePoint, self.db.char.xOfs, self.db.char.yOfs)
		DisqoDiceBaseFrame:Show()
		self.db.char.barshow = false

		f1:SetFrameStrata("LOW")
		f1:SetWidth(self.db.char.fWidth)
		f1:SetHeight(self.db.char.fHeight / 4)
		f1:ClearAllPoints()
 		f1:SetPoint("TOPLEFT", DisqoDiceBaseFrame, "TOPLEFT", 0, 0)
		f1:SetBackdrop({
			bgFile = "Interface/Tooltips/UI-Tooltip-Background",
			edgeFile = "Interface/AddOns/ButtonFacade_Apathy/Textures/Border",
			tile = false, tileSize = 0, edgeSize = 12,
			insets = { left = 2, right = 2, top = 2, bottom = 2 }
		});
		f1:SetBackdropColor(0, 0, 0, .2);
		f1:SetBackdropBorderColor( 1, 1, 1, 1);
		f1:EnableMouse(false)
		if not f1.statusbar then
			f1.statusbar = CreateFrame("StatusBar", nil, f1)
		end
		f1.statusbar:SetFrameLevel(f1.statusbar:GetFrameLevel() - 1)
		f1.statusbar:ClearAllPoints()
		f1.statusbar:SetHeight(self.db.char.fHeight / 4 - 6)
		f1.statusbar:SetWidth(self.db.char.fWidth - 6)
		f1.statusbar:SetPoint("TOPLEFT", f1, "TOPLEFT", 3, -3)
		f1.statusbar:SetStatusBarTexture(texture)
		f1.statusbar:SetStatusBarColor(1, .5, 1, .9)
		f1.statusbar:SetMinMaxValues(0,10)
		f1.statusbar:SetValue(6)

		if not f1.spark then
			f1.spark = f1.statusbar:CreateTexture(nil, "OVERLAY")
		end
		f1.spark:SetTexture("Interface\\CastingBar\\UI-CastingBar-Spark")
		f1.spark:SetWidth(16)
		f1.spark:SetHeight(self.db.char.fHeight/4 + 36)
		f1.spark:SetBlendMode("ADD")
		f1.spark:SetPoint("CENTER",f1.statusbar,"LEFT",(self.db.char.fWidth - 6)* 0.6,-1)
		f1.spark:Show()
		f1:Hide()

		f2:SetFrameStrata("LOW")
		f2:SetWidth(self.db.char.fWidth)
		f2:SetHeight(self.db.char.fHeight / 4)
		f2:ClearAllPoints()
 		f2:SetPoint("TOPLEFT", DisqoDiceBaseFrame, "TOPLEFT", 0, (-1 * self.db.char.fHeight / 4) + 3)
		f2:SetBackdrop({
			bgFile = "Interface/Tooltips/UI-Tooltip-Background",
			edgeFile = "Interface/AddOns/ButtonFacade_Apathy/Textures/Border",
			tile = false, tileSize = 0, edgeSize = 12,
			insets = { left = 2, right = 2, top = 2, bottom = 2 }
		});
		f2:SetBackdropColor(0, 0, 0, .2);
		f2:SetBackdropBorderColor( 1, 1, 1, 1);
		f2:EnableMouse(false)
		if not f2.statusbar then
			f2.statusbar = CreateFrame("StatusBar", nil, f2)
		end
		f2.statusbar:SetFrameLevel(f2.statusbar:GetFrameLevel() - 1)
		f2.statusbar:ClearAllPoints()
		f2.statusbar:SetHeight(self.db.char.fHeight / 4 - 6)
		f2.statusbar:SetWidth(self.db.char.fWidth - 6)
		f2.statusbar:SetPoint("TOPLEFT", f2, "TOPLEFT", 3, -3)
		f2.statusbar:SetStatusBarTexture(texture)
		f2.statusbar:SetStatusBarColor(1, 1, 0.2, .9)
		f2.statusbar:SetMinMaxValues(0,self.db.char.SSlen)
		f2.statusbar:SetValue(.4)

		if not f2.spark then
			f2.spark = f2.statusbar:CreateTexture(nil, "OVERLAY")
		end
		f2.spark:SetTexture("Interface\\CastingBar\\UI-CastingBar-Spark")
		f2.spark:SetWidth(16)
		f2.spark:SetHeight(self.db.char.fHeight/4 + 36)
		f2.spark:SetBlendMode("ADD")
		f2.spark:SetPoint("CENTER",f2.statusbar,"LEFT",(self.db.char.fWidth - 6) * .4,-1)
		f2.spark:Show()
		f2:Hide()

		f3:SetFrameStrata("LOW")
		f3:SetWidth(self.db.char.fWidth * self.db.char.ShockPercent)
		f3:SetHeight(self.db.char.fHeight / 4)
		f3:ClearAllPoints()
 		f3:SetPoint("TOPLEFT", DisqoDiceBaseFrame, "TOPLEFT", 0, (-2 * self.db.char.fHeight / 4) + 6)
		f3:SetBackdrop({
			bgFile = "Interface/Tooltips/UI-Tooltip-Background",
			edgeFile = "Interface/AddOns/ButtonFacade_Apathy/Textures/Border",
			tile = false, tileSize = 0, edgeSize = 12,
			insets = { left = 2, right = 2, top = 2, bottom = 2 }
		});
		f3:SetBackdropColor(0, 0, 0, .2);
		f3:SetBackdropBorderColor( 1, 1, 1, 1);
		f3:EnableMouse(false)
		if not f3.statusbar then
			f3.statusbar = CreateFrame("StatusBar", nil, f3)
		end
		f3.statusbar:SetFrameLevel(f3.statusbar:GetFrameLevel() - 1)
		f3.statusbar:ClearAllPoints()
		f3.statusbar:SetHeight(self.db.char.fHeight / 4 - 6)
		f3.statusbar:SetWidth(self.db.char.fWidth * DisqoDice.db.char.ShockPercent - 6)
		f3.statusbar:SetPoint("TOPLEFT", f3, "TOPLEFT", 3, -3)
		f3.statusbar:SetStatusBarTexture(texture)
		f3.statusbar:SetStatusBarColor(0, 1, .3, .9)
		f3.statusbar:SetMinMaxValues(0, DisqoDice.db.char.ShockPercent*10)
		f3.statusbar:SetValue(1)

		if not f3.spark then
			f3.spark = f3.statusbar:CreateTexture(nil, "OVERLAY")
		end
		f3.spark:SetTexture("Interface\\CastingBar\\UI-CastingBar-Spark")
		f3.spark:SetWidth(16)
		f3.spark:SetHeight(self.db.char.fHeight/4 + 36)
		f3.spark:SetBlendMode("ADD")
		f3.spark:SetPoint("CENTER",f3.statusbar,"LEFT",(self.db.char.fWidth * self.db.char.ShockPercent - 6) * .8,-1)
		f3.spark:Show()
		f3:Hide()

		f4:SetFrameStrata("MEDIUM")
		f4:SetWidth(self.db.char.fWidth * .3)
		f4:SetHeight(self.db.char.fHeight / 4)
		f4:ClearAllPoints()
 		f4:SetPoint("TOPLEFT", DisqoDiceBaseFrame, "TOPLEFT", 0, (-1 * self.db.char.fHeight / 4) + 3)
		f4:SetBackdrop({
			bgFile = "Interface/Tooltips/UI-Tooltip-Background",
			edgeFile = "Interface/AddOns/ButtonFacade_Apathy/Textures/Border",
			tile = false, tileSize = 0, edgeSize = 12,
			insets = { left = 2, right = 2, top = 2, bottom = 2 }
		});
		f4:SetBackdropColor(0, 0, 0, 0);
		f4:SetBackdropBorderColor( 1, 1, 1, 1);
		f4:EnableMouse(false)
		if not f4.statusbar then
			f4.statusbar = CreateFrame("StatusBar", nil, f4)
		end
		f4.statusbar:SetFrameLevel(f4.statusbar:GetFrameLevel() - 1)
		f4.statusbar:ClearAllPoints()
		f4.statusbar:SetHeight(self.db.char.fHeight / 4 - 6)
		f4.statusbar:SetWidth(self.db.char.fWidth * .3 - 6)
		f4.statusbar:SetPoint("TOPLEFT", f4, "TOPLEFT", 3, -3)
		f4.statusbar:SetStatusBarTexture(texture)
		f4.statusbar:SetStatusBarColor(1, 0, 0, .5)
		f4.statusbar:SetMinMaxValues(0,3)
		f4.statusbar:SetValue(3)

		if not f4.spark then
			f4.spark = f4.statusbar:CreateTexture(nil, "OVERLAY")
		end
		f4.spark:SetTexture("Interface\\CastingBar\\UI-CastingBar-Spark")
		f4.spark:SetWidth(16)
		f4.spark:SetHeight(self.db.char.fHeight/4 + 36)
		f4.spark:SetBlendMode("ADD")
		f4.spark:SetPoint("CENTER",f4.statusbar,"LEFT",(self.db.char.fWidth * .3 - 6),-1)
		f4.spark:Show()
		f4:Hide()

		f5:SetFrameStrata("LOW")
		f5:SetWidth(self.db.char.fWidth)
		f5:SetHeight(self.db.char.fHeight / 4)
		f5:ClearAllPoints()
 		f5:SetPoint("TOPLEFT", DisqoDiceBaseFrame, "TOPLEFT", 0, (-3 * self.db.char.fHeight / 4) + 9)
		f5:SetBackdrop({
			bgFile = "Interface/Tooltips/UI-Tooltip-Background",
			edgeFile = "Interface/AddOns/ButtonFacade_Apathy/Textures/Border",
			tile = false, tileSize = 0, edgeSize = 12,
			insets = { left = 2, right = 2, top = 2, bottom = 2 }
		});
		f5:SetBackdropColor(0, 0, 0, .2);
		f5:SetBackdropBorderColor( 1, 1, 1, self.db.char.wsalpha);
		f5:EnableMouse(false)
		if not f5.statusbar then
			f5.statusbar = CreateFrame("StatusBar", nil, f5)
		end
		f5.statusbar:SetFrameLevel(f5.statusbar:GetFrameLevel() - 1)
		f5.statusbar:ClearAllPoints()
		f5.statusbar:SetHeight(self.db.char.fHeight / 4 - 6)
		f5.statusbar:SetWidth(self.db.char.fWidth - 6)
		f5.statusbar:SetPoint("TOPLEFT", f5, "TOPLEFT", 3, -3)
		f5.statusbar:SetStatusBarTexture(texture)
		f5.statusbar:SetStatusBarColor(.6, .6, 1, self.db.char.wsalpha)
		f5.statusbar:SetMinMaxValues(0, 600)
		f5.statusbar:SetValue(600)

		if not f5.spark then
			f5.spark = f5.statusbar:CreateTexture(nil, "OVERLAY")
		end
		f5.spark:SetTexture("Interface\\CastingBar\\UI-CastingBar-Spark")
		f5.spark:SetWidth(16)
		f5.spark:SetHeight(self.db.char.fHeight/4 + 36)
		f5.spark:SetBlendMode("ADD")
		f5.spark:SetPoint("CENTER",f5.statusbar,"LEFT",self.db.char.fWidth - 6,-1)
		f5.spark:Show()
		f5:Hide()
end

function DisqoDice:ResetAll()
	DisqoDiceBaseFrame:ClearAllPoints()
	self.db.char.point = "CENTER"
	self.db.char.relativeTo = "UIParent"
	self.db.char.relativePoint = "CENTER"
	self.db.char.xOfs = 0
	self.db.char.yOfs = 0
	self.db.char.fWidth = 250
	self.db.char.fHeight = 100
	self.db.char.scale = 1
	barshow = true
	DisqoDiceBaseFrame:SetPoint("CENTER", "UIParent", "CENTER", 0, 0)
	self:CreateBaseFrame()
	self:ShowHideBars()
end

function DisqoDice:WFProcBar()
	f4:Show()
	gogogoWFProc = true
	WFProcTime = GetTime() + 3
	WFPMin, WFPMax = f4.statusbar:GetMinMaxValues()
	f4:SetScript("OnUpdate", 
		function()
			OnUpdate();
		end );
end

function DisqoDice:WSBar()
	f5.statusbar:SetStatusBarColor(.6, .6, 1, self.db.char.wsalpha)
	f5:SetBackdropBorderColor( 1, 1, 1, self.db.char.wsalpha);
	f5.spark:Show()
	f5:Show()
	gogogoWS = true
	WSTime = GetTime() + 600
	WSMin, WSMax = f5.statusbar:GetMinMaxValues()
	f5:SetScript("OnUpdate", 
		function()
			OnUpdate();
		end );
end

function DisqoDice:TotemBar()
	f1:Show()
	gogogoTotem = true
	TotemTime = GetTime() + 10
	TotemMin, TotemMax = f1.statusbar:GetMinMaxValues()
	f1:SetScript("OnUpdate", 
		function()
			OnUpdate();
		end );
end

function DisqoDice:SSBar()
	f2:Show()
	gogogoSS = true
	SSTime = GetTime() + self.db.char.SSlen
	SSmin, SSmax = f2.statusbar:GetMinMaxValues()
	f2:SetScript("OnUpdate", 
		function() 	
			OnUpdate();
		end );
end

function DisqoDice:ShockBar()
	f3:Show()
	gogogoShock = true
	ShockTime = GetTime() + 6
	ShockMin, ShockMax = f3.statusbar:GetMinMaxValues()
	f3:SetScript("OnUpdate", 
		function()
			OnUpdate();
		end );
end

function OnUpdate()
	if gogogoTotem then
		f1.statusbar:SetValue(TotemTime - GetTime())
		f1.spark:SetPoint("CENTER",f1.statusbar,"LEFT",(TotemTime - GetTime())/TotemMax*( DisqoDice.db.char.fWidth - 6),-1)
		if TotemTime < GetTime() then
			f1:Hide()
			gogogoTotem = false
		end
	end
	if gogogoSS then
		f2.statusbar:SetValue(SSTime - GetTime())
		f2.spark:SetPoint("CENTER",f2.statusbar,"LEFT",(SSTime - GetTime())/SSmax*( DisqoDice.db.char.fWidth - 6),-1)
		if SSTime < GetTime() then
			f2:Hide()
			gogogoSS = false
		end
	end
	if gogogoShock then
		f3.statusbar:SetValue(ShockTime - GetTime())
		f3.spark:SetPoint("CENTER",f3.statusbar,"LEFT",(ShockTime - GetTime())/ShockMax*( DisqoDice.db.char.fWidth - 6) * DisqoDice.db.char.ShockPercent ,-1)
		if ShockTime < GetTime() then
			f3:Hide()
			gogogoShock = false
		end
	end
	if gogogoWS then
		f5.statusbar:SetValue(WSTime - GetTime())
		f5.spark:SetPoint("CENTER",f5.statusbar,"LEFT",(WSTime - GetTime())/WSMax*( DisqoDice.db.char.fWidth - 6),-1)
		if WSTime < GetTime() then
			f5:Hide()
			gogogoWS = false
		end
	end
	if gogogoWFProc then
		f4.statusbar:SetValue(WFProcTime - GetTime())
		f4.spark:SetPoint("CENTER",f4.statusbar,"LEFT",(WFProcTime - GetTime())/WFPMax*( DisqoDice.db.char.fWidth - 6)*.3 ,-1)
		if WFProcTime < GetTime() then
			f4:Hide()
			gogogoWFProc = false
		end
	end
end

------ random debugging stuff -------
-- self:Print(self.db.char.xOfs.." "..self.db.char.yOfs)
-- self:Print(DisqoDiceBaseFrame:GetPoint())
