DispelReporter = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0","AceConsole-2.0")

DispelReporter:RegisterChatCommand({ "/dispelreporter" }, {
    type = 'group',
    args = {
        enabled = {
            name = "Enable Add-On",
            desc = "Turn on or off this add-on",
            type = 'toggle',
            get = 	function()
            			return DispelReporter:GetOption("enabled")
            		end,
            set =	function(v)
            			DispelReporter:SetOption("enabled", v)
            		end,
		},
        onlyme = {
            name = "Only Me",
            desc = "Show only buffs you dispel",
            type = 'toggle',
            get = 	function()
            			return DispelReporter:GetOption("onlyme")
            		end,
            set =	function(v)
            			DispelReporter:SetOption("onlyme", v)
            		end,           		      
		},         
        onlypvpbuffs = {
            name = "Only PVP Buffs",
            desc = "Only report PVP buffs",
            type = 'toggle',
            get = 	function()
            			return DispelReporter:GetOption("onlypvpbuffs")
            		end,
            set =	function(v)
            			DispelReporter:SetOption("onlypvpbuffs", v)
            		end,            		        
		},

        raidwarn = {
            name = "Report to Raid Warning",
            desc = "Report to Raid Warning if true",
            type = 'toggle',
            get = 	function()
            			return DispelReporter:GetOption("raidwarn")
            		end,
            set =	function(v)
            			DispelReporter:SetOption("raidwarn", v)
            		end,            		        
		},

        reporttoparty = {
            name = "Report to party / raid",
            desc = "Report to party / raid if true",
            type = 'toggle',
            get = 	function()
            			return DispelReporter:GetOption("reporttoparty")
            		end,
            set =	function(v)
            			DispelReporter:SetOption("reporttoparty", v)
            		end,            		        
		},

        reporttoself = {
            name = "Report to yourself",
            desc = "Report to yourself",
            type = 'toggle',
            get = 	function()
            			return DispelReporter:GetOption("reporttoself")
            		end,
            set =	function(v)
            			DispelReporter:SetOption("reporttoself", v)
            		end,            		        
		},

        sct = {
            name = "Report to SCT (or MSBT)",
            desc = "Report to SCT (or MSBT) if it exists, otherwise does nothing",
            type = 'toggle',
            get = 	function()
            			return DispelReporter:GetOption("sct")
            		end,
            set =	function(v)
            			DispelReporter:SetOption("sct", v)
            		end,            		        
		},
	},
})

function DispelReporter:GetOption(key, type)
	local optionValue = DispelReporterOptions[key]
	if type == "range" and optionValue == nil then
		optionValue = 1
	end
	return optionValue
end

function DispelReporter:SetOption(key, value)

	DispelReporterOptions[key] = value

end



function DispelReporter:OnEnable()

	self:RegisterEvent("CHAT_MSG_SPELL_BREAK_AURA", "OnDispelEvent")

	if DispelReporterOptions == nil then
		DispelReporterOptions = { }

		DispelReporterOptions.enabled = true
		DispelReporterOptions.onlyme = true
		DispelReporterOptions.onlypvpbuffs = true
		DispelReporterOptions.raidwarn = true
		DispelReporterOptions.reporttoparty = false
		DispelReporterOptions.reporttoself = false
		DispelReporterOptions.sct = true
	end

end

function DispelReporter:OnDispelEvent()
	local event = AceLibrary("AceEvent-2.0").currentEvent		

			
	if DispelReporterOptions.enabled == true and event == "CHAT_MSG_SPELL_BREAK_AURA" then			
			
		local _, _, target, buff, caster = string.find(arg1, "^([%a]+) 's (.+) is removed by (.+)'s ");

		local myname = UnitName("player")

		if target == nil then

			local _, _, buffself, casterself = string.find(arg1, "Your (.+) is removed by (.+)'s ");

			buff = buffself
			caster = casterself
			target = myname
		end

		if buff ~= nil then
			buff = strtrim(buff)
		end

		if caster ~= nil then
			caster = strtrim(caster)
		end

		if target ~= nil then
			target = strtrim(target)
		end
		

		if DispelReporterOptions.onlyme ~= true or caster == myname then

			if DispelReporterOptions.onlypvpbuffs ~= true or buff == "Blessing of Protection" or buff == "Blessing of Freedom" or buff == "Divine Shield" or buff == "Ice Block" or buff == "Divine Protection" or buff == "Earth Shield" or buff == "Blessing of Sacrifice" or buff == "Fel Armor" or buff == "Pain Suppression" then
				if buff ~= nil then
					DispelReporter:DisplayCustomEvent(buff .. " is removed from " .. target .. "!")
				end
			end
		end
		
		
	end	
		
end

function DispelReporter:DisplayCustomEvent(msg)

	local raidsize = GetNumRaidMembers()
	local partysize = GetNumPartyMembers() + 1

	if DispelReporterOptions.raidwarn == true then
		if raidsize > 1 or partysize > 1 then
			SendChatMessage(msg, "RAID_WARNING")
		end
	end

	if DispelReporterOptions.reporttoparty == true then

		if raidsize > 1 or partysize > 1 then
			if raidsize > partysize then
				SendChatMessage(msg, "RAID")
			else
				SendChatMessage(msg, "PARTY")
			end
		end
	end

	if DispelReporterOptions.reporttoself == true then
		AceLibrary("AceConsole-2.0").Print("DispelReporter",msg)
	end


	if DispelReporterOptions.sct == true then
		if SCT ~= nil then
		
			local color = {r = 256/256, g = 165/256, b = 0/256}
			SCT:DisplayText(msg , color, false, "event", 1)

		elseif MikSBT ~= nil then
			
			MikSBT.DisplayMessage(msg)

		elseif Parrot ~= nil then
		
			Parrot:ShowMessage(msg , "Notification", true, 0.5, 0.5, 1)

		end
	end
end