local Deadened = LibStub("AceAddon-3.0"):GetAddon("Deadened")
local ecast = Deadened:NewModule("eCastingBar", "AceHook-3.0")

function ecast:OnEnable()
	if not eCastingBar_OnEvent then return end
	if not self:IsHooked("eCastingBar_OnEvent") then
		self:RawHook("eCastingBar_OnEvent")
	end
end

function ecast:MenuHide()
	return eCastingBar_OnEvent == nil
end

local events = {
	["PLAYER_ENTERING_WORLD"] = true
}

function ecast.eCastingBar_OnEvent(orig_object, origevent, newarg1)
	local event
	if not newarg1 then 
		ecast.hooks.eCastingBar_OnEvent(origevent, newarg1)
		return
	end
	local spell, rank, displayName, icon, startTime, endTime = UnitCastingInfo(newarg1)
	local event = events[origevent] and "UNIT_SPELLCAST_START" or origevent
	if displayName and event == "UNIT_SPELLCAST_START" and Deadened:Suppress(displayName) then
		return
	end
	ecast.hooks.eCastingBar_OnEvent(origevent, newarg1)
end
