local Deadened = LibStub("AceAddon-3.0"):GetAddon("Deadened")
local azcast = Deadened:NewModule("azCastBar", "AceHook-3.0")

function azcast:OnEnable()
	if not AzCastBar_Frames then return end

	for i = 1, #AzCastBar_Frames do
		self:RawHookScript(AzCastBar_Frames[i], "OnEvent")		
	end
end

function azcast:MenuHide()
	return AzCastBar_Frames == nil
end

local events = {
	["PLAYER_ENTERING_WORLD"] = true,
	["PLAYER_TARGET_CHANGED"] = true,
	["PLAYER_FOCUS_CHANGED"] = true
}

function azcast:OnEvent(orig_object, origevent, newarg1)
	local event
	if not newarg1 then 
		azcast.hooks[orig_object].OnEvent(orig_object, origevent)
		return
	end
	local spell, rank, displayName, icon, startTime, endTime = UnitCastingInfo(newarg1)
	local event = events[origevent] and "UNIT_SPELLCAST_START" or origevent
	if displayName and event == "UNIT_SPELLCAST_START" and Deadened:Suppress(displayName) then
		return
	end
	azcast.hooks[orig_object].OnEvent(orig_object, origevent)
end
