local Deadened = LibStub("AceAddon-3.0"):GetAddon("Deadened")
local quartz = Deadened:NewModule("Quartz", "AceHook-3.0")

function quartz:OnInitialize()
	if not Quartz then return end
	
	Quartz.Ace2_AddonEnabled = function(self, module, first)
		if Quartz:HasModule("Target") and Quartz:GetModule("Target") == module then
			Deadened:InitModule("Quartz")
			Quartz.Ace2_AddonEnabled = nil
		end
	end
	Quartz:RegisterEvent("Ace2_AddonEnabled")
end

function quartz:OnEnable(module)
	if self:MenuHide() then return end
	local QuartzTarget = Quartz:GetModule("Target")
	if not self:IsHooked(QuartzTarget, "UNIT_SPELLCAST_START") then
		self:RawHook(QuartzTarget, "UNIT_SPELLCAST_START")
		self:RawHook(QuartzTarget, "PLAYER_TARGET_CHANGED")
	end
end

function quartz:MenuHide()
	return Quartz == nil or not Quartz:HasModule("Target") or not Quartz:IsModuleActive("Target")
end

function quartz:UNIT_SPELLCAST_START(obj, unit, ...)
	local spell, rank, displayName, icon, startTime, endTime = UnitCastingInfo(unit)
	if unit ~= "target" then return end
	if not Deadened:IsDeaden(displayName) then
		self.hooks[obj].UNIT_SPELLCAST_START(obj, unit, ...)
	end
end

function quartz:PLAYER_TARGET_CHANGED(obj, unit, ...)
	local spell, rank, displayName, icon, startTime, endTime = UnitCastingInfo("target")
	if not Deadened:IsDeaden(displayName) then
		self.hooks[obj].PLAYER_TARGET_CHANGED(obj, ...)
	end
end
