local Deadened = LibStub("AceAddon-3.0"):GetAddon("Deadened")
local pitbull = Deadened:NewModule("PitBull", "AceHook-3.0")

local function getPitbullModule()
	return PitBull:GetModule("CastBar")
end

function pitbull:OnInitialize()
	if not PitBull then return end
	self:Hook(PitBull, "FullyInitialized")
end

function pitbull:FullyInitialized()
	self:OnEnable()
end

function pitbull:MenuHide()
	return PitBull == nil
end

function pitbull:OnEnable(module)
	if not PitBull then return end
	local retOK, castBar = pcall(PitBull.GetModule, PitBull, "CastBar")
	if not retOK then return end
	if not self:IsHooked(castBar, "UNIT_SPELLCAST_START") then
		self:RawHook(castBar, "UNIT_SPELLCAST_START")
	end	
end

function pitbull:UNIT_SPELLCAST_START(object, ns, event, unit, ...)
	if unit == "target" then
		local spell, rank, displayName, icon, startTime, endTime = UnitCastingInfo(unit)
		if Deadened:IsDeaden(displayName) then
			return
		end
	end
	self.hooks[object].UNIT_SPELLCAST_START(object, ns, event, unit, ...)
end
