Deadened = LibStub("AceAddon-3.0"):NewAddon("Deadened", "AceHook-3.0", "AceTimer-3.0", "AceConsole-3.0", "AceEvent-3.0", "LibSink-2.0")

local L = LibStub("AceLocale-3.0"):GetLocale("Deadened")
local AceConfig = LibStub("AceConfig-3.0")
local AceConfigDialog = LibStub("AceConfigDialog-3.0")
local bit_band = _G.bit.band

local stockAnnounceModes = {None = L["None"], Group = L["Group"], Party = L["Party"], Raid = L["Raid"], Say = L["Say"], Yell = L["Yell"], RaidWarn = L["Raid Warning"]}
local announceModes = {}

local options = {
	type = "group",
	args = {
		spells = {
			type = "group",
			name = L["Spells to suppress"],
			desc = L["Select the casts you want to suppress"],
			args = {
				add = {
					type = "input",
					name = L["Add a spell ID"],
					desc = L["Add the spell ID of a spell to suppress (must be numeric)"],
					get = function() return "" end,
					set = function(info, v)
						Deadened.db.profile.spells[v] = true
						Deadened:AddSpell(v, true)
						Deadened:RebuildSpellTable()
					end,
					pattern = "%d+"
				}
			}
		},
		announce = {
			type = "select",
			name = L["Announce"],
			desc = L["Announce interrupts to..."],
			get = function()
				return Deadened.db.profile.announce
			end,
			set = function(info, v)
				Deadened.db.profile.announce = v
				Deadened:Print(L["Now announcing interrupts to"], v)
			end,
			values = announceModes
		},
		modules = {
			type = "group",
			name = L["Modules"],
			desc = L["Modules"],
			args = {}
		}
	}
}
	
AceConfig:RegisterOptionsTable("Deadened", options, {"deaden", "deadened"})
Deadened:SetDefaultModuleState(false)

function Deadened:OnInitialize()
	self.db = LibStub("AceDB-3.0"):New("DeadenedDB")
	self.db:RegisterDefaults({
		profile = {
			modules = {},
			tankmode = false,
			sink20OutputSink = "None",
			announce = "None",
			spells = {
				[41426] = false,
				[41410] = true,
				[40832] = false,
				[40904] = false,
				-- [13878] = true 		-- Scorch, testing
			},
		}
	})
	optFrame = AceConfigDialog:AddToBlizOptions("Deadened", "Deadened")
	options.args.profile = LibStub("AceDBOptions-3.0"):GetOptionsTable(self.db)
	
	for k, v in self:IterateModules() do
		options.args.modules.args[k] = {
			type = "toggle", 
			name = k, 
			desc = L["Toggle "] .. k, 
			get = function()
				return Deadened.db.profile.modules[k] ~= false or false
			end,
			set = function(info, v)
				Deadened.db.profile.modules[k] = v
				if v then
					Deadened:EnableModule(k)
					Deadened:Print(L["Enabled"], k, L["module"])
				else
					Deadened:DisableModule(k)
					Deadened:Print(L["Disabled"], k, L["module"])
				end
			end,
			hidden = function() return v.MenuHide and v:MenuHide() end
		}
	end		
	
end

local serverChannels = {}
local function excludeChannels(...)
	for i = 1, select("#", ...) do
		local name = select(i, ...)
		serverChannels[name] = true
	end
end

function Deadened:AddCustomChannels(...)
	for k, v in pairs(announceModes) do
		announceModes[k] = nil
	end
	for k, v in pairs(stockAnnounceModes) do
		announceModes[k] = v
	end
	excludeChannels(EnumerateServerChannels())
	for i = 1, select("#", ...), 2 do
		local id, name = select(i, ...)
		if not serverChannels[name] then
			announceModes[name] = name
		end
	end
end

local spellNames = {}

function Deadened:OnEnable()
	self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
	self:RegisterEvent("CHAT_MSG_CHANNEL_NOTICE")
	for k, v in pairs(self.db.profile.spells) do
		self:AddSpell(k, v)
	end
	
	for k, v in self:IterateModules() do
		if self.db.profile.modules[k] ~= false then
			v:Enable()
		end
	end
	self:AddCustomChannels(GetChannelList())
end

function Deadened:CHAT_MSG_CHANNEL_NOTICE()
	self:AddCustomChannels(GetChannelList())
end

function Deadened:AddSpell(k, v)
	k = tonumber(k)
	local spellName = GetSpellInfo(k)
	spellNames[spellName] = v
	options.args.spells.args[spellName:gsub(" ", "")] = {
		type = "toggle",
		name = spellName,
		desc = spellName,
		get = function(info) return Deadened.db.profile.spells[k] end,
		set = function(info, val)
			Deadened.db.profile.spells[k] = val
			Deadened:RebuildSpellTable()
		end,
	}
end

function Deadened:RebuildSpellTable()
	for k, v in pairs(self.db.profile.spells) do
		local spellName = GetSpellInfo(k)
		spellNames[spellName] = v
	end
end

function Deadened:InitModule(k)
	if self.db.profile.modules[k] ~= false then
		self:DisableModule(k)
		self:EnableModule(k)
	end
end

function Deadened:Dump()
	for k, v in pairs(spellNames) do
		self:Print(k, v)
	end
end

local function getDistribution(p)
	if p:lower() == "party" then
		if GetNumPartyMembers() > 0 then return "PARTY" end
	elseif p:lower() == "raid" then
		if GetNumRaidMembers() > 0 then return "RAID" end
	elseif p:lower() == "raidwarn" then
		if GetNumRaidMembers() > 0 then return "RAID_WARNING" end
	elseif p:lower() == "group" then
		if GetNumRaidMembers() > 0 then return "RAID" end
		if GetNumPartyMembers() > 0 then return "PARTY" end
	elseif p:lower() == "say" then
		return "SAY"
	elseif p:lower() == "yell" then
		return "YELL"
	elseif p then
		return "CHANNEL"
	end
	return nil
end

local COMBATLOG_FILTER_ME = _G.COMBATLOG_FILTER_ME

function Deadened:COMBAT_LOG_EVENT_UNFILTERED(event, ...)
	local timestamp, eventtype, srcGUID, srcName, srcFlags, dstGUID, dstName, dstFlags = ...
	if eventtype == "SPELL_INTERRUPT" and srcGUID == UnitGUID("player") then
		local srcSpellId, srcSpellName, srcSpellSchool, dstSpellId, dstSpellName, dstSpellSchool = select(9, ...);

		if self.db.profile.announce == "None" then return end
		local d = getDistribution(self.db.profile.announce)
		if d then
			local msg = ("%sed %s's %s!"):format(srcSpellName, dstName, dstSpellName)
			if d == "CHANNEL" then
				SendChatMessage(msg, d, nil, GetChannelName(self.db.profile.announce))
			else
				SendChatMessage(msg, d)
			end
		end	
	end
end

function Deadened:OnDisable()
end

function Deadened:IsDeaden(v)
	if type(v) == "number" then
		return self.db.profile.spells[v]
	end
	return spellNames[v]
end

Deadened.Suppress = Deadened.IsDeaden

local timer = nil
function Deadened:Alert(s)
	if timer then
		self:CancelTimer(timer, true)
		timer = nil
	end
	timer = self:ScheduleTimer(self.Pour, 0.25, self, s)
end

function Deadened:UNIT_SPELLCAST_START(orig_object, unit, ...)
	if unit == "target" then
		local spell, rank, displayName, icon, startTime, endTime = UnitCastingInfo(unit)
		if not Deadened:IsDeaden(displayName) then
			for k,v in pairs(self.hooks[orig_object]) do
				v(orig_object, unit, ...)
			end
		else
			self:Alert((L["%s casting %s (%s) sec"]):format(UnitName(unit), displayName, ("%2.1f"):format((endTime-startTime) / 1000 )))
		end
	end	
end
