﻿PortalFrame_NumPortals = 22;

PortalFrame_Portals = {
	[DAVPORTAL_T_ORG] = 0,
    [DAVPORTAL_T_TB] = 0,
    [DAVPORTAL_T_UC] = 0,
    [DAVPORTAL_T_SM] = 0,
    [DAVPORTAL_T_ST] = 0,
	[DAVPORTAL_T_IF] = 0,
    [DAVPORTAL_T_SW] = 0,
    [DAVPORTAL_T_DARN] = 0,
    [DAVPORTAL_T_EX] = 0,
    [DAVPORTAL_T_TH] = 0,
    [DAVPORTAL_T_SHAT] = 0,
        [DAVPORTAL_P_ORG] = 0,
    [DAVPORTAL_P_TB] = 0,
    [DAVPORTAL_P_UC] = 0,
    [DAVPORTAL_P_SM] = 0,
    [DAVPORTAL_P_ST] = 0,
	[DAVPORTAL_P_IF] = 0,
    [DAVPORTAL_P_SW] = 0,
    [DAVPORTAL_P_DARN] = 0,
    [DAVPORTAL_P_EX] = 0,
    [DAVPORTAL_P_TH] = 0,
    [DAVPORTAL_P_SHAT] = 0,
}

if PortalFrameUnlocked==nil then
    PortalFrameUnlocked = true;
end

--Updates the appearance of the lock button based on the status of AtlasLocked
function Portal_UpdateLock()
	if(not PortalFrameUnlocked) then
		PortalLockNorm:SetTexture("Interface\\AddOns\\DavPortalFrame\\Images\\LockButton-Locked-Up");
		PortalLockPush:SetTexture("Interface\\AddOns\\DavPortalFrame\\Images\\LockButton-Locked-Down");
		PortalFrame_Back:Hide();
        PortalFrame_Text:Hide();
	else
		PortalLockNorm:SetTexture("Interface\\AddOns\\DavPortalFrame\\Images\\LockButton-Unlocked-Up");
		PortalLockPush:SetTexture("Interface\\AddOns\\DavPortalFrame\\Images\\LockButton-Unlocked-Down");
		PortalFrame_Back:Show();
        PortalFrame_Text:Show();
	end
end

--Simple function to toggle the Atlas frame's lock status and update it's appearance
function Portal_ToggleLock()
	if(PortalFrameUnlocked) then
		PortalFrameUnlocked = false;
		Portal_UpdateLock();
	else
		PortalFrameUnlocked = true;
		Portal_UpdateLock();
	end
end


function PortalFrame_Initialize()
	-- Reset the available abilities.
	for spell, id in pairs(PortalFrame_Portals) do
		if (id > 0) then
			PortalFrame_Portals[spellName] = 0
		end
	end

	-- Calculate the total number of spells known by scanning the spellbook.
	local numTotalSpells = 0;
	for i=1, MAX_SKILLLINE_TABS do
		local name, texture, offset, numSpells = GetSpellTabInfo(i);
		if (name) then
			numTotalSpells = numTotalSpells + numSpells
		end
	end

	--bcAM_IconFrame.haveAbilities = false;
	
	-- Find the abilities available.
	for i=1, numTotalSpells do
		local spellName, subSpellName = GetSpellName(i, SpellBookFrame.bookType);
		if (spellName) then
			if (PortalFrame_Portals[spellName]) then
				PortalFrame_Portals[spellName] = i
			end
		end
	end

	local count = 0;
    local button;
    local buttontext;
    if PortalFrame_Portals[DAVPORTAL_T_ORG]~=0 then
        count = count + 1;
        local button = getglobal("PortalFrame_Portal"..count);
        local buttontext = getglobal("PortalFrame_Portal"..count.."Icon");
		button:SetAttribute("type", "spell");
		button:SetAttribute("spell", DAVPORTAL_T_ORG);
        buttontext:SetTexture("Interface\\Icons\\Spell_Arcane_TeleportOrgrimmar");
        button.SpellID = PortalFrame_Portals[DAVPORTAL_T_ORG];
        button:Show();
    end
    if PortalFrame_Portals[DAVPORTAL_T_TB]~=0 then
        count = count + 1;
        local button = getglobal("PortalFrame_Portal"..count);
        local buttontext = getglobal("PortalFrame_Portal"..count.."Icon");
		button:SetAttribute("type", "spell");
		button:SetAttribute("spell", DAVPORTAL_T_TB);
        buttontext:SetTexture("Interface\\Icons\\Spell_Arcane_TeleportThunderBluff");
        button.SpellID = PortalFrame_Portals[DAVPORTAL_T_TB];
        button:Show();
    end
    if PortalFrame_Portals[DAVPORTAL_T_UC]~=0 then
        count = count + 1;
        local button = getglobal("PortalFrame_Portal"..count);
        local buttontext = getglobal("PortalFrame_Portal"..count.."Icon");
		button:SetAttribute("type", "spell");
		button:SetAttribute("spell", DAVPORTAL_T_UC);
        buttontext:SetTexture("Interface\\Icons\\Spell_Arcane_TeleportUnderCity");
        button.SpellID = PortalFrame_Portals[DAVPORTAL_T_UC];
        button:Show();
    end
    if PortalFrame_Portals[DAVPORTAL_T_SM]~=0 then
        count = count + 1;
        local button = getglobal("PortalFrame_Portal"..count);
        local buttontext = getglobal("PortalFrame_Portal"..count.."Icon");
		button:SetAttribute("type", "spell");
		button:SetAttribute("spell", DAVPORTAL_T_SM);
        buttontext:SetTexture("Interface\\Icons\\Spell_Arcane_TeleportSilvermoon");
        button.SpellID = PortalFrame_Portals[DAVPORTAL_T_SM];
        button:Show();
    end
    if PortalFrame_Portals[DAVPORTAL_T_ST]~=0 then
        count = count + 1;
        local button = getglobal("PortalFrame_Portal"..count);
        local buttontext = getglobal("PortalFrame_Portal"..count.."Icon");
		button:SetAttribute("type", "spell");
		button:SetAttribute("spell", DAVPORTAL_T_ST);
        buttontext:SetTexture("Interface\\Icons\\Spell_Arcane_TeleportStonard");
        button.SpellID = PortalFrame_Portals[DAVPORTAL_T_ST];
        button:Show();
    end
    if PortalFrame_Portals[DAVPORTAL_T_IF]~=0 then
        count = count + 1;
        local button = getglobal("PortalFrame_Portal"..count);
        local buttontext = getglobal("PortalFrame_Portal"..count.."Icon");
		button:SetAttribute("type", "spell");
		button:SetAttribute("spell", DAVPORTAL_T_IF);
        buttontext:SetTexture("Interface\\Icons\\Spell_Arcane_TeleportIronForge");
        button.SpellID = PortalFrame_Portals[DAVPORTAL_T_IF];
        button:Show();
    end
    if PortalFrame_Portals[DAVPORTAL_T_SW]~=0 then
        count = count + 1;
        local button = getglobal("PortalFrame_Portal"..count);
        local buttontext = getglobal("PortalFrame_Portal"..count.."Icon");
		button:SetAttribute("type", "spell");
		button:SetAttribute("spell", DAVPORTAL_T_SW);
        buttontext:SetTexture("Interface\\Icons\\Spell_Arcane_TeleportStormWind");
        button.SpellID = PortalFrame_Portals[DAVPORTAL_T_SW];
        button:Show();
    end
    if PortalFrame_Portals[DAVPORTAL_T_DARN]~=0 then
        count = count + 1;
        local button = getglobal("PortalFrame_Portal"..count);
        local buttontext = getglobal("PortalFrame_Portal"..count.."Icon");
		button:SetAttribute("type", "spell");
		button:SetAttribute("spell", DAVPORTAL_T_DARN);
        buttontext:SetTexture("Interface\\Icons\\Spell_Arcane_TeleportDarnassus");
        button.SpellID = PortalFrame_Portals[DAVPORTAL_T_DARN];
        button:Show();
    end
    if PortalFrame_Portals[DAVPORTAL_T_EX]~=0 then
        count = count + 1;
        local button = getglobal("PortalFrame_Portal"..count);
        local buttontext = getglobal("PortalFrame_Portal"..count.."Icon");
		button:SetAttribute("type", "spell");
		button:SetAttribute("spell", DAVPORTAL_T_EX);
        buttontext:SetTexture("Interface\\Icons\\Spell_Arcane_TeleportExodar");
        button.SpellID = PortalFrame_Portals[DAVPORTAL_T_EX];
        button:Show();
    end
    if PortalFrame_Portals[DAVPORTAL_T_TH]~=0 then
        count = count + 1;
        local button = getglobal("PortalFrame_Portal"..count);
        local buttontext = getglobal("PortalFrame_Portal"..count.."Icon");
		button:SetAttribute("type", "spell");
		button:SetAttribute("spell", DAVPORTAL_T_TH);
        buttontext:SetTexture("Interface\\Icons\\Spell_Arcane_TeleportTheramore");
        button.SpellID = PortalFrame_Portals[DAVPORTAL_T_TH];
        button:Show();
    end
    if PortalFrame_Portals[DAVPORTAL_T_SHAT]~=0 then
        count = count + 1;
        local button = getglobal("PortalFrame_Portal"..count);
        local buttontext = getglobal("PortalFrame_Portal"..count.."Icon");
		button:SetAttribute("type", "spell");
		button:SetAttribute("spell", DAVPORTAL_T_SHAT);
        buttontext:SetTexture("Interface\\Icons\\Spell_Arcane_TeleportShattrath");
        button.SpellID = PortalFrame_Portals[DAVPORTAL_T_SHAT];
        button:Show();
    end
    if PortalFrame_Portals[DAVPORTAL_P_ORG]~=0 then
        count = count + 1;
        local button = getglobal("PortalFrame_Portal"..count);
        local buttontext = getglobal("PortalFrame_Portal"..count.."Icon");
		button:SetAttribute("type", "spell");
		button:SetAttribute("spell", DAVPORTAL_P_ORG);
        buttontext:SetTexture("Interface\\Icons\\Spell_Arcane_PortalOrgrimmar");
        button.SpellID = PortalFrame_Portals[DAVPORTAL_P_ORG];
        button:Show();
    end
    if PortalFrame_Portals[DAVPORTAL_P_TB]~=0 then
        count = count + 1;
        local button = getglobal("PortalFrame_Portal"..count);
        local buttontext = getglobal("PortalFrame_Portal"..count.."Icon");
		button:SetAttribute("type", "spell");
		button:SetAttribute("spell", DAVPORTAL_P_TB);
        buttontext:SetTexture("Interface\\Icons\\Spell_Arcane_PortalThunderBluff");
        button.SpellID = PortalFrame_Portals[DAVPORTAL_P_TB];
        button:Show();
    end
    if PortalFrame_Portals[DAVPORTAL_P_UC]~=0 then
        count = count + 1;
        local button = getglobal("PortalFrame_Portal"..count);
        local buttontext = getglobal("PortalFrame_Portal"..count.."Icon");
		button:SetAttribute("type", "spell");
		button:SetAttribute("spell", DAVPORTAL_P_UC);
        buttontext:SetTexture("Interface\\Icons\\Spell_Arcane_PortalUnderCity");
        button.SpellID = PortalFrame_Portals[DAVPORTAL_P_UC];
        button:Show();
    end
    if PortalFrame_Portals[DAVPORTAL_P_SM]~=0 then
        count = count + 1;
        local button = getglobal("PortalFrame_Portal"..count);
        local buttontext = getglobal("PortalFrame_Portal"..count.."Icon");
		button:SetAttribute("type", "spell");
		button:SetAttribute("spell", DAVPORTAL_P_SM);
        buttontext:SetTexture("Interface\\Icons\\Spell_Arcane_PortalSilvermoon");
        button.SpellID = PortalFrame_Portals[DAVPORTAL_P_SM];
        button:Show();
    end
    if PortalFrame_Portals[DAVPORTAL_P_ST]~=0 then
        count = count + 1;
        local button = getglobal("PortalFrame_Portal"..count);
        local buttontext = getglobal("PortalFrame_Portal"..count.."Icon");
		button:SetAttribute("type", "spell");
		button:SetAttribute("spell", DAVPORTAL_P_ST);
        buttontext:SetTexture("Interface\\Icons\\Spell_Arcane_PortalStondard");
        button.SpellID = PortalFrame_Portals[DAVPORTAL_P_ST];
        button:Show();
    end
    if PortalFrame_Portals[DAVPORTAL_P_IF]~=0 then
        count = count + 1;
        local button = getglobal("PortalFrame_Portal"..count);
        local buttontext = getglobal("PortalFrame_Portal"..count.."Icon");
		button:SetAttribute("type", "spell");
		button:SetAttribute("spell", DAVPORTAL_P_IF);
        buttontext:SetTexture("Interface\\Icons\\Spell_Arcane_PortalIronForge");
        button.SpellID = PortalFrame_Portals[DAVPORTAL_P_IF];
        button:Show();
    end
    if PortalFrame_Portals[DAVPORTAL_P_SW]~=0 then
        count = count + 1;
        local button = getglobal("PortalFrame_Portal"..count);
        local buttontext = getglobal("PortalFrame_Portal"..count.."Icon");
		button:SetAttribute("type", "spell");
		button:SetAttribute("spell", DAVPORTAL_P_SW);
        buttontext:SetTexture("Interface\\Icons\\Spell_Arcane_PortalStormWind");
        button.SpellID = PortalFrame_Portals[DAVPORTAL_P_SW];
        button:Show();
    end
    if PortalFrame_Portals[DAVPORTAL_P_DARN]~=0 then
        count = count + 1;
        local button = getglobal("PortalFrame_Portal"..count);
        local buttontext = getglobal("PortalFrame_Portal"..count.."Icon");
		button:SetAttribute("type", "spell");
		button:SetAttribute("spell", DAVPORTAL_P_DARN);
        buttontext:SetTexture("Interface\\Icons\\Spell_Arcane_PortalDarnassus");
        button.SpellID = PortalFrame_Portals[DAVPORTAL_P_DARN];
        button:Show();
    end
    if PortalFrame_Portals[DAVPORTAL_P_EX]~=0 then
        count = count + 1;
        local button = getglobal("PortalFrame_Portal"..count);
        local buttontext = getglobal("PortalFrame_Portal"..count.."Icon");
		button:SetAttribute("type", "spell");
		button:SetAttribute("spell", DAVPORTAL_P_EX);
        buttontext:SetTexture("Interface\\Icons\\Spell_Arcane_PortalExodar");
        button.SpellID = PortalFrame_Portals[DAVPORTAL_P_EX];
        button:Show();
    end
    if PortalFrame_Portals[DAVPORTAL_P_TH]~=0 then
        count = count + 1;
        local button = getglobal("PortalFrame_Portal"..count);
        local buttontext = getglobal("PortalFrame_Portal"..count.."Icon");
		button:SetAttribute("type", "spell");
		button:SetAttribute("spell", DAVPORTAL_P_TH);
        buttontext:SetTexture("Interface\\Icons\\Spell_Arcane_PortalTheramore");
        button.SpellID = PortalFrame_Portals[DAVPORTAL_P_TH];
        button:Show();
    end
    if PortalFrame_Portals[DAVPORTAL_P_SHAT]~=0 then
        count = count + 1;
        local button = getglobal("PortalFrame_Portal"..count);
        local buttontext = getglobal("PortalFrame_Portal"..count.."Icon");
		button:SetAttribute("type", "spell");
		button:SetAttribute("spell", DAVPORTAL_P_SHAT);
        buttontext:SetTexture("Interface\\Icons\\Spell_Arcane_PortalShattrath");
        button.SpellID = PortalFrame_Portals[DAVPORTAL_P_SHAT];
        button:Show();
    end
    
	-- Hide the buttons we don't need.
	for i = count + 1, PortalFrame_NumPortals, 1 do
		local button = getglobal("PortalFrame_Portal"..i);
		button:Hide();
	end
	
end

function Portal_OnEvent()
    if (event == "VARIABLES_LOADED") then
        if PortalFrameUnlocked==nil then
            PortalFrameUnlocked = true;
        end
		Portal_UpdateLock();
        PortalFrame_Initialize();
		return;
	end
    
    if (event == "SPELLS_CHANGED" or event == "LEARNED_SPELL_IN_TAB") then
		-- When the player learns a new spell, re-initialize the menu's contents.
		PortalFrame_Initialize();
		return;
	end
    
    if (event == "ACTIONBAR_UPDATE_COOLDOWN") then
        for i=1, 5, 1 do
            button=getglobal("PortalFrame_Portal"..i);
            cooldown=getglobal("PortalFrame_Portal"..i.."Cooldown");
            if button.SpellID ~= nil and button.SpellID ~= 0 then
                start, duration = GetSpellCooldown(button.SpellID, BOOKTYPE_SPELL);
                CooldownFrame_SetTimer( cooldown, start, duration, 1);
            end
        end        
    end
end

function PortalButton_OnEnter()
    local spellName, subSpellName = GetSpellName(this.SpellID, SpellBookFrame.bookType);
    GameTooltip:ClearLines();
    GameTooltip:SetOwner(this, "ANCHOR_CURSOR", -(this:GetWidth() / 2), 24);
    GameTooltip:AddLine(spellName);
    if subSpellName~=nil and subSpellName~="" then
        GameTooltip:AddLine(subSpellName);
    end
    GameTooltip:Show();
end

function PortalButton_OnLeave()
    GameTooltip:Hide();
end

function Portal_OnLoad()
    _, class = UnitClass("player");
    if class=="MAGE" then
        this:RegisterEvent("VARIABLES_LOADED");
	    this:RegisterEvent("SPELLS_CHANGED");
	    this:RegisterEvent("LEARNED_SPELL_IN_TAB");
        this:RegisterEvent("ACTIONBAR_UPDATE_COOLDOWN");
    else
        PortalFrame:Hide();
    end
end


