-- Title: Damn Duel Decline!
-- Desc: A simple add-on that blocks duel challenges
-- Author: Mythixus of Malorne
-- Version: 1.3.3

ddd_active = true
ddd_loudmouth = false

local ddd = CreateFrame("Frame")
local rechallenge = {}
local counter = nil

ddd:RegisterEvent("DUEL_REQUESTED")

local function echo(message)
	if DEFAULT_CHAT_FRAME then
		DEFAULT_CHAT_FRAME:AddMessage(message)
	end
end

local function command(subcommand)
	local argument = strlower(subcommand)

	local function active_check()
		if ddd_active then
			return "00ff00Yes"
		else
			return "ff0000No"
		end
	end

	local function loudmouth_check() 
		if ddd_loudmouth then
			return "00ff00On"
		else
			return "ff0000Off"
		end
	end

	if argument == "active" then
		if ddd_active then
			echo("|cffffff7fDamnDuelDecline!:|r Add-on functionality disabled")
			ddd_active = false
		else
			echo("|cffffff7fDamnDuelDecline!:|r Add-on functionality enabled")
			ddd_active = true
		end
	elseif argument == "loudmouth" then
		if ddd_loudmouth then
			echo("|cffffff7fDamnDuelDecline!:|r Block messages and emote disabled")
			ddd_loudmouth = false
		else
			echo("|cffffff7fDamnDuelDecline!:|r Block messages and emote enabled")
			ddd_loudmouth = true
		end
	else
		echo("|cffffff7fDamnDuelDecline!:|r A simple add-on that blocks duel challenges")
		echo("|cffffff7fUsage:|r /ddd {active | loudmouth}")
		echo(" - |cffffff7factive[|cff" .. active_check() .. "|cffffff7f]:|r Toggles add-on functionality on/off")
		echo(" - |cffffff7floudmouth[|cff" .. loudmouth_check() .. "|cffffff7f]:|r Toggles block messages and emote on/off")
	end
end

SlashCmdList["DDD"] = command
SLASH_DDD1 = "/ddd"
SLASH_DDD2 = "/damnduel"
SLASH_DDD3 = "/damndueldecline"

ddd:SetScript("OnEvent", function(self, event, challenger)
	if ddd_active then
		HideUIPanel(StaticPopup1)
		CancelDuel()

		if ddd_loudmouth then
			if not UnitIsEnemy("player", challenger) then
				local message = "Uh-uh-uh!"

				if not rechallenge[challenger] or counter == 5 then
					message = message .. " You didn't say the magic word!"
					counter = 0
				end

				SendChatMessage(message, "SAY")
				-- Use 'SendChatMessage(message, "WHISPER", nil, challenger)' if you wish to send whispers instead of using the SAY channel
			else
				DoEmote("NO", challenger)
			end

			rechallenge[challenger] = true
			counter = counter + 1
		end
	end
end)