DailiesTooltips = AceLibrary("AceAddon-2.0"):new()
local L = AceLibrary("AceLocale-2.2"):new("Dailies")
local Crayon = AceLibrary("LibCrayon-3.0")

-- Reputation Faction Colors
RepFactionColors = {
	[0] = {r = 0.5, g = 0.5, b = 0.5, title = L["Unknown"]}, -- Unknown
	[1] = {r = 0.55, g = 0, b = 0, title = FACTION_STANDING_LABEL1, icon = "Interface\\Icons\\INV_Misc_Bone_HumanSkull_01"}, -- Hated
	[2] = {r = 1, g = 0, b = 0, title = FACTION_STANDING_LABEL2, icon = "Interface\\Icons\\Spell_Shadow_DeathPact"}, -- Hostile
	[3] = {r = 1, g = 0.55, b = 0, title = FACTION_STANDING_LABEL3, icon = "Interface\\Icons\\Spell_BrokenHeart"}, -- Unfriendly
	[4] = {r = 0.75, g = 0.75, b = 0.75, title = FACTION_STANDING_LABEL4, icon = "Interface\\PvPRankBadges\\PvPRank01"}, -- Neutral
	[5] = {r = 1, g = 1, b = 1, title = FACTION_STANDING_LABEL5, icon = "Interface\\PvPRankBadges\\PvPRank06"}, -- Friendly
	[6] = {r = 0, g = 1, b = 0, title = FACTION_STANDING_LABEL6, icon = "Interface\\PvPRankBadges\\PvPRank10"}, -- Honored
	[7] = {r = 0.25, g = 0.4, b = 0.9, title = FACTION_STANDING_LABEL7, icon = "Interface\\PvPRankBadges\\PvPRank12"}, -- Revered
	[8] = {r = 0.6, g = 0.2, b = 0.8, title = FACTION_STANDING_LABEL8, icon = "Interface\\PvPRankBadges\\PvPRank15"}, -- Exalted
}

function DailiesTooltips:BuildTooltips()	
	-- The Burning Crusade and Wrath of the Lich King Tooltip
	ExpansionsFrame = CreateFrame ("Frame", "ExpansionsFrameTooltip", UIParent)
	ExpansionsFrame:ClearAllPoints()
	ExpansionsFrame:SetFrameStrata("TOOLTIP")
	ExpansionsFrame:SetHeight (120)
	ExpansionsFrame:SetWidth (265)
	ExpansionsFrame:SetPoint ("BOTTOMRIGHT", GameTooltip, "BOTTOMRIGHT", 0, 0)
	
	ExpansionsFrame:SetBackdrop({
		bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", 
		edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border", 
		tile = true, tileSize = 16, edgeSize = 16, 
		insets = { left = 3, right = 3, top = 3, bottom = 3 }
	})
	ExpansionsFrame:SetBackdropColor(.09, .09, .19)

	ExpansionsTitle = ExpansionsFrame:CreateFontString()
	ExpansionsTitle:SetPoint ('TOPLEFT', ExpansionsFrame, 'TOPLEFT', 11, -11)
	ExpansionsTitle:SetFontObject(GameTooltipHeaderText)
	ExpansionsTitle:SetText(Crayon:White("Expansions"))
	
	ExpansionsTitleSub = ExpansionsFrame:CreateFontString()
	ExpansionsTitleSub:SetWidth (250)
	ExpansionsTitleSub:SetPoint ('TOPLEFT', ExpansionsTitle, 'TOPLEFT', 0, -(ExpansionsTitle:GetHeight()))
	ExpansionsTitleSub:SetFontObject(GameTooltipText)
	ExpansionsTitleSub:SetText(Crayon:Gold("Lets you choose which dailies to display from the following World of Warcraft expansions:"))
	
	ExpansionsFrameBackdropTBC = ExpansionsFrame:CreateTexture("TBCBackDrop", "BACKGROUND")
	ExpansionsFrameBackdropTBC:SetPoint('TOPLEFT', ExpansionsFrame, 'TOPLEFT', 0, -(ExpansionsTitle:GetHeight() + ExpansionsTitleSub:GetHeight() + 5))
	ExpansionsFrameBackdropTBC:SetTexture("Interface\\QuestFrame\\UI-QuestItemNameFrame")
	
	ExpansionsFrameBackdropWotLK = ExpansionsFrame:CreateTexture("WotLKBackDrop")
	ExpansionsFrameBackdropWotLK:SetPoint('TOPRIGHT', ExpansionsFrame, 'TOPRIGHT', 0, -(ExpansionsTitle:GetHeight() + ExpansionsTitleSub:GetHeight() + 5))
	ExpansionsFrameBackdropWotLK:SetTexture("Interface\\QuestFrame\\UI-QuestItemNameFrame")

	ExpansionsFrameTBC = ExpansionsFrame:CreateTexture("TBCIcon", "ARTWORK")
	ExpansionsFrameTBC:SetHeight(36)
	ExpansionsFrameTBC:SetWidth(36)
	ExpansionsFrameTBC:SetPoint('TOPLEFT', ExpansionsFrameBackdropTBC, 'TOPLEFT', 13, -14)	
	ExpansionsFrameTBC:SetTexture("Interface\\Addons\\DailiesQuestTracker\\Icons\\TBC.tga")
	
	ExpansionsFrameTBCOFF = ExpansionsFrame:CreateTexture("TBCPassIcon", "OVERLAY")
	ExpansionsFrameTBCOFF:SetHeight(36)
	ExpansionsFrameTBCOFF:SetWidth(36)
	ExpansionsFrameTBCOFF:SetPoint('CENTER', ExpansionsFrameTBC, 'CENTER')	
	ExpansionsFrameTBCOFF:SetTexture("Interface\\Buttons\\UI-GroupLoot-Pass-Up")	
	
	ExpansionsFrameWotLK = ExpansionsFrame:CreateTexture("WotLKIcon", "ARTWORK")
	ExpansionsFrameWotLK:SetHeight(36)
	ExpansionsFrameWotLK:SetWidth(36)
	ExpansionsFrameWotLK:SetPoint('TOPLEFT', ExpansionsFrameBackdropWotLK, 'TOPLEFT', 13, -14)	
	ExpansionsFrameWotLK:SetTexture("Interface\\Addons\\DailiesQuestTracker\\Icons\\WotLK.tga")

	ExpansionsFrameWotLKOFF = ExpansionsFrame:CreateTexture("WotLKPassIcon", "OVERLAY")
	ExpansionsFrameWotLKOFF:SetHeight(36)
	ExpansionsFrameWotLKOFF:SetWidth(36)
	ExpansionsFrameWotLKOFF:SetPoint('CENTER', ExpansionsFrameWotLK, 'CENTER')	
	ExpansionsFrameWotLKOFF:SetTexture("Interface\\Buttons\\UI-GroupLoot-Pass-Up")	

	ExpansionsTitleTBC = ExpansionsFrame:CreateFontString()
	ExpansionsTitleTBC:SetWidth (65)
	ExpansionsTitleTBC:SetHeight (36)
	ExpansionsTitleTBC:SetPoint ('TOPLEFT', ExpansionsFrameTBC, 'TOPLEFT', 37, 2)
	ExpansionsTitleTBC:SetFontObject(GameFontNormal)
	ExpansionsTitleTBC:SetText(Crayon:Green("The Burning Crusade"))
	ExpansionsTitleTBC:SetJustifyV("CENTER")
	ExpansionsTitleTBC:SetJustifyH("CENTER")
	
	ExpansionsTitleWotLK = ExpansionsFrame:CreateFontString()
	ExpansionsTitleWotLK:SetWidth (65)
	ExpansionsTitleWotLK:SetHeight (36)
	ExpansionsTitleWotLK:SetPoint ('TOPLEFT', ExpansionsFrameWotLK, 'TOPLEFT', 37, 2)
	ExpansionsTitleWotLK:SetFontObject(GameFontNormal)
	ExpansionsTitleWotLK:SetText(Crayon:Blue("Wrath of the Lich King"))
	ExpansionsTitleWotLK:SetJustifyV("CENTER")
	ExpansionsTitleWotLK:SetJustifyH("CENTER")
	
	ExpansionsFrame:SetHeight (ExpansionsTitleTBC:GetHeight() + ExpansionsTitleSub:GetHeight() + ExpansionsTitleTBC:GetHeight() + 10)
	
	-- Faction Icons Frame
	IconFrame = CreateFrame("Frame", "IconFrameTooltip", UIParent)
	IconFrame:ClearAllPoints()
	IconFrame:SetFrameStrata("TOOLTIP")
	IconFrame:SetHeight (132)
	IconFrame:SetWidth (277)
	IconFrame:SetPoint("BOTTOMRIGHT", GameTooltip, "BOTTOMRIGHT", 0, 0)
	
	IconFrame:SetBackdrop({
		bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", 
		edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border", 
		tile = true, tileSize = 16, edgeSize = 16, 
		insets = { left = 3, right = 3, top = 3, bottom = 3 }
	})
	IconFrame:SetBackdropColor(.09, .09, .19)

	IconFrameTitle = IconFrame:CreateFontString("TitleText", "OVERLAY")
	IconFrameTitle:SetPoint ('TOPLEFT', IconFrame, 'TOPLEFT', 11, -11)
	IconFrameTitle:SetFontObject(GameTooltipHeaderText)
	IconFrameTitle:SetText(Crayon:White("Icon"))
	
	IconFrameTitleSub = IconFrame:CreateFontString("SubTitleText", "OVERLAY")
	IconFrameTitleSub:SetWidth (250)
	IconFrameTitleSub:SetPoint ('TOPLEFT', IconFrameTitle, 'TOPLEFT', 0, -(IconFrameTitle:GetHeight()))
	IconFrameTitleSub:SetFontObject(GameTooltipText)
	IconFrameTitleSub:SetText(Crayon:Gold("Sets the group faction status with Icons.\nIcons displayed with the respective levels of faction:"))
	
	-- Neutral Icon Display
	IconFrameBackdropNeutral = IconFrame:CreateTexture("NeutralBackDrop", "BACKGROUND")
	IconFrameBackdropNeutral:SetPoint('TOPLEFT', IconFrame, 'TOPLEFT', 3, -(IconFrameTitle:GetHeight() + IconFrameTitleSub:GetHeight() + 5))
	IconFrameBackdropNeutral:SetTexture("Interface\\QuestFrame\\UI-QuestItemNameFrame")
	IconFrameBackdropNeutral:SetWidth(100)
	IconFrameBackdropNeutral:SetHeight(50)

	IconFrameNeutral = IconFrame:CreateTexture("NeutralIcon", "ARTWORK")
	IconFrameNeutral:SetHeight(24)
	IconFrameNeutral:SetWidth(24)
	IconFrameNeutral:SetPoint('TOPLEFT', IconFrameBackdropNeutral, 'TOPLEFT', 10, -14)	
	IconFrameNeutral:SetTexture(RepFactionColors[4].icon)

	local NeutralIconColorized = Crayon:Colorize(RGBPercToHex(RepFactionColors[4].r,
														RepFactionColors[4].g,
														RepFactionColors[4].b ),
														RepFactionColors[4].title)
														
	IconFrameTitleNeutral = IconFrame:CreateFontString("NeutralText", "OVERLAY")
	IconFrameTitleNeutral:SetWidth (85)
	IconFrameTitleNeutral:SetHeight (24)
	IconFrameTitleNeutral:SetPoint ('TOPLEFT', IconFrameNeutral, 'TOPLEFT', 8, 0)
	IconFrameTitleNeutral:SetFontObject(GameFontNormal)
	IconFrameTitleNeutral:SetText(NeutralIconColorized)
	
	-- Friendly Icon Display
	IconFrameBackdropFriendly = IconFrame:CreateTexture("FriendlyBackDrop", "BACKGROUND")
	IconFrameBackdropFriendly:SetPoint('LEFT', IconFrameBackdropNeutral, 'RIGHT', -15, 0)
	IconFrameBackdropFriendly:SetTexture("Interface\\QuestFrame\\UI-QuestItemNameFrame")
	IconFrameBackdropFriendly:SetWidth(100)
	IconFrameBackdropFriendly:SetHeight(50)

	IconFrameFriendly = IconFrame:CreateTexture("FriendlyIcon", "ARTWORK")
	IconFrameFriendly:SetHeight(24)
	IconFrameFriendly:SetWidth(24)
	IconFrameFriendly:SetPoint('TOPLEFT', IconFrameBackdropFriendly, 'TOPLEFT', 10, -14)	
	IconFrameFriendly:SetTexture(RepFactionColors[5].icon)
	
	local FriendlyIconColorized = Crayon:Colorize(RGBPercToHex(RepFactionColors[5].r,
														RepFactionColors[5].g,
														RepFactionColors[5].b ),
														RepFactionColors[5].title)
														
	IconFrameTitleFriendly = IconFrame:CreateFontString("FriendlyText", "OVERLAY")
	IconFrameTitleFriendly:SetWidth (85)
	IconFrameTitleFriendly:SetHeight (24)
	IconFrameTitleFriendly:SetPoint ('TOPLEFT', IconFrameFriendly, 'TOPLEFT', 8, 0)
	IconFrameTitleFriendly:SetFontObject(GameFontNormal)
	IconFrameTitleFriendly:SetText(FriendlyIconColorized)		

	-- Honored Icon Display
	IconFrameBackdropHonored = IconFrame:CreateTexture("HonoredBackDrop", "BACKGROUND")
	IconFrameBackdropHonored:SetPoint('LEFT', IconFrameBackdropFriendly, 'RIGHT', -15, 0)
	IconFrameBackdropHonored:SetTexture("Interface\\QuestFrame\\UI-QuestItemNameFrame")
	IconFrameBackdropHonored:SetWidth(100)
	IconFrameBackdropHonored:SetHeight(50)

	IconFrameHonored = IconFrame:CreateTexture("HonoredIcon", "ARTWORK")
	IconFrameHonored:SetHeight(24)
	IconFrameHonored:SetWidth(24)
	IconFrameHonored:SetPoint('TOPLEFT', IconFrameBackdropHonored, 'TOPLEFT', 10, -14)	
	IconFrameHonored:SetTexture(RepFactionColors[6].icon)

	local HonorIconColorized = Crayon:Colorize(RGBPercToHex(RepFactionColors[6].r,
														RepFactionColors[6].g,
														RepFactionColors[6].b ),
														RepFactionColors[6].title)
														
	IconFrameTitleHonored = IconFrame:CreateFontString("HonoredText", "OVERLAY")
	IconFrameTitleHonored:SetWidth (85)
	IconFrameTitleHonored:SetHeight (24)
	IconFrameTitleHonored:SetPoint ('TOPLEFT', IconFrameHonored, 'TOPLEFT', 8, 0)
	IconFrameTitleHonored:SetFontObject(GameFontNormal)
	IconFrameTitleHonored:SetText(HonorIconColorized)

	-- Revered Icon Display
	IconFrameBackdropRevered = IconFrame:CreateTexture("ReveredBackDrop", "BACKGROUND")
	IconFrameBackdropRevered:SetPoint('TOPLEFT', IconFrameBackdropNeutral, 'TOPLEFT', 45, -35)
	IconFrameBackdropRevered:SetTexture("Interface\\QuestFrame\\UI-QuestItemNameFrame")	
	IconFrameBackdropRevered:SetWidth(100)
	IconFrameBackdropRevered:SetHeight(50)
	
	IconFrameRevered = IconFrame:CreateTexture("ReveredIcon", "ARTWORK")
	IconFrameRevered:SetHeight(24)
	IconFrameRevered:SetWidth(24)
	IconFrameRevered:SetPoint('TOPLEFT', IconFrameBackdropRevered, 'TOPLEFT', 10, -14)	
	IconFrameRevered:SetTexture(RepFactionColors[7].icon)	
	
	local ReveredIconColorized = Crayon:Colorize(RGBPercToHex(RepFactionColors[7].r,
														RepFactionColors[7].g,
														RepFactionColors[7].b ),
														RepFactionColors[7].title)
														
	IconFrameTitleRevered = IconFrame:CreateFontString("ReveredText", "OVERLAY")
	IconFrameTitleRevered:SetWidth (85)
	IconFrameTitleRevered:SetHeight (24)
	IconFrameTitleRevered:SetPoint ('TOPLEFT', IconFrameRevered, 'TOPLEFT', 8, 0)
	IconFrameTitleRevered:SetFontObject(GameFontNormal)
	IconFrameTitleRevered:SetText(ReveredIconColorized)
	
	-- Exalted Icon Display
	IconFrameBackdropExalted = IconFrame:CreateTexture("ExaltedBackDrop", "BACKGROUND")
	IconFrameBackdropExalted:SetPoint('LEFT', IconFrameBackdropRevered, 'RIGHT', -15, 0)
	IconFrameBackdropExalted:SetTexture("Interface\\QuestFrame\\UI-QuestItemNameFrame")	
	IconFrameBackdropExalted:SetWidth(100)
	IconFrameBackdropExalted:SetHeight(50)
	
	IconFrameExalted = IconFrame:CreateTexture("ExaltedIcon", "ARTWORK")
	IconFrameExalted:SetHeight(24)
	IconFrameExalted:SetWidth(24)
	IconFrameExalted:SetPoint('TOPLEFT', IconFrameBackdropExalted, 'TOPLEFT', 10, -14)	
	IconFrameExalted:SetTexture(RepFactionColors[8].icon)	
	
	local ExaltedIconColorized = Crayon:Colorize(RGBPercToHex(RepFactionColors[8].r,
														RepFactionColors[8].g,
														RepFactionColors[8].b ),
														RepFactionColors[8].title)
														
	IconFrameTitleExalted = IconFrame:CreateFontString("ExaltedText", "OVERLAY")
	IconFrameTitleExalted:SetWidth (85)
	IconFrameTitleExalted:SetHeight (24)
	IconFrameTitleExalted:SetPoint ('TOPLEFT', IconFrameExalted, 'TOPLEFT', 8, 0)
	IconFrameTitleExalted:SetFontObject(GameFontNormal)
	IconFrameTitleExalted:SetText(ExaltedIconColorized)	

	IconFrame:SetHeight ((IconFrameTitle:GetHeight() + IconFrameTitleSub:GetHeight()) + (IconFrameBackdropHonored:GetHeight() * 2) - 5)
	
	ExpansionsFrameTBCOFF:Hide()	
	ExpansionsFrameWotLKOFF:Hide()
	
	local _, _, _, ver = GetBuildInfo()
	if ver >= 30000 then
		WotLKExpansion = true
	end
	
	if ver >= 20000 and ver <= 30000 then
		TBCExpansion = true
	end

	if WotLKExpansion ~= true then
		ExpansionsFrameWotLKOFF:Show()
	end

	if TBCExpansion ~= true then
		ExpansionsFrameTBCOFF:Show()
	end		

	IconFrame:Hide()
	ExpansionsFrame:Hide()
end