﻿local L = AceLibrary("AceLocale-2.2"):new("Dailies")
local BZ = AceLibrary("LibBabble-Zone-3.0"):GetLookupTable()
local BF = AceLibrary("LibBabble-Faction-3.0"):GetLookupTable()

DailesDATE = "%A:%B:%d:%Y"
if type(DailesDATE) == "string" then
	Calendar = {
		January = {month = CALENDAR_MONTH_JANUARY, no = 01},
		February = {month = CALENDAR_MONTH_FEBRUARY, no = 02},
		March = {month = CALENDAR_MONTH_MARCH, no = 03},
		April = {month = CALENDAR_MONTH_APRIL, no = 04},
		May = {month = CALENDAR_MONTH_MAY, no = 05},
		June = {month = CALENDAR_MONTH_JUNE, no = 06},
		July = {month = CALENDAR_MONTH_JULY, no = 07},
		August = {month = CALENDAR_MONTH_AUGUST, no = 08},
		September = {month = CALENDAR_MONTH_SEPTEMBER, no = 09},
		October = {month = CALENDAR_MONTH_OCTOBER, no = 10},
		November = {month = CALENDAR_MONTH_NOVEMBER, no = 11},
		December = {month = CALENDAR_MONTH_DECEMBER, no = 12},
		
		Sunday = CALENDAR_WEEKDAY_SUNDAY,
		Monday = CALENDAR_WEEKDAY_MONDAY,
		Tuesday = CALENDAR_WEEKDAY_TUESDAY,
		Wednesday = CALENDAR_WEEKDAY_WEDNESDAY,
		Thursday = CALENDAR_WEEKDAY_THURSDAY,
		Friday = CALENDAR_WEEKDAY_FRIDAY,
		Saturday = CALENDAR_WEEKDAY_SATURDAY
		}
		
	local A,B,d,Y = (":"):split(date(DailesDATE))
	if GetLocale() == "zhCN" then
		DailesDATE = Y .. "年, " .. Calendar[B].month .." " .. d .. "日, " ..Calendar[A]
	else
		DailesDATE = Calendar[A] ..", ".. Calendar[B].month .. " " .. d ..", " ..Y
	end
	
	DailiesNumberDate = Calendar[B].no .. ":" .. d
else
	DailesDATE = DATE()
end

hasHerbalism = nil; hasMining = nil; hasSkinning = nil;
SkyguardValue = 0; NetherwingValue = 0; CookingValue = 0; OgrilaValue = 0; BGPvPValue = 0; FishingValue = 0; WorldPvPCounter = 0; HolidayCounter = 0
DInstanceValue = 0; HInstanceValue = 0; HolidayValue = 0; SSOValue = 0; WorldPvPValue = 0; SSOCounter = 0; TradeskillCounter = 0; ReputationCounter = nil

DailyQuestsList = {
	-- Dungeon Instances
	[L["Wanted: Tempest-Forge Destroyers"]] = {icon = "Interface\\Addons\\DailiesQuestTracker\\Icons\\Destroyer.tga", link = "|cffffff00|Hquest:11387:70|h[Wanted: Tempest-Forge Destroyers]|h|r", coords ="75:37", qgiver = "Nether-Stalker Mah'dunn", qzone = "Shattrath City", qszone = "Lower City", loc = BZ["The Mechanar"], area = BZ["The Mechanar"], group = "DInstance", SID = "None:0", ["rep"] = {BF["The Sha'tar"]..":250", BF["The Consortium"]..":250"}, ["rewards"] = {"29460:1"}, gold = 163900}, --The Mechanar
	[L["Wanted: Arcatraz Sentinels"]] = {icon = "Interface\\Addons\\DailiesQuestTracker\\Icons\\Sentinel.tga", link = "|cffffff00|Hquest:11389:70|h[Wanted: Arcatraz Sentinels]|h|r", coords ="75:37", qgiver = "Nether-Stalker Mah'dunn", qzone = "Shattrath City", qszone = "Lower City", loc = BZ["The Arcatraz"], area = BZ["The Arcatraz"], group = "DInstance", SID = "None:0", ["rep"] = {BF["The Sha'tar"]..":250", BF["The Consortium"]..":250"}, ["rewards"] = {"29460:1"}, gold = 163900}, --Arcatraz
	[L["Wanted: Coilfang Myrmidons"]] = {icon = "Interface\\Addons\\DailiesQuestTracker\\Icons\\Myrmidon.tga", link = "|cffffff00|Hquest:11371:70|h[Wanted: Coilfang Myrmidons]|h|r", coords ="75:37", qgiver = "Nether-Stalker Mah'dunn", qzone = "Shattrath City", qszone = "Lower City", loc = BZ["The Steamvault"], area = BZ["The Steamvault"], group = "DInstance", SID = "None:0", ["rep"] = {BF["Cenarion Expedition"]..":250", BF["The Consortium"]..":250"}, ["rewards"] = {"29460:1"}, gold = 163900}, --Steamvault
	[L["Wanted: Rift Lords"]] = {icon = "Interface\\Addons\\DailiesQuestTracker\\Icons\\Rift.tga", link = "|cffffff00|Hquest:11383:70|h[Wanted: Rift Lords]|h|r", coords ="75:37", qgiver = "Nether-Stalker Mah'dunn", qzone = "Shattrath City", qszone = "Lower City", loc = BZ["The Black Morass"], area = BZ["The Black Morass"], group = "DInstance", SID = "None:0", ["rep"] = {BF["Keepers of Time"]..":250", BF["The Consortium"]..":250"}, ["rewards"] = {"29460:1"}, gold = 163900}, --Black Morass
	[L["Wanted: Malicious Instructors"]] = {icon = "Interface\\Addons\\DailiesQuestTracker\\Icons\\Instructor.tga", link = "|cffffff00|Hquest:11376:70|h[Wanted: Malicious Instructors]|h|r", coords ="75:37", qgiver = "Nether-Stalker Mah'dunn", qzone = "Shattrath City", qszone = "Lower City", loc = BZ["Shadow Labyrinth"], area = BZ["Shadow Labyrinth"], group = "DInstance", SID = "None:0", ["rep"] = {BF["Lower City"]..":250", BF["The Consortium"]..":250"}, ["rewards"] = {"29460:1"}, gold = 163900}, --Shadow Labyrinth
	[L["Wanted: Sunseeker Channelers"]] = {icon = "Interface\\Addons\\DailiesQuestTracker\\Icons\\Instructor.tga", link = "|cffffff00|Hquest:11385:70|h[Wanted: Sunseeker Channelers]|h|r", coords ="75:37", qgiver = "Nether-Stalker Mah'dunn", qzone = "Shattrath City", qszone = "Lower City", loc = BZ["The Botanica"], area = BZ["The Botanica"], group = "DInstance", SID = "None:0", ["rep"] = {BF["The Sha'tar"]..":250", BF["The Consortium"]..":250"}, ["rewards"] = {"29460:1"}, gold = 163900}, --Botanica

	-- Heroic Instances
	[L["Wanted: Pathaleon's Projector"]] = {icon = "Interface\\Icons\\INV_Misc_EngGizmos_08", link = "|cffffff00|Hquest:11386:70|h[Wanted: Pathaleon's Projector]|h|r", coords ="75:37", qgiver = "Wind Trader Zhareem", qzone = "Shattrath City", qszone = "Lower City", loc = BZ["The Mechanar"], area = BZ["The Mechanar"], group = "HInstance", SID = "The Sha'tar:6", ["rep"] = {BF["The Sha'tar"]..":350", BF["The Consortium"]..":350"}, ["rewards"] = {"29434:2"}, gold = 246000}, -- Mechnar
	[L["Wanted: The Heart of Quagmirran"]] = {icon = "Interface\\Icons\\INV_Misc_Organ_02", link = "|cffffff00|Hquest:11368:70|h[Wanted: The Heart of Quagmirran]|h|r", coords ="75:37", qgiver = "Wind Trader Zhareem", qzone = "Shattrath City", qszone = "Lower City", loc = BZ["The Slave Pens"], area = BZ["The Slave Pens"], group = "HInstance", SID = "Cenarion Expedition:6", ["rep"] = {BF["Cenarion Expedition"]..":350", BF["The Consortium"]..":350"}, ["rewards"] = {"29434:2"}, gold = 246000}, -- Slave Pens
	[L["Wanted: A Black Stalker Egg"]] = {icon = "Interface\\Icons\\INV_Misc_ShadowEgg", link = "|cffffff00|Hquest:11369:70|h[Wanted: A Black Stalker Egg]|h|r", coords ="75:37", qgiver = "Wind Trader Zhareem", qzone = "Shattrath City", qszone = "Lower City", loc = BZ["The Underbog"], area = BZ["The Underbog"], group = "HInstance", SID = "Cenarion Expedition:6", ["rep"] = {BF["Cenarion Expedition"]..":350", BF["The Consortium"]..":350"}, ["rewards"] = {"29434:2"}, gold = 246000}, --Underbog
	[L["Wanted: The Epoch Hunter's Head"]] = {icon = "Interface\\Icons\\INV_Misc_Head_Dragon_Black", link = "|cffffff00|Hquest:11378:70|h[Wanted: The Epoch Hunter's Head]|h|r", coords ="75:37", qgiver = "Wind Trader Zhareem", qzone = "Shattrath City", qszone = "Lower City", loc = BZ["Old Hillsbrad Foothills"],  area = BZ["Old Hillsbrad Foothills"], group = "HInstance", SID = "Keepers of Time:6", ["rep"] = {BF["Keepers of Time"]..":350", BF["The Consortium"]..":350"}, ["rewards"] = {"29434:2"}, gold = 246000}, --Durnholde
	[L["Wanted: Shaffar's Wondrous Pendant"]] = {icon = "Interface\\Icons\\INV_Jewelry_Amulet_07", link = "|cffffff00|Hquest:11373:70|h[Wanted: Shaffar's Wondrous Pendant]|h|r", coords ="75:37", qgiver = "Wind Trader Zhareem", qzone = "Shattrath City", qszone = "Lower City", loc = BZ["Mana-Tombs"],  area = BZ["Mana-Tombs"], group = "HInstance", SID = "Lower City:6", ["rep"] = {BF["Lower City"]..":350", BF["The Consortium"]..":350"}, ["rewards"] = {"29434:2"}, gold = 246000}, --Mana Tombs
	[L["Wanted: The Headfeathers of Ikiss"]] = {icon = "Interface\\Icons\\INV_Feather_06", link = "|cffffff00|Hquest:11372:70|h[Wanted: The Headfeathers of Ikiss]|h|r", coords ="75:37", qgiver = "Wind Trader Zhareem", qzone = "Shattrath City", qszone = "Lower City", loc = BZ["Sethekk Halls"], area = BZ["Sethekk Halls"],  group = "HInstance", SID = "Lower City:6", ["rep"] = {BF["Lower City"]..":350", BF["The Consortium"]..":350"}, ["rewards"] = {"29434:2"}, gold = 246000}, -- Sethekk Halls	
	[L["Wanted: Murmur's Whisper"]] = {icon = "Interface\\Icons\\INV_Elemental_Mote_Air01", link = "|cffffff00|Hquest:11375:70|h[Wanted: Murmur's Whisper]|h|r", coords ="75:37", qgiver = "Wind Trader Zhareem", qzone = "Shattrath City", qszone = "Lower City", loc = BZ["Shadow Labyrinth"], area = BZ["Shadow Labyrinth"], group = "HInstance", SID = "Lower City:6", ["rep"] = {BF["Lower City"]..":350", BF["The Consortium"]..":350"}, ["rewards"] = {"29434:2"}, gold = 246000}, --Shadow Labs
	[L["Wanted: The Scroll of Skyriss"]] = {icon = "Interface\\Icons\\INV_Misc_SymbolofKings_01", link = "|cffffff00|Hquest:11388:70|h[Wanted: The Scroll of Skyriss]|h|r", coords ="75:37", qgiver = "Wind Trader Zhareem", qzone = "Shattrath City", qszone = "Lower City", loc = BZ["The Arcatraz"], area = BZ["The Arcatraz"], group = "HInstance", SID = "The Sha'tar:6", ["rep"] = {BF["The Sha'tar"]..":350", BF["The Consortium"]..":350"}, ["rewards"] = {"29434:2"}, gold = 246000}, -- Arcatraz
	[L["Wanted: The Exarch's Soul Gem"]] = {icon = "Interface\\Icons\\INV_Misc_Gem_Pearl_07", link = "|cffffff00|Hquest:11374:70|h[Wanted: The Exarch's Soul Gem]|h|r", coords ="75:37", qgiver = "Wind Trader Zhareem", qzone = "Shattrath City", qszone = "Lower City", loc = BZ["Auchenai Crypts"], area = BZ["Auchenai Crypts"],  group = "HInstance", SID = "Lower City:6", ["rep"] = {BF["Lower City"]..":350", BF["The Consortium"]..":350"}, ["rewards"] = {"29434:2"}, gold = 246000}, -- Auchenai Crypt
	[L["Wanted: Aeonus's Hourglass"]] = {icon = "Interface\\Icons\\INV_Gizmo_KhoriumPowerCore", link = "|cffffff00|Hquest:11382:70|h[Wanted: Aeonus's Hourglass]|h|r", coords ="75:37", qgiver = "Wind Trader Zhareem", qzone = "Shattrath City", qszone = "Lower City", loc = BZ["The Black Morass"], area = BZ["The Black Morass"], group = "HInstance", SID = "Keepers of Time:6", ["rep"] = {BF["Keepers of Time"]..":350", BF["The Consortium"]..":350"}, ["rewards"] = {"29434:2"}, gold = 246000}, -- Black Morasses
	[L["Wanted: A Warp Splinter Clipping"]] = {icon = "Interface\\Icons\\INV_Misc_Branch_01", link = "|cffffff00|Hquest:11384:70|h[Wanted: A Warp Splinter Clipping]|h|r", coords ="75:37", qgiver = "Wind Trader Zhareem", qzone = "Shattrath City", qszone = "Lower City", loc = BZ["The Botanica"], area = BZ["The Botanica"], group = "HInstance", SID = "The Sha'tar:6", ["rep"] = {BF["The Sha'tar"]..":350", BF["The Consortium"]..":350"}, ["rewards"] = {"29434:2"}, gold = 246000}, --Botanica
	[L["Wanted: The Warlord's Treatise"]] = {icon = "Interface\\Icons\\INV_Misc_Book_05", link = "|cffffff00|Hquest:11370:70|h[Wanted: The Warlord's Treatise]|h|r", coords ="75:37", qgiver = "Wind Trader Zhareem", qzone = "Shattrath City", qszone = "Lower City", loc = BZ["The Steamvault"], area = BZ["The Steamvault"], group = "HInstance", SID = "Cenarion Expedition:6", ["rep"] = {BF["Cenarion Expedition"]..":350", BF["The Consortium"]..":350"}, ["rewards"] = {"29434:2"}, gold = 246000}, --Steam Vault
	
	-- Cooking
	[L["Revenge is Tasty"]] = {icon = "Interface\\Icons\\INV_Misc_Food_46", link = "|cffffff00|Hquest:11377:70|h[Revenge is Tasty]|h|r", coords ="62:16", qgiver = "The Rokk", qzone = "Shattrath City", qszone = "Lower City", area = BZ["Terokkar Forest"], group = "Cooking", SID = "None:0", ["rewards"] = {"33844:1", "33857:1"}, gold = 75900},
	[L["Manalicious"]] = {icon = "Interface\\Icons\\INV_Misc_Food_58", link = "|cffffff00|Hquest:11380:70|h[Manalicious]|h|r", coords ="62:16", qgiver = "The Rokk", qzone = "Shattrath City", qszone = "Lower City", area = BZ["Netherstorm"], subarea = "", group = "Cooking", SID = "None:0", ["rewards"] = {"33844:1", "33857:1"}, gold = 75900},
	[L["Soup for the Soul"]] = {icon = "Interface\\Icons\\INV_Misc_Food_64", link = "|cffffff00|Hquest:11381:70|h[Soup for the Soul]|h|r", coords ="62:16", qgiver = "The Rokk", qzone = "Shattrath City", qszone = "Lower City", area = BZ["Nagrand"], group = "Cooking", SID = "None:0", ["rewards"] = {"33844:1", "33857:1"}, gold = 75900},
	[L["Super Hot Stew"]] = {icon = "Interface\\Icons\\INV_Misc_Food_48", link = "|cffffff00|Hquest:11379:70|h[Super Hot Stew]|h|r", coords ="62:16", qgiver = "The Rokk", qzone = "Shattrath City", qszone = "Lower City", area = BZ["Blade's Edge Mountains"], group = "Cooking", SID = "None:0", ["rewards"] = {"33844:1", "33857:1"}, gold = 75900},
	
	-- Sha'tari Skyguard
	[L["Wrangle More Aether Rays!"]] = {icon = "Interface\\Icons\\INV_Misc_Noose_01", link = "|cffffff00|Hquest:11066:70|h[Wrangle More Aether Rays!]|h|r", coords ="28:51", qgiver = "Skyguard Khatie", qzone = "Blade's Edge Mountains", qszone = "Skyguard Outpost", area = BZ["Blade's Edge Mountains"], group = "Sha'tari Skyguard", SID = "Sha'tari Skyguard:4", ["rep"] = {BF["Ogri'la"]..":350", BF["Sha'tari Skyguard"]..":350"}, ["rewards"] = {"32569:15"}, gold = 119900},
	[L["Fires Over Skettis"]] = {icon = "Interface\\Icons\\INV_Misc_Bomb_07", link = "|cffffff00|Hquest:11008:70|h[Fires Over Skettis]|h|r", coords ="65:67", qgiver = "Sky Sergeant Doryn", qzone = "Terokkar Forest", qszone = "Blackwind Landing", area = BZ["Terokkar Forest"], group = "Sha'tari Skyguard", SID = "Sha'tari Skyguard:4", ["rep"] = {BF["Sha'tari Skyguard"]..":350"}, gold = 119900},
	[L["Escape from Skettis"]] = {icon = "Interface\\Addons\\DailiesQuestTracker\\Icons\\ES.tga", link = "|cffffff00|Hquest:11085:70|h[Escape from Skettis]|h|r", coords ="0:0", qgiver = "Skyguard Prisoner", qzone = "Terokkar Forest", qszone = "Skettis", area = BZ["Terokkar Forest"], group = "Sha'tari Skyguard", SID = "Sha'tari Skyguard:4", ["rep"] = {BF["Sha'tari Skyguard"]..":350"}, gold = 91000},
	[L["Bomb Them Again!"]] = {icon = "Interface\\Icons\\INV_Misc_Bomb_04", link = "|cffffff00|Hquest:11023:70|h[Bomb Them Again!]|h|r", coords ="28:53", qgiver = "Sky Sergeant Vanderclip", qzone = "Blade's Edge Mountains", qszone = "Skyguard Outpost", area = BZ["Blade's Edge Mountains"], group = "Sha'tari Skyguard", SID = "Sha'tari Skyguard:4", ["rep"] = {BF["Ogri'la"]..":500", BF["Sha'tari Skyguard"]..":500"}, ["rewards"] = {"32569:15"}, gold = 119900},
	
	-- Ogri'la
	[L["The Relic's Emanation"]] = {icon = "Interface\\Icons\\INV_Misc_Apexis_Shard", link = "|cffffff00|Hquest:11080:70|h[The Relic's Emanation]|h|r", coords ="29:57", qgiver = "Chu'a'lor", qzone = "Blade's Edge Mountains", qszone = "Ogri'la", area = BZ["Blade's Edge Mountains"], group = "Ogri'la", SID = "Ogri'la:4", ["rep"] = {BF["Ogri'la"]..":350", BF["Sha'tari Skyguard"]..":350"}, ["rewards"] = {"32569:15"}, gold = 91000},
	[L["Banish More Demons"]] = {icon = "Interface\\Icons\\INV_Misc_Gem_AzureDraenite_02", link = "|cffffff00|Hquest:11051:70|h[Banish More Demons]|h|r", coords ="29:58", qgiver = "Kronk", qzone = "Blade's Edge Mountains", qszone = "Ogri'la", area = BZ["Blade's Edge Mountains"], group = "Ogri'la", SID = "Ogri'la:6", ["rep"] = {BF["Ogri'la"]..":350", BF["Sha'tari Skyguard"]..":350"}, ["rewards"] = {"32569:15", "32777:1"}, gold = 119900},

	-- Netherwing
	[L["The Not-So-Friendly Skies..."]] = {icon = "Interface\\Icons\\INV_Bijou_Blue", link = "|cffffff00|Hquest:11035:70|h[The Not-So-Friendly Skies...]|h|r", coords ="66:86", qgiver = "Yarzill the Merc", qzone = "Shadowmoon Valley", qszone = "Dragonmaw Base Camp", area = BZ["Shadowmoon Valley"], group = "Netherwing", SID = "Netherwing:4", ["rep"] = {BF["Netherwing"]..":250"}, gold = 119900},
	[L["The Booterang: A Cure For The Common Worthless Peon"]] = {icon = "Interface\\Icons\\INV_Boots_Chain_01", link = "|cffffff00|Hquest:11055:70|h[The Booterang: A Cure For The Common Worthless Peon]|h|r", coords ="67:86", qgiver = "Chief Overseer Mudlump", qzone = "Shadowmoon Valley", qszone = "Dragonmaw Base Camp", area = BZ["Shadowmoon Valley"], group = "Netherwing", SID = "Netherwing:5", ["rep"] = {BF["Netherwing"]..":350"}, gold = 119900},
	[L["Picking Up The Pieces..."]] = {icon = "Interface\\Icons\\INV_Crate_04", link = "|cffffff00|Hquest:11076:70|h[Picking Up The Pieces...]|h|r", coords ="63:88", qgiver = "Mistress of the Mines", qzone = "Shadowmoon Valley", qszone = "Dragonmaw Base Camp", area = BZ["Shadowmoon Valley"], group = "Netherwing", SID = "Netherwing:5", ["rep"] = {BF["Netherwing"]..":350"}, gold = 182800},
	[L["Netherwing Crystals"]] = {icon = "Interface\\Icons\\INV_Misc_Gem_AzureDraenite_02", link = "|cffffff00|Hquest:11015:70|h[Netherwing Crystals]|h|r", coords ="66:86", qgiver = "Taskmaster Varkule Dragonbreath", qzone = "Shadowmoon Valley", qszone = "Dragonmaw Base Camp", area = BZ["Shadowmoon Valley"], group = "Netherwing", SID = "Netherwing:4", ["rep"] = {BF["Netherwing"]..":250"}, gold = 119900},
	[L["Dragons are the Least of Our Problems"]] = {icon = "Interface\\Icons\\Ability_Hunter_Pet_Ravager", link = "|cffffff00|Hquest:11077:70|h[Dragons are the Least of Our Problems]|h|r", coords ="65:87", qgiver = "Dragonmaw Foreman", qzone = "Shadowmoon Valley", qszone = "Dragonmaw Base Camp", area = BZ["Shadowmoon Valley"], group = "Netherwing", SID = "Netherwing:5", ["rep"] = {BF["Netherwing"]..":350"}, gold = 119900},
	[L["Disrupting the Twilight Portal"]] = {icon = "Interface\\Icons\\INV_Armor_Shield_Naxxramas_D_01", link = "|cffffff00|Hquest:11086:70|h[Disrupting the Twilight Portal]|h|r", coords ="66:86", qgiver = "Overlord Mor'ghor", qzone = "Shadowmoon Valley", qszone = "Dragonmaw Base Camp", SID = "Netherwing:6", ["rep"] = {BF["Netherwing"]..":500"}, area = BZ["Nagrand"], group = "Netherwing", gold = 119900},
	[L["A Slow Death"]] = {icon = "Interface\\Icons\\INV_Misc_Food_60", link = "|cffffff00|Hquest:11020:70|h[A Slow Death]|h|r", coords ="66:86", qgiver = "Yarzill the Merc", qzone = "Shadowmoon Valley", qszone = "Dragonmaw Base Camp", area = BZ["Shadowmoon Valley"], group = "Netherwing", SID = "Netherwing:4", ["rep"] = {BF["Netherwing"]..":250"}, gold = 119900},

	-- ***** Patch 2.4 Dailies List	*****
	-- Heroic Daily
	[L["Wanted: The Signet Ring of Prince Kael'thas"]] = {icon = "Interface\\Icons\\INV_Jewelry_Ring_55", link = "|cffffff00|Hquest:11499:70|h[Wanted: The Signet Ring of Prince Kael'thas]|h|r", coords ="75:37", qgiver = "Wind Trader Zhareem", qzone = "Shattrath City", qszone = "Lower City", area = BZ["Magisters' Terrace"], loc = BZ["Magisters' Terrace"], group = "HInstance", SID = "Shattered Sun Offensive:4", ["rep"] = {BF["Shattered Sun Offensive"]..":350", BF["The Consortium"]..":350"}, ["rewards"] = {"29434:2"}, gold = 246000}, -- Magisters' Terrace
	-- Non Heroic Daily
	[L["Wanted: Sisters of Torment"]] = {icon = "Interface\\Addons\\DailiesQuestTracker\\Icons\\SisterofTorment.tga", link = "|cffffff00|Hquest:11500:70|h[Wanted: Sisters of Torment]|h|r", coords ="75:37", qgiver = "Nether-Stalker Mah'dunn", qzone = "Shattrath City", qszone = "Lower City", area = BZ["Magisters' Terrace"], loc = BZ["Magisters' Terrace"], group = "DInstance", SID = "Shattered Sun Offensive:4", ["rep"] = {BF["Shattered Sun Offensive"]..":250", BF["The Consortium"]..":250"}, ["rewards"] = {"29460:1"}, gold = 163900}, -- Magisters' Terrace

	-- Fishing
	[L["Shrimpin' Ain't Easy"]] = {icon = "Interface\\Icons\\INV_Misc_Fish_15", link = "|cffffff00|Hquest:11668:70|h[Shrimpin' Ain't Easy]|h|r", coords = "38.718:12.800", qgiver = "Old Man Barlo", qzone = "Terokkar Forest", qszone = "Silmyr Lake", area = BZ["Zangarmarsh"], group = "Fishing", SID = "None:0", ["rewards"] = {"35348:1"}},
	[L["Bait Bandits"]] = {icon = "Interface\\Icons\\INV_Misc_Fish_43", link = "|cffffff00|Hquest:11666:70|h[Bait Bandits]|h|r", coords = "38.718:12.800", qgiver = "Old Man Barlo", qzone = "Terokkar Forest", qszone = "Silmyr Lake", area = BZ["Terokkar Forest"], group = "Fishing", SID = "None:0", ["rewards"] = {"35348:1"}},
	[L["Felblood Fillet"]] = {icon = "Interface\\Icons\\INV_Misc_Fish_38", link = "|cffffff00|Hquest:11669:70|h[Felblood Fillet]|h|r", coords = "38.718:12.800", qgiver = "Old Man Barlo", qzone = "Terokkar Forest", qszone = "Silmyr Lake", area = BZ["Shadowmoon Valley"], group = "Fishing", SID = "None:0", ["rewards"] = {"35348:1"}},
	[L["The One That Got Away"]] = {icon = "Interface\\Icons\\INV_Misc_Fish_45", link = "|cffffff00|Hquest:11667:70|h[The One That Got Away]|h|r", coords = "38.718:12.800", qgiver = "Old Man Barlo", qzone = "Terokkar Forest", qszone = "Silmyr Lake", area = BZ["Nagrand"], group = "Fishing", SID = "None:0", ["rewards"] = {"35348:1"}},

	-- Shattered Sun Offensive [Final Quests Only]
	[L["Blood for Blood"]] = {icon = "Interface\\Icons\\INV_Qiraj_JewelEngraved", link = "|cffffff00|Hquest:11515:70|h[Blood for Blood]|h|r", coords ="58:18", qgiver = "Magistrix Seyla", qzone = "Hellfire Peninsula", qszone = "Throne of Kil'jaeden", area = BZ["Hellfire Peninsula"], group = "Shattered Sun Offensive", SID = "Shattered Sun Offensive:4", ["rep"] = {BF["Shattered Sun Offensive"]..":250"}, ["rewards"] = {"30809:5", "30810:5"}, gold = 119900},
	[L["Blast the Gateway"]] = {icon = "Interface\\Icons\\INV_Ammo_FireTar", link = "|cffffff00|Hquest:11516:70|h[Blast the Gateway]|h|r", coords ="58:18", qgiver = "Magistrix Seyla", qzone = "Hellfire Peninsula", qszone = "Throne of Kil'jaeden", area = BZ["Hellfire Peninsula"], group = "Shattered Sun Offensive", SID = "Shattered Sun Offensive:4", ["rep"] = {BF["Shattered Sun Offensive"]..":250"}, ["rewards"] = {"35232:1"}, gold = 101000},
	[L["Sunfury Attack Plans"]] = {icon = "Interface\\Icons\\INV_Scroll_04", link = "|cffffff00|Hquest:11877:70|h[Sunfury Attack Plans]|h|r", coords = "62.771:35.962", qgiver = "Lord Torros", qzone = "Shattrath City", qszone = "Terrace of Light", area = BZ["Netherstorm"], group = "Shattered Sun Offensive", SID = "Shattered Sun Offensive:4", ["rep"] = {BF["Shattered Sun Offensive"]..":250"}, ["rewards"] = {"35232:1"}, gold = 101000},
	[L["The Multiphase Survey"]] = {icon = "Interface\\Icons\\INV_Gizmo_NewGoggles", link = "|cffffff00|Hquest:11880:70|h[The Multiphase Survey]|h|r", coords ="61.634:52.171", qgiver = "Harbinger Haronem", qzone = "Shattrath City", qszone = "Terrace of Light", area = BZ["Nagrand"], group = "Shattered Sun Offensive", SID = "Shattered Sun Offensive:4", ["rep"] = {BF["Shattered Sun Offensive"]..":150"}, gold = 91000},
	[L["Arm the Wards!"]] = {icon = "Interface\\Icons\\INV_Misc_Dust_03", link = "|cffffff00|Hquest:11523:70|h[Arm the Wards!]|h|r", coords ="47:30", qgiver = "Captain Theris Dawnhearth", qzone = "Isle of Quel'Danas", qszone = "Shattered Sun Staging Area", area = BZ["Isle of Quel'Danas"], group = "Shattered Sun Offensive", SID = "Shattered Sun Offensive:4", ["rep"] = {BF["Shattered Sun Offensive"]..":150"}, gold = 91000},
	[L["Further Conversions"]] = {icon = "Interface\\Icons\\INV_Misc_Gem_Variety_02", link = "|cffffff00|Hquest:11525:70|h[Further Conversions]|h|r", coords ="47:31", qgiver = "Vindicator Xayann", qzone = "Isle of Quel'Danas", qszone = "Shattered Sun Staging Area", area = BZ["Isle of Quel'Danas"], group = "Shattered Sun Offensive", SID = "Shattered Sun Offensive:4", ["rep"] = {BF["Shattered Sun Offensive"]..":150"}, gold = 91000},
	[L["Ata'mal Armaments"]] = {icon = "Interface\\Icons\\INV_Ore_Khorium_01", link = "|cffffff00|Hquest:11544:70|h[Ata'mal Armaments]|h|r", coords ="51:41", qgiver = "Smith Hauthaa", qzone = "Isle of Quel'Danas", qszone = "Sun's Reach Armory", area = BZ["Shadowmoon Valley"], group = "Shattered Sun Offensive", SID = "Shattered Sun Offensive:4", ["rep"] = {BF["Shattered Sun Offensive"]..":350"}, ["rewards"] = {"34538:1", "34539:1"}, gold = 182800},
	[L["Disrupt the Greengill Coast"]] = {icon = "Interface\\Icons\\Spell_Nature_WispSplode", link = "|cffffff00|Hquest:11541:70|h[Disrupt the Greengill Coast]|h|r", coords ="54:34", qgiver = "Captain Valindria", qzone = "Isle of Quel'Danas", qszone = "Silvermoon's Pride", area = BZ["Isle of Quel'Danas"], group = "Shattered Sun Offensive", SID = "Shattered Sun Offensive:4", ["rep"] = {BF["Shattered Sun Offensive"]..":250"}, gold = 119900},
	[L["Don't Stop Now...."]] = {icon = "Interface\\Icons\\INV_Ore_Iron_01", link = "|cffffff00|Hquest:11536:70|h[Don't Stop Now....]|h|r", coords ="51:41", qgiver = "Smith Hauthaa", qzone = "Isle of Quel'Danas", qszone = "Sun's Reach Armory", area = BZ["Isle of Quel'Danas"], group = "Shattered Sun Offensive", SID = "Shattered Sun Offensive:4", ["rep"] = {BF["Shattered Sun Offensive"]..":250"}, gold = 119900},
	[L["Keeping the Enemy at Bay"]] = {icon = "Interface\\Icons\\Spell_Fire_Fire", link = "|cffffff00|Hquest:11543:70|h[Keeping the Enemy at Bay]|h|r", coords ="51:39", qgiver = "Vindicator Kaalan", qzone = "Isle of Quel'Danas", qszone = "Sun's Reach Armory", area = BZ["Isle of Quel'Danas"], group = "Shattered Sun Offensive", SID = "Shattered Sun Offensive:4", ["rep"] = {BF["Shattered Sun Offensive"]..":250"}, gold = 75900},
	[L["Crush the Dawnblade"]] = {icon = "Interface\\Icons\\INV_Misc_Gem_Bloodstone_02", link = "|cffffff00|Hquest:11540:70|h[Crush the Dawnblade]|h|r", coords ="49:40", qgiver = "Magister Ilastar", qzone = "Isle of Quel'Danas", qszone = "Sun's Reach Armory", area = BZ["Isle of Quel'Danas"], group = "Shattered Sun Offensive", SID = "Shattered Sun Offensive:4", ["rep"] = {BF["Shattered Sun Offensive"]..":250"}, gold = 119900},
	[L["Maintaining the Sunwell Portal"]] = {icon = "Interface\\Icons\\INV_Gizmo_KhoriumPowerCore", link = "|cffffff00|Hquest:11514:70|h[Maintaining the Sunwell Portal]|h|r", coords ="59:42", qgiver = "Exarch Nasuun", qzone = "Shattrath City", qszone = "Terrace of Light", area = BZ["Blade's Edge Mountains"], group = "Shattered Sun Offensive", SID = "Shattered Sun Offensive:4", ["rep"] = {BF["Shattered Sun Offensive"]..":250"}, ["rewards"] = {"35232:1"}, gold = 101000},
	[L["Know Your Ley Lines"]] = {icon = "Interface\\Icons\\INV_Scroll_02", link = "|cffffff00|Hquest:11547:70|h[Know Your Ley Lines]|h|r", coords ="47:35", qgiver = "Astromancer Darnarian", qzone = "Isle of Quel'Danas", qszone = "Sun's Reach Sanctum", area = BZ["Isle of Quel'Danas"], group = "Shattered Sun Offensive", SID = "Shattered Sun Offensive:4", ["rep"] = {BF["Shattered Sun Offensive"]..":250"}, ["rewards"] = {"35230:1"}, gold = 119900},
	[L["The Air Strikes Must Continue"]] = {icon = "Interface\\Icons\\Spell_Arcane_StarFire", link = "|cffffff00|Hquest:11533:70|h[The Air Strikes Must Continue]|h|r", coords ="48:35", qgiver = "Battlemage Arynn", qzone = "Isle of Quel'Danas", qszone = "Sun's Reach Sanctum", area = BZ["Isle of Quel'Danas"], group = "Shattered Sun Offensive", SID = "Shattered Sun Offensive:4", ["rep"] = {BF["Shattered Sun Offensive"]..":150"}, gold = 91000},
	[L["Rediscovering Your Roots"]] = {icon = "Interface\\Icons\\INV_Misc_Herb_15", link = "|cffffff00|Hquest:11521:70|h[Rediscovering Your Roots]|h|r", coords ="51:32", qgiver = "Mar'nah", qzone = "Isle of Quel'Danas", qszone = "Sun's Reach Harbor", area = BZ["Terokkar Forest"], group = "Shattered Sun Offensive", SID = "Shattered Sun Offensive:4", ["rep"] = {BF["Shattered Sun Offensive"]..":250"}, ["rewards"] = {"35232:1"}, gold = 138800},
	[L["Open for Business"]] = {icon = "Interface\\Icons\\INV_Misc_Branch_01", link = "|cffffff00|Hquest:11546:70|h[Open for Business]|h|r", coords ="51:32", qgiver = "Mar'nah", qzone = "Isle of Quel'Danas", qszone = "Sun's Reach Harbor", area = BZ["Isle of Quel'Danas"], group = "Shattered Sun Offensive", SID = "Shattered Sun Offensive:4", ["rep"] = {BF["Shattered Sun Offensive"]..":250"}, ["rewards"] = {"34537:1"}, gold = 119900},
	[L["The Battle Must Go On"]] = {icon = "Interface\\Icons\\INV_BRD_Banner", link = "|cffffff00|Hquest:11537:70|h[The Battle Must Go On]|h|r", coords ="48:35", qgiver = "Harbinger Inuuro", qzone = "Isle of Quel'Danas", qszone = "Sun's Reach Sanctum", area = BZ["Isle of Quel'Danas"], group = "Shattered Sun Offensive", SID = "Shattered Sun Offensive:4", ["rep"] = {BF["Shattered Sun Offensive"]..":250"}, gold = 101000},	
	}
