﻿--[[Copyright (C) 2008 by Fritos

	This program is free software; you can redistribute it and--or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software Foundation, Inc.,
	59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.]]
	
Dailies = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceComm-2.0", "AceEvent-2.0", "FuBarPlugin-2.0", "AceDB-2.0", "AceHook-2.1")

local Tablet = AceLibrary("Tablet-2.0")
local Dewdrop = AceLibrary("Dewdrop-2.0")
local Crayon = AceLibrary("LibCrayon-3.0")
local Quixote = AceLibrary("LibQuixote-2.0")
local Deformat = AceLibrary("Deformat-2.0")
local Sink = AceLibrary("LibSink-2.0")
local L = AceLibrary("AceLocale-2.2"):new("Dailies")
local BZ = AceLibrary("LibBabble-Zone-3.0"):GetLookupTable()
local BF = AceLibrary("LibBabble-Faction-3.0"):GetLookupTable()

Dailies.hasIcon  = "Interface\\Addons\\DailiesQuestTracker\\Icon.tga"
Dailies.hasNoText  = false;
Dailies.title = L["Dailies Quest Tracker"];
Dailies.hideMenuTitle = true;
Dailies.cannotDetachTooltip = true;
Dailies:RegisterDB("DailiesDB");
Dailies.clickableTooltip = true;

-- Reputation Pane, collapsed headers value holder
CollapsedHeaders = {}

-- Tradeskill Holder
DailiesTradeskills = {}

-- Scheduled reset time for dailies (i.e 3 am Server Time)
DailiesReset = 4

-- Toggle Seasonal Filter off by default unless Holiday Dailies are availiable
ShowSeasonal = false

-- Grab Channel List of Users
GrabbedChannelList = false

-- Set the font used in DQT (FRIZQT__.TTF is too LARGE)
DQTFont = ChatFontNormal

-- Random Dailies values
DailiesKnownNotCompleted = Crayon:Red(L["Not Completed"])
DailiesKnownCompleted = Crayon:Green(L["Completed"])

-- Format Fontstring Textures
TEXTURE_LINK_FORMAT = "|T%s:%d:%d:0:%d|t"

-- Holder for multiple character dailies
UnitsHolder = {}

--Setup Own formatted Tooltips
QuestUnitsTooltip = CreateFrame("GameTooltip", "UnitsTooltip", nil, "GameTooltipTemplate")
QuestRewardsTooltip = CreateFrame("GameTooltip", "RewardsTooltip", nil, "GameTooltipTemplate")

QuestUnitsTooltip:SetBackdrop({bgFile = "Interface/Tooltips/UI-Tooltip-Background", 
edgeFile = "Interface/Tooltips/UI-Tooltip-Border", 
tile = true, tileSize = 16, edgeSize = 16, 
insets = { left = 3, right = 3, top = 3, bottom = 3 }});
											
QuestRewardsTooltip:SetBackdrop({bgFile = "Interface/Tooltips/UI-Tooltip-Background", 
edgeFile = "Interface/Tooltips/UI-Tooltip-Border", 
tile = true, tileSize = 16, edgeSize = 16, 
insets = { left = 3, right = 3, top = 3, bottom = 3 }});

-- Comm Setup
Dailies.CommPrefix = "DQTComm";
Dailies:SetCommPrefix(Dailies.CommPrefix);
Dailies.OnCommReceive = {}
DailiesRoster = {}
Dailies.UniqueNames = {};
DailiesCommHolder = {}

-- Dialog Pop-up Messages
DialogOffComms = Crayon:Gold(L["You're turning "]) .. Crayon:Red(L["OFF"]) .. Crayon:Gold(L[" communications for "]) .. Crayon:Green(L["Dailies Quest Tracker"]) .. Crayon:Gold(L[".\n\n Clicking "]).. Crayon:Green(L["YES"])
	.. Crayon:Gold(L[" will reload your UI to remove the channel and you will no longer send and/or receive the Random Dailies!\n\nAre you sure you would like to do this?"])
DialogOnComms = Crayon:Gold(L["You're turning "]) .. Crayon:Green(L["ON"]) .. Crayon:Gold(L[" communications for "]) .. Crayon:Green(L["Dailies Quest Tracker"]) .. Crayon:Gold(L[".\n\n Clicking "]).. Crayon:Green(L["YES"])
	.. Crayon:Gold(L[" will reload your UI to set-up the channel, please make sure your "]) .. Crayon:Green(L["CUSTOM"]) .. Crayon:Gold(L[" channels are set before continuing.\n\nAre you sure you would like to do this?"])

local config = {
	type = 'group',
	handler = SCT,
	args = {
	}
}
	
-- Reputation Values holder
local RepValuesHolder = {
	["Shattered Sun Offensive"] = {},
	["Netherwing"] = {},
	["Ogri'la"] = {},
	["Sha'tari Skyguard"] = {},
}

-- Icons for specific classes
classIcons = {
	DRUID = "Interface\\Icons\\INV_Misc_MonsterClaw_04",
	WARLOCK = "Interface\\Icons\\Spell_Nature_FaerieFire",
	HUNTER = "Interface\\Icons\\INV_Weapon_Bow_07",
	MAGE = "Interface\\Icons\\INV_Staff_13",
	PRIEST = "Interface\\Icons\\INV_Staff_30",
	WARRIOR = "Interface\\Icons\\INV_Sword_27",
	SHAMAN = "Interface\\Icons\\Spell_Nature_BloodLust",
	PALADIN = "Interface\\Addons\\DailiesQuestTracker\\Icons\\Paladin",
	ROGUE = "Interface\\Addons\\DailiesQuestTracker\\Icons\\Rogue",
}
	
-- Reputation Table holder
local RepFactionsHolder = {
	["None"] = 0,
	["BGPvP"] = 0,
	["Cooking"] = 0,
	["Fishing"] = 0,
	["Holiday"] = 0,
	["HInstance"] = 0,
	["DInstance"] = 0,
	["World PvP"] = 0,
	["Shattered Sun Offensive"] = nil,
	["Netherwing"] = nil,
	["Ogri'la"] = nil,
	["Sha'tari Skyguard"] = nil,
}

 -- Coverter from RGB to HEX
function RGBPercToHex(r, g, b)
	r = r <= 1 and r >= 0 and r or 0
	g = g <= 1 and g >= 0 and g or 0
	b = b <= 1 and b >= 0 and b or 0
	return string.format("%02x%02x%02x", r*255, g*255, b*255)
end -- function RGBPercToHex
 
 -- Output Debug Messages to Chatframe
function Dailies:Debug(...)
	if self.db.profile and self.db.profile.DebugEnabled == true then
		self:Print(...);
	end
end -- function Debug

-- Resets the Comms to on/off from USERS choice
function Dailies:ResetAllComms()
	ReloadUI();
end -- function ResetAllComms

function Dailies:OnInitialize()
englishFaction, _ = UnitFactionGroup("Player")
PlayerRace, _ = UnitRace("Player");

-- Register Events
Dailies:RegisterEvent("ADDON_LOADED", "ADDON_LOADED")
Dailies:RegisterEvent("CHAT_MSG_SKILL", "CHAT_MSG_SKILL")
Dailies:RegisterEvent("CHAT_MSG_SYSTEM", "DailiesQuest_Tracker")
Dailies:RegisterEvent("UNIT_QUEST_LOG_CHANGED", "DailiesUpdate")
Dailies:RegisterEvent("PLAYER_ALIVE", "PLAYER_ALIVE")
Dailies:RegisterEvent("Quixote_Quest_Complete", "QuestObjectives")
Dailies:RegisterEvent("ZONE_CHANGED", "ZONE_CHANGED")
Dailies:RegisterEvent("ZONE_CHANGED_INDOORS", "ZONE_CHANGED")
Dailies:RegisterEvent("ZONE_CHANGED_NEW_AREA", "ZONE_CHANGED")
Dailies:RegisterEvent("GOSSIP_SHOW", "GOSSIP_SHOW")
Dailies:RegisterEvent("QUEST_DETAIL", "QUEST_DETAIL")
Dailies:RegisterEvent("VARIABLES_LOADED", "VARIABLES_LOADED")

Dailies:RegisterBucketEvent("UPDATE_FACTION", 5, "UpdateTheReputation")

Dailies:RegisterEvent("TurnOnComms", "TurnOnComms");
Dailies:RegisterEvent("CHANNEL_COUNT_UPDATE", "GetChannelMembers");
Dailies:RegisterEvent("SendTheDailies", "SendTheDailies")
	
-- Turn Comm Channels On/Off Dialog
StaticPopupDialogs["RESET_COMMS"] = {
	text = "%s",
	button1 = L["YES"],
	button2 = L["NO"],
	OnAccept = function()
		self.db.char.DailyCommSet  = not self.db.char.DailyCommSet;		
		Dailies:ResetAllComms();
	end,
	OnCancel = function (_, reason)
		if reason == "clicked" then
			SetDailyCommSet = self.db.char.DailyCommSet;
		end
	end,
	timeout = 0,
	whileDead = 1,
	showAlert = 1
};

Dailies:RegisterChatCommand({"/DQT", "/Dailies"}, config)

DailiesGroups = {
	["BGPvP"] = {group = "BGPvP", title = L["Battleground"] ..": ["..Crayon:Green(L["Random Daily"]).."]", ValueMax = 1, Accepted = 0},
	["Cooking"] = {group ="Cooking", title = GetSpellInfo(2550) .. ": ["..Crayon:Green(L["Random Daily"]).."]", ValueMax = 1, Accepted = 0},
	["DInstance"] = {group ="DInstance", title = L["Dungeon Instance"] ..": [".. Crayon:Green(L["Random Daily"]).."]", ValueMax = 1, Accepted = 0},
	["Fishing"] = {group ="Fishing", title = GetSpellInfo(7620) .. ": ["..Crayon:Green(L["Random Daily"]).."]", ValueMax = 1, Accepted = 0},
	["Holiday"] = {group ="Holiday", title = L["Holiday"], ValueMax = 1, Accepted = 0},
	["HInstance"] = {group ="HInstance", title = L["Heroic Instance"] .. ": [".. Crayon:Green(L["Random Daily"]).."]", ValueMax = 1, Accepted = 0},
	["Netherwing"] = {group ="Netherwing", title = BF["Netherwing"], ValueMax = 8, Accepted = 0},
	["Ogri'la"] = {group ="Ogri'la", title = BF["Ogri'la"], ValueMax = 2, Accepted = 0},
	["Sha'tari Skyguard"] = {group ="Sha'tari Skyguard", title = BF["Sha'tari Skyguard"], ValueMax = 4, Accepted = 0},
	["Shattered Sun Offensive"] = {group = "Shattered Sun Offensive", title = BF["Shattered Sun Offensive"], ValueMax = 17, Accepted = 0},
	["World PvP"] = {group ="World PvP", title = L["World PvP"], ValueMax = 2, Accepted = 0}
}

if englishFaction == "Alliance" then
	-- Battlegrounds
	DailyQuestsList[L["Call to Arms: Warsong Gulch"]] = {icon = "Interface\\Icons\\INV_Misc_Rune_07", link = "|cffffff00|Hquest:11338:-1|h[Call to Arms: Warsong Gulch]|h|r", coords ="67:34", qgiver = "Alliance Brigadier General", qzone = "Shattrath City", qszone = "Terrace Of Light", area = BZ["Warsong Gulch"], group = "BGPvP", SID = "None:0", ["honor"] = 420, gold = 119900}
	DailyQuestsList[L["Call to Arms: Arathi Basin"]] = {icon = "Interface\\Icons\\INV_Jewelry_Amulet_07", link = "|cffffff00|Hquest:11335:-1|h[Call to Arms: Arathi Basin]|h|r", coords ="67:34", qgiver = "Alliance Brigadier General", qzone = "Shattrath City", qszone = "Terrace Of Light", area = BZ["Arathi Basin"], group = "BGPvP", SID = "None:0", ["honor"] = 420, gold = 119900}
	DailyQuestsList[L["Call to Arms: Eye of the Storm"]] = {icon = "Interface\\Icons\\Spell_Nature_EyeOfTheStorm", link = "|cffffff00|Hquest:11337:-1|h[Call to Arms: Eye of the Storm]|h|r", coords ="67:34", qgiver = "Alliance Brigadier General", qzone = "Shattrath City", qszone = "Terrace Of Light", area = BZ["Eye of the Storm"], group = "BGPvP", SID = "None:0", ["honor"] = 420, gold = 119900}
	DailyQuestsList[L["Call to Arms: Alterac Valley"]] = {icon = "Interface\\Icons\\INV_Jewelry_Necklace_21", link = "|cffffff00|Hquest:11336:-1|h[Call to Arms: Alterac Valley]|h|r", coords ="67:34", qgiver = "Alliance Brigadier General", qzone = "Shattrath City", qszone = "Terrace Of Light", area = BZ["Alterac Valley"], group = "BGPvP", SID = "None:0", ["honor"] = 420, gold = 119900}
	-- Regular Instance
	DailyQuestsList[L["Wanted: Shattered Hand Centurions"]] = {icon = "Interface\\Addons\\DailiesQuestTracker\\Icons\\Centurion.tga", link = "|cffffff00|Hquest:11364:70|h[Wanted: Shattered Hand Centurions]|h|r", coords ="75:37", qgiver = "Nether-Stalker Mah'dunn", qzone = "Shattrath City", qszone = "Lower City", loc = BZ["The Shattered Halls"], area = BZ["The Shattered Halls"], group = "DInstance", SID = "None:0", ["rep"] = {BF["Honor Hold"]..":250", BF["The Consortium"]..":250"}, ["rewards"] = {"29460:1"}, gold = 163900} --Shattered Halls
	-- Heroic Instance
	DailyQuestsList[L["Wanted: Nazan's Riding Crop"]] = {icon = "Interface\\Icons\\INV_Misc_Crop_01", link = "|cffffff00|Hquest:11354:70|h[Wanted: Nazan's Riding Crop]|h|r", coords ="75:37", qgiver = "Wind Trader Zhareem", qzone = "Shattrath City", qszone = "Lower City", loc = BZ["Hellfire Ramparts"], area = BZ["Hellfire Ramparts"], group = "HInstance", SID = "Honor Hold:6", ["rep"] = {BF["Honor Hold"]..":350", BF["The Consortium"]..":350"}, ["rewards"] = {"29434:2"}, gold = 246000} --Ramparts
	DailyQuestsList[L["Wanted: Keli'dan's Feathered Stave"]] = {icon = "Interface\\Icons\\INV_Staff_Goldfeathered_01", link = "|cffffff00|Hquest:11354:70|h[Wanted: Nazan's Riding Crop]|h|r", coords ="75:37", qgiver = "Wind Trader Zhareem", qzone = "Shattrath City", qszone = "Lower City", loc = BZ["The Blood Furnace"], area = BZ["The Blood Furnace"], group = "HInstance", SID = "Honor Hold:6", ["rep"] = {BF["Honor Hold"]..":350", BF["The Consortium"]..":350"}, ["rewards"] = {"29434:2"}, gold = 246000} --Blood Furnace
	DailyQuestsList[L["Wanted: Bladefist's Seal"]] = {icon = "Interface\\Icons\\INV_SummerFest_Symbol_Medium", link = "|cffffff00|Hquest:11363:70|h[Wanted: Bladefist's Seal]|h|r", coords ="75:37", qgiver = "Wind Trader Zhareem", qzone = "Shattrath City", qszone = "Lower City", loc = BZ["The Shattered Halls"], area = BZ["The Shattered Halls"], group = "HInstance", SID = "Honor Hold:6", ["rep"] = {BF["Honor Hold"]..":350", BF["The Consortium"]..":350"}, ["rewards"] = {"29434:2"}, gold = 246000} --Shattered Halls
	--Fishing [Patch 2.4]
	DailyQuestsList[L["Crocolisks in the City"]] = {icon = "Interface\\Icons\\Ability_Hunter_Pet_Crocolisk", link = "|cffffff00|Hquest:11665:70|h[Crocolisks in the City]|h|r", coords ="39:13", qgiver = "Old Man Barlo", qzone = "Terokkar Forest", qszone = "Silmyr Lake", area = BZ["Stormwind City"], group = "Fishing", SID = "None:0", ["rewards"] = {"35348:1"}}
	-- Alliance Nagrand PvP [Patch 2.4]
	DailyQuestsList[L["Spirits of Auchindoun"]] = {icon = "Interface\\Icons\\INV_Jewelry_FrostwolfTrinket_04", link = "|cffffff00|Hquest:11505:-1|h[Spirits of Auchindoun]|h|r", coords ="56:54", qgiver = "Exorcist Sullivan", qzone = "Terokkar Forest", qszone = "Allerian Stronghold", group = "World PvP", loc = BZ["Terokkar Forest"], area = BZ["Terokkar Forest"], SID = "None:0", ["honor"] = 210, gold = 119900}
	-- Alliance Terokkar PvP [Patch 2.4]
	DailyQuestsList[L["In Defense of Halaa"]] = {icon = "Interface\\Icons\\INV_Misc_Rune_08", link = "|cffffff00|Hquest:11502:70|h[In Defense of Halaa]|h|r", coords ="56:74", qgiver = "Lakoor", qzone = "Nagrand", qszone = "Telaar", group = "World PvP", loc = BZ["Nagrand"], area = BZ["Nagrand"], SID = "None:0", ["honor"] = 210, gold = 119900}
	BGHonor = "Interface\\Addons\\DailiesQuestTracker\\Icons\\Alliance.tga"
	
elseif englishFaction == "Horde" then
	-- Battlegrounds
	DailyQuestsList[L["Call to Arms: Warsong Gulch"]] = {icon = "Interface\\Icons\\INV_Misc_Rune_07", link = "|cffffff00|Hquest:11342:-1|h[Call to Arms: Warsong Gulch]|h|r", coords ="66.9:54.4", qgiver = "Horde Warbringer", qzone = "Shattrath City", qszone = "Terrace Of Light", area = BZ["Warsong Gulch"], group = "BGPvP", SID = "None:0", ["honor"] = 420, gold = 119900}
	DailyQuestsList[L["Call to Arms: Arathi Basin"]] = {icon = "Interface\\Icons\\INV_Jewelry_Amulet_07", link = "|cffffff00|Hquest:11339:-1|h[Call to Arms: Arathi Basin]|h|r", coords ="66.9:54.4", qgiver = "Horde Warbringer", qzone = "Shattrath City", qszone = "Terrace Of Light", area = BZ["Arathi Basin"], group = "BGPvP", SID = "None:0", ["honor"] = 420, gold = 119900}
	DailyQuestsList[L["Call to Arms: Eye of the Storm"]] = {icon = "Interface\\Icons\\Spell_Nature_EyeOfTheStorm", link = "|cffffff00|Hquest:11341:-1|h[Call to Arms: Eye of the Storm]|h|r", coords ="66.9:54.4", qgiver = "Horde Warbringer", qzone = "Shattrath City", qszone = "Terrace Of Light", area = BZ["Eye of the Storm"], group = "BGPvP", SID = "None:0", ["honor"] = 420, gold = 119900}
	DailyQuestsList[L["Call to Arms: Alterac Valley"]] = {icon = "Interface\\Icons\\INV_Jewelry_Necklace_21", link = "|cffffff00|Hquest:11340:-1|h[Call to Arms: Alterac Valley]|h|r", coords ="66.9:54.4", qgiver = "Horde Warbringer", qzone = "Shattrath City", qszone = "Terrace Of Light", area = BZ["Alterac Valley"], group = "BGPvP", SID = "None:0", ["honor"] = 420, gold = 119900}
	-- Regular Instance
	DailyQuestsList[L["Wanted: Shattered Hand Centurions"]] = {icon = "Interface\\Addons\\DailiesQuestTracker\\Icons\\Centurion.tga", link = "|cffffff00|Hquest:11364:70|h[Wanted: Shattered Hand Centurions]|h|r", coords ="75:37", qgiver = "Wind Trader Zhareem", qzone = "Shattrath City", qszone = "Lower City", loc = BZ["The Shattered Halls"], area = BZ["The Shattered Halls"], group = "DInstance", SID = "None:0", ["rep"] = {BF["Thrallmar"]..":250", BF["The Consortium"]..":250"}, ["rewards"] = {"29460:1"}, gold = 163900} --Shattered Halls
	-- Heroic Instance
	DailyQuestsList[L["Wanted: Nazan's Riding Crop"]] = {icon = "Interface\\Icons\\INV_Misc_Crop_01", link = "|cffffff00|Hquest:11354:70|h[Wanted: Nazan's Riding Crop]|h|r", coords ="75:37", qgiver = "Wind Trader Zhareem", qzone = "Shattrath City", qszone = "Lower City", loc = BZ["Hellfire Ramparts"], area = BZ["Hellfire Ramparts"], group = "HInstance", SID = "Thrallmar:6", ["rep"] = {BF["Thrallmar"]..":350", BF["The Consortium"]..":350"}, ["rewards"] = {"29434:2"}, gold = 246000} --Ramparts
	DailyQuestsList[L["Wanted: Keli'dan's Feathered Stave"]] = {icon = "Interface\\Icons\\INV_Staff_Goldfeathered_01", link = "|cffffff00|Hquest:11354:70|h[Wanted: Nazan's Riding Crop]|h|r", coords ="75:37", qgiver = "Wind Trader Zhareem", qzone = "Shattrath City", qszone = "Lower City", loc = BZ["The Blood Furnace"], area = BZ["The Blood Furnace"], group = "HInstance", SID = "Thrallmar:6", ["rep"] = {BF["Thrallmar"]..":350", BF["The Consortium"]..":350"}, ["rewards"] = {"29434:2"}, gold = 246000} --Blood Furnace
	DailyQuestsList[L["Wanted: Bladefist's Seal"]] = {icon = "Interface\\Icons\\INV_SummerFest_Symbol_Medium", link = "|cffffff00|Hquest:11363:70|h[Wanted: Bladefist's Seal]|h|r", coords ="75:37", qgiver = "Wind Trader Zhareem", qzone = "Shattrath City", qszone = "Lower City", loc = BZ["The Shattered Halls"], area = BZ["The Shattered Halls"], group = "HInstance", SID = "Thrallmar:6", ["rep"] = {BF["Thrallmar"]..":350", BF["The Consortium"]..":350"}, ["rewards"] = {"29434:2"}, gold = 246000} --Shattered Halls
	--Fishing [Patch 2.4]
	DailyQuestsList[L["Crocolisks in the City"]] = {icon = "Interface\\Icons\\Ability_Hunter_Pet_Crocolisk", link = "|cffffff00|Hquest:11665:70|h[Crocolisks in the City]|h|r", coords ="39:13", qgiver = "Old Man Barlo", qzone = "Terokkar Forest", qszone = "Silmyr Lake", area = BZ["Orgrimmar"], group = "Fishing", SID = "None:0", ["rewards"] = {"35348:1"}}
	-- Horde Nagrand PvP [Patch 2.4]
	DailyQuestsList[L["Spirits of Auchindoun"]] = {icon = "Interface\\Icons\\INV_Jewelry_FrostwolfTrinket_04", link = "|cffffff00|Hquest:11506:70|h[Spirits of Auchindoun]|h|r", coords ="49.7:46.6", qgiver = "Exorcist Vaisha", qzone = "Terokkar Forest", qszone = "Stonebreaker Hold", group = "World PvP", loc = BZ["Terokkar Forest"], area = BZ["Terokkar Forest"], SID = "None:0", ["honor"] = 210, gold = 119900}
	-- Horde Terokkar PvP [Patch 2.4]
	DailyQuestsList[L["Enemies, Old and New"]] = {icon = "Interface\\Icons\\INV_Misc_Rune_08", link = "|cffffff00|Hquest:11503:70|h[Enemies, Old and New]|h|r", coords ="49.7:46.6", qgiver = "Karrtog", qzone = "Nagrand", qszone = "Garadar", group = "World PvP", loc = BZ["Nagrand"], area = BZ["Nagrand"], SID = "None:0", ["honor"] = 210, gold = 119900}
	BGHonor = "Interface\\Addons\\DailiesQuestTracker\\Icons\\Horde.tga"
end

Dailies:RegisterDefaults('server', {
	UnitTrackerValid = 0,
	chars = {
	   ['*'] = {
			PlayerClass = nil,
			UnitCanDo = {
			},
			UnitCompleted = {
			},		
		},
	},
})

Dailies:RegisterDefaults('profile', {
	AceCommDelay = 20,
	DebugEnabled = false,
	QuestsVisible = true,
	SinkOptions = {},
	hideDetails = {
		["BGPvP"] = true,
		["Cooking"] = true,
		["Holiday"] = true,
		["Fishing"] = true,
		["HInstance"] = true,
		["DInstance"] = true,
		["Netherwing"] = true,
		["Ogri'la"] = true,
		["Sha'tari Skyguard"] = true,
		["Shattered Sun Offensive"] = true,
		["World PvP"] = true,
		},
})

Dailies:RegisterDefaults('char', {
	DailyQuestsAccepted = {},
	DailyQuestsCompleted = {},
	DailyQuestsObjectives = {},
	TooltipPlacement = "Right",
	MutilpleCharacters = true,
	TooltipTimer = false,
	TBCDisplay = false,
	WotLKDisplay = false,
	TimeFormat = "Standard",
	DailyCommSet = false,
	LocationShow = true,
	HideDailyList = false,
	TOMTOM_WAYPOINTS = false,
	CART_WAYPOINTS = false,
	GoldDisplay = 1,
	QuestGiver = true,
	FactionDisplay = "Icon",
	Filters = {
		["BGPvP"] = false,
		["Cooking"] = false,
		["Fishing"] = false,
		["Holiday"] = false,
		["HInstance"] = false,			
		["DInstance"] = false,
		["Netherwing"] = false,
		["Ogri'la"] = false,
		["Sha'tari Skyguard"] = false,
		["Shattered Sun Offensive"] = false,
		["World PvP"] = false,
	},
	GroupValues = {
		["BGPvP"] = 0,
		["Cooking"] = 0,
		["Fishing"] = 0,
		["Holiday"] = 0,
		["HInstance"] = 0,			
		["DInstance"] = 0,
		["Netherwing"] = 0,
		["Ogri'la"] = 0,
		["Sha'tari Skyguard"] = 0,
		["Shattered Sun Offensive"] = 0,
		["World PvP"] = 0,
	}
})

StaticPopupDialogs["RESET_COMMS"].OnShow = function()
	for index = 1, STATICPOPUP_NUMDIALOGS, 1 do
		local frame = getglobal("StaticPopup"..index);
		local alertIcon = getglobal(frame:GetName().."AlertIcon");
		if self.db.char.DailyCommSet == true then
			alertIcon:SetTexture("Interface\\Addons\\DailiesQuestTracker\\Icons\\CommOff.tga")
		else
			alertIcon:SetTexture("Interface\\Addons\\DailiesQuestTracker\\Icons\\CommOn.tga")
		end
	end
end;
	
StaticPopupDialogs["ABANDON_QUEST"].OnAccept = function() Dailies:AbandonedQuest(GetAbandonQuestName()); AbandonQuest(); PlaySound("igQuestLogAbandonQuest"); Dailies:ZONE_CHANGED() end
StaticPopupDialogs["ABANDON_QUEST_WITH_ITEMS"].OnAccept = function() Dailies:AbandonedQuest(GetAbandonQuestName()); AbandonQuest(); PlaySound("igQuestLogAbandonQuest"); Dailies:ZONE_CHANGED() end

Dailies:PLAYER_ALIVE()
LibStub("LibSink-2.0"):Embed(self)
Dailies:SetSinkStorage(self.db.profile.SinkOptions)
end -- function OnInitialize

-- Check dates to add in Seasonal Dailies
function Dailies:DailiesSeasonal()
	if (HolidayCounter == 0) then
		-- Midsummer Fire Festival
		if ((DailiesMONTH == 6 and DailiesDAY >= 21) and (DailiesMONTH == 6 and DailiesDAY <= 30)) or ((DailiesMONTH == 7 and DailiesDAY >= 1) and (DailiesMONTH == 7 and DailiesDAY <= 4)) then
				HOLIDAY_TITLE = "Midsummer Fire Festival"
				self.db.char.Filters["Holiday"] = false; ShowSeasonal = true; DailiesGroups["Holiday"]["ValueMax"] = 4
				DailyQuestsList[L["More Torch Tossing"]] = {icon = "Interface\\Icons\\INV_Torch_Lit", link = "|cffffff00|Hquest:11921:-1|h[More Torch Tossing]|h|r", coords ="0:0", qgiver = "Master Fire Eater", qzone = "Capital Cities", qszone = "Nil", group = "Holiday", area = "Capital Cities", SID = "Holiday:0", dates = {starting = "6/21", ending = "7/05"}, ["rewards"] = {"23247:5"},  gold = 119900}
				DailyQuestsList[L["More Torch Catching"]] = {icon = "Interface\\Icons\\INV_TradeskillItem_03", link = "|cffffff00|Hquest:11924:-1|h[More Torch Catching]|h|r", coords ="0:0", qgiver = "Master Fire Eater", qzone = "Capital Cities", qszone = "Nil", group = "Holiday", area = "Capital Cities", SID = "Holiday:0", dates = {starting = "6/21", ending = "7/05"}, ["rewards"] = {"23247:5"},  gold = 119900}
				DailyQuestsList[L["Striking Back"]] = {icon = "Interface\\Icons\\INV_Misc_Gem_AzureDraenite_02", link = "|cff40c040|Hquest:11954:67|h[Striking Back]|h|r", group = "Holiday", coords ="0:0", qgiver = "Earthen Ring Elder", qzone = "Capital Cities", qszone = "Nil", area = BZ["Hellfire Peninsula"], SID = "Holiday:0", dates = {starting = "6/21", ending = "7/05"}, ["rewards"] = {"23247:10"},  gold = 79300}
				DailyQuestsList[L["Summon Ahune"]] = {icon = "Interface\\Icons\\Spell_Frost_IceShard", link = "|cff40c040|Hquest:11691:70|h[Summon Ahune]|h|r", coords ="0:0", qgiver = "Luma Skymother", qzone = "The Slave Pens", qszone = "Nil", group = "Holiday", area = BZ["The Slave Pens"], SID = "Holiday:0", dates = {starting = "6/21", ending = "7/05"}, gold = 119900}
			
		-- Brewfest
		elseif (DailiesMONTH == 10 and DailiesDAY >= 2) and (DailiesMONTH == 10 and DailiesDAY <= 16) then
			HOLIDAY_TITLE = "Brewfest"
			self.db.char.Filters["Holiday"] = false; ShowSeasonal = true; DailiesGroups["Holiday"]["ValueMax"] = 2
			if englishFaction == "Alliance" then
				DailyQuestsList[L["Bark for the Barleybrews!"]] = {icon = "Interface\\Icons\\INV_Belt_05", group = "Holiday", SID = "Holiday:0", dates = {starting = "10/02", ending = "10/16"}, ["rewards"] = {"33455:40"}}
				DailyQuestsList[L["Bark for the Thunderbrews!"]] = {icon = "Interface\\Icons\\INV_Belt_05", group = "Holiday", SID = "Holiday:0", dates = {starting = "10/02", ending = "10/16"}, ["rewards"] = {"33455:40"}}	
			elseif englishFaction == "Horde" then
				DailyQuestsList[L["Bark for Drohn's Distillery!"]] = {icon = "Interface\\Icons\\INV_Belt_05", group = "Holiday", SID = "Holiday:0", dates = {starting = "10/02", ending = "10/16"}, ["rewards"] = {"33455:40"}}
				DailyQuestsList[L["Bark for T'chali's Voodoo Brewery!"]] = {icon = "Interface\\Icons\\INV_Belt_05", group = "Holiday", SID = "Holiday:0", dates = {starting = "10/02", ending = "10/16"}, ["rewards"] = {"33455:40"}}
			end
			
		-- Headless Horseman (Hallow's End)
		elseif ((DailiesMONTH == 10 and DailiesDAY >= 18) and (DailiesMONTH == 10 and DailiesDAY <= 31)) or ((DailiesMONTH == 11 and DailiesDAY >= 1) and (DailiesMONTH == 11 and DailiesDAY <= 2)) then
			HOLIDAY_TITLE = "Hallow's End"
			self.db.char.Filters["Holiday"] = false; ShowSeasonal = true; DailiesGroups["Holiday"]["ValueMax"] = 1
			DailyQuestsList[L["Call the Headless Horseman"]] = {icon = "Interface\\Icons\\INV_Misc_Bag_28_Halloween", group = "Holiday", SID = "Holiday:0", dates = {starting = "10/18", ending = "11/02"},  gold = 7500}
		
		else
			self.db.char.Filters["Holiday"] = true; ShowSeasonal = false
		end
		HolidayCounter = 1
	else
		return
	end
end -- function DailiesSeasonal

-- Check to see if USER wants unfolding of groups and unfold when necessary
function Dailies:ZONE_CHANGED()
	if self.db.char.LocationShow == true then
		if (Tablet20Frame) and (Tablet20Frame:IsVisible()) then
			return
		else
		
			local DailiesZoneName = GetRealZoneText(); local DailiesSubZoneName = GetSubZoneText();
			local DailiesInInstance, DailiesInstanceType = IsInInstance(); local DailiesDifficulty = GetInstanceDifficulty()
					
			for GroupName, GroupText in pairsByKeys (DailiesGroups) do
				self.db.profile.hideDetails[DailiesGroups[GroupName]["group"]] = true
			end
			
			for index, value in pairs (Dailies.db.char.DailyQuestsAccepted) do
				if DailyQuestsList[index]["area"] then
					if (DailyQuestsList[index]["area"] == DailiesZoneName) or (DailyQuestsList[index]["qzone"] == DailiesZoneName) then
						self.db.profile.hideDetails[DailyQuestsList[index]["group"]] = false
					end
				end
			end
			
			if DailiesInInstance and DailiesInstanceType == "pvp"  then
				self.db.profile.hideDetails["BGPvP"] = false
			end		
			
			if DailiesInInstance then
				if (DailiesInstanceType == "party") and (DailiesDifficulty == 2) then
					for index, value in pairs (Dailies.db.char.DailyQuestsAccepted) do
						if DailyQuestsList[index]["area"] then
							if DailyQuestsList[index]["area"] == DailiesZoneName then
								self.db.profile.hideDetails["DInstance"] = false
							end
							
							if DailyQuestsList[index]["area"] == DailiesZoneName then
								self.db.profile.hideDetails["HInstance"] = false
							end
						end
					end
				end
			else
				if (DailiesInstanceType == "party") and (DailiesDifficulty == 1) then
					for index, value in pairs (Dailies.db.char.DailyQuestsAccepted) do
						if DailyQuestsList[index]["area"] then
							if DailyQuestsList[index]["area"] == DailiesZoneName then
								self.db.profile.hideDetails["DInstance"] = false
							end
						end
					end
				end
			end
		end
	end
end -- function ZONE_CHANGED

function Dailies:VARIABLES_LOADED()
	DailiesTooltips:BuildTooltips()
end -- function VARIABLES_LOADED

-- Check to see if Fubar is loaded
function Dailies:ADDON_LOADED(arg1)
	if (arg1 == "LibFuBarPlugin-3.0") or (arg1 == "LibFuBarPlugin-2.0") then
		LibRockFuBar = true
		if (LibRockFuBar == true) then
			Dailies:Debug("FuBar Plugin loaded!")
			if (FuBar.db.profile.tooltip.fontSizePercent == 1) then
				FuBar.db.profile.tooltip.fontSizePercent = 1.01
			end	
			
			MENU_OFFSET = -5;
			FONTSIZE_NORMAL = floor(Tablet:GetNormalFontSize() * FuBar.db.profile.tooltip.fontSizePercent)
			FONTSIZE_LARGE = floor(Tablet:GetNormalFontSize() * FuBar.db.profile.tooltip.fontSizePercent) + 2
			FONTSIZE_SMALL = floor(Tablet:GetNormalFontSize() * FuBar.db.profile.tooltip.fontSizePercent) - 2
		else
			MENU_OFFSET = 0
			FONTSIZE_NORMAL = floor(Tablet:GetNormalFontSize() * Tablet:GetFontSizePercent(Minimap))
			FONTSIZE_LARGE = floor(Tablet:GetNormalFontSize() * Tablet:GetFontSizePercent(Minimap)) + 2
			FONTSIZE_SMALL = floor(Tablet:GetNormalFontSize() * Tablet:GetFontSizePercent(Minimap)) - 2
		end
	end
	
	if (arg1 == "TomTom") then
		Dailies:Debug("TomTom Plugin loaded!")
		TOMTOM_LOADED = true
	end
	
	if (arg1 == "Cartographer_Waypoints") then
		Dailies:Debug("Cartographer_Waypoints Plugin loaded!")
		CARTOGRAPH_LOADED = true
	end
 end -- function ADDON_LOADED
 
 -- Hack for when someone Abandons a daily, so we can reset it in the FuBar tooltip
function Dailies:AbandonedQuest(AbandonedName)
	for QuestNameHolder, NilHolder in pairs (self.db.char.DailyQuestsAccepted) do
		DailiesGroups[DailyQuestsList[QuestNameHolder]["group"]].Accepted = 0
	end
	
	for index, value in pairs (Dailies.db.char.DailyQuestsAccepted) do
		if index == AbandonedName then
			Dailies.db.char.DailyQuestsAccepted[index] = nil;
			Dailies.db.char.DailyQuestsObjectives[index] = nil;
		end
	end
	Dailies:QuestAccepted()
end -- function AbandonedQuest

-- Gold Sorter
function goldByKeys (t, f)
	local TempHolder = {}
	for n in pairs (t) do 
		table.insert (TempHolder, n) 
	end
	
	table.sort(TempHolder, function(a, b)
		if t[a]["gold"] == t[b]["gold"] then
			return a < b
		else
			return (t[a]["gold"] or 0) > (t[b]["gold"] or 0)
		end
	end)
		
	local i = 0
	return function ()
	i = i + 1
	return TempHolder[i], t[TempHolder[i]]
	end
end -- function goldByKeys

-- Title Sorter
function pairsByKeys (t, f)
	local TempHolder = {}
	for n in pairs (t) do 
		table.insert (TempHolder, n) 
	end
	table.sort (TempHolder, f)
	local i = 0
	return function ()
	i = i + 1
	return TempHolder[i], t[TempHolder[i]]
	end
end -- function pairByKeys

-- Checks to see if the USER has finished all the objectives in a quest
function Dailies:QuestObjectives(QuestNameObjectives, QID)
	if Dailies.db.char.DailyQuestsAccepted[QuestNameObjectives] then
		Dailies.db.char.DailyQuestsObjectives[QuestNameObjectives] = "Turn-In"
		if DailyQuestsList[QuestNameObjectives]["coords"] then
			if DailyQuestsList[QuestNameObjectives]["qszone"] == "Nil" then
				self:Pour("Turn in " .. DailyQuestsList[QuestNameObjectives].link .. " to " .. Crayon:Green(DailyQuestsList[QuestNameObjectives]["qgiver"]) .. "\n" .. Crayon:White(DailyQuestsList[QuestNameObjectives]["qzone"]), nil, nil, nil, nil, nil, nil, nil, "NOTIFY", DailyQuestsList[QuestNameObjectives]["icon"])
			else
				self:Pour("Turn in " .. DailyQuestsList[QuestNameObjectives].link .. " to " .. Crayon:Green(DailyQuestsList[QuestNameObjectives]["qgiver"]) .. "\n" .. Crayon:White(DailyQuestsList[QuestNameObjectives]["qszone"]) .. Crayon:Silver(", ") .. Crayon:White(DailyQuestsList[QuestNameObjectives]["qzone"]), nil, nil, nil, nil, nil, nil, nil, "NOTIFY", DailyQuestsList[QuestNameObjectives]["icon"])		
			end
		end
	end
end -- function QuestObjectives

-- addon, text, r, g, b, font, size, outline, sticky, loc, icon

-- Check for EVENT triggers
function Dailies:DailiesQuest_Tracker(msg)
	-- /script Dailies:DailiesQuest_Tracker("You can complete 25 daily quests today.")
	-- /script Dailies:DailiesQuest_Tracker("Quest accepted: Super Hot Stew")
	-- /script Dailies:DailiesQuest_Tracker("Quest accepted: Felblood Fillet")
	-- /script Dailies:DailiesQuest_Tracker("You are now Neutral with Ogri'la.")
	
	_, ChatFrameFontSize, _, _, _, _, _, _, _ = GetChatWindowInfo(1)
	local QuestNameCompleted = Deformat(msg, ERR_QUEST_COMPLETE_S)
	local QuestNameAccepted = Deformat(msg, ERR_QUEST_ACCEPTED_S)
	local DailiesQuestReset = Deformat(msg, DAILY_QUESTS_REMAINING)
	local DailiesFactionChanged, DailiesFactionName = Deformat(msg, FACTION_STANDING_CHANGED)
	
	
	if DailiesQuestReset == GetMaxDailyQuests() then
		Dailies:Debug(L["Dailies Have Reset!"])
		ResetText = Crayon:Green(L["Dailies have reset for the day."])
		DEFAULT_CHAT_FRAME:AddMessage (" |TInterface\\Addons\\DailiesQuestTracker\\Icons\\Reset.tga:" .. ChatFrameFontSize .. "|t" .. ResetText); 
		self:Pour(ResetText, nil, nil, nil, nil, nil, nil, nil, "NOTIFY", "Interface\\Addons\\DailiesQuestTracker\\Icons\\Reset.tga")
		self.db.char.DailyQuestsCompleted = {};
		DailyHInstance = nil; DailyDInstance = nil; DailyCooking = nil; DailyFishing = nil; DailyBGPvP = nil;
		DailiesCommHolder = {};
		self.db.char.GroupValues = {
			["BGPvP"] = 0,
			["Cooking"] = 0,
			["Fishing"] = 0,
			["Holiday"] = 0,
			["HInstance"] = 0,			
			["DInstance"] = 0,
			["Netherwing"] = 0,
			["Ogri'la"] = 0,
			["Sha'tari Skyguard"] = 0,
			["Shattered Sun Offensive"] = 0,
			["World PvP"] = 0,			
		}

		if Dailies.db.server.chars then
			for UnitName in pairs (Dailies.db.server.chars) do
				for UnitQuest in pairs (Dailies.db.server.chars[UnitName].UnitCompleted) do
					Dailies.db.server.chars[UnitName].UnitCompleted[UnitQuest] = nil
				end
			end
		end
	end

	
	if DailiesFactionChanged then
		Dailies:UpdateTheReputation()
		StatusColorized = Crayon:Colorize(RGBPercToHex(RepFactionColors[RepFactionsHolder[DailiesFactionName]].r,
														RepFactionColors[RepFactionsHolder[DailiesFactionName]].g,
														RepFactionColors[RepFactionsHolder[DailiesFactionName]].b ),
														RepFactionColors[RepFactionsHolder[DailiesFactionName]].title)
														
		FactionColorized = Crayon:Colorize(RGBPercToHex(RepFactionColors[RepFactionsHolder[DailiesFactionName]].r,
														RepFactionColors[RepFactionsHolder[DailiesFactionName]].g,
														RepFactionColors[RepFactionsHolder[DailiesFactionName]].b ),
														DailiesFactionName)																									
														
		self:Pour("You are now " .. StatusColorized .. " with " .. FactionColorized, nil, nil, nil, nil, nil, nil, true, "NOTIFY", RepFactionColors[RepFactionsHolder[DailiesFactionName]].icon)
	end
	
	if QuestNameAccepted then
		for QuestNameHolder in pairs (self.db.char.DailyQuestsAccepted) do
			DailiesGroups[DailyQuestsList[QuestNameHolder]["group"]].Accepted = 0
		end
		
		for QuestAcceptedIndex, QuestAcceptedValue in pairs(DailyQuestsList) do
			if (QuestNameAccepted == QuestAcceptedIndex) then
				Dailies:Debug(L["Quest Accepted!"])
				local QuestHour, QuestMinute = GetGameTime(); local TwentyFourTime = QuestHour .. ":" .. QuestMinute; QuestTimeAccepted = TwentyFourTime
				Dailies.db.char.DailyQuestsAccepted[QuestNameAccepted] = QuestTimeAccepted
				
				if self.db.char.TimeFormat == "Standard" then
					local QuestPM = floor(QuestHour / 12) == 1; QuestHour = mod(QuestHour, 12); if QuestHour == 0 then QuestHour = 12 end;
					local QuestTime = string.format("%d" .. Crayon:Gold(":") .. "%02d" .. Crayon:Gold(" %s"), QuestHour, QuestMinute, QuestPM and "PM" or "AM");
					self:Pour(DailyQuestsList[QuestNameAccepted].link .. L[" accepted at "] .. QuestTime, nil, nil, nil, nil, nil, nil, nil, "NOTIFY", DailyQuestsList[QuestNameAccepted]["icon"])
				else
					local QuestTime = QuestHour .. Crayon:Gold(":") .. QuestMinute
					self:Pour(DailyQuestsList[QuestNameAccepted].link .. L[" accepted at "] .. QuestTime, nil, nil, nil, nil, nil, nil, nil, "NOTIFY", DailyQuestsList[QuestNameAccepted]["icon"])
				end
				
				Dailies.db.server.UnitTrackerValid = 1
				Dailies:QuestAccepted()
				Dailies:Debug(DailyQuestsList[QuestAcceptedIndex]["group"] .. " accepted value is " .. DailiesGroups[DailyQuestsList[QuestAcceptedIndex]["group"]].Accepted)
				Dailies:ZONE_CHANGED()
			end
		end
	end
	
	if QuestNameCompleted then
		for QuestNameHolder in pairs (self.db.char.DailyQuestsAccepted) do
			DailiesGroups[DailyQuestsList[QuestNameHolder]["group"]].Accepted = 0
		end
		
		for QuestCompletedIndex, QuestCompletedValue in pairs(DailyQuestsList) do
			if (QuestNameCompleted == QuestCompletedIndex) then
				Dailies:Debug(L["Quest Completed!"])
				local QuestHour, QuestMinute = GetGameTime(); local TwentyFourTime = QuestHour .. ":" .. QuestMinute; QuestTimeCompleted = TwentyFourTime; local UnitCompleteTime = DailiesNumberDate .. ":" .. TwentyFourTime
				
				if self.db.char.TimeFormat == "Standard" then
					local QuestPM = floor(QuestHour / 12) == 1; QuestHour = mod(QuestHour, 12); if QuestHour == 0 then QuestHour = 12 end;
					local QuestTime = string.format("%d" .. Crayon:Gold(":") .. "%02d" .. Crayon:Gold(" %s"), QuestHour, QuestMinute, QuestPM and "PM" or "AM");
					self:Pour(DailyQuestsList[QuestNameCompleted].link .. L[" completed at "] .. QuestTime, nil, nil, nil, nil, nil, nil, nil, "NOTIFY", DailyQuestsList[QuestNameCompleted]["icon"])
				else
					local QuestTime = QuestHour .. Crayon:Gold(":") .. QuestMinute
					self:Pour(DailyQuestsList[QuestNameCompleted].link .. L[" completed at "] .. QuestTime, nil, nil, nil, nil, nil, nil, nil, "NOTIFY", DailyQuestsList[QuestNameCompleted]["icon"])
				end
				
				Dailies.db.char.DailyQuestsCompleted[QuestNameCompleted] = UnitCompleteTime; Dailies.db.char.DailyQuestsAccepted[QuestNameCompleted] = nil; Dailies.db.char.DailyQuestsObjectives[QuestNameCompleted] = nil; Dailies.db.server.chars[UnitName("player")].UnitCompleted[QuestNameCompleted] = UnitCompleteTime
				Dailies:QuestAccepted()
				Dailies:QuestValue(QuestNameCompleted)
				Dailies:Debug(DailyQuestsList[QuestNameCompleted]["group"] .. " accepted value is " .. DailiesGroups[DailyQuestsList[QuestNameCompleted]["group"]].Accepted)
				Dailies:ZONE_CHANGED()
			end
		end
	end
end -- function DailiesQuest_Tracker

-- Holder and Counter for Accepted Quests
function Dailies:QuestAccepted()
	for QuestNameHolderNiller in pairs (self.db.char.DailyQuestsAccepted) do
		DailiesGroups[DailyQuestsList[QuestNameHolderNiller]["group"]].Accepted = 0
	end
	
	for QuestNameHolder in pairs (self.db.char.DailyQuestsAccepted) do
		if DailyQuestsList[QuestNameHolder]["group"] == "Cooking" then
			DailiesGroups["Cooking"].Accepted = DailiesGroups["Cooking"].Accepted + 1
			
		elseif DailyQuestsList[QuestNameHolder]["group"] == "Shattered Sun Offensive" then
			DailiesGroups["Shattered Sun Offensive"].Accepted = DailiesGroups["Shattered Sun Offensive"].Accepted + 1
			
		elseif DailyQuestsList[QuestNameHolder]["group"] == "World PvP" then
			DailiesGroups["World PvP"].Accepted = DailiesGroups["World PvP"].Accepted + 1
			
		elseif DailyQuestsList[QuestNameHolder]["group"] == "Fishing" then
			DailiesGroups["Fishing"].Accepted = DailiesGroups["Fishing"].Accepted + 1
			
		elseif DailyQuestsList[QuestNameHolder]["group"] == "Netherwing" then
			DailiesGroups["Netherwing"].Accepted = DailiesGroups["Netherwing"].Accepted + 1
			
		elseif DailyQuestsList[QuestNameHolder]["group"] == "Ogri'la" then
			DailiesGroups["Ogri'la"].Accepted = DailiesGroups["Ogri'la"].Accepted + 1
			
		elseif DailyQuestsList[QuestNameHolder]["group"] == "Sha'tari Skyguard" then
			DailiesGroups["Sha'tari Skyguard"].Accepted = DailiesGroups["Sha'tari Skyguard"].Accepted + 1
			
		elseif DailyQuestsList[QuestNameHolder]["group"] == "Holiday" then
			DailiesGroups["Holiday"].Accepted = DailiesGroups["Holiday"].Accepted + 1

		elseif DailyQuestsList[QuestNameHolder]["group"] == "BGPvP" then
			DailiesGroups["BGPvP"].Accepted = DailiesGroups["BGPvP"].Accepted + 1			

		elseif DailyQuestsList[QuestNameHolder]["group"] == "DInstance" then
			DailiesGroups["DInstance"].Accepted = DailiesGroups["DInstance"].Accepted + 1

		elseif DailyQuestsList[QuestNameHolder]["group"] == "HInstance" then
			DailiesGroups["HInstance"].Accepted = DailiesGroups["HInstance"].Accepted + 1
		end
	end
	return
end -- function QuestAccepted

-- Holder and Counter for groups counts
function Dailies:QuestValue(QuestName)
	Dailies:Debug(L["Adding Group Values!"])
	CookingValue = Dailies.db.char.GroupValues["Cooking"]
	if DailyQuestsList[QuestName]["group"] == "Cooking" then CookingValue = CookingValue + 1 end; Dailies.db.char.GroupValues["Cooking"] = CookingValue
	
	WorldPvPValue = Dailies.db.char.GroupValues["World PvP"]
	if DailyQuestsList[QuestName]["group"] == "World PvP" then WorldPvPValue = WorldPvPValue + 1 end; Dailies.db.char.GroupValues["World PvP"] = WorldPvPValue

	FishingValue = Dailies.db.char.GroupValues["Fishing"]
	if DailyQuestsList[QuestName]["group"] == "Fishing" then FishingValue = FishingValue + 1 end; Dailies.db.char.GroupValues["Fishing"] = FishingValue	
	
	NetherwingValue = Dailies.db.char.GroupValues["Netherwing"]
	if DailyQuestsList[QuestName]["group"] == "Netherwing" then NetherwingValue = NetherwingValue + 1 end; Dailies.db.char.GroupValues["Netherwing"] = NetherwingValue
	
	SSOValue = Dailies.db.char.GroupValues["Shattered Sun Offensive"]
	if DailyQuestsList[QuestName]["group"] == "Shattered Sun Offensive" then SSOValue = SSOValue + 1 end; Dailies.db.char.GroupValues["Shattered Sun Offensive"] = SSOValue

	OgrilaValue = Dailies.db.char.GroupValues["Ogri'la"]
	if DailyQuestsList[QuestName]["group"] == "Ogri'la" then OgrilaValue = OgrilaValue + 1 end; Dailies.db.char.GroupValues["Ogri'la"] = OgrilaValue
		
	SkyguardValue = Dailies.db.char.GroupValues["Sha'tari Skyguard"]
	if DailyQuestsList[QuestName]["group"] == "Sha'tari Skyguard" then SkyguardValue = SkyguardValue + 1 end; Dailies.db.char.GroupValues["Sha'tari Skyguard"] = SkyguardValue
	
	HolidayValue = Dailies.db.char.GroupValues["Holiday"]
	if DailyQuestsList[QuestName]["group"] == "Holiday" then HolidayValue = HolidayValue + 1 end; Dailies.db.char.GroupValues["Holiday"] = HolidayValue	

	BGPvPValue = Dailies.db.char.GroupValues["BGPvP"]
	if DailyQuestsList[QuestName]["group"] == "BGPvP" then BGPvPValue = BGPvPValue + 1 end; Dailies.db.char.GroupValues["BGPvP"] = BGPvPValue	

	DInstanceValue = Dailies.db.char.GroupValues["DInstance"]
	if DailyQuestsList[QuestName]["group"] == "DInstance" then DInstanceValue = DInstanceValue + 1 end; Dailies.db.char.GroupValues["DInstance"] = DInstanceValue	

	HInstanceValue = Dailies.db.char.GroupValues["HInstance"]
	if DailyQuestsList[QuestName]["group"] == "HInstance" then HInstanceValue = HInstanceValue + 1 end; Dailies.db.char.GroupValues["HInstance"] = HInstanceValue		
end -- function QuestValue

function Dailies:DailiesUpdate()
	DQMax = GetMaxDailyQuests();
	DQComplete = GetDailyQuestsCompleted();
	Dailies:Update()
end -- function DailiesUpdate

-- Turns on Comms
function Dailies:TurnOnComms()
	if (self.db.char.DailyCommSet == false) then
		return
	else
	Dailies:RegisterComm(Dailies.CommPrefix, "GLOBAL")
	Dailies:RegisterComm(Dailies.CommPrefix, "WHISPER")
	Dailies:ScheduleRepeatingEvent("SendTheDailies", 15)
	
	_, ChatFrameFontSize, _, _, _, _, _, _, _ = GetChatWindowInfo(1)
	CommIcon = format(TEXTURE_LINK_FORMAT, "Interface\\Addons\\DailiesQuestTracker\\Icons\\Comm.tga", ChatFrameFontSize, ChatFrameFontSize, 0)
	CommText = Crayon:Green(L[" You have joined the GLOBAL AceComm channel."])
	DEFAULT_CHAT_FRAME:AddMessage (CommIcon .. CommText);		
	end
end -- function TurnOnComms

function Dailies:OnEnable()	
	DQComplete = GetDailyQuestsCompleted();
	DQMax = GetMaxDailyQuests();
		
	if DQComplete == 0 then
		self.db.char.DailyQuestsCompleted = {};
		self.db.char.GroupValues = {
			["BGPvP"] = 0,
			["Cooking"] = 0,
			["Fishing"] = 0,
			["Holiday"] = 0,
			["HInstance"] = 0,
			["DInstance"] = 0,			
			["Netherwing"] = 0,
			["Ogri'la"] = 0,
			["Sha'tari Skyguard"] = 0,
			["Shattered Sun Offensive"] = 0,
			["World PvP"] = 0,
		}
	end
	
	hour, minute = GetGameTime();
	DQStartHour = hour;
	DQStartMiniute = minute;
	SetDailyCommSet = self.db.char.DailyCommSet;
	Dailies:ScheduleEvent("TurnOnComms", self.db.profile.AceCommDelay)
end -- function OnEnable

function Dailies:UpdateTheReputation()
	ReputationCounter = nil
	Dailies:ExpandTheReputation()
end -- function UpdateTheReputation

function Dailies:ExpandTheReputation()
	Dailies:Debug ("Reputation Updated!")
	for i = 1, GetNumFactions() do
		local FactionName, _, StandingID, BottomValue, TopValue, EarnedValue, _, _, isHeader, isCollapsed = GetFactionInfo(i)

		RepFactionsHolder[FactionName] = StandingID
		
		if RepValuesHolder[FactionName] then
			RepValuesHolder[FactionName].title = RepFactionColors[StandingID].title
			RepValuesHolder[FactionName].StandingID = StandingID
			RepValuesHolder[FactionName].ReputationIs = (EarnedValue - BottomValue)
			RepValuesHolder[FactionName].ReputationMax = (TopValue - BottomValue)
			RepValuesHolder[FactionName].ReputationAbsolute = EarnedValue
		end
		
		if isHeader == 1 then
			if isCollapsed == 1 then
				local NumFactions = GetNumFactions()
				ExpandFactionHeader(i)
				NumFactions = GetNumFactions() - NumFactions
				for j = i+1, i+NumFactions do
					local FactionName, _, StandingID, BottomValue, TopValue, EarnedValue = GetFactionInfo(j)
					
					if RepValuesHolder[FactionName] then
						RepValuesHolder[FactionName].title = RepFactionColors[StandingID].title
						RepValuesHolder[FactionName].StandingID = StandingID
						RepValuesHolder[FactionName].ReputationIs = (EarnedValue - BottomValue)
						RepValuesHolder[FactionName].ReputationMax = (TopValue - BottomValue)
						RepValuesHolder[FactionName].ReputationAbsolute = EarnedValue
					end
					
					RepFactionsHolder[FactionName] = StandingID		
				end
				CollapseFactionHeader(i)
			end
		end				

		-- The Deadliest Trap Ever Laid (Scryer or Aldor version)
		if (RepFactionsHolder["The Scryers"]) and (RepFactionsHolder["The Scryers"] >= 4) then
				DailyQuestsList[L["The Deadliest Trap Ever Laid"]] = {icon = "Interface\\Icons\\Ability_Warrior_EndlessRage", link = "|cffffff00|Hquest:11097:70|h[The Deadliest Trap Ever Laid]|h|r", coords ="56:69", qgiver = "Commander Hobb", qzone = "Shadowmoon Valley", qszone = "Sanctum of the Stars", area = BZ["Shadowmoon Valley"], group = "Netherwing", SID = "Netherwing:7", ["rep"] = {BF["Netherwing"]..":500"}, gold = 182800}
		end

		if (RepFactionsHolder["The Aldor"]) and (RepFactionsHolder["The Aldor"] >= 4) then
				DailyQuestsList[L["The Deadliest Trap Ever Laid"]] = {icon = "Interface\\Icons\\Ability_Warrior_EndlessRage", link = "|cffffff00|Hquest:11101:70|h[The Deadliest Trap Ever Laid]|h|r", coords ="62.388:29.289", qgiver = "Commander Arcus", qzone = "Shadowmoon Valley", qszone = "Altar of Sha'tar", area = BZ["Shadowmoon Valley"], group = "Netherwing", SID = "Netherwing:7", ["rep"] = {BF["Netherwing"]..":500"}, gold = 182800}
		end
		
		-- Hellfire World PvP that requires Reputation
		if englishFaction == "Alliance" then
			if (RepFactionsHolder["Honor Hold"]) and (RepFactionsHolder["Honor Hold"] >= 4) then
				DailyQuestsList[L["Hellfire Fortifications"]] = {icon = "Interface\\Icons\\INV_Misc_Token_HonorHold", link = "|cffffff00|Hquest:10106:60|h[Hellfire Fortifications]|h|r", coords ="56.330:62.846", qgiver = "Warrant Officer Tracy Proudwell", qzone = "Hellfire Peninsula", qszone = "Honor Hold", group = "World PvP", loc = BZ["Hellfire Peninsula"], area = BZ["Hellfire Peninsula"], SID = "Honor Hold:4", ["rep"] = {BF["Honor Hold"]..":150"}, ["rewards"] = {"24579:3"}, gold = 11350}
				DailiesGroups["World PvP"]["ValueMax"] = 3
			end
		elseif englishFaction == "Horde" then
			if (RepFactionsHolder["Thrallmar"]) and (RepFactionsHolder["Thrallmar"] >= 4) then
				DailyQuestsList[L["Hellfire Fortifications"]] = {icon = "Interface\\Icons\\INV_Misc_Token_Thrallmar", link = "|cffffff00|Hquest:10110:70|h[Hellfire Fortifications]|h|r", coords ="55.9:39.1", qgiver = "Battlecryer Blackeye", qzone = "Hellfire Peninsula", qszone = "Thrallmar", group = "World PvP", loc = BZ["Hellfire Peninsula"], area = BZ["Hellfire Peninsula"], SID = "Thrallmar:4", ["rep"] = {BF["Thrallmar"]..":150"}, ["rewards"] = {"24581:3"}, gold = 11350}		
				DailiesGroups["World PvP"]["ValueMax"] = 3
			end
		end	
	end
end -- function ExpandTheReputation

-- Gets the Members in the AceComm Channel to communicate the known Random Dailies
function Dailies:GetChannelMembers()
	channelCount = GetNumDisplayChannels();
	
	for i=1, channelCount do
		channel, header, collapsed, channelNumber, count, active, category = GetChannelDisplayInfo(i);
		
		if (count) and (table.getn(DailiesRoster) ~= count) then
			GrabbedChannelList = false
		else
			GrabbedChannelList = true
		end
							
		if (count) then
			if (channel == "AceComm") then	
				if (GrabbedChannelList == false) then
					DailiesRoster = {}
					SetSelectedDisplayChannel(i)
					
					for y=1, count do
						local name, owner, moderator, muted, voiceEnabled = GetChannelRosterInfo(GetSelectedDisplayChannel(), y)
						DailiesRoster[y] = name
					end
				end
			end
		end
	end
end -- function GetChannelMembers

-- Sends the known Random Dailies
function Dailies:SendTheDailies()
	if DailyHInstance then
		Dailies:SendTheQuest("HInstance", DailiesCommHolder["HInstance"])
	end

	if DailyDInstance then
		Dailies:SendTheQuest("DInstance", DailiesCommHolder["DInstance"])
	end

	if DailyCooking then
		Dailies:SendTheQuest("Cooking", DailiesCommHolder["Cooking"])
	end

	if DailyFishing then
		Dailies:SendTheQuest("Fishing", DailiesCommHolder["Fishing"])
	end

	if DailyBGPvP then
		Dailies:SendTheQuest("BGPvP", DailiesCommHolder["BGPvP"])
	end	
	
	Dailies:SendTheUser("MEMBER", UnitName("player"))
end -- function SendTheDailies

-- Send the USER to see if they are using DQT
function Dailies:SendTheUser(CommUser, SenderName)
	for i = 1, table.getn(DailiesRoster) do
		if AceLibrary("AceComm-2.0"):IsUserInChannel(DailiesRoster[i], "GLOBAL") then
			Dailies:SendCommMessage("WHISPER", DailiesRoster[i], CommUser, SenderName)
		end
	end
end -- function SendTheUser

-- Send the Random Dailies to Unique Users
function Dailies:SendTheQuest(Instance, questName)
	for i = 1, table.getn(self.UniqueNames) do
		if (self.UniqueNames[i] and self.UniqueNames[i] ~= UnitName("player")) then
			if AceLibrary("AceComm-2.0"):IsUserInChannel(self.UniqueNames[i], "GLOBAL") then
				Dailies:Debug (L["Sending Dailies to: "] .. self.UniqueNames[i])
				Dailies:SendCommMessage("WHISPER", self.UniqueNames[i], Instance, questName)
			else
				Dailies:Debug(L["Removing User: "] .. self.UniqueNames[i])
				table.remove(self.UniqueNames, i);
			end
		end
	end
end -- function SendTheQuest

-- Grab unique users for DQT
function Dailies:GetUniqueNames(SenderName)
	local doInsert = true;
	for i=1,table.getn(self.UniqueNames) do
		if self.UniqueNames[i] == SenderName then
			doInsert = false;
		end
	end	
	
	if doInsert then
		table.insert(self.UniqueNames, SenderName);
	end
end -- function GetUniqueUsers

-- Receives the dailies and collects the information
function Dailies.OnCommReceive:HInstance (prefix, sender, distribution, questName)
	Dailies:Debug ("Heroic Daily from: " .. sender)
	DailiesCommHolder["HInstance"] = questName; DailyHInstance = questName; DailiesKnown = true;
end -- function Dailies.OnCommReceive:HInstance

function Dailies.OnCommReceive:DInstance (prefix, sender, distribution, questName)
	Dailies:Debug ("Dungeon Daily from: " .. sender)
	DailiesCommHolder["DInstance"] = questName; DailyDInstance = questName; DailiesKnown = true;
end -- function Dailies.OnCommReceive:DInstance

function Dailies.OnCommReceive:Cooking (prefix, sender, distribution, questName)
	Dailies:Debug (GetSpellInfo(2550) .. " Daily from: " .. sender)
	DailiesCommHolder["Cooking"] = questName; DailyCooking = questName; DailiesKnown = true;
end -- function Dailies.OnCommReceive:Cooking

function Dailies.OnCommReceive:Fishing (prefix, sender, distribution, questName)
	Dailies:Debug (GetSpellInfo(7620) .. " Daily from: "  .. sender)
	DailiesCommHolder["Fishing"] = questName; DailyFishing = questName; DailiesKnown = true;
end -- function Dailies.OnCommReceive:Fishing

function Dailies.OnCommReceive:BGPvP (prefix, sender, distribution, questName)
	Dailies:Debug ("Battleground Daily from: " .. sender)
	DailiesCommHolder["BGPvP"] = questName; DailyBGPvP = questName; DailiesKnown = true;
end -- function Dailies.OnCommReceive:BGPvP

function Dailies.OnCommReceive:MEMBER (prefix, sender, distribution, UserName)
	local doInsert = true;
	for i=1,table.getn(self.UniqueNames) do
		if self.UniqueNames[i] == UserName then
			doInsert = false;
		end
	end	
	
	if doInsert then
		table.insert(self.UniqueNames, UserName);
		Dailies:Debug(L["Adding User: "] .. UserName)
	end
end -- function Dailies.OnCommReceive:MEMBER

-- Check if aquired new tradeskills and update gathering quests you can do
function Dailies:CHAT_MSG_SKILL(msg)
	local TradeskillGained = Deformat(msg, ERR_SKILL_GAINED_S)
	if TradeskillGained ==  GetSpellInfo(8613) or TradeskillGained == GetSpellInfo(2575) or TradeskillGained == GetSpellInfo(9134) then
		SSOCounter = 0;	TradeskillCounter = 0
		hasHerbalism = nil; hasMining = nil; hasSkinning = nil;
		Dailies:PLAYER_ALIVE()
	end
end -- function CHAT_MSG_SKILL

-- Cycle through Tradeskills
function Dailies:PLAYER_ALIVE()
	DQMax = GetMaxDailyQuests();
	DQComplete = GetDailyQuestsCompleted();
	numSkills = GetNumSkillLines();

	if TradeskillCounter == 0 then
		for i=1, numSkills do
			skillName, _, _, skillRank, _, _, _, _, _, _, _, _, _ = GetSkillLineInfo(i)
			DailiesTradeskills[skillName] = skillRank
			
			if skillName == GetSpellInfo(9134) then
				DailyQuestsList[L["Gaining the Advantage"]] = {icon = "Interface\\Icons\\INV_MISC_DUST_03", link = "|cffffff00|Hquest:11875:70|h[Gaining the Advantage]|h|r", coords = "62.811:35.576", qgiver = "Emissary Mordin", qzone = "Shattrath City", qszone = "Terrace of Light", group = "Shattered Sun Offensive", area = BZ["Outland"], SID = "Shattered Sun Offensive:4", ["rep"] = {BF["Shattered Sun Offensive"]..":250"}, ["rewards"] = {"18253:1"}, gold = 163900}
				DailyQuestsList[L["Netherdust Pollen"]] = {icon = "Interface\\Icons\\INV_Enchant_DustSoul", link = "|cffffff00|Hquest:11017:70|h[Netherdust Pollen]|h|r", coords ="66:86", qgiver = "Taskmaster Varkule Dragonbreath", qzone = "Shadowmoon Valley", qszone = "Dragonmaw Base Camp", group = "Netherwing", area = BZ["Shadowmoon Valley"], SID = "Netherwing:4", prof = GetSpellInfo(9134), ["rep"] = {BF["Netherwing"]..":250"}, gold = 119900} --Herbalism
				DailiesGroups["Netherwing"]["ValueMax"] = DailiesGroups["Netherwing"]["ValueMax"] + 1
				hasHerbalism = GetSpellInfo(9134);
			elseif skillName == GetSpellInfo(2575) then
				DailyQuestsList[L["Gaining the Advantage"]] = {icon = "Interface\\Icons\\INV_MISC_DUST_03", link = "|cffffff00|Hquest:11875:70|h[Gaining the Advantage]|h|r", coords = "62.811:35.576", qgiver = "Emissary Mordin", qzone = "Shattrath City", qszone = "Terrace of Light", group = "Shattered Sun Offensive", area = BZ["Outland"], SID = "Shattered Sun Offensive:4", ["rep"] = {BF["Shattered Sun Offensive"]..":250"}, ["rewards"] = {"18253:1"}, gold = 163900}			
				DailyQuestsList[L["Nethercite Ore"]] = {icon = "Interface\\Icons\\INV_Ore_Ethernium_01", link = "|cffffff00|Hquest:11018:70|h[Nethercite Ore]|h|r", coords ="66:86", qgiver = "Taskmaster Varkule Dragonbreath", qzone = "Shadowmoon Valley", qszone = "Dragonmaw Base Camp", group = "Netherwing", area = BZ["Shadowmoon Valley"], SID = "Netherwing:4", prof = GetSpellInfo(2575), ["rep"] = {BF["Netherwing"]..":250"}, gold = 119900} --Mining
				DailiesGroups["Netherwing"]["ValueMax"] = DailiesGroups["Netherwing"]["ValueMax"] + 1
				hasMining = GetSpellInfo(2575);
			elseif skillName == GetSpellInfo(8613) then
				DailyQuestsList[L["Gaining the Advantage"]] = {icon = "Interface\\Icons\\INV_MISC_DUST_03", link = "|cffffff00|Hquest:11875:70|h[Gaining the Advantage]|h|r", coords = "62.811:35.576", qgiver = "Emissary Mordin", qzone = "Shattrath City", qszone = "Terrace of Light", group = "Shattered Sun Offensive", area = BZ["Outland"], SID = "Shattered Sun Offensive:4", ["rep"] = {BF["Shattered Sun Offensive"]..":250"}, ["rewards"] = {"18253:1"}, gold = 163900}
				DailyQuestsList[L["Nethermine Flayer Hide"]] = {icon = "Interface\\Icons\\INV_Misc_Rune_12", link = "|cffffff00|Hquest:11016:70|h[Gaining the Advantage]|h|r", coords ="66:86", qgiver = "Taskmaster Varkule Dragonbreath", qzone = "Shadowmoon Valley", qszone = "Dragonmaw Base Camp", group = "Netherwing", area = BZ["Shadowmoon Valley"], SID = "Netherwing:4", prof = GetSpellInfo(8613), ["rep"] = {BF["Netherwing"]..":250"}, gold = 119900}  --Skinning
				DailiesGroups["Netherwing"]["ValueMax"] = DailiesGroups["Netherwing"]["ValueMax"] + 1
				hasSkinning = GetSpellInfo(8613);
			end
			
			if SSOCounter == 0 then
				if (hasHerbalism or hasMining or hasSkinning) then
					DailiesGroups["Shattered Sun Offensive"]["ValueMax"] = DailiesGroups["Shattered Sun Offensive"]["ValueMax"] + 1
					SSOCounter = 1
				end
			end
			TradeskillCounter = 1
		end	
	end
end -- function PLAYER_ALIVE

-- FuBar Icon updates
function Dailies:OnTextUpdate()
	Dailies:SetIcon("Interface\\Addons\\DailiesQuestTracker\\Icons\\Numbers\\" .. (GetMaxDailyQuests() - GetDailyQuestsCompleted()) .. ".tga")
	
	DQColor = Crayon:GetThresholdHexColor((GetMaxDailyQuests() - GetDailyQuestsCompleted()), GetMaxDailyQuests())
	Dailies:SetText(" " .. Crayon:Colorize(DQColor, (GetMaxDailyQuests() - GetDailyQuestsCompleted())) .. "/" .. Crayon:Green(GetMaxDailyQuests()));
end -- function OnTextUpdate

-- Get Blizzards Dailies reset and break it apart
function Dailies:SecondsToTime(seconds, noSeconds, notAbbreviated)
	local time = "";
	local count = 0;
	local tempTime;
	seconds = floor(seconds);
	if ( seconds >= 86400  ) then
		tempTime = floor(seconds / 86400);
		if ( notAbbreviated ) then
			time = tempTime.." "..GetText("DAYS", nil, tempTime);
		else
			time = tempTime.." "..GetText("DAYS_ABBR", nil, tempTime);
		end
		seconds = mod(seconds, 86400);
		count = count + 1;
	end
	if ( seconds >= 3600  ) then
		if ( time ~= "" ) then
			time = time.." ";
		end
		tempTime = floor(seconds / 3600);
		if ( notAbbreviated ) then
			time = time..tempTime..":"
		else
			time = time..tempTime..":"
		end
		seconds = mod(seconds, 3600);
		count = count + 1;
	end
	if ( count < 2 and seconds >= 60  ) then
		if ( time ~= "" ) then
			time = time.." ";
		end
		tempTime = floor(seconds / 60);
		if ( notAbbreviated ) then
			time = time..tempTime..":"
		else
			time = time..tempTime..":"
		end
		seconds = mod(seconds, 60);
		count = count + 1;
	end
	if ( count < 2 and seconds > 0 and not noSeconds ) then
		if ( time ~= "" ) then
			time = time.." ";
		end
		seconds = format("%d", seconds);
		if ( notAbbreviated ) then
			time = time..seconds..":"
		else
			time = time..seconds..":"
		end
	end
	return time;
end -- function SecondsToTime


function Dailies:OnDataUpdate()
	DailesUnitsDATE = "%A:%B:%d:%Y"
	local A,B,d,Y = (":"):split(date(DailesUnitsDATE))	
	local QuestHour, QuestMinute = GetGameTime()
	local CheckMonth = tonumber(Calendar[B].no); CheckDay = tonumber(d)
	
	if self.db.char.DailyQuestsCompleted then
		for UnitQuest, UnitQuestTime in pairs (self.db.char.DailyQuestsCompleted) do
			local UnitMonth, UnitDay, UnitHour, UnitMinute = (":"):split(UnitQuestTime)
			local UnitMonth = tonumber(UnitMonth); local UnitDay = tonumber(UnitDay); local UnitHour = tonumber(UnitHour); local UnitMinute = tonumber(UnitMinute)
			--Dailies:Debug (UnitName("player") .. "'s Completed Quest: " .. UnitQuest .. " | " .. UnitMonth .. "/" .. UnitDay .. " " .. UnitHour .. ":" .. UnitMinute)
			
			if ((CheckMonth == 1) and (CheckDay == 1) and (UnitHour >= DailiesReset) and (QuestMinute >= 0)) or
			((CheckMonth > UnitMonth) and (UnitHour <= DailiesReset) and (QuestHour >= DailiesReset) and (QuestMinute >= 0)) or
			((CheckDay > UnitDay) and (UnitHour >= DailiesReset) and (QuestHour >= DailiesReset) and (QuestMinute >= 0)) or
			((CheckDay == UnitDay) and (UnitHour <= DailiesReset) and (QuestHour >= DailiesReset) and (QuestMinute >= 0)) then
				self.db.char.DailyQuestsCompleted[UnitQuest] = nil
				self.db.char.GroupValues[DailyQuestsList[UnitQuest].group] = self.db.char.GroupValues[DailyQuestsList[UnitQuest].group] - 1
				Dailies:Debug ("Cleared Completed Daily " .. UnitQuest)
			end
		end
	end
	
	if Dailies.db.server.chars then
		for UnitName in pairs (Dailies.db.server.chars) do
			for UnitQuest in pairs (Dailies.db.server.chars[UnitName].UnitCompleted) do
				local UnitMonth, UnitDay, UnitHour, UnitMinute = (":"):split(Dailies.db.server.chars[UnitName].UnitCompleted[UnitQuest])
				local UnitMonth = tonumber(UnitMonth); local UnitDay = tonumber(UnitDay); local UnitHour = tonumber(UnitHour); local UnitMinute = tonumber(UnitMinute)
				--Dailies:Debug (UnitName .. "'s Unit Quest: " .. UnitQuest .. " | " .. UnitMonth .. "/" .. UnitDay .. " " .. UnitHour .. ":" .. UnitMinute)

				if ((CheckMonth == 1) and (CheckDay == 1) and (QuestHour >= DailiesReset) and (QuestMinute >= 0)) or
				((CheckMonth > UnitMonth) and (UnitHour >= DailiesReset) and (QuestMinute >= 0)) or
				((CheckDay > UnitDay) and (UnitHour >= DailiesReset) and (QuestHour >= DailiesReset) and (QuestMinute >= 0)) or
				((CheckDay == UnitDay) and (UnitHour <= DailiesReset) and (QuestHour >= DailiesReset) and (QuestMinute >= 0)) then
					Dailies.db.server.chars[UnitName].UnitCompleted[UnitQuest] = nil
					Dailies:Debug ("Cleared " .. UnitName .. "'s " .. UnitQuest)
				end
			end
		end
	end

	Dailies:QuestAccepted()
end

function Dailies:OnTooltipUpdate()	
	Tablet:SetTitle(L[" Dailies for "] .. DailesDATE .. " ")
	englishFaction, _ = UnitFactionGroup("Player")
		
	if (LibRockFuBar == true) then
		if (FuBar.db.profile.tooltip.fontSizePercent) then
			if (FuBar.db.profile.tooltip.fontSizePercent == 1) then
				FuBar.db.profile.tooltip.fontSizePercent = 1.01
			end	
			
			MENU_OFFSET = -5;
			FONTSIZE_NORMAL = floor(Tablet:GetNormalFontSize() * FuBar.db.profile.tooltip.fontSizePercent)
			FONTSIZE_LARGE = floor(Tablet:GetNormalFontSize() * FuBar.db.profile.tooltip.fontSizePercent) + 2
			FONTSIZE_SMALL = floor(Tablet:GetNormalFontSize() * FuBar.db.profile.tooltip.fontSizePercent) - 2
		end
	else
		MENU_OFFSET = 0
		FONTSIZE_NORMAL = floor(Tablet:GetNormalFontSize() * Tablet:GetFontSizePercent(Minimap))
		FONTSIZE_LARGE = floor(Tablet:GetNormalFontSize() * Tablet:GetFontSizePercent(Minimap)) + 2
		FONTSIZE_SMALL = floor(Tablet:GetNormalFontSize() * Tablet:GetFontSizePercent(Minimap)) - 2
	end
	
	-- Grab the Seasonal Dailies only once
	Dailies:DailiesSeasonal()

	-- Set the Holiday Icon Titles
	if (HOLIDAY_TITLE == "Midsummer Fire Festival") then
		HolidayIcon = format(TEXTURE_LINK_FORMAT, "Interface\\Icons\\INV_Misc_TabardSummer02", FONTSIZE_NORMAL, FONTSIZE_NORMAL, 0)
		DailiesGroups["Holiday"].title = "Holiday: " .. "[" .. HolidayIcon .. Crayon:Orange(HOLIDAY_TITLE) .. "]"
	elseif (HOLIDAY_TITLE == "Brewfest") then
		HolidayIcon = format(TEXTURE_LINK_FORMAT, "Interface\\Icons\\INV_Holiday_BrewfestBuff_01", FONTSIZE_NORMAL, FONTSIZE_NORMAL, 0)
		DailiesGroups["Holiday"].title = "Holiday: " .. "[" .. HolidayIcon .. Crayon:Orange(HOLIDAY_TITLE) .. "]"
	elseif (HOLIDAY_TITLE == "Hallow's End") then
		HolidayIcon = format(TEXTURE_LINK_FORMAT, "Interface\\Icons\\INV_Misc_Bag_28_Halloween", FONTSIZE_NORMAL, FONTSIZE_NORMAL, 0)
		DailiesGroups["Holiday"].title = "Holiday: " .. "[" .. HolidayIcon .. Crayon:Orange(HOLIDAY_TITLE) .. "]"		
	end
	
	TURN_IN_ICON = format(TEXTURE_LINK_FORMAT, "Interface\\Addons\\DailiesQuestTracker\\Icons\\ActiveQuestIcon.tga", FONTSIZE_NORMAL, FONTSIZE_NORMAL, 0)
	ACCEPTED_ICON = format(TEXTURE_LINK_FORMAT, "Interface\\Addons\\DailiesQuestTracker\\Icons\\AvailableQuestIcon.tga", FONTSIZE_NORMAL, FONTSIZE_NORMAL, 0)
	MAX_ICON = format(TEXTURE_LINK_FORMAT, "Interface\\Buttons\\UI-GroupLoot-Pass-Up", FONTSIZE_NORMAL, FONTSIZE_NORMAL, 0)
	DQT_USERS_ICON = format(TEXTURE_LINK_FORMAT, "Interface\\Icons\\INV_Misc_GroupNeedMore", FONTSIZE_NORMAL, FONTSIZE_NORMAL, 0)
	COMM_ON_ICON = format(TEXTURE_LINK_FORMAT, "Interface\\Addons\\DailiesQuestTracker\\Icons\\CommOn.tga", FONTSIZE_NORMAL, FONTSIZE_NORMAL, 0)
	COMM_OFF_ICON = format(TEXTURE_LINK_FORMAT, "Interface\\Addons\\DailiesQuestTracker\\Icons\\CommOff.tga", FONTSIZE_NORMAL, FONTSIZE_NORMAL, 0)
	
	if DailiesReset == 4 then
		DailiesResetSeconds = GetQuestResetTime() + 3600
	else
		DailiesResetSeconds = GetQuestResetTime()
	end
	
	local DailiesResetTimeHour, DailiesResetTimeMin = (":"):split(Dailies:SecondsToTime(DailiesResetSeconds, true, 1))
	local DailiesResetTimeHour = tonumber(DailiesResetTimeHour)
	local DailiesResetTimeMin = tonumber(DailiesResetTimeMin)
	
	local GameHour = GetGameTime()
	local LocalHour = tonumber(date("%H"))
	
	if DailiesResetTimeHour then
		if DailiesResetTimeHour > 1 then
			HoursFormat = L["Hours"]
		else
			HoursFormat = L["Hour"]
		end
	end
	
	if DailiesResetTimeMin then
		if DailiesResetTimeMin > 1 then
			MinutesFormat = L["Minutes"]
		else
			MinutesFormat = L["Minute"]
		end
	end
	
	if DailiesResetSeconds >= 3600 then
		DailiesIconError = false
		
		-- GameTime/LocalTime offset
		if self.db.char.TooltipTimer == true then
			UserTimerChoice = " [" .. Crayon:Green(L["LOCAL"]) .. "]: "
			if (GameHour >= LocalHour) then
				DailiesResetTimeHour = (DailiesResetTimeHour) - (GameHour - LocalHour)
			end
		else
			UserTimerChoice = " [" .. Crayon:Green(L["REALM"]) .. "]: "
		end

		if DailiesResetTimeMin then
			DailiesText = (UserTimerChoice .. L["Dailies are scheduled to reset in "] .. Crayon:Green(DailiesResetTimeHour .. " " .. HoursFormat) .. L[" and "] .. Crayon:Green(DailiesResetTimeMin .. " " .. MinutesFormat) .. L["."])
		else
			DailiesText = (UserTimerChoice .. L["Dailies are scheduled to reset in "] .. Crayon:Green(DailiesResetTimeHour .. " " .. HoursFormat) .. L["."])
		end
	else
		if DailiesResetTimeMin then
			DailiesText = (UserTimerChoice .. L["Dailies are scheduled to reset in "] .. Crayon:Green(DailiesResetTimeMin .. " " .. MinutesFormat) .. L["."])
		else
			DailiesText = Crayon:Red(L["[ERROR]: "]) .. "|cffAA0000" .. L["Reset time from realm is not valid."] .. "|r"
			DailiesIconError = true
		end
	end

	local DQTooltipColor = Crayon:GetThresholdHexColor((GetMaxDailyQuests() - GetDailyQuestsCompleted()), GetMaxDailyQuests())
	if ( DQComplete < DQMax ) then
		-- You can complete XX daily quests today
		AmountText = L["You can complete "] .. Crayon:Colorize(DQTooltipColor, (GetMaxDailyQuests() - GetDailyQuestsCompleted())) ..L[" daily quests today."]
	else
		-- You cannot complete any more daily quests today
		AmountText = L["You cannot complete any more daily quests today."]
	end
	
	if table.getn(self.UniqueNames) <= 0 then
		UniqueUsers = Crayon:Red("0")
	else
		UniqueUsers = Crayon:Green(table.getn(self.UniqueNames))
	end	
	
	cat = Tablet:AddCategory(
		'columns', 3,
		'showWithoutChildren', true,
		'hideBlankLine', true
	 )
			
		if self.db.char.DailyQuestsCompleted then
		for GroupName, GroupText in pairsByKeys (DailiesGroups) do
			if self.db.char.Filters[GroupName] == false and RepFactionsHolder[GroupName] then
				MinColor = Crayon:GetThresholdHexColor(self.db.char.GroupValues[DailiesGroups[GroupName]["group"]], DailiesGroups[GroupName]["ValueMax"])

				if (RepValuesHolder[GroupName]) and (RepValuesHolder[GroupName].title ~= "Unknown") then
					FactionColorize = Crayon:Colorize(RGBPercToHex(RepFactionColors[RepValuesHolder[GroupName].StandingID].r,
																				   RepFactionColors[RepValuesHolder[GroupName].StandingID].g,
																				   RepFactionColors[RepValuesHolder[GroupName].StandingID].b),
																				   RepFactionColors[RepValuesHolder[GroupName].StandingID].title)
					FactionThreshold = Crayon:GetThresholdHexColor(RepValuesHolder[GroupName].ReputationIs, RepValuesHolder[GroupName].ReputationMax)
					
					FactionValue = Crayon:Colorize(FactionThreshold, Dailies:Commas(RepValuesHolder[GroupName].ReputationIs)) .. " of " .. Crayon:Green(Dailies:Commas(RepValuesHolder[GroupName].ReputationMax))
					
					if self.db.char.FactionDisplay == "Icon" then
						FactionFormattedSuffix = ": [ " .. format(TEXTURE_LINK_FORMAT, RepFactionColors[RepValuesHolder[GroupName].StandingID].icon, FONTSIZE_NORMAL, FONTSIZE_NORMAL, 0) .. "]"
					elseif self.db.char.FactionDisplay == "Value" then
						FactionFormattedSuffix = ": [" .. FactionColorize .. ": " .. FactionValue .. "]"
					elseif self.db.char.FactionDisplay == "Title" then
						FactionFormattedSuffix = ": [" .. FactionColorize .. "]"
					end
				else
					FactionFormattedSuffix = ""
				end
				
				cat = Tablet:AddCategory(
					'text', DailiesGroups[GroupName]["title"] .. FactionFormattedSuffix,
					'textR', 1, 'textG', 0.8, 'textB', 0,
					'wrap', false,
					'text2', "[" .. Crayon:Colorize(MinColor, self.db.char.GroupValues[GroupName]) .. "/" .. "|cff2ba1ff" .. DailiesGroups[GroupName].Accepted .. "|r" .. "/" .. Crayon:Green(DailiesGroups[GroupName]["ValueMax"]) .. "]",
					'text2R', 1, 'text2G', 0.8, 'text2B', 0,
					'wrap2', false,
					'columns', 2,
					'showWithoutChildren', true,
					'hideBlankLine', true,
					'func', function() self.db.profile.hideDetails[DailiesGroups[GroupName]["group"]] = not self.db.profile.hideDetails[DailiesGroups[GroupName]["group"]] end,
					'hasCheck', true,
					'checked', true,
					'checkIcon', self.db.profile.hideDetails[DailiesGroups[GroupName]["group"]] and "Interface\\Buttons\\UI-PlusButton-Up" or "Interface\\Buttons\\UI-MinusButton-Up"
				)
				
				for index, value in pairsByKeys (DailyQuestsList) do
					if Dailies.db.profile.hideDetails[DailiesGroups[GroupName]["group"]] == false then		
						if DailyQuestsList[index]["group"] == GroupName then
						
							TotalUnits = 0; UnitsCompleted = 0; DailyUnitsTotal = ""
							for PlayerName, NilHolder in pairsByKeys (Dailies.db.server.chars) do
								if Dailies.db.server.chars[PlayerName].UnitCanDo[index] then
									TotalUnits = TotalUnits + 1	
									UnitsHolder[index] = TotalUnits
								end
								
								if Dailies.db.server.chars[PlayerName].UnitCompleted[index] then
									UnitsCompleted = UnitsCompleted + 1
								end
								
								UnitMinColor = Crayon:GetThresholdHexColor(UnitsCompleted, UnitsHolder[index])
								if (UnitsHolder[index]) and (UnitsHolder[index] >= 2) then
									DailyUnitsTotal = Crayon:Gold("[") .. Crayon:Colorize(UnitMinColor, UnitsCompleted) .. Crayon:Gold("/") .. Crayon:Green(UnitsHolder[index]) .. Crayon:Gold("] ")
								else
									DailyUnitsTotal = ""
								end
							end							
						
							if self.db.char.DailyQuestsObjectives[index] == "Turn-In" then RColor= 1; GColor= 1; BColor = 0; RIcon= 1; GIcon= 1; BIcon = 1; CompletedText = TURN_IN_ICON
								elseif self.db.char.DailyQuestsCompleted[index] then RColor= 1; GColor= 1; BColor = 1; RIcon= 1; GIcon= 1; BIcon = 1;
								
									if self.db.char.TimeFormat == "Standard" then
										local QuestMonth, QuestDay, QuestHour, QuestMinute = (":"):split(self.db.char.DailyQuestsCompleted[index])
										local QuestPM = floor(QuestHour / 12) == 1; QuestHour = mod(QuestHour, 12); if QuestHour == 0 then QuestHour = 12 end;
										local QuestTime = string.format("%d" .. Crayon:Gold(":") .. "%02d" .. Crayon:Gold(" %s"), QuestHour, QuestMinute, QuestPM and "PM" or "AM");	
										CompletedText = QuestTime
									else
										local QuestMonth, QuestDay, QuestHour, QuestMinute = (":"):split(self.db.char.DailyQuestsCompleted[index])
										CompletedText = string.format("%d" .. Crayon:Gold(":") .. "%02d", QuestHour, QuestMinute)
									end
								
								elseif self.db.char.DailyQuestsAccepted[index] then RColor= .17; GColor= .63; BColor = 1; RIcon= 1; GIcon= 1; BIcon = 1; CompletedText = ACCEPTED_ICON
								elseif self.db.char.GroupValues[DailiesGroups[GroupName]["group"]] ==  DailiesGroups[GroupName]["ValueMax"] then RColor= 1; GColor= 0; BColor = 0; RIcon= 1; GIcon= 0; BIcon = 0; CompletedText = MAX_ICON
								else RColor= 0.5; GColor= 0.5; BColor = 0.5; RIcon= 0.5; GIcon= 0.5; BIcon = 0.5;
								
								if DailyQuestsList[index]["dates"] then
									CompletedText = DailyQuestsList[index]["dates"].starting .." - ".. DailyQuestsList[index]["dates"].ending
								elseif DailyQuestsList[index]["loc"] then
									CompletedText = DailyQuestsList[index]["loc"]
								elseif (GetDailyQuestsCompleted() == GetMaxDailyQuests()) then
									RColor= 1; GColor= 0; BColor = 0; RIcon= 1; GIcon= 0; BIcon = 0;
									CompletedText = MAX_ICON
								else
									CompletedText = " "
								end
							end
														
							local ReputationName, ReputationID = (":"):split(DailyQuestsList[index]["SID"]); ReputationID = tonumber(ReputationID)
							if (index and RepFactionsHolder[ReputationName]) and (ReputationID <= RepFactionsHolder[ReputationName])  then
								cat:AddLine(									
									'text', " " .. DailyUnitsTotal .. index,
									'textR', RColor,
									'textG', GColor,
									'textB', BColor,
									'indentation', 14,
									'text2', CompletedText,
									'text2R', RColor,
									'text2G', GColor,
									'text2B', BColor,
									'hasCheck', true,
									'checked', true,
									'checkIcon', DailyQuestsList[index]["icon"],
									'checkColorR', RIcon,
									'checkColorG', BIcon,
									'checkColorB', GIcon,
									'onEnterFunc', function()
								        Dailies:OnHoverTooltip(index, GetMouseFocus():GetName(),  "ENTER")
								    end,
									'onLeaveFunc', function()
								        Dailies:OnHoverTooltip(nil, nil, "LEAVE")
								    end,
									'func', 'OnQuestClick',
									'arg1', self,
									'arg2', index
								)
							end
						end
					end
				end
				if Dailies.db.profile.hideDetails[DailiesGroups[GroupName]["group"]] == false then cat:AddLine () end
			end
		end
	
	if (self.db.char.DailyCommSet == true) then
		if (self.db.char.HideDailyList == false) then
			if (DailiesKnown == nil) then
				cat = Tablet:AddCategory(
					'columns', 1,
					'showWithoutChildren', true,
					'hideBlankLine', true
				 )
				 
				cat:AddLine(
					'text', " "
				)

			-- Random Dailies Report List
			elseif (DailiesKnown ~= nil) then
				-- Spacer	
				cat = Tablet:AddCategory(
					'columns', 1,
					'showWithoutChildren', true,
					'hideBlankLine', true
				 )

				cat:AddLine(
					'text', " "
				)
				
				cat:AddLine(				
					'text', L["The "] .."["..Crayon:Green(L["Random Dailies"]).."]" .. L[" for "] .. DailesDATE .. L[" are:"],
					'justify', "CENTER"
				)
				
				cat = Tablet:AddCategory(
					'columns', 3,
					'showWithoutChildren', true,
					'hideBlankLine', true
				 )

				if DailyBGPvP then
				--	BGPvPQuestIcon = format(DAILIES_TEXTURE_FORMAT, DailyQuestsList[DailyBGPvP]["icon"] .. ":" .. Tablet:GetNormalFontSize())
				--	DailiesGroups["BGPvP"].title = L["Battleground"] ..": [".. BGPvPQuestIcon .. Crayon:Green(DailyBGPvP) .. "]"
					
					if Dailies.db.char.DailyQuestsCompleted[DailyBGPvP] then
						DailiesKnownBGPvP = DailiesKnownCompleted
					else
						DailiesKnownBGPvP = DailiesKnownNotCompleted
					end
					cat:AddLine(					
					'text', Crayon:White(DailyBGPvP),
					'text2', "[" .. DailiesKnownBGPvP .."]",
					'text3', "[" .. Crayon:Green(L["Daily Battleground"]) .."]",
					'hasCheck', true,
					'checked', true,
					'checkIcon', DailyQuestsList[DailyBGPvP]["icon"],
					'func', 'QuestClickLink',
					'arg1', self,
					'arg2', DailyBGPvP				
					)
				end
				
				if DailyCooking then
				--	CookingQuestIcon = format(DAILIES_TEXTURE_FORMAT, DailyQuestsList[DailyCooking]["icon"] .. ":" .. Tablet:GetNormalFontSize())
				--	DailiesGroups["Cooking"].title = "Cooking" ..": [".. CookingQuestIcon .. Crayon:Green(DailyCooking) .. "]"				
				
					if Dailies.db.char.DailyQuestsCompleted[DailyCooking] then
						DailiesKnownCooking = DailiesKnownCompleted
					else
						DailiesKnownCooking = DailiesKnownNotCompleted
					end
					cat:AddLine(					
					'text', Crayon:White(DailyCooking),
					'text2', "[" .. DailiesKnownCooking .."]",
					'text3', "[" .. Crayon:Green(L["Daily Cooking"]) .."]",
					'hasCheck', true,
					'checked', true,
					'checkIcon', DailyQuestsList[DailyCooking]["icon"],
					'func', 'QuestClickLink',
					'arg1', self,
					'arg2', DailyCooking
					)
				end

				if DailyFishing then
				--	FishingQuestIcon = format(DAILIES_TEXTURE_FORMAT, DailyQuestsList[DailyFishing]["icon"] .. ":" .. Tablet:GetNormalFontSize())
				--	DailiesGroups["Fishing"].title = "Fishing" ..": [".. FishingQuestIcon .. Crayon:Green(DailyFishing) .. "]"				
				
					if Dailies.db.char.DailyQuestsCompleted[DailyFishing] then
						DailiesKnownFishing = DailiesKnownCompleted
					else
						DailiesKnownFishing = DailiesKnownNotCompleted
					end
					cat:AddLine(					
					'text', Crayon:White(DailyFishing),
					'text2', "[" .. DailiesKnownFishing .."]",
					'text3', "[" .. Crayon:Green(L["Daily Fishing"]) .."]",
					'hasCheck', true,
					'checked', true,
					'checkIcon', DailyQuestsList[DailyFishing]["icon"],
					'func', 'QuestClickLink',
					'arg1', self,
					'arg2', DailyFishing				
					)
				end
				
				if DailyHInstance then
					if Dailies.db.char.DailyQuestsCompleted[DailyHInstance] then
						DailiesKnownHInstance = DailiesKnownCompleted
					else
						DailiesKnownHInstance = DailiesKnownNotCompleted
					end
					cat:AddLine(					
					'text', Crayon:White(DailyHInstance),
					'text2', "[" .. DailiesKnownHInstance .."]",
					'text3', "[" .. Crayon:Green(L["Daily Heroic"]) .."]",
					'hasCheck', true,
					'checked', true,
					'checkIcon', DailyQuestsList[DailyHInstance]["icon"],
					'func', 'QuestClickLink',
					'arg1', self,
					'arg2', DailyHInstance
					)
				end
				
				if DailyDInstance then
					if Dailies.db.char.DailyQuestsCompleted[DailyDInstance] then
						DailiesKnownDInstance = DailiesKnownCompleted
					else
						DailiesKnownDInstance = DailiesKnownNotCompleted
					end
					cat:AddLine(					
					'text', Crayon:White(DailyDInstance),
					'text2', "[" .. DailiesKnownDInstance .."]",
					'text3', "[" .. Crayon:Green(L["Daily Dungeon"]) .."]",
					'hasCheck', true,
					'checked', true,
					'checkIcon', DailyQuestsList[DailyDInstance]["icon"],
					'func', 'QuestClickLink',
					'arg1', self,
					'arg2', DailyDInstance				
					)
				end
				
				cat:AddLine(
					'text', " "
				)			
			end
		end
	end
	
		if self.db.char.DailyCommSet == true then
			cat = Tablet:AddCategory(
				'columns', 3,
				'showWithoutChildren', true,
				'hideBlankLine', true
			 )		
			
			cat:AddLine(
			'text', COMM_ON_ICON .. ": " .. Crayon:Green(L["ON"]),
			'text2', AmountText,
			'text3', DQT_USERS_ICON .. ": " .. UniqueUsers .. "  ",
			'justify2', 'CENTER'
			)
		else
			cat = Tablet:AddCategory(
				'columns', 3,
				'showWithoutChildren', true,
				'hideBlankLine', true
			 )

			 cat:AddLine(
			'text', COMM_OFF_ICON .. ": " .. Crayon:Red(L["OFF"]),
			'text2', AmountText,
			'text3', DQT_USERS_ICON .. ": " .. Crayon:Red(L["OFF"]) .. "  ",
			'justify2', 'CENTER'
			)		
		end
	end

	cat = Tablet:AddCategory(
		'columns', 1,
		'showWithoutChildren', true,
		'hideBlankLine', true
	 )
			 
	
	-- Displays when the dailies will reset
	cat:AddLine(		
		'text', DailiesText,
		'justify', "CENTER"
	)
end -- function OnTooltipUpdate

function Dailies:OnHoverTooltip(QuestTitleValue, Focus, Status)											
	if Status == "ENTER" then
		if self.db.char.TooltipPlacement == "Left" then
			QuestRewardsTooltip:SetOwner(getglobal(Focus), "ANCHOR_BOTTOMRIGHT", 12, 14)
			if LibRockFuBar == true then
				QuestRewardsTooltip:SetScale(FuBar.db.profile.tooltip.fontSizePercent)
			else
				QuestRewardsTooltip:SetScale(1)
			end
		else
			QuestRewardsTooltip:SetOwner(getglobal(Focus), "ANCHOR_BOTTOMLEFT", -12, 14)
			if LibRockFuBar == true then
				QuestRewardsTooltip:SetScale(FuBar.db.profile.tooltip.fontSizePercent)
			else
				QuestRewardsTooltip:SetScale(1)
			end
		end
		
		if self.db.char.DailyQuestsCompleted[QuestTitleValue] then
			-- Return with no colorization
		elseif Dailies.db.char.DailyQuestsObjectives[QuestTitleValue] == "Turn-In" then
			QuestRewardsTooltip:SetBackdropColor(.50, .50, 0)
			QuestRewardsTooltip:SetBackdropBorderColor(1, 1, 0)
		elseif self.db.char.DailyQuestsAccepted[QuestTitleValue] then
			QuestRewardsTooltip:SetBackdropColor(0, .13, .50)
			QuestRewardsTooltip:SetBackdropBorderColor(.17, .63, 1)
		elseif self.db.char.GroupValues[DailyQuestsList[QuestTitleValue].group] ==  DailiesGroups[DailyQuestsList[QuestTitleValue].group]["ValueMax"] then
			QuestRewardsTooltip:SetBackdropColor(.50, 0, 0)
			QuestRewardsTooltip:SetBackdropBorderColor(1, 0, 0)
		else
			QuestRewardsTooltip:SetBackdropColor(.09, .09, .19)
			QuestRewardsTooltip:SetBackdropBorderColor(1, 1, 1)
		end
		QuestRewardsTooltip:SetText(QuestTitleValue .. ":")
		
		-- If ITEMS are awarded, add them to the tooltip
		if DailyQuestsList[QuestTitleValue]["rewards"] then
			for Reward, RewardType in pairs(DailyQuestsList[QuestTitleValue]["rewards"]) do
			-- Grab itemlink and quantity from quest and break it apart
			local RewardType, RewardAmount = (":"):split(RewardType); RewardAmount = tonumber(RewardAmount)
			if RewardAmount < 2 then RewardAmount = "" else RewardAmount = (" x" .. Crayon:White(RewardAmount)) end
			itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, itemTexture = GetItemInfo(RewardType); 
			if itemLink == nil then GameTooltip:SetHyperlink("item:".. RewardType); end
				if itemLink then
					QuestRewardsTooltip:AddLine(itemLink .. RewardAmount)
					QuestRewardsTooltip:AddTexture(itemTexture)
				end
			end
		end

		-- If HONOR awarded, add it to the tooltip
		if DailyQuestsList[QuestTitleValue]["honor"] then
			QuestRewardsTooltip:AddLine(Crayon:White("~") .. Crayon:Green(DailyQuestsList[QuestTitleValue]["honor"]) .. Crayon:White(L[" Honor Points"]))
			QuestRewardsTooltip:AddTexture(BGHonor)
		end

		-- If REPUTATION awarded, add it to the tooltip
		if DailyQuestsList[QuestTitleValue]["rep"] then	
			for RepReward, RepRewardType in pairs(DailyQuestsList[QuestTitleValue]["rep"]) do
			-- Grab faction name and reputation from quest and break it apart
				local RepRewardType, RepAmount = (":"):split(RepRewardType)
				-- Check to see if the PLAYER is HUMAN and multiply Reputation by 10%
				if PlayerRace == "Human" then RepAmount = ceil(RepAmount + (RepAmount * .10)) else RepAmount = RepAmount end
				-- If Repuation Standing is nil then set it to UNKNOWN
				if RepFactionsHolder[RepRewardType] == nil then RepFactionsHolder[RepRewardType] = 0 end

				QuestRewardsTooltip:AddLine(Crayon:Green(RepAmount) .. Crayon:White(L[" reputation with "]) .. Crayon:Colorize(RGBPercToHex(RepFactionColors[RepFactionsHolder[RepRewardType]].r,
																										RepFactionColors[RepFactionsHolder[RepRewardType]].g,
																										RepFactionColors[RepFactionsHolder[RepRewardType]].b ),
																										BF[RepRewardType]))
				QuestRewardsTooltip:AddTexture("Interface\\Addons\\DailiesQuestTracker\\Icons\\Rep\\" .. RepRewardType)

				if RepFactionsHolder[RepRewardType] == 0 then RepFactionsHolder[RepRewardType] = nil end
			end
		end
		
		-- If GOLD awarded, add it to the tooltip
		if DailyQuestsList[QuestTitleValue]["gold"] then
			MoneyFormat = Dailies:FormatTheGold(DailyQuestsList[QuestTitleValue]["gold"], 0)
			QuestRewardsTooltip:AddLine(MoneyFormat)
			QuestRewardsTooltip:AddTexture("Interface\\Icons\\INV_Misc_Coin_02")
		end
		
		-- Get Quest Giver information, add it to the tooltip
		if (Dailies.db.char.QuestGiver == true) then
			if DailyQuestsList[QuestTitleValue]["coords"] then
				local LeftCoord, RightCoord = (":"):split(DailyQuestsList[QuestTitleValue]["coords"]); local LeftCoord = tonumber(LeftCoord); local RightCoord = tonumber (RightCoord)
				QuestRewardsTooltip:AddLine(" ") -- Spacer
				
				QuestRewardsTooltip:AddLine(QuestTitleValue .. " Quest Giver:")
				QuestRewardsTooltip:AddLine(Crayon:White(DailyQuestsList[QuestTitleValue]["qgiver"]))
				QuestRewardsTooltip:AddTexture("Interface\\Addons\\DailiesQuestTracker\\Icons\\AvailableQuestIcon.tga")
				
				if (DailyQuestsList[QuestTitleValue]["qszone"] == "Nil") then
					QuestRewardsTooltip:AddLine(Crayon:White(DailyQuestsList[QuestTitleValue]["qzone"]))
					QuestRewardsTooltip:AddTexture("Interface\\TaxiFrame\\TaxiMap530")
				else
					QuestRewardsTooltip:AddLine(Crayon:White(DailyQuestsList[QuestTitleValue]["qszone"]) .. Crayon:Silver(", ") .. Crayon:White(DailyQuestsList[QuestTitleValue]["qzone"]))
					QuestRewardsTooltip:AddTexture("Interface\\TaxiFrame\\TaxiMap530")				
				end
								
				if (LeftCoord == 0) and (RightCoord == 0) then
					-- Add no Coordinates
				else
					QuestRewardsTooltip:AddLine(Crayon:White("Coordinates: ") .. Crayon:Green(ceil(LeftCoord)) .. Crayon:Silver(", ") .. Crayon:Green(ceil(RightCoord)))
					QuestRewardsTooltip:AddTexture("Interface\\Icons\\INV_Misc_PocketWatch_02")
				end
			end
		end		
		QuestRewardsTooltip:Show()		
		
		if (self.db.char.MutilpleCharacters == true) then
			QuestUnitsTooltip:SetBackdropColor(.09, .09, .19)
			QuestUnitsTooltip:SetBackdropBorderColor(1, 1, 1)
			
			if UnitsHolder[QuestTitleValue] then
				if self.db.char.TooltipPlacement == "Left" then
					QuestUnitsTooltip:SetOwner(QuestRewardsTooltip, "ANCHOR_NONE")
					QuestUnitsTooltip:SetPoint("TOPLEFT", QuestRewardsTooltip, "BOTTOMLEFT")
					QuestUnitsTooltip:SetScale(FuBar.db.profile.tooltip.fontSizePercent)
				else
					QuestUnitsTooltip:SetOwner(QuestRewardsTooltip, "ANCHOR_NONE")
					QuestUnitsTooltip:SetPoint("TOPRIGHT", QuestRewardsTooltip, "BOTTOMRIGHT")
					QuestUnitsTooltip:SetScale(FuBar.db.profile.tooltip.fontSizePercent)
				end

				QuestUnitsTooltip:SetText("Character(s) on [" .. Crayon:Green(GetRealmName()) .. "]:")	
				
				if (self.db.server.chars) and (self.db.server.UnitTrackerValid == 1) and (UnitsHolder[QuestTitleValue] >= 2) then
					for PlayerName, NilHolder in pairsByKeys(Dailies.db.server.chars) do
						if (PlayerName ~= UnitName("player")) then
							if (Dailies.db.server.chars[PlayerName].UnitCanDo[QuestTitleValue]) then
								
								if Dailies.db.server.chars[PlayerName].UnitCompleted[QuestTitleValue] then
									UnitQuestStatus = DailiesKnownCompleted
								else
									UnitQuestStatus = DailiesKnownNotCompleted
								end
								
								local PClass, PFaction = (":"):split(Dailies.db.server.chars[PlayerName].PlayerClass)
								
								if PFaction == FACTION_ALLIANCE then
									FactionIcon = "Interface\\Addons\\DailiesQuestTracker\\Icons\\Alliance.tga"
									FactionIconName = Crayon:Green(FACTION_ALLIANCE)
								else
									FactionIcon = "Interface\\Addons\\DailiesQuestTracker\\Icons\\Horde.tga"
									FactionIconName = Crayon:Green(FACTION_HORDE)
								end
								
								local FACTION_ICON = format(TEXTURE_LINK_FORMAT, FactionIcon, 12, 12, -1)							
								local PlayerNameHEX = RGBPercToHex(RAID_CLASS_COLORS[PClass].r, RAID_CLASS_COLORS[PClass].g, RAID_CLASS_COLORS[PClass].b)
								
								QuestUnitsTooltip:AddDoubleLine(Crayon:Colorize(PlayerNameHEX, PlayerName) .. " [" .. FACTION_ICON .. FactionIconName .. "]", Crayon:Gold(" [") .. UnitQuestStatus .. Crayon:Gold("]"))
								QuestUnitsTooltip:AddTexture(classIcons[PClass])
								QuestUnitsTooltip:Show()
							end
						end
					end
				else
					QuestUnitsTooltip:Hide()
				end
			end
		else
			QuestUnitsTooltip:Hide()
		end
	elseif Status == "LEAVE" then
		QuestUnitsTooltip:Hide()
		QuestRewardsTooltip:Hide()
	end
end

function Dailies:OnQuestClick(QuestTitleValue)
	local LeftCoord, RightCoord = (":"):split(DailyQuestsList[QuestTitleValue]["coords"])

	if IsShiftKeyDown() then
		Dailies:CoordClickLink(LeftCoord, RightCoord, QuestTitleValue)
	else
		Dailies:QuestClickLink(QuestTitleValue)
	end
end -- function OnQuestClick

-- Format the gold with icons for money placement
function Dailies:FormatTheGold (GoldAmount, Offset)
local gold = abs(floor(GoldAmount / 10000))
local silver = abs(floor(mod(GoldAmount / 100, 100)))
local copper = abs(floor(mod(GoldAmount, 100)))

GOLD_ICON = format(TEXTURE_LINK_FORMAT, "Interface\\Addons\\DailiesQuestTracker\\Icons\\GoldIcon.tga", 12, 12, Offset)
SILVER_ICON = format(TEXTURE_LINK_FORMAT, "Interface\\Addons\\DailiesQuestTracker\\Icons\\SilverIcon.tga", 12, 12, Offset)
COPPER_ICON = format(TEXTURE_LINK_FORMAT, "Interface\\Addons\\DailiesQuestTracker\\Icons\\CopperIcon.tga", 12, 12, Offset)

	if (copper == 00) then
		MoneyFormat = Crayon:Gold(gold) .. GOLD_ICON .. " " .. Crayon:Silver(silver) .. SILVER_ICON
		return MoneyFormat
	elseif (silver == 00) then
		MoneyFormat = Crayon:Gold(gold) .. GOLD_ICON
		return MoneyFormat
	else
		MoneyFormat = Crayon:Gold(gold) .. GOLD_ICON .. " " .. Crayon:Silver(silver) .. SILVER_ICON .. " " .. Crayon:Copper(copper) .. COPPER_ICON
		return MoneyFormat
	end
end -- function FormatTheGold

-- Click on FuBar icon will toggle the Quest Log Window
function Dailies:OnClick(button)
	ToggleQuestLog();
end -- function OnClick

-- Makes the tooltip an actual item
function Dailies:SetTooltip(arg1, arg2)
	GameTooltip_SetDefaultAnchor(GameTooltip, this)
	GameTooltip:SetHyperlink("item:"..arg1..":0:0:0:0:0:0:0")
end -- function SetTooltip

-- Shift-Left-Click to paste the quest link into the chatbox
function Dailies:QuestClickLink(link)
	if not ChatFrameEditBox:IsVisible() then
		ChatFrameEditBox:Show()
	end
	
	if DailyQuestsList[link]["loc"] then
		if DailyQuestsList[link]["link"] then
			ChatFrameEditBox:Insert(DailyQuestsList[link]["link"] .. L[" located in "].. DailyQuestsList[link]["loc"])
		else
			ChatFrameEditBox:Insert(L["No Quest Link known!"])
		end
	else
		if DailyQuestsList[link]["link"] then
			ChatFrameEditBox:Insert(DailyQuestsList[link]["link"])
		else
			ChatFrameEditBox:Insert(L["No Quest Link known!"])
		end
	end
	
	-- Get Quest HyperLink and send it to break apart
--	local _, QuestLink = Quixote:GetQuest(link)
--		if QuestLink then
--			Dailies:GetQuestDetails(GetQuestLink(QuestLink))
--		end
end -- function QuestClickLink

-- Click to paste coordinates into the chatbox
function Dailies:CoordClickLink(LeftCoord, RightCoord, QuestName)
	local CoordsZoneName = GetRealZoneText()
	if (LeftCoord and RightCoord) and (self.db.char.TOMTOM_WAYPOINTS == true) then
		if (CoordsZoneName == DailyQuestsList[QuestName]["qzone"]) then
			-- TomTom:AddWaypoint(x, y, desc, persistent, minimap, world)
			TomTom:AddWaypoint(LeftCoord, RightCoord, Crayon:Green(DailyQuestsList[QuestName]["qgiver"]) .. ", " .. DailyQuestsList[QuestName].link, nil, nil, nil)
		end
	end

	if (LeftCoord and RightCoord) and (self.db.char.CART_WAYPOINTS == true) then
		if (CoordsZoneName == DailyQuestsList[QuestName]["qzone"]) then
			-- Cartographer_Waypoints:AddLHWaypoint(c, z, x, y, desc)
			Cartographer_Waypoints:AddLHWaypoint(nil, nil, LeftCoord, RightCoord, Crayon:Green(DailyQuestsList[QuestName]["qgiver"]) .. ", " .. DailyQuestsList[QuestName].link)
		end
	end
end -- function CoordClickLink

-- Click to paste itemlink into the chatbox
function Dailies:itemClickLink(link, amount)
	if not ChatFrameEditBox:IsVisible() then
		ChatFrameEditBox:Show()
	end
	
	if link then
		ChatFrameEditBox:Insert(link .. amount)
	end
end -- function itemClickLink

-- Gather Random Dailies when the quest-giver GOSSIP is shown
function Dailies:GOSSIP_SHOW()
	local englishFaction, _ = UnitFactionGroup("Player")
	local _, DPlayerClass = UnitClass("player")
	local QuestName, _, _ = GetGossipAvailableQuests()
	
	if QuestName and DailyQuestsList[QuestName] then
		Dailies:Debug(L["Gathered quest: "] .. QuestName)
		Dailies.db.server.chars[UnitName("player")].UnitCanDo[QuestName] = true; DailiesPlayerClass = (DPlayerClass .. ":" .. englishFaction); Dailies.db.server.chars[UnitName("player")].PlayerClass = DailiesPlayerClass
		if DailyQuestsList[QuestName]["group"] == "HInstance" then DailyHInstance = QuestName; DailiesKnown = true; DailiesCommHolder["HInstance"] = QuestName end
		if DailyQuestsList[QuestName]["group"] == "DInstance" then DailyDInstance = QuestName; DailiesKnown = true; DailiesCommHolder["DInstance"] = QuestName end
		if DailyQuestsList[QuestName]["group"] == "Cooking" then DailyCooking = QuestName; DailiesKnown = true; DailiesCommHolder["Cooking"] = QuestName end
		if DailyQuestsList[QuestName]["group"] == "Fishing" then DailyFishing = QuestName; DailiesKnown = true; DailiesCommHolder["Fishing"] = QuestName end
		if DailyQuestsList[QuestName]["group"] == "BGPvP" then DailyBGPvP = QuestName; DailiesKnown = true; DailiesCommHolder["BGPvP"] = QuestName end
	end
end -- function GOSSIP_SHOW

-- Gather Random Dailies when the quest-giver DETAILS are shown
function Dailies:QUEST_DETAIL()
	local englishFaction, _ = UnitFactionGroup("Player")
	local _, DPlayerClass = UnitClass("player")
	local QuestName = GetTitleText()
	
	if QuestName and DailyQuestsList[QuestName] then
		Dailies:Debug(L["Gathered quest: "] .. QuestName)
		Dailies.db.server.chars[UnitName("player")].UnitCanDo[QuestName] = true; DailiesPlayerClass = (DPlayerClass .. ":" .. englishFaction); Dailies.db.server.chars[UnitName("player")].PlayerClass = DailiesPlayerClass
		if DailyQuestsList[QuestName]["group"] == "HInstance" then DailyHInstance = QuestName; DailiesKnown = true; DailiesCommHolder["HInstance"] = QuestName end
		if DailyQuestsList[QuestName]["group"] == "DInstance" then DailyDInstance = QuestName; DailiesKnown = true; DailiesCommHolder["DInstance"] = QuestName end
		if DailyQuestsList[QuestName]["group"] == "Cooking" then DailyCooking = QuestName; DailiesKnown = true; DailiesCommHolder["Cooking"] = QuestName end
		if DailyQuestsList[QuestName]["group"] == "Fishing" then DailyFishing = QuestName; DailiesKnown = true; DailiesCommHolder["Fishing"] = QuestName end
		if DailyQuestsList[QuestName]["group"] == "BGPvP" then DailyBGPvP = QuestName; DailiesKnown = true; DailiesCommHolder["BGPvP"] = QuestName end
	end
end -- function QUEST_DETAIL

-- Add commas for every thousandths place
function Dailies:Commas(num)
	assert (type (num) == "number" or type (num) == "string")

	local result = ""
	local sign, before, after = string.match (tostring (num), "^([%+%-]?)(%d*)(%.?.*)$")

	-- pull out batches of 3 digits from the end, put a comma before them
	while string.len (before) > 3 do
		result = "," .. string.sub (before, -3, -1) .. result
		before = string.sub (before, 1, -4)  -- remove last 3 digits
	end -- while

	return sign .. before .. result .. after
end -- function Commas

-- Break apart QuestLink to get data
function Dailies:GetQuestDetails(questString)
	if not questString then return nil end
	
	printable = gsub(questString, "|", "||")
	DEFAULT_CHAT_FRAME:AddMessage(printable)	
end -- function GetQuestDetails

-- Dailies Quest Tracker options menu
function Dailies:OnMenuRequest(level, value, inTooltip)		
    if not inTooltip then
		if level == 1 then
			-- Dailies Config Title
			Dewdrop:AddLine(
				'text', L["Dailies Config"],
				'isTitle', true,
				'icon', "Interface\\Addons\\DailiesQuestTracker\\Icon.tga",
				'iconWidth', 12,
				'iconHeight', 12
			)

			-- Random Dailies Communication Toggle
			Dewdrop:AddLine(
				'text', L["Random Dailies Communication"],
				'checked', self.db.char.DailyCommSet,
				'func', function ()
					SetDailyCommSet  = not SetDailyCommSet
					if (SetDailyCommSet  == true) then
						StaticPopup_Show ("RESET_COMMS", DialogOnComms)
					elseif (SetDailyCommSet  == false) then
						StaticPopup_Show ("RESET_COMMS", DialogOffComms)
					end
				end,
				'isRadio', true,
				'tooltipTitle', L["Random Dailies Communication"],
				'tooltipText', L["This toggles turning communications on/off for Dailies Quest Tracker."]
			)
			
			-- Hides/Shows the Random Dailies List
			Dewdrop:AddLine(
				'text', L["Hide Random Dailies List"],
				'checked', self.db.char.HideDailyList,
				'disabled', not self.db.char.DailyCommSet,
				'func', function ()
					self.db.char.HideDailyList  = not self.db.char.HideDailyList
				end,
				'isRadio', true,
				'tooltipTitle', L["Hide Random Dailies List"],
				'tooltipText', L["Hides the random dailies list in Dailies Quest Tracker."]
			)			
			
			-- Location unfold
			Dewdrop:AddLine(
				'text', L["Auto Unfold Groups"],
				'checked', self.db.char.LocationShow,
				'func', function ()
					self.db.char.LocationShow  = not self.db.char.LocationShow
				end,
				'isRadio', true,
				'tooltipTitle', L["Auto Unfold Groups"],
				'tooltipText', L["Automatically unfolds groups when you are in the zone or instance of those quests."]
			)

			-- Location unfold
			Dewdrop:AddLine(
				'text', "Multiple Characters",
				'checked', self.db.char.MutilpleCharacters,
				'func', function ()
					self.db.char.MutilpleCharacters  = not self.db.char.MutilpleCharacters
				end,
				'isRadio', true,
				'tooltipTitle', "Multiple Characters",
				'tooltipText', "Displays tooltips for dailies known by all characters on [" .. Crayon:Green(GetRealmName()).. "]."
			)
			
			-- QuestGiver locations
			Dewdrop:AddLine(
				'text', "Quest Givers",			
			--	'text', format(TEXTURE_LINK_FORMAT, "Interface\\Addons\\DailiesQuestTracker\\Icons\\AvailableQuestIcon.tga", FONTSIZE_NORMAL, FONTSIZE_NORMAL, MENU_OFFSET) .. "Quest Givers",
				'checked', self.db.char.QuestGiver,
				'func', function ()
					self.db.char.QuestGiver  = not self.db.char.QuestGiver
				end,
				'isRadio', true,
				'tooltipTitle', "Quest Givers",
				'tooltipText', "Shows the Quest Givers location in the Dailies Quest Tracker tooltips."
			)			
			
			-- Time Offset
			Dewdrop:AddLine(
				'text', L["Dailies Reset Time Offset"],
				'checked', self.db.char.TooltipTimer,
				'disabled', true,				
				'func', function ()
					self.db.char.TooltipTimer  = not self.db.char.TooltipTimer
				end,
				'isRadio', true,
				'tooltipTitle', L["Dailies Reset Time Offset"],
				'tooltipText', L["Toggles the visual timer in the tooltip to the REALM or your LOCAL time."]
			)
			
			-- Spacer
			Dewdrop:AddSeparator()
			
			-- AceComm Joining Channel Delay
			Dewdrop:AddLine(
			'text', "Communications Delay",
			'hasArrow', true,
			'hasSlider', true,
			'sliderMin', 10,
			'sliderMinText', '10 Secs.',
			'sliderMax', 60,
			'sliderMaxText', '60 Secs.',
			'sliderStep', 5,
			'sliderValue', self.db.profile.AceCommDelay,
			'sliderFunc', function(value)
		        self.db.profile.AceCommDelay = value
		    end,
			'icon', "Interface\\Addons\\DailiesQuestTracker\\Icons\\CommOn.tga",
			'tooltipTitle', "Communications Delay",
			'tooltipText', "Sets the delay when joining the AceComm Channel. Setting this value higher, will help with older computers having issues with AceComm joining Channel 1.\n\nThis setting will take effect the next time you log-in the game or reload your user interface."
			)	
			
			-- Expansions Display
			Dewdrop:AddLine(
				'text', "Expansions",
				'icon', "Interface\\Addons\\DailiesQuestTracker\\Icons\\TBC.tga",
				'value', "ExpansionDisplay",
				'hasArrow', true,
				'tooltipTitle', ""
			)
			
			-- Faction Display
			Dewdrop:AddLine(
				'text', L["Faction Display"],
				'hasArrow', true,
				'icon', "Interface\\PvPRankBadges\\PvPRank15",
				'value', "FactionDisplay",
				'tooltipTitle', L["Faction Display"],
				'tooltipText', "Lets you change how the faction values are displayed in the Dailies Quest Tracker Tooltip."
			)	
			
			-- Filters
			Dewdrop:AddLine(
				'text', L["Filters"],
				'hasArrow', true,
				'icon', "Interface\\Buttons\\UI-GroupLoot-Pass-Up",
				'value', "Filters",
				'tooltipTitle', L["Filters"],
				'tooltipText', L["Lets you filter out groups you have no interest in watching."]
			)
					
			-- Tooltip Placement
			Dewdrop:AddLine(
				'text', L["Rewards Tooltip Placement"],
				'hasArrow', true,
				'value', "Rewards",
				'icon', "Interface\\Addons\\DailiesQuestTracker\\Icons\\Tooltip.tga",
				'tooltipTitle',  L["Rewards Tooltip Placement"],
				'tooltipText', L["Places the rewards tooltip on either the Left or Right of Dailies Quest Tracker."]
			)			
				
			-- Show Me The Money!
			Dewdrop:AddLine(
				'text', L["Show Me The Money!"],
				'hasArrow', true,
				'value', "MoneyRewards",
				'icon', "Interface\\Icons\\INV_Misc_Coin_02",
				'tooltipTitle',  L["Show Me The Money!"],
				'tooltipText', L["Makes a list of the highest monetary value of the dailies."]
			)			
			
			-- Scrolling Combat Text Title
			Dewdrop:AddLine(
			'text', L["Scrolling Combat Text"],
			'hasArrow', true,
			'value', "SCT",
			'icon', "Interface\\Addons\\DailiesQuestTracker\\Icons\\SCT.tga",
			'tooltipTitle', L["Scrolling Combat Text"],
			'tooltipText', L["Displays notifications if you have specific addon's installed."]
			)
			
			Dewdrop:AddLine(
			'text', "Time Format",
			'hasArrow', true,
			'value', "TimeFormat",
			'icon', "Interface\\Icons\\INV_Misc_PocketWatch_03",
			'tooltipTitle', "Time Format",
			'tooltipText', "Lets you display the time in Standard AM/PM or 24 hour format."
			)			
			
			-- Waypoints
			if (TOMTOM_LOADED == true) or (CARTOGRAPH_LOADED == true) then
				Dewdrop:AddLine(
				'text', "Waypoints",
				'hasArrow', true,
				'value', "Waypoints",
				'icon', "Interface\\TaxiFrame\\TaxiMap530",
				'checkColorR', 1,
				'checkColorG', 0,
				'checkColorB', 0,				
				'tooltipTitle', "Waypoints",
				'tooltipText', "Lets you show waypoints for quest givers when " .. Crayon:Green("Shift-Left-Clicking") .. " quest titles, if you have specific mapping mods installed."
				)
			end			
					
			-- Spacer
			Dewdrop:AddSeparator()
			
			-- HINTS
			Dewdrop:AddLine(
				'text', Crayon:Green(L["[Hints]"]),
				'hasArrow', true,
				'icon', "Interface\\GossipFrame\\AvailableQuestIcon",
				'value', "Hints",
				'tooltipTitle', Crayon:Green(L["[Hints]"]),
				'tooltipText', L["Hints for specific things done in Dailies Quest Tracker."]
			)			

			-- Spacer
			Dewdrop:AddSeparator()

			Dewdrop:AddLine(
				'text', L["Debug"],
				'checked', self.db.profile.DebugEnabled,
				'func', function ()
					self.db.profile.DebugEnabled  = not self.db.profile.DebugEnabled
				end,
				'tooltipTitle', L["Debug Dailies Quest Tracker"],
				'tooltipText', L["Turns the Debugger on/off for Dailies Quest Tracker."]
			)			
		
		elseif level == 3 then
			if value == "ScrollArea" then
				Dewdrop:FeedAceOptionsTable(self:GetSinkAce2OptionsDataTable().output, 1)
			end
			
		elseif level == 2 then
			TBC_ICON = format(TEXTURE_LINK_FORMAT, "Interface\\Addons\\DailiesQuestTracker\\Icons\\TBC.tga", 16, 16, 0)
			WOTLK_ICON = format(TEXTURE_LINK_FORMAT, "Interface\\Addons\\DailiesQuestTracker\\Icons\\WotLK.tga", 16, 16, 0)
								
			if value == "ExpansionDisplay" then
				ExpansionsFrame:Show()
				
				if not GetMouseFocus() then
					ExpansionsFrame:Hide()
				else
					if not Dailies:IsHooked(_G[GetMouseFocus():GetName()], "OnLeave") then
						Dailies:HookScript(_G[GetMouseFocus():GetName()], "OnLeave", function(this)
							Dailies.hooks[this].OnLeave(this)
							ExpansionsFrame:Hide()
						end)
					end
				end
								
				if TBCExpansion == true then
					TBCText = Crayon:Green("The Burning Crusade")
				else
					TBCText = "|cff008000" .. "The Burning Crusade" .. "|r"
				end
				
				Dewdrop:AddLine(
				'text', TBC_ICON .. TBCText,
				'checked', self.db.char.TBCDisplay,				
				'disabled', not TBCExpansion,
				'func', function ()
					self.db.char.TBCDisplay = not self.db.char.TBCDisplay
				end,
				'isRadio', true,
				'tooltipTitle', format(TEXTURE_LINK_FORMAT, "Interface\\Addons\\DailiesQuestTracker\\Icons\\TBC.tga", 32, 32, 0) .. " " .. Crayon:Green("The Burning Crusade"),
				'tooltipText', "Shows dailies for The Burning Crusade in the Dailies Quest Tracker tooltip."				
				)
				
				if WotLKExpansion == true then
					WotLKText = Crayon:Blue("Wrath of the Lich King")
				else
					WotLKText = "|cff000080" .. "Wrath of the Lich King" .. "|r"
				end
					
				Dewdrop:AddLine(
				'text', WOTLK_ICON .. WotLKText,
				'checked', self.db.char.WotLKDisplay,
				'disabled', not WotLKExpansion,
				'func', function ()
					self.db.char.WotLKDisplay = not self.db.char.WotLKDisplay
				end,
				'isRadio', true,
				'tooltipTitle', format(TEXTURE_LINK_FORMAT, "Interface\\Addons\\DailiesQuestTracker\\Icons\\WotLK.tga", 32, 32, 0) .. " " .. Crayon:Blue("Wrath of the Lich King"),
				'tooltipText', "Shows dailies for The Wrath of the Lich King in the Dailies Quest Tracker tooltip."
				)
			end
			
			if value == "FactionDisplay" then
				Dewdrop:AddLine(
				'text', L["Icon"] .. ":" .. Crayon:Gold(" [" .. format(TEXTURE_LINK_FORMAT, "Interface\\PvPRankBadges\\PvPRank15", 12, 12, 0) .. "]"),
				'checked', self.db.char.FactionDisplay == "Icon",
				'func', function () 
					self.db.char.FactionDisplay = "Icon"
				end,
				'isRadio', true,
				'tooltipFunc', function()
					IconFrame:ClearAllPoints()
					IconFrame:SetPoint("BOTTOMRIGHT", "UIParent", "BOTTOMRIGHT", -CONTAINER_OFFSET_X - 13, CONTAINER_OFFSET_Y);
					IconFrame:Show()

					if not GetMouseFocus() then
						IconFrame:Hide()
					else
						if not Dailies:IsHooked(_G[GetMouseFocus():GetName()], "OnLeave") then
							Dailies:HookScript(_G[GetMouseFocus():GetName()], "OnLeave", function(this)
								Dailies.hooks[this].OnLeave(this)
								IconFrame:Hide()
							end)
						end
					end
				end,
				'tooltipTitle', ""
				)
				
				Dewdrop:AddLine(
				'text', L["Title"] .. ":" .. Crayon:Gold(" [") .. Crayon:Colorize(RGBPercToHex(0.6, 0.2, 0.8), "Exalted") .. Crayon:Gold("]"),
				'checked', self.db.char.FactionDisplay == "Title",
				'func', function () 
					self.db.char.FactionDisplay = "Title"
				end,
				'isRadio', true,
				'tooltipTitle', "Title",
				'tooltipText', "Sets the group faction status with Titles."
				)

				Dewdrop:AddLine(
				'text', L["Value"] .. ":" .. Crayon:Gold(" [") .. Crayon:Colorize(RGBPercToHex(0.6, 0.2, 0.8), "Exalted") .. Crayon:Gold(": ").. Crayon:Red("0") .. Crayon:Gold(" of ") .. Crayon:Green("1,000") .. Crayon:Gold("]"),
				'checked', self.db.char.FactionDisplay == "Value",
				'func', function ()
					self.db.char.FactionDisplay = "Value"
				end,
				'isRadio', true,
				'tooltipTitle', "Value",
				'tooltipText', "Sets the group faction status with Values."
				)				
			end
			
			if value == "Rewards" then
				Dewdrop:AddLine(
				'text', L["Left"],
				'checked', self.db.char.TooltipPlacement == "Right",
				'func', function ()
					RightTooltip = true; LeftTooltip = nil; 
					self.db.char.TooltipPlacement = "Right"
				end,
				'isRadio', true,
				'tooltipTitle', "Left",
				'tooltipText', "Place the rewards tooltip on the Left of Dailies Quest Tracker."
				)
				
				Dewdrop:AddLine(
				'text', L["Right"],
				'checked', self.db.char.TooltipPlacement == "Left",
				'func', function ()
					RightTooltip = nil; LeftTooltip = true; 
					self.db.char.TooltipPlacement = "Left"
				end,
				'isRadio', true,
				'tooltipTitle', "Right",
				'tooltipText', "Place the rewards tooltip on the Right of Dailies Quest Tracker."				
				)
			end
			
			if value == "TimeFormat" then
				Dewdrop:AddLine(
				'text', "Standard",
				'checked', self.db.char.TimeFormat == "Standard",
				'func', function ()
					self.db.char.TimeFormat = "Standard"
				end,
				'isRadio', true,
				'tooltipTitle', "Standard",
				'tooltipText', "The time will display with the AM/PM format."
				)
				
				Dewdrop:AddLine(
				'text', "24 Hour",
				'checked', self.db.char.TimeFormat == "TwentyFourHour",
				'func', function ()
					self.db.char.TimeFormat = "TwentyFourHour"
				end,
				'isRadio', true,
				'tooltipTitle', "24 Hour",
				'tooltipText', "The time will display with the 24 hour format."		
				)
			end			

			if value == "Filters" then
				Dewdrop:AddLine(
				'text', L["Battleground"],
				'checked', self.db.char.Filters["BGPvP"],
				'func', function ()
					self.db.char.Filters["BGPvP"] = not self.db.char.Filters["BGPvP"]
				end,
				'isRadio', true
				)
				
				Dewdrop:AddLine(
				'text', GetSpellInfo(2550),
				'checked', self.db.char.Filters["Cooking"],
				'func', function ()
					self.db.char.Filters["Cooking"] = not self.db.char.Filters["Cooking"]				
				end,
				'isRadio', true
				)

				Dewdrop:AddLine(
				'text', L["Dungeon Instance"],
				'checked', self.db.char.Filters["DInstance"],
				'func', function ()
					self.db.char.Filters["DInstance"] = not self.db.char.Filters["DInstance"]				
				end,
				'isRadio', true
				)
		
				Dewdrop:AddLine(
				'text', GetSpellInfo(7620),
				'checked', self.db.char.Filters["Fishing"],
				'func', function ()
					self.db.char.Filters["Fishing"] = not self.db.char.Filters["Fishing"]				
				end,
				'isRadio', true
				)
				
				Dewdrop:AddLine(
				'text', L["Heroic Instance"],
				'checked', self.db.char.Filters["HInstance"],
				'func', function ()
					self.db.char.Filters["HInstance"] = not self.db.char.Filters["HInstance"]				
				end,
				'isRadio', true
				)				
				
				if ShowSeasonal == true then
					Dewdrop:AddLine(
					'text', L["Holiday"],
					'checked', self.db.char.Filters["Holiday"],
					'func', function ()
						self.db.char.Filters["Holiday"] = not self.db.char.Filters["Holiday"]				
					end,
					'isRadio', true
					)
				end
				

				if RepFactionsHolder["Netherwing"] then
					Dewdrop:AddLine(
					'text', BF["Netherwing"],
					'checked', self.db.char.Filters["Netherwing"],
					'func', function ()
						self.db.char.Filters["Netherwing"] = not self.db.char.Filters["Netherwing"]				
					end,
					'isRadio', true
					)
				end

				if RepFactionsHolder["Ogri'la"] then
					Dewdrop:AddLine(
					'text', BF["Ogri'la"],
					'checked', self.db.char.Filters["Ogri'la"],
					'func', function ()
						self.db.char.Filters["Ogri'la"] = not self.db.char.Filters["Ogri'la"]				
					end,
					'isRadio', true
					)
				end

				if RepFactionsHolder["Sha'tari Skyguard"] then
					Dewdrop:AddLine(
					'text', BF["Sha'tari Skyguard"],
					'checked', self.db.char.Filters["Sha'tari Skyguard"],
					'func', function ()
						self.db.char.Filters["Sha'tari Skyguard"] = not self.db.char.Filters["Sha'tari Skyguard"]				
					end,
					'isRadio', true
					)
				end
				
				if RepFactionsHolder["Shattered Sun Offensive"] then
					Dewdrop:AddLine(
					'text', BF["Shattered Sun Offensive"],
					'checked', self.db.char.Filters["Shattered Sun Offensive"],
					'func', function ()
						self.db.char.Filters["Shattered Sun Offensive"] = not self.db.char.Filters["Shattered Sun Offensive"]				
					end,
					'isRadio', true
					)
				end		

				Dewdrop:AddLine(
				'text', L["World PvP"],
				'checked', self.db.char.Filters["World PvP"],
				'func', function ()
					self.db.char.Filters["World PvP"] = not self.db.char.Filters["World PvP"]				
				end,
				'isRadio', true
				)				
			end
			
			if value == "SCT" then
				Dewdrop:FeedAceOptionsTable(self:GetSinkAce2OptionsDataTable().output, 1)
			end
			
			if value == "Hints" then
				Dewdrop:AddLine(
				'icon', "Interface\\GossipFrame\\AvailableQuestIcon",
				'text', Crayon:Green(L["Left-Click"]) .. L[" on the FuBar icon to open the Quest Log Window."]
				)
				Dewdrop:AddLine(
				'icon', "Interface\\GossipFrame\\AvailableQuestIcon",
				'text', Crayon:Green(L["Left-Click"]) .. L[" on a quest title to paste the "] .. Crayon:Green("[Quest Link]") ..L[" into the chatbox."]
				)
				
				if (CARTOGRAPH_LOADED == true) or (TOMTOM_LOADED == true) then
					Dewdrop:AddLine(
					'icon', "Interface\\GossipFrame\\AvailableQuestIcon",
					'text', Crayon:Green(L["Shift-Left-Click"]) .. " on a quest title to show the waypoint."
					)
				end					
			end			

			if value == "Waypoints" then
				if (CARTOGRAPH_LOADED == true) then
					Dewdrop:AddLine(
					'text', "Cartographer Waypoints",
					'checked', self.db.char.CART_WAYPOINTS,
					'func', function ()
						self.db.char.CART_WAYPOINTS = not self.db.char.CART_WAYPOINTS
						self.db.char.TOMTOM_WAYPOINTS = not self.db.char.CART_WAYPOINTS						
					end,
					'isRadio', true,
					'tooltipTitle', "Cartographer Waypoints",
					'tooltipText', "Module which shows an arrow to direct you to a specified note or location."
					)	
				end
				
				if (TOMTOM_LOADED == true) then
					Dewdrop:AddLine(
					'text', "Tom Tom",
					'checked', self.db.char.TOMTOM_WAYPOINTS,
					'func', function ()
						self.db.char.TOMTOM_WAYPOINTS = not self.db.char.TOMTOM_WAYPOINTS
						self.db.char.CART_WAYPOINTS = not self.db.char.TOMTOM_WAYPOINTS					
					end,
					'isRadio', true,
					'tooltipTitle', "Tom Tom",
					'tooltipText', "Acts as your portable navigation assistant."
					)
				end
			end
			
			if value == "MoneyRewards" then
				Dewdrop:AddLine(
					'text', "Gold Amount Filter",
					'hasArrow', true,
					'hasSlider', true,
					'sliderMin', 1,
					'sliderMinText', Crayon:Gold("1 ") .. format(TEXTURE_LINK_FORMAT, "Interface\\Addons\\DailiesQuestTracker\\Icons\\GoldIcon.tga", 12, 12, 0),
					'sliderMax', 25,
					'sliderMaxText', Crayon:Gold("25 ") .. format(TEXTURE_LINK_FORMAT, "Interface\\Addons\\DailiesQuestTracker\\Icons\\GoldIcon.tga", 12, 12, 0),
					'sliderStep', 1,
					'sliderValue', self.db.char.GoldDisplay,
					'sliderFunc', function(value)
						self.db.char.GoldDisplay = value
					end,
					'icon', "Interface\\Icons\\INV_Misc_Coin_02",
					'tooltipTitle', "Gold Amount Filter",
					'tooltipText', "Displays the minimum gold value you'd like displayed from quests."
				)
				
				Dewdrop:AddLine(
					'text', " "
				)
					
				for QuestName, GroupText in goldByKeys (DailyQuestsList) do
					if DailyQuestsList[QuestName]["area"] == nil then
						Dailies:Debug(QuestName)
					end

					if Dailies.db.char.DailyQuestsObjectives[QuestName] then
						QuestStatus = Crayon:Yellow(QuestName)					
					elseif Dailies.db.char.DailyQuestsCompleted[QuestName] then
						QuestStatus = Crayon:White(QuestName) 
					elseif Dailies.db.char.DailyQuestsAccepted[QuestName] then
						QuestStatus = "|cff2ba1ff" .. QuestName .. "|r"
					else
						QuestStatus = "|cff808080" .. QuestName .. "|r" 
					end
					
					if DailyQuestsList[QuestName]["group"] == "HInstance" then
						QuestLocation = Crayon:White(L["Heroic Instance: "])
					elseif DailyQuestsList[QuestName]["group"] == "DInstance" then
						QuestLocation = Crayon:White(L["Dungeon Instance: "])
					elseif DailyQuestsList[QuestName]["group"] == "BGPvP" then
						QuestLocation = Crayon:White(L["Battleground: "])
					else
						QuestLocation = Crayon:White("Zone: ")
					end
						
					if DailyQuestsList[QuestName]["gold"] and (self.db.char.Filters[DailyQuestsList[QuestName]["group"]] == false) then
						local LeftCoord, RightCoord = (":"):split(DailyQuestsList[QuestName]["coords"]); local LeftCoord = tonumber(ceil(LeftCoord)); local RightCoord = tonumber(ceil(RightCoord))
						if (DailyQuestsList[QuestName]["gold"] >= (self.db.char.GoldDisplay * 10000)) then
							MoneyValue = Dailies:FormatTheGold(DailyQuestsList[QuestName]["gold"], 0)
							MoneyValueTooltip = Dailies:FormatTheGold(DailyQuestsList[QuestName]["gold"], 0)						
							if (Dailies.db.char.QuestGiver == true) then
								if (LeftCoord == 0) and (RightCoord == 0) then
									Dewdrop:AddLine(
										'text', Crayon:Gold("[") .. MoneyValue .. Crayon:Gold("] ") .. QuestStatus,
										'icon', DailyQuestsList[QuestName]["icon"],
										'iconHeight', 14,
										'iconWidth', 14,
										'tooltipTitle', format(TEXTURE_LINK_FORMAT, DailyQuestsList[QuestName]["icon"], 14, 14, 0) .. " " .. QuestStatus,
										'tooltipText', QuestLocation .. DailyQuestsList[QuestName]["area"] .. "\n" .. Crayon:White(L["Monetary Value: "]) .. MoneyValueTooltip .. "\n\n" .. Crayon:White("Quest Giver: ") .. DailyQuestsList[QuestName].qgiver .. "\n" .. Crayon:White("Location: ") .. DailyQuestsList[QuestName].qzone
									)
								else
									Dewdrop:AddLine(
										'text', Crayon:Gold("[") .. MoneyValue .. Crayon:Gold("] ") .. QuestStatus,
										'icon', DailyQuestsList[QuestName]["icon"],
										'iconHeight', 14,
										'iconWidth', 14,										
										'tooltipTitle', format(TEXTURE_LINK_FORMAT, DailyQuestsList[QuestName]["icon"], 14, 14, 0) .. " " .. QuestStatus,
										'tooltipText', QuestLocation .. DailyQuestsList[QuestName]["area"] .. "\n" .. Crayon:White(L["Monetary Value: "]) .. MoneyValueTooltip .. "\n\n" .. Crayon:White("Quest Giver: ") .. DailyQuestsList[QuestName].qgiver .. "\n" .. Crayon:White("Location: ") .. DailyQuestsList[QuestName].qszone .. Crayon:White(", ") .. DailyQuestsList[QuestName].qzone .. "\n" .. Crayon:White("Coordinates: ") .. Crayon:Green(LeftCoord)  .. Crayon:White(", ") .. Crayon:Green(RightCoord)
									)							
								end
							else
								Dewdrop:AddLine(
									'text', Crayon:Gold("[") .. MoneyValue .. Crayon:Gold("] ") .. QuestStatus,
									'icon', DailyQuestsList[QuestName]["icon"],
									'iconHeight', 14,
									'iconWidth', 14,									
									'tooltipTitle', format(TEXTURE_LINK_FORMAT, DailyQuestsList[QuestName]["icon"], 14, 14, 0) .. " " .. QuestStatus,
									'tooltipText', QuestLocation .. DailyQuestsList[QuestName]["area"] .. "\n" .. Crayon:White(L["Monetary Value: "]) .. MoneyValueTooltip
								)
							end
						end
					end
				end
			end		
		end
	end
end -- function OnMenuRequest

function Dailies:ShowFractionsFrames(this)
end -- function ShowFrame