﻿
function DMAScroll_Init(objScroll, objSlider)
  objScroll:Clear();
  objScroll:ScrollToTop();
  objSlider:SetMinMaxValues(0,0);
  objSlider:SetValue(0);
end

function DMAScroll_Scroll(objScroll, objSlider, dir)
  local step = 1;
    
  if(dir == 1) then
    objScroll:ScrollDown();
    objSlider:SetValue(objSlider:GetValue() + step);  
  else
    objScroll:ScrollUp();
    objSlider:SetValue(objSlider:GetValue() - step);  
  end
  
end

function DMAScroll_ScrollToTop(objScroll, objSlider)
  
  objScroll:ScrollToTop();  
  
  for i=1, (objScroll:GetNumMessages()-1) do
    objScroll:ScrollDown();
  end
  
  objSlider:SetMinMaxValues(objScroll:GetNumLinesDisplayed(),objScroll:GetNumMessages());
  objSlider:SetValue(objScroll:GetNumLinesDisplayed());
end

function DMAScroll_OnValueChanged(objScroll, objSlider)
  objScroll:ScrollToTop();
  for i=2, math.floor(objSlider:GetValue()) do
    objScroll:ScrollDown();
  end
end

function DMAScroll_AddMessage(objScroll, objSlider, strText, r, g, b)
  objScroll:AddMessage(strText,r,g,b);
  --objSlider:SetMinMaxValues(objScroll:GetNumLinesDisplayed(),objScroll:GetNumMessages());
end

function DMAScroll_MsgOnMouseWheel(objScroll, objSlider, dir)
  DMAScroll_Scroll(objScroll, objSlider, -dir)
end