﻿
local SendMailFunc = SendMailFrame_SendMail;

function DMAOutbox_OnLoad()
  DMAOutbox:SetParent(SendMailFrame);
  DMAOutbox:RegisterEvent("ADDON_LOADED");
  DMAOutbox:RegisterEvent("MAIL_SHOW");
  DMAOutbox:RegisterEvent("MAIL_CLOSED");
  DMAOutbox:RegisterEvent("MAIL_SEND_INFO_UPDATE");
  DMAOutbox:RegisterEvent("UPDATE_PENDING_MAIL");
  DMAOutbox:RegisterForDrag("LeftButton");
end

function DMAOutbox_OnEvent()
  
end

function SendMailFrame_SendMail()
  DMARecents_Add(SendMailNameEditBox:GetText());
  DMAOutbox_GetRecents();
  SendMailFunc();
end

function DMAOutbox_GetGuildMembers()
  local senders = DMAGuild_GetMembers();
  
  if(senders == nil) then
    return;
  end
  
  DMAScroll_Init(txtGuild, slGuild);
  
  for i=1, #senders do
    local pmsg = "";
    pmsg = "|H" .. senders[i]["name"] .. "|h" .. senders[i]["name"] .. "|h";
    if(senders[i]["online"] == nil) then
      DMAScroll_AddMessage(txtGuild, slGuild, pmsg, .80, .80, .80);
    else
      DMAScroll_AddMessage(txtGuild, slGuild, pmsg, .65, 1, .65);
    end
    
  end
  
  DMAScroll_ScrollToTop(txtGuild, slGuild);
end

function DMAOutbox_GetFriends()
  local senders = DMAFriends_GetFriends();
  
  if(senders == nil) then
    return;
  end
  
  DMAScroll_Init(txtFriends, slFriends);
  
  for i=0, #senders do
    local pmsg = "";
    pmsg = "|H" .. senders[i]["name"] .. "|h" .. senders[i]["name"] .. "|h";
    if(senders[i]["online"] == nil) then
      DMAScroll_AddMessage(txtFriends, slFriends, pmsg, .80, .80, .80);
    else
      DMAScroll_AddMessage(txtFriends, slFriends, pmsg, .65, 1, .65);
    end
    
  end
  
  DMAScroll_ScrollToTop(txtFriends, slFriends);
end

function DMAOutbox_GetRecents()
  local senders = DMARecents_Get();

  if(senders == nil) then
    return;
  end
  
  DMAScroll_Init(txtRecent, slRecent);
  
  for i=0, #senders do
    if(senders[i] ~= nil) then
      local pmsg = "";
      pmsg = "|H" .. senders[i] .. "|h" .. senders[i] .. "|h";
      DMAScroll_AddMessage(txtRecent, slRecent, pmsg, .80, .80, .80);
    end
  end
  
  DMAScroll_ScrollToTop(txtRecent, slRecent);
end


