﻿
MAIL_QUEUE = {};
MAIL_QUEUE_ITEMS = 0;
MAIL_PROCESSING = false;



function DMAMail_EventHandler()

  DebugPrint("DMAMail_EventHandler: Event Fired: " .. event);
  
  if(event == "BAG_UPDATE") then
    DMAMail_BagUpdate();
  elseif(event == "PLAYER_MONEY") then
    DMAMail_PlayerMoney();
  elseif(event == "MAIL_INBOX_UPDATE") then
    DMAMail_MailInboxUpdate();
  elseif(event == "MAIL_FAILED") then
    DMAMail_MailFailed();
  elseif(event == "MAIL_CLOSED") then
    DMAMail_MailClosed();
  elseif(event == "MAIL_SEND_INFO_UPDATE") then
    DMAMail_SendInfoUpdate();
  elseif(event == "MAIL_SHOW") then
    DMAMail_MailShow();
  elseif(event == "ITEM_PUSH") then
    DMAMail_ItemPush();
  end
end

--BAG_UPDATE
function DMAMail_ItemPush()
  if(MAIL_PROCESSING == true) then
    DMAMail_ProcessQueue();  
  end
end

--BAG_UPDATE
function DMAMail_BagUpdate(arg1)
end

--PLAYER_MONEY
function DMAMail_PlayerMoney()
  if(MAIL_PROCESSING == true) then
    DMAMail_ProcessQueue();  
  end
end

--MAIL_INBOX_UPDATE
function DMAMail_MailInboxUpdate()
  if(IsFrameDisplayed(DMAInbox) == true) then
    DMAInbox_ShowInboxInfo();
    DMAInbox_PopulateDropDown();
  end
end

--MAIL_FAILED
function DMAMail_MailFailed()
end

--MAIL_CLOSED
function DMAMail_MailClosed()
end

--MAIL_SEND_INFO_UPDATE
function DMAMail_SendInfoUpdate()
end

--MAIL_SHOW
function DMAMail_MailShow()
  CheckInbox();
end

function DMAMail_GetMoneyCount()
  local amount = 0;
  local iG = 0;
  local iS = 0;
  local iC = 0;
  
  for i=GetInboxNumItems(),1, -1  do
    packageIcon, stationeryIcon, sender, subject, money, CODAmount, daysLeft, hasItem, wasRead,     wasReturned, textCreated, canReply, isGM = GetInboxHeaderInfo(i);
  
    if(money ~= nil) then
      if(money > 0) then
        amount = amount + money;
      end
    end
    
  end

  local msg = "";

  if(amount > 0) then
    iG = (amount / 10000);
    iS = (iG - math.floor(iG)) * 100;
    iC = (iS - math.floor(iS)) * 100;
    iG = math.floor(iG);
    iS = math.floor(iS);
    iC = math.ceil(iC);

    return iG, iS, iC;
  else
    return 0,0,0;
  end
end

function DMAMail_GetNewCount()
  local newCount = 0;
  for i=GetInboxNumItems(),1, -1  do
    packageIcon, stationeryIcon, sender, subject, money, CODAmount, daysLeft, hasItem, wasRead,     wasReturned, textCreated, canReply, isGM = GetInboxHeaderInfo(i);
    if(wasRead == nil) then
      newCount = newCount + 1;
    end
  end
  return newCount;
end

function DMAMail_GetSenders()
  local tbl = {};
  local tblIndex = 0;

  for i=GetInboxNumItems(),1, -1  do
    packageIcon, stationeryIcon, sender, subject, money, CODAmount, daysLeft, hasItem, wasRead,     wasReturned, textCreated, canReply, isGM = GetInboxHeaderInfo(i);
    senderFound = false;
   
    for j=0, #tbl do
      if(tbl[j] == sender) then
        senderFound = true;
      end
    end
    if(senderFound == false) then
      tbl[tblIndex] = sender;
      tblIndex = tblIndex + 1;
    end
  end
  
  table.sort(tbl);
  
  return tbl;
end

function DMAMail_GetInboxInfo()
  local info = {};
  info["messages"] = GetInboxNumItems();
  info["senders"] = DMAMail_GetSenders();
  info["newMail"] = HasNewMail();
  info["newCount"] = DMAMail_GetNewCount();
  info["gold"], info["silver"], info["copper"] = DMAMail_GetMoneyCount();
  info["items"] = {};
    
  return info;
end

function DMAMail_StartProcessQueue()
  DebugPrint("Start Process Queue");
  MAIL_PROCESSING = true;
  DMAMail_ProcessQueue();
end

function DMAMail_EndProcessQueue()
  DebugPrint("End Process Queue");
  MAIL_QUEUE = {};
  MAIL_QUEUE_ITEMS = 0;
  MAIL_PROCESSING = false;
  DMAInbox_ShowInboxInfo();
end


function DMAMail_PrintQueue()

  if(MAIL_QUEUE == nil) then
    MAIL_QUEUE = {};
    MAIL_QUEUE_ITEMS = 0;
    MAIL_PROCESSING = false;
    Print("Queue Empty",1,.5,.5);
    return;
  end
  
  for i=0, MAIL_QUEUE_ITEMS do
    if(MAIL_QUEUE[i] ~= nil) then
      Print(MAIL_QUEUE[i]["type"] .. ", " .. MAIL_QUEUE[i]["inboxIndex"] .. ", " .. MAIL_QUEUE[i]["itemIndex"], 1, .5, .5);
    end
  end
end


function DMAMail_QueueGrabAll()
  MAIL_QUEUE = {};
  MAIL_QUEUE_ITEMS = 0;
  
  for i=GetInboxNumItems(),1, -1  do
    packageIcon, stationeryIcon, sender, subject, money, CODAmount, daysLeft, hasItem, wasRead,     wasReturned, textCreated, canReply, isGM = GetInboxHeaderInfo(i);
  
    if(money ~= nil) then
      if(money > 0) then
        MAIL_QUEUE[MAIL_QUEUE_ITEMS] = {};
        MAIL_QUEUE[MAIL_QUEUE_ITEMS]["type"] = "MONEY";
        MAIL_QUEUE[MAIL_QUEUE_ITEMS]["inboxIndex"] = i;
        MAIL_QUEUE[MAIL_QUEUE_ITEMS]["itemIndex"] = 0;
        MAIL_QUEUE[MAIL_QUEUE_ITEMS]["processed"] = false;
        MAIL_QUEUE_ITEMS = MAIL_QUEUE_ITEMS + 1;
      end
    end
    
    if(hasItem ~= nil) then
      for j=hasItem, 1, -1 do
        cname, citemTexture, ccount, cquality, ccanUse = GetInboxItem(i, j);
        if(cname ~= nil) then
          MAIL_QUEUE[MAIL_QUEUE_ITEMS] = {};
          MAIL_QUEUE[MAIL_QUEUE_ITEMS]["type"] = "ITEM";
          MAIL_QUEUE[MAIL_QUEUE_ITEMS]["inboxIndex"] = i;
          MAIL_QUEUE[MAIL_QUEUE_ITEMS]["itemIndex"] = j;
          MAIL_QUEUE[MAIL_QUEUE_ITEMS]["processed"] = false;
          MAIL_QUEUE_ITEMS = MAIL_QUEUE_ITEMS + 1;
        end
      end
    end
  end

end
         
function DMAMail_QueueGrabSender(senderName, getItems, getMoney)
  MAIL_QUEUE = {};
  MAIL_QUEUE_ITEMS = 0;
  
  DebugPrint("Start QueueGrabSender");
  
  for i=GetInboxNumItems(),1, -1  do
    packageIcon, stationeryIcon, sender, subject, money, CODAmount, daysLeft, hasItem, wasRead,     wasReturned, textCreated, canReply, isGM = GetInboxHeaderInfo(i);
  
    if(sender == senderName or senderName == "All") then
      
      if(getMoney == true) then
        if(money ~= nil) then
          if(money > 0) then
            MAIL_QUEUE[MAIL_QUEUE_ITEMS] = {};
            MAIL_QUEUE[MAIL_QUEUE_ITEMS]["type"] = "MONEY";
            MAIL_QUEUE[MAIL_QUEUE_ITEMS]["inboxIndex"] = i;
            MAIL_QUEUE[MAIL_QUEUE_ITEMS]["itemIndex"] = 0;
            MAIL_QUEUE[MAIL_QUEUE_ITEMS]["processed"] = false;
            MAIL_QUEUE_ITEMS = MAIL_QUEUE_ITEMS + 1;
          end
        end
      end
    
      if(getItems == true) then
        if(hasItem ~= nil) then
          for j=hasItem, 1, -1 do
            cname, citemTexture, ccount, cquality, ccanUse = GetInboxItem(i, j);
            if(cname ~= nil) then
              MAIL_QUEUE[MAIL_QUEUE_ITEMS] = {};
              MAIL_QUEUE[MAIL_QUEUE_ITEMS]["type"] = "ITEM";
              MAIL_QUEUE[MAIL_QUEUE_ITEMS]["inboxIndex"] = i;
              MAIL_QUEUE[MAIL_QUEUE_ITEMS]["itemIndex"] = j;
              MAIL_QUEUE[MAIL_QUEUE_ITEMS]["processed"] = false;
              MAIL_QUEUE_ITEMS = MAIL_QUEUE_ITEMS + 1;
            end
          end
        end
      end
    end
    
  end
  
  DebugPrint("End QueueGrabSender");

end

function DMAMail_ProcessQueue()
  
  DebugPrint("ProcessQueue");
  
  if(MAIL_PROCESSING == false) then
    DebugPrint("MAIL_PROCESSING is false");
    return;
  end
  
  if(MAIL_QUEUE == nil) then
    DebugPrint("MAIL_QUEUE is nil");
    MAIL_QUEUE = {};
    MAIL_QUEUE_ITEMS = 0;
    MAIL_PROCESSING = false;
    return;
  end
  
  for i=0, MAIL_QUEUE_ITEMS do
    if(MAIL_QUEUE[i] ~= nil) then
      if(MAIL_QUEUE[i]["processed"] == false) then
        MAIL_QUEUE[i]["processed"] = true;
        if(MAIL_QUEUE[i]["type"] == "ITEM") then
          DebugPrint("Taking Inbox Item");
          TakeInboxItem(MAIL_QUEUE[i]["inboxIndex"],MAIL_QUEUE[i]["itemIndex"]);
          return;
        elseif(MAIL_QUEUE[i]["type"] == "MONEY") then
          DebugPrint("Taking Money");
          TakeInboxMoney(MAIL_QUEUE[i]["inboxIndex"]); 
          return;
        end
      end
    end
  end
  
  DebugPrint("Queue done");
  DMAInbox_ShowInboxInfo();
  MAIL_QUEUE = {};
  MAIL_QUEUE_ITEMS = 0;
  MAIL_PROCESSING = false;
end

