﻿
function DMAInbox_OnLoad()
  DMAInbox:SetParent(InboxFrame);
  DMAInbox:RegisterEvent("ADDON_LOADED");
  DMAInbox:RegisterEvent("MAIL_SHOW");
  DMAInbox:RegisterEvent("MAIL_CLOSED");
  DMAInbox:RegisterEvent("MAIL_INBOX_UPDATE");
  DMAInbox:RegisterEvent("MAIL_FAILED");
  DMAInbox:RegisterEvent("MAIL_SEND_INFO_UPDATE");
  DMAInbox:RegisterEvent("UPDATE_PENDING_MAIL");
  DMAInbox:RegisterEvent("BAG_UPDATE");
  DMAInbox:RegisterEvent("PLAYER_MONEY");
  DMAInbox:RegisterEvent("ITEM_PUSH");
  DMAInbox:RegisterForDrag("LeftButton");
end

function DMAInbox_OnEvent()
  DMAMail_EventHandler();
end

function DMAInbox_ShowInboxInfo()
  local info = DMAMail_GetInboxInfo();
  local msg = "";
  
  SetLabelText("lblCount",info["messages"]);
      
  if(info["newMail"] == nil or info["newMail"] == 0) then
    SetLabelText("lblNew","0");
  else
    SetLabelText("lblNew",info["newCount"]);
  end
  
  msg="<html><body><p>";
   
  if(info["gold"] > 0) then
    msg = msg .. info["gold"] .. " |Tinterface\\addons\\daemonmailassist\\textures\\gold:12:12:0:0|t";
  end
  if(info["silver"] > 0) then
    msg = msg .. info["silver"] .. " |Tinterface\\addons\\daemonmailassist\\textures\\silver:12:12:0:0|t";
  end
  if(info["copper"] > 0) then
    msg = msg .. info["copper"] .. " |Tinterface\\addons\\daemonmailassist\\textures\\copper:12:12:0:0|t";
  end

  msg = msg .. "</p></body></html>";
   
  htmlMoney:SetText(msg);
  
  if(info["messages"] == nil or info["messages"] == 0) then
    btnGrab:Disable();
    chkItems:Disable();
    chkMoney:Disable();
  else
    btnGrab:Enable();
    chkItems:Enable();
    chkMoney:Enable();
  end
end

function DMAInbox_PopulateDropDown()
  local senders = DMAMail_GetSenders();
  
  if(senders == nil) then
    return;
  end
  
  local ddlSenders_init_fn = function()
    for i=-1, #senders do
      local entry = UIDropDownMenu_CreateInfo();
      if(i == -1) then
        entry.textHeight = 11;
        entry.text = "All";
        entry.value = "All";
        entry.func = function() 
                       ddlSenders.selectedName = "All";
                       ddlSenders.selectedID = i;
                       ddlSenders.selectedValue = "All";
                       ddlSendersText:SetText("All"); 
                     end
        ddlSenders.selectedName = "All";
        ddlSenders.selectedID = i;
        ddlSenders.selectedValue = "All";
        ddlSendersText:SetText("All"); 
      else
        entry.textHeight = 11;
        entry.text = senders[i];
        entry.value = senders[i];
        entry.func = function() 
                       ddlSenders.selectedName = senders[i];
                       ddlSenders.selectedID = i;
                       ddlSenders.selectedValue = senders[i];
                       ddlSendersText:SetText(senders[i]);
                     end
      end
      
      UIDropDownMenu_AddButton(entry);
    end
  end
  UIDropDownMenu_Initialize(ddlSenders, ddlSenders_init_fn)
end

