--local DRTimers_Config = {}
local DRTimers_Defaults = {
   ["debug"] = true,
   ["debuglevel"] = 1,
   ["scale"] = 1.0,
   ["titleshown"] = true,
   ["enabled"] = true,
   ["movable"] = true,
   ["version"] = "0.1231",
   ["growup"] = false,
   ["track"] = {
      ["target"] = true,
      ["party"] = true,
      ["raid"] = true,
      ["hostileplayers"] = true,
      ["friendlyplayers"] = true,
      ["focus"] = true,
      ["playerpets"] = true,
   }
}
local debuglevel = 0
local debug = false
local candy = LibStub:GetLibrary("LibCandyBar");
local player = UnitName("player")

local function print(msg)
   DEFAULT_CHAT_FRAME:AddMessage(tostring(msg))
end

function DRTimers_Debug(msg, level) 
   if( debug == true ) then
      if (level == nil) then
	 level = 0
      end
      if(level >= debuglevel) then
	 DEFAULT_CHAT_FRAME:AddMessage(tostring(msg));
      end
   end
end

function DRTimers_Message(msg)
   DEFAULT_CHAT_FRAME:AddMessage(tostring(msg))
end

function DRTimers_OnLoad()
   DRTimers_Debug("Loading DRTimers")
   SLASH_DRTIMERS1 = "/DRTimers";
   SLASH_DRTIMERS2 = "/DRT";
   SlashCmdList["DRTIMERS"] = DRTimers_SlashCommand
   this:RegisterEvent("VARIABLES_LOADED");
   this:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
   DRTimers_Message("DRTimers Loaded - /DRT or /DRTimers to see commands");
end

function DRTimers_OnEvent(event)
--   DRTimers_Debug(event, 0)
   DRTimers_EventHandler[event]()
end

DRTimers_EventHandler = {}
DRTimers_EventHandler["VARIABLES_LOADED"] = function()
   DRTimers_Debug("Entering VARIABLES_LOADED handler")
   if ( not DRTimers_Config ) then
      DRTimers_Message("Configuring DRTimers for the first time...")
      DRTimers_Config = {}
   end
   if ( not DRTimers_Config[player] ) then 
      DRTimers_Message("Loading player defaults.")
      DRTimers_Config[player] = DRTimers_Defaults
   elseif ( DRTimers_Config[player]["version"] ~= DRTimers_Defaults["version"] ) then
      DRTimers_Message("Version mismatch, loading new config")
      DRTimers_AddNewConfigs(DRTimers_Config[player], DRTimers_Defaults)
      DRTimers_Debug("Added new config options", 0)
      DRTimers_RemoveOldConfigs(DRTimers_Config[player], DRTimers_Defaults)
      DRTimers_Config[player]["version"] = DRTimers_Defaults["version"]
   end

   DRTimers_InitFrame();
   DRTimers_ShowTitle();
   DRTimers_Debug("Frame Created");
   DRTimers_LoadSpellList();
   DRTimers_LoadColorList();
   DRTimers_Loaded = true
   DRTimers_ToggleAddon()
   DRTimers_Debug("Leaving VARIABLES_LOADED handler")
end

DRTimers_EventHandler["COMBAT_LOG_EVENT_UNFILTERED"] = function()
  if (not DRTimers_Loaded or not DRTimers_Config[player]["enabled"] ) then
     return 
  end
  
  timestamp = arg1;
  event = arg2;
  sourceGUID = arg3;
  sourceName = arg4
  sourceFlags = arg5;
  destGUID = arg6;
  destName = arg7;
  destFlags = arg8;
  reaction = bit.band(destFlags, 0xf0)
  affiliation = bit.band(destFlags, COMBATLOG_OBJECT_AFFILIATION_MASK)
  istarget = bit.band(destFlags, COMBATLOG_OBJECT_TARGET)
  isfocus = bit.band(destFlags, COMBATLOG_OBJECT_FOCUS)
  isplayer = bit.band(destFlags, COMBATLOG_OBJECT_TYPE_PLAYER)
  isplayerpetfilter = bit.bor(COMBATLOG_OBJECT_CONTROL_PLAYER, COMBATLOG_OBJECT_TYPE_PET)
  isplayerpet = bit.band(destFlags, isplayerpetfilter)

  if ( istarget and not DRTimers_Config[player]["track"]["target"] ) then
     return
  elseif ( isfocus and not DRTimers_Config[player]["track"]["focus"] ) then
     return
  elseif ( affiliation == COMBATLOG_OBJECT_AFFILIATION_PARTY and not DRTimers_Config[player]["track"]["party"] ) then 
     return
  elseif ( affiliation == COMBATLOG_OBJECT_AFFILIATION_RAID and not DRTimers_Config[player]["track"]["raid"] ) then
     return
  elseif ( not (istarget or isfocus) and reaction == COMBATLOG_OBJECT_REACTION_HOSTILE and isplayer and not DRTimers_Config[player]["track"]["hostileplayers"] ) then
     return
  elseif ( not (istarget or isfocus) and reaction == COMBATLOG_OBJECT_REACTION_FRIENDLY and isplayer and not DRTimers_Config[player]["track"]["friendlyplayers"] ) then
     return
  elseif ( not (istarget or isfocus) and isplayerpet and not DRTimers_Config[player]["track"]["playerpets"]) then
     return
  end

  if(event == "SPELL_AURA_REMOVED") then
     if(DRTimers_SpellList) then
	spellName = arg10
	if(DRTimers_SpellList[spellName]) then 
	   DRTimers_StartTimer(DRTimers_SpellList[spellName], title, 15, destGUID, destName, DRTimers_GetTimerColor(reaction));
	end
     end
  end
end


function DRTimers_InitFrame()
   DRTimers_Debug("Entering InitFrame")
   -- thankes to natur for this code :)
   title = 'DRTimers'
   anchor = CreateFrame("Frame",title.."_ANCHOR",UIParent); -- these need names if you want them to save their position across sessions
   ------------------------
   anchor:SetToplevel(true);
   anchor:SetFrameStrata("LOW");
   anchor:SetWidth(200);
   anchor:SetHeight(25);
   anchor:SetBackdrop{bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", tile = true, tileSize = 16, 
		      edgeSize = 0, insets = {left = 0, right = 0, top = 0, bottom = 0}};
   anchor:SetBackdropColor(0,0,0,0.75);
   anchor:SetPoint("CENTER");
   anchor:EnableMouse(true);
   anchor:SetMovable(true);
   anchor:SetClampedToScreen(true);
   ------------------------
   anchor.title = anchor:CreateFontString(nil,"OVERLAY");
   anchor.title:SetFont(STANDARD_TEXT_FONT,12);
   anchor.title:SetWidth(200); anchor.title:SetHeight(12);
   anchor.title:SetPoint("CENTER");
   anchor.title:SetText(title);
   -------------------------
   anchor:SetScript("OnMouseDown",function() DRTimers_MoveAnchor(anchor, true); end);
   anchor:SetScript("OnDragStart",function() DRTimers_MoveAnchor(anchor, true); end);
   anchor:SetScript("OnMouseUp",function() DRTimers_MoveAnchor(anchor, false); end);
   anchor:SetScript("OnDragStop",function() DRTimers_MoveAnchor(anchor, false); end);
   ------------------------
   candy:RegisterCandyBarGroup(title);
   candy:SetCandyBarGroupPoint(title,"TOP",anchor,"BOTTOM",0,0);	
   DRTimers_SetGrowth()
   anchor:Show();
   DRTimers_Debug("Leaving InitFrame")
end
   

function DRTimers_MoveAnchor(anchor,unlock) -- this enabled the fancy movement animation
   if (not anchor) then return; end	
   if (unlock and IsControlKeyDown()) then
      anchor:SetBackdropColor(1,1,0,0.75);
      anchor:StartMoving();
   else
      anchor:SetBackdropColor(0,0,0,0.75);
      anchor:StopMovingOrSizing();
   end
end;

function DRTimers_ShowTitle()
   if(DRTimers_Config[player]["titleshown"]) then
      anchor:SetHeight(25)
      anchor:SetWidth(200)
      anchor:SetAlpha(1)
   else
      anchor:SetHeight(1)
      anchor:SetWidth(1)
      anchor:SetAlpha(0)
   end
end


function DRTimers_GetTimerColor(reaction)
   return DRTimers_ColorList[reaction][1], DRTimers_ColorList[reaction][2], DRTimers_ColorList[reaction][3]
end

function DRTimers_StartTimer(DRType, group, duration, targetGUID, target, r, g, b)
   DRTimers_Debug("Starting Timer " .. DRType.name);
   candy:RegisterCandyBar(DRType.name, duration, DRType.name .. ' - ' .. target, DRType.icon, r or 0, g or 1, b or 0)
   candy:SetCandyBarScale(DRType.name, DRTimers_Config[player]["scale"])
   candy:RegisterCandyBarWithGroup(DRType.name, group)
   candy:StartCandyBar(DRType.name, true)
end


function DRTimers_GetWords(str)
   local ret = {};
   local pos=0;
   while(true) do
      local word;
      _,pos,word=string.find(str, "^ *([^%s]+) *", pos+1);
      if(not word) then
	 return ret;
      end
      table.insert(ret, word);
   end
end

function DRTimers_SlashCommand(msg)
   DRTimers_Debug("Message " .. msg .. '!!');
   local words = DRTimers_GetWords(msg)
   for i,line in ipairs(words) do
      DRTimers_Debug(line)
   end

   if (msg == "") then
      DRTimers_Message('Use Ctrl+LeftClick to move the bar.');
      DRTimers_Message('toggle')
      print('scale %')
   elseif (words[1] == "toggle") then
      if (words[2] == "addon" ) then
	 DRTimers_Config[player]["enabled"] = not DRTimers_Config[player]["enabled"]
	 DRTimers_ToggleAddon()
      elseif (words[2] == "title") then
	 DRTimers_Config[player]["titleshown"] = not DRTimers_Config[player]["titleshown"]
	 DRTimers_ShowTitle()
      elseif (words[2] == "grow_direction") then
	 DRTimers_Config[player]["growup"] = not DRTimers_Config[player]["growup"]
	 DRTimers_SetGrowth()
      elseif (words[2] == "track") then
	 if ( words[3] ~= nil ) then
	    if ( DRTimers_Config["track"][words[3]] ~= nil ) then
	       DRTimers_Config[player]["track"][words[3]] = not DRTimers_Config[player]["track"][words[3]]
	       DRTimers_Message("Toggled tracking of " .. words[3])
	    end
	 else
	    print("Possible tracking targets -- ")
	    for key, value in pairs(DRTimers_Config[player]["track"]) do
	       print("   " .. key)
	    end
	 end
      else
	 print("toggle options -")
	 print("   addon -- toggles DRTimers on/off")
	 print("   title -- toggles the title bar on/off")  
	 print("   grow_direction -- toggle whether the bars grow up or down")
	 print("   track -- toggle tracking of various units")
      end
   elseif (words[1] == "scale") then
      scale = tonumber(words[2])
      if(not scale) then
	 DRTimers_Message("Invalid Scale");	 
      else
	 anchor:SetScale(scale)
	 DRTimers_Config[player]["scale"] = scale
      end
   elseif (words[1] == "print") then
      for i,v in pairs(DRTimers_Config[player]) do 
	 print(tostring(i) .. " - " .. tostring(v))
      end
   end
end

function DRTimers_ToggleAddon()
   if (not DRTimers_Config[player]["enabled"]) then
      anchor:Hide();
   else
      anchor:Show();
   end
end

function DRTimers_SetGrowth()
   candy:SetCandyBarGroupGrowth(title, DRTimers_Config[player]["growup"])
   if(DRTimers_Config[player]["growup"]) then 
      candy:SetCandyBarGroupPoint(title,"TOP",anchor,"BOTTOM",0,41);	
   else
      candy:SetCandyBarGroupPoint(title,"TOP",anchor,"BOTTOM",0,0);	
   end
end

function DRTimers_AddNewConfigs(configs, defaults)
   DRTimers_Debug("Entering AddNewConfigs", 1)
   if(configs == nil or defaults == nil) then
      return
   end
   DRTimers_Debug("Entering loop", 0)
   for i,v in pairs(defaults) do -- add new options
      DRTimers_Debug(i)
      DRTimers_Debug(v)
      if(configs[i] == nil) then 
	 configs[player][i] = v
      elseif ( string.find(tostring(configs[i]), "table:") ) then
	 DRTimers_Debug(configs[i])
	 DRTimers_Debug(defaults[i])
	 DRTimers_AddNewConfigs(configs[i], defaults[i])
      end
   end
   DRTimers_Debug("Leaving AddNewConfigs", 1)
end

function DRTimers_RemoveOldConfigs(configs, defaults)
   DRTimers_Debug("Entering RemoveOldConfigs", 1)
   if(configs == nil or defaults == nil) then
      return
   end
   for i,v in pairs(configs) do
      if( defaults[i] == nil ) then
	 configs[i] = nil
      elseif ( string.find(tostring(defaults[i]), "table:") ) then
	 DRTimers_RemoveOldConfigs(configs[i], defaults[i])
      end
   end
   DRTimers_Debug("Exit RemoveOldConfigs", 1)
end

      