function DRTimers_LoadColorList()
	DRTimers_Debug("LoadColorList")
	DRTimers_ColorList = {}
	
	DRTimers_ColorList[0x10] = { 0, 1, 0 } -- friendly, green
	DRTimers_ColorList[0x20] = { 1, 1, 0 } -- neutral, 
	DRTimers_ColorList[0x40] = { 1, 0, 0 } -- hostile
	DRTimers_Debug("LoadColorList Exit")
end

function DRTimers_LoadSpellList()
	DRTimers_Debug("LoadSpellList")
	
	if( not DRTimers_DRTypes ) then 
		DRTimers_LoadDRTypes()
	end
	
	DRTimers_Debug("DRTypes Loaded");
	DRTimers_SpellList = {}
	
	-- druid
	DRTimers_SpellList["Bash"] = DRTimers_DRTypes["Stun"] -- tested
	DRTimers_SpellList["Entangling Roots"] = DRTimers_DRTypes["Root"] -- tested
	DRTimers_SpellList["Hibernate"] = DRTimers_DRTypes["Sleep"] -- tested
	DRTimers_SpellList["Cyclone"] = DRTimers_DRTypes["Cyclone"] -- untested
	DRTimers_SpellList["Celestial Focus"] = DRTimers_DRTypes["Stun Proc"] -- untested
	-- hunter
	DRTimers_SpellList["Freezing Trap Effect"] = DRTimers_DRTypes["Sleep"] -- tested
	--DRTimers_SpellList["Entrapment"] =	Yes 	TBD 	None
	DRTimers_SpellList["Wyvern Sting"] = DRTimers_DRTypes["Sleep"] -- untested
	-- mage
	DRTimers_SpellList["Frost Nova"] = DRTimers_DRTypes["Root"] -- untested
	DRTimers_SpellList["Polymorph"] = DRTimers_DRTypes["Polymorph"] -- tested
	DRTimers_SpellList["Impact"] = DRTimers_DRTypes["Stun"] -- untested
	DRTimers_SpellList["Frostbite"] = DRTimers_DRTypes["Root Proc"]  --untested
	-- shaman
	DRTimers_SpellList["Stoneclaw Stun"] = DRTimers_DRTypes["Stun Proc"] -- tested
	-- paladin
	DRTimers_SpellList["Hammer of Justice"] = DRTimers_DRTypes["Stun"] -- tested
	DRTimers_SpellList["Stun"] = DRTimers_DRTypes["Stun Proc"] -- tested
	-- priest
	DRTimers_SpellList["Psychic Scream"] = DRTimers_DRTypes["Fear"] -- tested
	DRTimers_SpellList["Mind Control"] = DRTimers_DRTypes["Charm"] -- tested
	DRTimers_SpellList["Blackout"] = DRTimers_DRTypes["Stun Proc"] -- untested
	-- rogue
	DRTimers_SpellList["Kidney Shot"] = DRTimers_DRTypes["Kidney Shot"]; -- tested
	DRTimers_SpellList["Cheap Shot"] = DRTimers_DRTypes["Stun"]; -- tested
	DRTimers_SpellList["Sap"] = DRTimers_DRTypes["Polymorph"]; -- tested
	DRTimers_SpellList["Gouge"] = DRTimers_DRTypes["Polymorph"] -- tested
	DRTimers_SpellList["Blind"] = DRTimers_DRTypes["Cyclone"] -- tested
	DRTimers_SpellList["Mace Specialization"] = DRTimers_DRTypes["Stun Proc"] -- untested
	-- warlock
	DRTimers_SpellList["Fear"] = DRTimers_DRTypes["Fear"] -- tested
	DRTimers_SpellList["Seduction"] = DRTimers_DRTypes["Fear"] -- tested 
	DRTimers_SpellList["Howl of Terror"] = DRTimers_DRTypes["Fear"] -- tested
	DRTimers_SpellList["Death Coil"] = DRTimers_DRTypes["Horror"] -- tested
	DRTimers_SpellList["Shadowfury"] = DRTimers_DRTypes["Stun"] -- untested
	-- warrior
	DRTimers_SpellList["Mace Specialization (Stun)"] = DRTimers_DRTypes["Stun Proc"] -- untested
	DRTimers_SpellList["Charge Stun"] = DRTimers_DRTypes["Stun"] -- tested
	DRTimers_SpellList["Intercept Stun"] = DRTimers_DRTypes["Stun"] -- tested
	DRTimers_SpellList["Concussion Blow"] = DRTimers_DRTypes["Stun"] -- untested

end

local addDRType = function(DRtype, id, name)

	local name2,rank,icon,_,_,_,castTime = GetSpellInfo(id);

	DRTimers_DRTypes[DRtype] = {}
	DRTimers_DRTypes[DRtype].icon = icon;
	DRTimers_DRTypes[DRtype].name = name;

end

function DRTimers_LoadDRTypes()

	DRTimers_DRTypes = {}
	
	addDRType("Kidney Shot", 408, "Kidney Shot");
	addDRType("Stun", 853, "Stun");
	addDRType("Stun Proc", 20253, "Stun Proc");
	addDRType("Root", 339, "Root");
	addDRType("RootProc", 11071, "Root Proc");
	addDRType("Fear", 5782, "Fear");
	addDRType("Charm", 605, "Charm");
	addDRType("Polymorph", 2070, "Gouge/Poly/Sap");
	addDRType("Cyclone", 29538, "Cyclone/Blind");
	addDRType("Horror", 6789, "Horror");
	addDRType("Sleep", 2637, "Sleep");

end


	