--------------------------------------------------------------------------
--                   DPSMeter by Daedal at Darksorrow EU                --
-- The code is not very clean, but I try to clean it and make it faster --
--------------------------------------------------------------------------
DPSMeter = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceEvent-2.0", "AceDB-2.0");
dewdrop = AceLibrary("Dewdrop-2.0");
DPSMETERDEBUG = false;
DPSSESSIONSECS = 0;
DPSSESSIONDMG = 0;
DPSSESSIONBEST = 0;
DPSSESSIONTOPHIT = 0;
DPSSESSIONSPELL = "none";
DPSSESSIONAVG = 0;
DPSDMGMETERS = {};
DPSDMGMETERS["damage"] = {};
DPSDMGMETERS["healing"] = {};
DPSMETERNAMES = {};
DPSDMGMETERINFO = {};
DPSDMGMETERINFO["isRaid"] = false;
DPSDMGMETERINFO["isParty"] = false;
DPSDMGMETERINFO["members"] = 0;
StaticPopupDialogs["DPSMETERBETA"] = {
  text = "Are you sure you want to enable damage meters? They are only in beta testing and it might cause errors and/or incorrect values.",
  button1 = "Yes",
  button2 = "No",
  OnAccept = function()
      DPSMenu_RecEn();
  end,
  timeout = 0,
  whileDead = 1,
  hideOnEscape = 1
};
--################ TINY MENU FUNCS ###################
function DPSMenu_reset()
DPSM_MAXCHART = 40; DPSM_DAMAGE = 0; DPSM_TIME = 0; DPSM_COMBAT = false; DPSM_MAXDPS = 40;
DPSMETERDEBUG = false;
DPSSESSIONSECS = 0;
DPSSESSIONDMG = 0;
DPSSESSIONBEST = 0;
DPSSESSIONTOPHIT = 0;
DPSSESSIONSPELL = "none";
DPSSESSIONAVG = 0;
end
function DPSMenu_Lock()
DPSMeter.db.char.lock = true;
DPSMeterFrame.isLocked = true;
dewdrop:Close();
end
function DPSMenu_UnLock()
DPSMeter.db.char.lock = false;
DPSMeterFrame.isLocked = false;
dewdrop:Close();
end
function DPSMenu_ScEn()
DPSMeter.db.char.scen = true;
dewdrop:Close();
end
function DPSMenu_ScDis()
DPSMeter.db.char.scen = false;
dewdrop:Close();
end
function DPSMenu_HealEn()
DPSMeter.db.char.heal = true;
dewdrop:Close();
end
function DPSMenu_HealDis()
DPSMeter.db.char.heal = false;
dewdrop:Close();
end
function DPSMenu_RecDis()
DPSMeter.db.char.record = false;
dewdrop:Close();
DPSMeter:Print("Damage meters disabled.");
end
function DPSMenu_RecEn()
DPSMeter.db.char.record = true;
dewdrop:Close();
DPSMeter:Print("Damage meters enabled.");
end
function DPSMenu_RecRes()
if (DPSMeter.db.char.record == true) then
dewdrop:Close();
DPSDMGMETERS = {};
DPSDMGMETERS["damage"] = {};
DPSDMGMETERS["healing"] = {};
DPSMeter:Print("Damage meters reseted.");
else
DPSMeter:Print("The damage recording is not enabled. You can enable it from the menu.");
end
end
function DPSMeterNot(value)
local retu;
if (value == true) then retu = false; else retu = true; end
return retu;
end
--####################################################
function DPSMeter_Menu()
	dewdrop:Open(DPSMeterFrame,
    'children', 
    function()
		dewdrop:AddLine('text', "Enable dmg/heal meters", 'checked', DPSMeter.db.char.record, 'func', StaticPopup_Show, 'arg1', "DPSMETERBETA", 'tooltipTitle', "Enable recording",	'tooltipText', "Enable recording damage and healing of party")
        dewdrop:AddLine('text', "Disable dmg/heal meters", 'checked', DPSMeterNot(DPSMeter.db.char.record), 'func', DPSMenu_RecDis, 'tooltipTitle', "Disable recording",	'tooltipText', "Disable recording damage and healing of party")
        dewdrop:AddLine('text', "Print dmg meters", 'func', DPSMeter_PrintRec, 'arg1', "damage", 'tooltipTitle', "Print DMG Meters",	'tooltipText', "Print all damage meter records to chat frame")
        dewdrop:AddLine('text', "Print heal meters", 'func', DPSMeter_PrintRec, 'arg1', "healing", 'tooltipTitle', "Print Heal Meters",	'tooltipText', "Print all healing records to chat frame")
        dewdrop:AddLine('text', "Broadcast dmg meters", 'func', DPSMeter_PrintRec, 'arg1', "damage", 'arg2', 'SAY', 'tooltipTitle', "Broadcast DMG Meters",	'tooltipText', "Broadcast all damage meter records to party/raid chat")
        dewdrop:AddLine('text', "Broadcast heal meters", 'func', DPSMeter_PrintRec, 'arg1', "healing", 'arg2', 'SAY', 'tooltipTitle', "Broadcast Heal Meters",	'tooltipText', "Broadcast all healing records to party/raid chat")
        dewdrop:AddLine('text', "Reset DMG & Heal meters", 'func', DPSMenu_RecRes, 'tooltipTitle', "Reset DMG meters",	'tooltipText', "Reset all damage meter records")
        dewdrop:AddSeparator()
        dewdrop:AddLine(
    		'text', "Set scale",
    		'tooltipTitle', "Scale",
    		'tooltipText', "Sets the scale of the whole frame",
    		'hasArrow', true,
    		'hasSlider', true,
    		'sliderMin', 0.5,
    		'sliderMax', 1.5,
    		'sliderStep', 0.1,
    		'sliderValue', DPSMeter.db.char.scale,
    		'sliderMinText', '50%',
    		'sliderMaxText', '150%',
    		'sliderFunc', function(value)	DPSMeter.db.char.scale = value; DPSMeterFrame:SetScale(value); end
			)
        dewdrop:AddLine(
    		'text', "Set normal transparency",
    		'tooltipTitle', "Normal Transparency",
    		'tooltipText', "Sets the normal transparency of the whole frame",
    		'hasArrow', true,
    		'hasSlider', true,
    		'sliderMin', 0.1,
    		'sliderMax', 1.0,
    		'sliderStep', 0.1,
    		'sliderValue', DPSMeter.db.char.alpha,
    		'sliderMinText', '10%',
    		'sliderMaxText', '100%',
    		'sliderFunc', function(value)	DPSMeter.db.char.alpha = value; DPSMeterFrame:SetAlpha(value); end
			)
		dewdrop:AddLine(
    		'text', "Set combat transparency",
    		'tooltipTitle', "Combat Transparency",
    		'tooltipText', "Sets the transparency of the whole frame while in combat",
    		'hasArrow', true,
    		'hasSlider', true,
    		'sliderMin', 0.1,
    		'sliderMax', 1.0,
    		'sliderStep', 0.1,
    		'sliderValue', DPSMeter.db.char.alpha2,
    		'sliderMinText', '10%',
    		'sliderMaxText', '100%',
    		'sliderFunc', function(value)	DPSMeter.db.char.alpha2 = value; end
			)
		dewdrop:AddSeparator()
        dewdrop:AddLine('text', "Lock Frame", 'func', DPSMenu_Lock, 'tooltipTitle', "Lock", 'checked', DPSMeter.db.char.lock,	'tooltipText', "Locks the frame in place so it can't be dragged")
        dewdrop:AddLine('text', "Unlock Frame", 'func', DPSMenu_UnLock, 'tooltipTitle', "Unlock", 'checked', DPSMeterNot(DPSMeter.db.char.lock),	'tooltipText', "Unlocks the frame so it can be dragged")
        dewdrop:AddSeparator()
        dewdrop:AddLine('text', "Reset DPSMeter", 'func', DPSMenu_reset, 'tooltipTitle', "Reset",	'tooltipText', "Resets the meter, if you have any errors")
        dewdrop:AddSeparator()
        dewdrop:AddLine('text', "Enable SCT display", 'func', DPSMenu_ScEn, 'tooltipTitle', "Enable SCT", 'checked', DPSMeter.db.char.scen,	'tooltipText', "Enable displaying DPS in SCT addon")
        dewdrop:AddLine('text', "Disable SCT display", 'func', DPSMenu_ScDis, 'tooltipTitle', "Disable SCT", 'checked', DPSMeterNot(DPSMeter.db.char.scen),	'tooltipText', "Disable displaying DPS in SCT addon")
        dewdrop:AddSeparator()
        dewdrop:AddLine('text', "Enable heals", 'func', DPSMenu_HealEn, 'tooltipTitle', "Enable heals", 'checked', DPSMeter.db.char.heal,	'tooltipText', "Enable counting of healing spells during combat")
        dewdrop:AddLine('text', "Disable heals", 'func', DPSMenu_HealDis, 'tooltipTitle', "Disable heals", 'checked', DPSMeterNot(DPSMeter.db.char.heal),	'tooltipText', "Disable counting of healing spells during combat")
        dewdrop:AddSeparator()
        dewdrop:AddLine('text', "Close", 'closeWhenClicked', true, 'tooltipTitle', "Close",	'tooltipText', "Close this menu")
    end)
end

function DPSMeter_AddMes(message, color)
	if (DPSMeter.db.char.scen == false) then return end;
	if (not SCT) then return end;
	if (color == nil) then color = {r=1,g=1,b=1}; end
	if (DPSMeter.db.char.frame == "1") then
	SCT:DisplayText(message, color, nil, "event", SCT.FRAME1);
	end
	if (DPSMeter.db.char.frame == "2") then
	SCT:DisplayText(message, color, nil, "event", SCT.FRAME2);
	end
end

function DPSMeter_gg()
	--old, does nothing anymore
end

function DPSMeter_updateparty()
	--store guids in a table (maybe a slow method but it works)
	--check if raid or party
	--DPSMenu_RecRes();
	DPSMETERNAMES = {};
	local isRaid, isParty, members;
	local raid = GetNumRaidMembers();
	if (raid == 0) then isRaid = false; else isRaid = true; end
	if (isRaid == false) then
	members = GetNumPartyMembers(); --parteeeiiiii
	if (members == 0) then isParty = false; else isParty = true; end
	else
	members = raid; -- raid
	end
	--store for other uses
	DPSDMGMETERINFO["isRaid"] = isRaid;
	DPSDMGMETERINFO["isParty"] = isParty;
	DPSDMGMETERINFO["members"] = members;
	-- ok now we have the info about party or raid. so now check the GUIDs out
	DPSMETERNAMES[UnitGUID("player")] = UnitName("player");
	if (isRaid == true) then
	--raid
		for i=1, members, 1 do
			local uid = "raid"..i;
			local uname, uguid = UnitName(uid), UnitGUID(uid);
			DPSMETERNAMES[uguid] = uname;
		end
	else
	--party
		if (isParty == true) then
			for i=1, members, 1 do
				local uid = "party"..i;
				local uname, uguid = UnitName(uid), UnitGUID(uid);
				DPSMETERNAMES[uguid] = uname;
			end
		end
	end
	--woot now we have teh names
end

function DPSMeter_findkey(array, value)
local a;
  for key,val in pairs(array) do
    if (val == value) then a= key; end
  end
return a;
end

function DPSMeter_PrintLines(names, orig, sorti, what, where)
	table.sort(sorti, function(a,b) return a>b end)
	for i,n in pairs(sorti) do
		local t = DPSMeter_findkey(orig,n);
		local w = names[t];
		DPSMeter_swpr(i..". "..w..": "..n.." "..what, where);
		orig[t] = nil;
	end
end

function DPSMeter_swpr(what,where)
	if (where ~=nil) then 
		if (DPSDMGMETERINFO["isRaid"] == true) then
			SendChatMessage(what,"RAID");
		else
			SendChatMessage(what,"PARTY");
		end
	else
	DEFAULT_CHAT_FRAME:AddMessage(what);
	end
end

function DPSMeter_PrintRec(what, where)
	if (DPSMeter.db.char.record == true) then
		--TEMPORARY PRINTING
		local sorta = {};
		local data = {};
		local orig = {};
		DPSMeter_swpr("-----DPSMeter v"..DPSMETERVERSION.." "..what.." records-----", where);
		local name = UnitName("player");
		local dmg = DPSDMGMETERS[what][name];
		if (dmg == nil) then dmg = 0; end
		if (DPSDMGMETERINFO["isRaid"] == false) then 
			--DPSMeter_swpr(name..": "..dmg.." "..what, where); OLD
			local x = DPSDMGMETERINFO["members"];
			data[x+1] = name;
			sorta[x+1] = dmg;
			orig[x+1] = dmg;
		end
		--now start others
		if (DPSDMGMETERINFO["isRaid"] == true) then
		--woo raid
			for i=1, DPSDMGMETERINFO["members"], 1 do
				local uid = "raid"..i;
				local name = UnitName(uid);
				local dmg = DPSDMGMETERS[what][name];
				if (dmg == nil) then dmg = 0; end
				--DPSMeter_swpr(name..": "..dmg.." "..what, where); OLD
				data[i] = name;
				sorta[i] = dmg;
				orig[i] = dmg;
			end 
		else if (DPSDMGMETERINFO["isParty"] == true) then
		--woo party
			for i=1, DPSDMGMETERINFO["members"], 1 do
				local uid = "party"..i;
				local name = UnitName(uid);
				local dmg = DPSDMGMETERS[what][name];
				if (dmg == nil) then dmg = 0; end
				--DPSMeter_swpr(name..": "..dmg.." "..what, where); OLD
				data[i] = name;
				sorta[i] = dmg;
				orig[i] = dmg;
			end 
		end	
		end
		--arrays sorted, now flush...
		--local sorted = DPSMeter_flush(tempdata, sortarray);
		--and, print: TEST TEST
		DPSMeter_PrintLines(data, orig, sorta, what, where);
		--DEFAULT_CHAT_FRAME:AddMessage("---------------------------------------");	
	else
	DPSMeter:Print("The damage recording is not enabled. You can enable it from the menu.");
	end
end

function DPSMeter_Record(sourceGUID,amount,healz)
	local name;
	if (not DPSMETERNAMES[sourceGUID]) then return end; --not in our party
	name = DPSMETERNAMES[sourceGUID];
	if (healz) then
		--record healing
		if (DPSDMGMETERS["healing"][name] == nil) then DPSDMGMETERS["healing"][name] = 0; end --if first heal
		DPSDMGMETERS["healing"][name] = DPSDMGMETERS["healing"][name]+amount;
	else
		--record dmg
		if (DPSDMGMETERS["damage"][name] == nil) then DPSDMGMETERS["damage"][name] = 0; end --if first dmg
		DPSDMGMETERS["damage"][name] = DPSDMGMETERS["damage"][name]+amount;
	end
end

local trackedCombatEvents = {
	["SWING_DAMAGE"] = true,
	["RANGE_DAMAGE"] = true,
	["SPELL_DAMAGE"] = true,
	["SPELL_HEAL"] = true,
	["SPELL_PERIODIC_DAMAGE"] = true,
	["SPELL_PERIODIC_HEAL"] = true,
	-- add combat events to listen/watch
	}

function DPSMeter:PLAYER_DEAD()
	DPSMeter:PLAYER_REGEN_ENABLED(); -- end combat
end	

function DPSMeter_parse(timestamp, event, sourceGUID, sourceName, sourceFlags, destGUID, destName, destFlags, ...)
	local yep = false;
	if (not trackedCombatEvents[event]) then return end
	-- wow we have an event
	ismine = CombatLog_Object_IsA(sourceFlags, COMBATLOG_FILTER_MINE);
	ismypet = CombatLog_Object_IsA(sourceFlags, COMBATLOG_FILTER_MY_PET);
	--if( not ismine and not ismypet )then return end MOVED, FOR RECORDING
	-- wow the event is mine or my pet's
	local spellId, spellName, spellSchool, amount, school, resisted, blocked, absorbed, critical, glancing, crushing, healz
	if (event == "SWING_DAMAGE") then
		healz = false;
		amount, school, resisted, blocked, absorbed, critical, glancing, crushing = select(1, ...);
	else
		if ((event == "SPELL_HEAL") or (event == "SPELL_PERIODIC_HEAL")) then
		healz = true;
		spellId, spellName, spellSchool, amount, critical = select(1, ...);
		else
		healz = false;
		spellId, spellName, spellSchool, amount, school, resisted, blocked, absorbed, critical, glancing, crushing = select(1, ...);
		end
	end
	if (DPSMeter.db.char.record == true) then
	DPSMeter_Record(sourceGUID,amount,healz);
	end
	if ( not ismine and not ismypet ) then return end -- do not count if not mine
	if ( (healz == true) and (DPSM_COMBAT == false) ) then return end; --dont count non combat heals!
	if ( (healz == true) and (DPSMeter.db.char.heal == false) ) then return end; --dont count heals if disabled!
	-- check if records
	local spN;
	if (spellName == nil) then spN = "unknown"; else spN = spellName; end
	DPSMeter_Debugg("add: "..spN.." for "..amount..", ev: "..event);
	if (amount > DPSSESSIONTOPHIT) then
	DPSSESSIONTOPHIT = amount;
	if (spellName ~= nil) then
	DPSSESSIONSPELL = spellName;
	else
	DPSSESSIONSPELL = "Normal hit";
	end
	end
	-- well now add the parser thingy
	if (DPSM_COMBAT == false) then 
	DPSMeter:PLAYER_REGEN_DISABLED();
	end
	DPSM_DAMAGE = DPSM_DAMAGE+amount;
	--DPSMeter_Debugg("HIT: "..amount);
	--DPSMeter_gg();
	-- end!
end

function DPSMeter:PLAYER_REGEN_DISABLED()
	if (DPSM_COMBAT == false) then
	-- combat started!!!!
	DPSDigital:SetText("0");
	DPSM_TIME = GetTime()-0.1;
	DPSTEMP1 = GetTime();
	DPSM_DAMAGE = 0; -- just in case
	DPSM_COMBAT = true;
	end
end

function DPSMeter_round(number)
	local result;
	local frac = number-math.floor(number);
	if (frac < 0.5) then
	result = math.floor(number);
	else
	result = math.ceil(number);
	end
	return result;
end

function DPSMeter:PLAYER_REGEN_ENABLED()
	DPSMeter_Debugg("regen enabled, combat end");
	--combat end! start counting!
	local now = GetTime();
	local diff = (now-DPSM_TIME);
	local dpswas = (DPSM_DAMAGE/diff);
	local rounded = DPSMeter_round(dpswas);
	DPSSESSIONDMG = DPSSESSIONDMG+DPSM_DAMAGE;
	DPSMeter.db.char.damage = DPSMeter.db.char.damage+DPSM_DAMAGE;
	DPSSESSIONSECS = DPSSESSIONSECS+diff;
	DPSSESSIONAVG = DPSSESSIONDMG/DPSSESSIONSECS;
	--done, easy! now add to sct...
	if (rounded > 0) then  --check if DPS: 0
	local vari = {r=0.5,g=0.5,b=1};
	DPSMeter_AddMes("DPS: "..rounded, vari);
	--ChatFrame2:AddMessage("|cff"..DPSMeter.db.char.color.."Damage per second: "..rounded.."|r");
	end
	--now reset
	DPSRotateTexture(Speedostick, 0);
	DPSM_COMBAT = false;
	DPSM_DAMAGE = 0;
end

function DPSMeter_GetCmd(msg)
 	if msg then
 		local a,b,c=strfind(msg, "(%S+)"); --contiguous string of non-space characters
 		if a then
 			return c, strsub(msg, b+2);
 		else	
 			return "";
 		end
 	end
end
function DPSMeter_GetArgument(msg)
 	if msg then
 		local a,b=strfind(msg, "=");
 		if a then
 			return strsub(msg,1,a-1), strsub(msg, b+1);
 		else	
 			return "";
 		end
 	end
end

function DPSMeter_Debugg(msg)
	if (DPSMETERDEBUG == true) then
		DPSMeter:Print(msg);
	end
end

function ShowDPSStats()
	--show stat tooltip
	local high, avg, top, spell, dmg, total = DPSSESSIONBEST, DPSSESSIONAVG, DPSSESSIONTOPHIT, DPSSESSIONSPELL, DPSSESSIONDMG, DPSMeter.db.char.damage;
	local ish;
	if (DPSMeter.db.char.heal == false) then
	ish = "";
	else
	ish = "/healing";
	end
	GameTooltip_AddNewbieTip("DPSMeter v"..DPSMETERVERSION, 1.0, 1.0, 1.0, 
	"|cff7777ffby Daedal at Darksorrow EU|r|cff77bbff\n------------- Session Stats -------------"
	.."\n(only updated after combat)\nHighest DPS: |r|cffffffff"..high
	.."|r\n|cff77bbffAverage DPS: |r|cffffffff"..DPSMeter_round(avg)
	.."|r\n|cff77bbffTotal damage"..ish..": |r|cffffffff"..dmg
	.."|r\n|cff77bbffTop Hit: |r|cffffffff"..top
	.."|r|cff77bbff, |r|cffffffff"..spell
	.."|r|cff77bbff\n------------ Lifetime Stats ------------"
	.."|r\n|cff77bbffTotal Damage"..ish..": |r|cffffffff"..total
	.."|r|cff77bbff\n-------------------------------------------\n|rRight-click for options",
	1);
end

function DPSMeter_ParseC(msg)
	local Cmd, SubCmd = DPSMeter_GetCmd(msg); --call to above function
	--showcommands
	if (Cmd == "") then
	DPSMeter:Print("Usage: /dps {reset | about}");
	DPSMeter:Print(" - reset: Reset the addon, if something has gone wrong");
	DPSMeter:Print(" - about: Show information about the addon");
	end
	if (Cmd == "about") then
		DPSMeter:Print("DPS Meter v"..DPSMETERVERSION.." by Daedal at Darksorrow EU realm.");
		DPSMeter:Print("Please report bugs and comment to the addon webpage.");
	end
	if (Cmd == "reset") then
		--not much here yet :)
		DPSMeterFrame:ClearAllPoints();
		DPSMeterFrame:SetPoint("CENTER", "UIParent", "CENTER", 0, 0);
		DPSMeter.db.char.color = "FF00FF";
   		DPSMeter.db.char.frame = "1";
   		DPSM_MAXCHART = 40;
   		DPSM_DAMAGE = 0;
    	DPSM_TIME = 0;
    	DPSM_COMBAT = false;
    	DPSM_MAXDPS = 40;
		DPSMeter:Print("DPS Meter reseted.");
	end
	if (Cmd == "debug") then
		--debugges
		if (DPSMETERDEBUG == true) then
		DPSMETERDEBUG = false;
		DPSMeter:Print("Debug: false");
		else
		DPSMETERDEBUG = true;
		DPSMeter:Print("Debug: true");
		end
	end
end

local s2 = sqrt(2);
local cos, sin, rad = math.cos, math.sin, math.rad;
local function CalculateCorner(angle)
	local r = rad(angle);
	return 0.5 + cos(r) / s2, 0.5 + sin(r) / s2;
end

function DPSRotateTexture(texture,amount)
	local tempmax = DPSM_MAXCHART;
	if (-amount > tempmax) then -- uu we have new session record
	local newmax = math.ceil( (-amount) / 40 )*40;
	DPSM_MAXCHART = newmax;
	local tick = newmax/8;
	DPS1:SetText(tick);
	DPS2:SetText(tick*2);
	DPS3:SetText(tick*3);
	DPS4:SetText(tick*4);
	DPS5:SetText(tick*5);
	DPS6:SetText(tick*6);
	DPS7:SetText(tick*7);
	tempmax = newmax;
	end
	local fixedrot = -(( (-amount)/tempmax )*275);
	DPSRotTexture(texture, fixedrot);
end 

function DPSRotTexture(texture, angle)
	local LRx, LRy = CalculateCorner(angle + 45);
	local LLx, LLy = CalculateCorner(angle + 135);
	local ULx, ULy = CalculateCorner(angle + 225);
	local URx, URy = CalculateCorner(angle - 45);	
	texture:SetTexCoord(ULx, ULy, LLx, LLy, URx, URy, LRx, LRy);
end

function Speedostick_Update()
	if (DPSM_COMBAT == true) then
		DPSMeterFrame:SetAlpha(DPSMeter.db.char.alpha2);
		local now = GetTime();
		local diff = (now-DPSM_TIME);
		local dpswas = (DPSM_DAMAGE/diff);
		local rounded = DPSMeter_round(dpswas);
		--if (rounded > 270) then rounded = 270; end;
		if (diff > 0.9) then
		DPSRotateTexture(Speedostick, -dpswas);
		end
		if (rounded > DPSSESSIONBEST) then
		DPSSESSIONBEST = rounded;
		end
		DPSDigital:SetText(""..rounded);
	else
	DPSMeterFrame:SetAlpha(DPSMeter.db.char.alpha);
	end
end

function DPSmeter_MouseUp()
	if ( this.isMoving ) then
  	this:StopMovingOrSizing();
  	this.isMoving = false;
  	--ArathiHelper_Print();
 	end
end

function DPSmeter_MouseDown()
	if ( arg1 == "RightButton" ) then
	DPSMeter_Menu();
	end
	if ( ( ( not this.isLocked ) or ( this.isLocked == 0 ) ) and ( arg1 == "LeftButton" ) ) then
 	this:StartMoving();
 	this.isMoving = true;
 	end
end

function DPSMeter:CHAT_MSG_ADDON()
	--DPSMeter:Print("call: "..arg1..", "..arg2..", "..arg3);
	if (arg4 == UnitName("player")) then return end
	if (arg1 == "DPSMETERVERSION") then	
	 	if (tonumber(arg2) > DPSMETERVERSION) then
	 		DPSMeter:Print("An updated DPSMeter detected! (version "..arg2..", from "..arg4..")");
	 	end
	end
end

function DPSMeter:OnInitialize()
    --No need for this
end

function DPSMeter:OnEnable()
	DPSMeter:RegisterDB("DPSMeterDB","DPSMeterDBPC");
	self:RegisterEvent("PLAYER_REGEN_DISABLED");
	self:RegisterEvent("PLAYER_REGEN_ENABLED");
	self:RegisterEvent("PLAYER_DEAD");
	self:RegisterEvent("CHAT_MSG_ADDON");
	self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED",DPSMeter_parse);
	self:RegisterEvent("PARTY_MEMBERS_CHANGED",DPSMeter_updateparty);
	SLASH_DPS1 = "/DPS";
	SlashCmdList["DPS"] = DPSMeter_ParseC;
	DPSMETERNAMES[UnitGUID("player")] = UnitName("player");
	DPSMeter_updateparty();
    DPSM_DAMAGE = 0;
    DPSM_TIME = 0;
    DPSM_COMBAT = false;
    DPSM_MAXDPS = 40;
    DPSM_MAXCHART = 40;
    DPSTEMP1 = 0;
    DPSMETERVERSION = 1.25;
    if (DPSMeter.db.char.frame == nil) then
    DPSMeter.db.char.frame = "1";
    end
    if (DPSMeter.db.char.damage == nil) then
    DPSMeter.db.char.damage = 0;
    end
    if (DPSMeter.db.char.lock == nil) then
    DPSMeter.db.char.lock = false;
    end
    if (DPSMeter.db.char.scale == nil) then
    DPSMeter.db.char.scale = 1;
    end
    if (DPSMeter.db.char.scen == nil) then
    DPSMeter.db.char.scen = false;
    end
    if (DPSMeter.db.char.heal == nil) then
    DPSMeter.db.char.heal = false;
    end
    if (DPSMeter.db.char.record == nil) then
    DPSMeter.db.char.record = false;
    end
    if (DPSMeter.db.char.alpha == nil) then
    DPSMeter.db.char.alpha = 0.8;
    end
    if (DPSMeter.db.char.alpha2 == nil) then
    DPSMeter.db.char.alpha2 = 1;
    end
    DPSMeterFrame:SetAlpha(DPSMeter.db.char.alpha);
    DPSMeterFrame:SetScale(DPSMeter.db.char.scale);
	DPSMeterFrame.isLocked = DPSMeter.db.char.lock;
    -- Loaded
    DEFAULT_CHAT_FRAME:AddMessage("|cff33ff33DPS Meter|r |cff77cc77 v"..DPSMETERVERSION.." loaded.|r");
end

function DPSMeter:OnDisable()
    -- Nothing here yet (WIP) :D
end