
-- ##############################################################################################################
-- Variable definitions
-- ##############################################################################################################
-- Set default values of saved variables
DMCVisible = true;
DMCScale = 1;
DMCWidth = 100;
-- ##############################################################################################################






function fDMCoords_OnLoad()
	--Coords_OnLoad();
	--message("test message");
	--PlayMusic("x");

	trace("DMCoords loaded type /DMC for options.");
	this:RegisterEvent('VARIABLES_LOADED');
	this:RegisterEvent("ZONE_CHANGED_NEW_AREA");

	SlashCmdList["DMCoordsCOMMAND"] = DMCoordsSlashFunction;
	SLASH_DMCoordsCOMMAND1 = "/DMC";

	fSetupText(DMiniCoordsTXT);

end



function fSetupText(element)
	local sFontPath = "Interface\\AddOns\\DMiniCoords\\Fonts\\";
	element:SetFont(sFontPath.."ClearFontNumber.ttf", 10, "OUTLINE");
	element:SetTextColor(255,255,255);
end






function fDMCoordsOnEvent()
	local DMCFrame = getglobal("DMiniCoords");

	if (event == "ZONE_CHANGED_NEW_AREA") then
		SetMapToCurrentZone();
	end

	if (event == 'VARIABLES_LOADED') then
		if (DMCVisible == true) then
			DMCFrame:Show();
			--trace("DMCoords INI DMCVisible:Show");
		else
			DMCFrame:Hide();
			--trace("DMCoords INI DMCVisible:Hide");
		end

		--trace("DMCoords INI DMCFrame:SetScale" .. DMCScale);
		DMCFrame:SetScale(DMCScale);

		--trace("DMCoords INI DMCFrame:SetWidth" .. DMCWidth);
		DMCFrame:SetWidth(DMCWidth);

	end
end






function fDMCoordsOnUpdate()
		this.px, this.py = GetPlayerMapPosition("player");
		if (this.px > 0.01 and this.py  > 0.01) then
			xWhole = format("%d", 100 * this.px);
			tmpX = format("%d", 10000 * this.px);
			lenX = string.len(tmpX);
			xPoint = string.sub(tmpX, 3, -1);
			
			yWhole = format("%d", 100 * this.py);
			tmpY = format("%d", 10000 * this.py);
			lenY = string.len(tmpY);
			yPoint = string.sub(tmpY, 3, -1);			
			

			sDMOutput = "";
			sDMOutput = " x:" .. xWhole .. "." .. xPoint .. " - y:" .. yWhole .. "." .. yPoint;

		else
			sDMOutput = "NA";
		end
		DMiniCoordsTXT:SetText(sDMOutput)

end



function DMCoordsSlashFunction(msg)
	local DMCFrame = getglobal("DMiniCoords");

	if (msg == nil or msg == "" or string.find(msg, "help") ~= nil) then
		trace("DMCoords commands:");
		trace("  /DMC hide - hide the mod");
		trace("  /DMC show - shows the mod");
		trace("  /DMC setscale:80 - sets the scale of the mod to 80%");
	end


	strtosearch = string.find(msg,"setscale:");
	if (strtosearch ~= nil) then
		local v1,v2 = strsplit(":",msg);
		local s = tonumber(v2);
		if (s ~= null) then
			DMCScale = (s/100);
			trace("DMCoords: Setting [DMCScale] to ["..DMCScale..")");
			DMCFrame:SetScale(DMCScale);
		end
	end


	strtosearch = string.find(msg,"hide");
	if (strtosearch ~= nil) then
		trace("Hidining DMCoords - type /DMC show to make visible again");
		DMCVisible = false;
		trace("DMCoords: Setting [DMCVisible] to [false)");
	  DMCFrame:Hide();
	end
	
	
	strtosearch = string.find(msg,"joinav");
	if (strtosearch ~= nil) then
		trace("Attempting to join AV");
		JoinBattlefield(0);
	end
	
	
	
	

	strtosearch = string.find(msg,"show");
	if (strtosearch ~= nil) then
		trace("Hidining DMCoords - type /DMC hide to hide again");
		DMCVisible = true;
		trace("DMCoords: Setting [DMCVisible] to [true)");
	  DMCFrame:Show();
	end


	strtosearch = string.find(msg,"setwidth:");
	if (strtosearch ~= nil) then
		local v1,v2 = strsplit(":",msg);
		local s = tonumber(v2);
		if (s ~= null) then
			DMCWidth = s;
			trace("DMCoords: Setting [DMCWidth] to [" .. DMCWidth .. ")");
			DMCFrame:SetWidth(DMCWidth);
		end
	end


end





function trace(msg)
	DEFAULT_CHAT_FRAME:AddMessage(msg);
end