--[[
Author: Darcey Lloyd
Email: Darcey.Lloyd@gmail.com
Date: 12-2007
--]]

-- ##############################################################################################################
-- Variable definitions
-- ##############################################################################################################
local ModVersion = 2.71;
local ModName = "DGPS";
local bVarsLoaded = false;
local CoordsActive = 1; -- 1 to 5 which coordinate set is active.

local pi = math.pi;
local pi2 = pi * 2;
local rad = 57.2957795;
local piOffset = pi * 0.7;
local minimapPlayerModel,minimapPlayerModelFacing;
local lastMouseY, scaleOffset, DesiredHeading, delta, DrawRadians, Distance;
local ActualHeading, Velocity, Acceleration, VelDecay, AccelFactor, AccelDecay = 0, 0, 0, 0.1, 15, 0.5;
local l, throttle, Sin, Cos, scale, x, y = 0.7, 0;
local arrowRotation = 0;

-- Set default values of saved variables
SavedVarInputMapName1 = "Enter info' here 1";
SavedVarInputMapName2 = "Enter info' here 2";
SavedVarInputMapName3 = "Quest name";
SavedVarInputMapName4 = "Quest item name";
SavedVarInputMapName5 = "Coordinates meaning etc";

SavedVarDefaultXCoord1 = "22.2";
SavedVarDefaultXCoord2 = "33.3";
SavedVarDefaultXCoord3 = "44.4";
SavedVarDefaultXCoord4 = "55.5";
SavedVarDefaultXCoord5 = "66.6";

SavedVarDefaultYCoord1 = "66.6";
SavedVarDefaultYCoord2 = "55.5";
SavedVarDefaultYCoord3 = "44.4";
SavedVarDefaultYCoord4 = "33.3";
SavedVarDefaultYCoord5 = "22.2";

DGPSArrowVisible = true;
DGPSInputVisible = true;


DGPSInputScale = 1;
DGPSArrowScale = 1;
-- ##############################################################################################################







-- ##############################################################################################################
-- Event handlers
-- ##############################################################################################################


function fOnLoad()
	trace("DGPS v" .. ModVersion .. " loaded. Type /dgps or /gps for options.");

	this:RegisterEvent("ADDON_LOADED");
	this:RegisterEvent('VARIABLES_LOADED');

	fSetupSlashCommand();
	fInIElements();


	--local sound = media:Fetch("sound", "Interface\\AddOns\\DGPS\\ScanComplete.mp3");
	--PlaySoundFile("Interface\\AddOns\\DGPS\\ScanComplete.mp3");
end


-- ##############################################################################################################
-- ##############################################################################################################








-- ##############################################################################################################
-- INI
-- ##############################################################################################################
-- Setup all text elements within this function
function fInIElements()
	fSetupText(sTitle,8,255,255,255,"DGPS Version " .. ModVersion);
	fSetupText(DGPSCoordsText,7,255,255,255,"LOCATION");


	-- Create a table of all the Minimap's children objectSimpleCompass_Saved.
	local children = {Minimap:GetChildren()};

	for i=getn(children), 1, -1 do
		-- Iterate over them all, starting from the end of the list to see if the object reference is a model.
		-- If it is, and it has no name (in case some addon attached a model to it), it's probably the right one.
		if children[i]:IsObjectType("Model") and not children[i]:GetName() then
			-- Found, setting as the addon's local to keep the reference.
			minimapPlayerModel = children[i];
			minimapPlayerModelFacing = minimapPlayerModel.GetFacing;
			return;
		end
	end
end


-- Setup slash command
function fSetupSlashCommand()
	SlashCmdList["DGPSCOMMAND"] = ParseSlashCommands;
	SLASH_DGPSCOMMAND1 = "/dgps";
	SLASH_DGPSCOMMAND2 = "/gps";
end

-- ##############################################################################################################
-- ##############################################################################################################









-- ##############################################################################################################
-- Event handler
-- ##############################################################################################################
function fEventHandler(evt,arg1)
	if (event == 'VARIABLES_LOADED') then
		bVarsLoaded = true;
		fSetupGUI(1);
		fSetCheckButtons(CoordsActive);


		--trace("INI: DGPSInputScale scale[" .. DGPSInputScale .. "]");
		DGPSFrame1:SetScale(DGPSInputScale);


		if (DGPSInputVisible == true) then
			DGPSFrame1:Show();
		else
			DGPSFrame1:Hide();
		end


		--trace("INI: DGPSArrowScale scale[" .. DGPSArrowScale .. "]");
		DirectionalArrow:SetScale(DGPSArrowScale);

		if (DGPSArrowVisible == true) then
			DirectionalArrow:Show();
		else
			DirectionalArrow:Hide();
		end


	end


	if ((event == "ADDON_LOADED") and (arg1 == ModName)) then
	  -- Setup of saved variables must be done after this event
		inputMapName1:SetText(SavedVarInputMapName1);
		inputMapName2:SetText(SavedVarInputMapName2);
		inputMapName3:SetText(SavedVarInputMapName3);
		inputMapName4:SetText(SavedVarInputMapName4);
		inputMapName5:SetText(SavedVarInputMapName5);

		inputCoordinatesX1:SetText(SavedVarDefaultXCoord1);
		inputCoordinatesX2:SetText(SavedVarDefaultXCoord2);
		inputCoordinatesX3:SetText(SavedVarDefaultXCoord3);
		inputCoordinatesX4:SetText(SavedVarDefaultXCoord4);
		inputCoordinatesX5:SetText(SavedVarDefaultXCoord5);

		inputCoordinatesY1:SetText(SavedVarDefaultYCoord1);
		inputCoordinatesY2:SetText(SavedVarDefaultYCoord2);
		inputCoordinatesY3:SetText(SavedVarDefaultYCoord3);
		inputCoordinatesY4:SetText(SavedVarDefaultYCoord4);
		inputCoordinatesY5:SetText(SavedVarDefaultYCoord5);

		DGPSCoordsTextBackground:SetPoint("TOPLEFT",0,-42);
		DGPSCoordsTextBackground:SetWidth(315);

		DGPSCoordsText:SetWidth(315);
		--DGPSCoordsText:SetScale(0.8);
		--DGPSCoordsText:SetPoint("TOPLEFT",2,-39);
		DGPSCoordsText:SetText("WAITING FOR GAME UPDATE");
		DGPSCoordsText:SetJustifyH("CENTER");


		DGPSResetInputRow1:SetPoint("TOPLEFT",295,-19);
		DGPSResetInputRow2:SetPoint("TOPLEFT",295,-39);
		DGPSResetInputRow3:SetPoint("TOPLEFT",295,-59);
		DGPSResetInputRow4:SetPoint("TOPLEFT",295,-79);
		DGPSResetInputRow5:SetPoint("TOPLEFT",295,-99);


		YLoc = "-25";
		inputMapName1:SetPoint("TOPLEFT",15,YLoc); inputMapName1:SetWidth(145);
		inputCoordinatesX1:SetPoint("TOPLEFT",175,YLoc); inputCoordinatesX1:SetWidth(40);
		inputCoordinatesY1:SetPoint("TOPLEFT",230,YLoc); inputCoordinatesY1:SetWidth(40);
		inputDistance1:SetPoint("TOPLEFT",285,YLoc); inputDistance1:SetWidth(55);

		YLoc = "-50";
		inputMapName2:SetPoint("TOPLEFT",15,YLoc); inputMapName2:SetWidth(145);
		inputCoordinatesX2:SetPoint("TOPLEFT",175,YLoc); inputCoordinatesX2:SetWidth(40);
		inputCoordinatesY2:SetPoint("TOPLEFT",230,YLoc); inputCoordinatesY2:SetWidth(40);
		inputDistance2:SetPoint("TOPLEFT",285,YLoc); inputDistance2:SetWidth(55);

		YLoc = "-75";
		inputMapName3:SetPoint("TOPLEFT",15,YLoc); inputMapName3:SetWidth(145);
		inputCoordinatesX3:SetPoint("TOPLEFT",175,YLoc); inputCoordinatesX3:SetWidth(40);
		inputCoordinatesY3:SetPoint("TOPLEFT",230,YLoc); inputCoordinatesY3:SetWidth(40);
		inputDistance3:SetPoint("TOPLEFT",285,YLoc); inputDistance3:SetWidth(55);

		YLoc = "-100";
		inputMapName4:SetPoint("TOPLEFT",15,YLoc); inputMapName4:SetWidth(145);
		inputCoordinatesX4:SetPoint("TOPLEFT",175,YLoc); inputCoordinatesX4:SetWidth(40);
		inputCoordinatesY4:SetPoint("TOPLEFT",230,YLoc); inputCoordinatesY4:SetWidth(40);
		inputDistance4:SetPoint("TOPLEFT",285,YLoc); inputDistance4:SetWidth(55);

		YLoc = "-125";
		inputMapName5:SetPoint("TOPLEFT",15,YLoc); inputMapName5:SetWidth(145);
		inputCoordinatesX5:SetPoint("TOPLEFT",175,YLoc); inputCoordinatesX5:SetWidth(40);
		inputCoordinatesY5:SetPoint("TOPLEFT",230,YLoc); inputCoordinatesY5:SetWidth(40);
		inputDistance5:SetPoint("TOPLEFT",285,YLoc); inputDistance5:SetWidth(55);
	end




end
-- ##############################################################################################################









-- ##############################################################################################################
function fReset(row)
	if (row == 1) then
		fUpdateSavedVariable("inputMapName1","");
		inputMapName1:SetText("");
		inputCoordinatesX1:SetText("");
		inputCoordinatesY1:SetText("");
	end
	
	if (row == 2) then
		fUpdateSavedVariable("inputMapName2","");
		inputMapName2:SetText("");
		inputCoordinatesX2:SetText("");
		inputCoordinatesY2:SetText("");
	end
	
	if (row == 3) then
		fUpdateSavedVariable("inputMapName3","");
		inputMapName3:SetText("");
		inputCoordinatesX3:SetText("");
		inputCoordinatesY3:SetText("");
	end
	
	if (row == 4) then
		fUpdateSavedVariable("inputMapName4","");
		inputMapName4:SetText("");
		inputCoordinatesX4:SetText("");
		inputCoordinatesY4:SetText("");
	end
	
	if (row == 5) then
		fUpdateSavedVariable("inputMapName5","");
		inputMapName5:SetText("");
		inputCoordinatesX5:SetText("");
		inputCoordinatesY5:SetText("");
	end
end
-- ##############################################################################################################









-- ##############################################################################################################
-- Main application
-- ##############################################################################################################
function fCalculateData()
	if (bVarsLoaded == true) then
		fGetDistanceToTarget(inputCoordinatesX1:GetText(),inputCoordinatesY1:GetText(),1);
		fGetDistanceToTarget(inputCoordinatesX2:GetText(),inputCoordinatesY2:GetText(),2);
		fGetDistanceToTarget(inputCoordinatesX3:GetText(),inputCoordinatesY3:GetText(),3);
		fGetDistanceToTarget(inputCoordinatesX4:GetText(),inputCoordinatesY4:GetText(),4);
		fGetDistanceToTarget(inputCoordinatesX5:GetText(),inputCoordinatesY5:GetText(),5);

		if (CoordsActive == 1) then
			fHandlePointer(inputCoordinatesX1:GetText(),inputCoordinatesY1:GetText(),1);
		end

		if (CoordsActive == 2) then
			fHandlePointer(inputCoordinatesX2:GetText(),inputCoordinatesY2:GetText(),1);
		end

		if (CoordsActive == 3) then
			fHandlePointer(inputCoordinatesX3:GetText(),inputCoordinatesY3:GetText(),1);
		end

		if (CoordsActive == 4) then
			fHandlePointer(inputCoordinatesX4:GetText(),inputCoordinatesY4:GetText(),1);
		end

		if (CoordsActive == 5) then
			fHandlePointer(inputCoordinatesX5:GetText(),inputCoordinatesY5:GetText(),1);
		end


		-- New coordinates to title
		this.px, this.py = GetPlayerMapPosition("player");
		if (this.px > 0 and this.py  > 0) then

			xWhole = format("%d", 100 * this.px);
			tmpA = format("%d", 1000 * this.px);
			lenA = string.len(tmpA);
			if (lenA == 3) then
				xPoint = string.sub(tmpA, 3, -1);
			else
				xPoint = string.sub(tmpA, 2, -1);
			end

			xPoint = string.sub(tmpA, 3, -1);

			yWhole = format("%d", 100 * this.py);
			tmpB = format("%d", 1000 * this.py);
			lenB = string.len(tmpB);

			if (lenB == 3) then
				yPoint = string.sub(tmpB, 3, -1);
			else
				yPoint = string.sub(tmpB, 2, -1);
			end


	 		--fSetText(sTitle,"DGPS V " .. ModVersion .. " [" .. xWhole .. "." .. xPoint .. "," .. yWhole .. "." .. yPoint .. "]");
	 		fSetText(sTitle,"DGPS V " .. ModVersion);

	 		CoordsMessage = "";
			if (GetSubZoneText() == "") then
				CoordsMessage = GetZoneText() .. "  - [" .. xWhole .. "." .. xPoint .. "," .. yWhole .. "." .. yPoint .. "]";
			else
				CoordsMessage = GetZoneText() .. "  - " .. GetSubZoneText() .. " [" .. xWhole .. "." .. xPoint .. "," .. yWhole .. "." .. yPoint .. "]";
			end

	 		fSetText(DGPSCoordsText,CoordsMessage);

			-- Handle coords location
			sv = ViewCount:GetValue() - 1;
			aa = -44 - (sv * 19.7);
			bb = 0;


			DGPSCoordsTextBackground:SetPoint("TOPLEFT",0,aa);
			DGPSCoordsText:SetPoint("TOPLEFT",2,bb);


	 end


	end
end








function GetFacing()
	return minimapPlayerModelFacing(minimapPlayerModel);
end



function fHandlePointer(argX,argY,RowNo)
	-- Player coordinates
	local region = "NA";
	local distX = 0; local distY = 0;
	local curX,curY = GetPlayerMapPosition("player");
	curX = curX * 100; curY = curY * 100;

	local destX = tonumber(argX,10);
	local destY = tonumber(argY,10);


	-- Exit if nil values
	if (destX == nil) then return; end
	if (destY == nil) then return; end

	-- Calculate which circle segment we are in
	if (curX > destX) then
		if (curY < destY) then
			region = "Q1";
			distX = curX - destX;
			distY = destY - curY;
		else
			region = "Q2";
			distX = curX - destX;
			distY = curY - destY;
		end
	else
		if (curY > destY) then
			region = "Q3";
			distX = destX - curX;
			distY = curY - destY;
		else
			region = "Q4";
			distX = destX - curX;
			distY = destY - curY;
		end
	end


	-- Calculate distance to target
	local v1 = (destX-curX) * (destX-curX);
	local v2 = (destY-curY) * (destY-curY);
	local v3 = 30 * (sqrt((v1 + v2)));
	v3 = tonumber(v3,10);
	DistanceToTarget = format("%d", v3);

	--if (v3 < 1) then
		--trace("DGPS: You have arrived at coordinates set " .. RowNo);
		--PlaySound("LEVELUP", 1, 1, 0, 1, 3);
	--end





	-- Calculate angles and radians
	local RegionAngle = 0;
	local CompleteAngle = 0;

	if (region == "Q1") then
		RegionAngle = atan((distX/distY));
		CompleteAngle = RegionAngle;
		radians = CompleteAngle * (pi/180);
	end

	if (region == "Q2") then
		RegionAngle = atan((distY/distX));
		CompleteAngle = RegionAngle + 90;
		radians = CompleteAngle * (pi/180);
	end

	if (region == "Q3") then
		RegionAngle = atan((distX/distY));
		CompleteAngle = RegionAngle + 180;
		radians = CompleteAngle * (pi/180);
	end

	if (region == "Q4") then
		RegionAngle = atan((distY/distX));
		CompleteAngle = RegionAngle + 270;
		radians = CompleteAngle * (pi/180);
	end



	-- Compensate for players facing direction -- Direction to north local
	local NorthRadians = GetFacing();
	local CompRadians =  NorthRadians + radians;

	-- Fix radians
	CompRadians = (pi2 - CompRadians) + piOffset;

	-- Set var
	arrowRotation = CompRadians

	--inputDistance1:SetText(arrowRotation);

	Sin = math.sin(arrowRotation) * l;
	Cos = math.cos(arrowRotation) * l
	DirectionalArrowBack:SetTexCoord(0.5-Sin, 0.5+Cos,		 0.5+Cos, 0.5+Sin,		 0.5-Cos, 0.5-Sin,		 0.5+Sin, 0.5-Cos);

end












function fGetDistanceToTarget(argX,argY,RowNo)
	-- Player coordinates
	local curX,curY = GetPlayerMapPosition("player");
	curX = curX * 100;
	curY = curY * 100;

	local destX = tonumber(argX,10);
	local destY = tonumber(argY,10);
	local ipError = false;

	-- Exit if nil values
	if (destX == nil) then destX = 0; ipError=true; end
	if (destY == nil) then destY = 0;	ipError=true; end

	if (ipError == true) then
		if (RowNo == 1) then inputDistance1:SetText("NA"); return; end
		if (RowNo == 2) then inputDistance2:SetText("NA"); return; end
		if (RowNo == 3) then inputDistance3:SetText("NA"); return; end
		if (RowNo == 4) then inputDistance4:SetText("NA"); return; end
		if (RowNo == 5) then inputDistance5:SetText("NA"); return; end
	end


	-- Calculate which circle segment we are in
	if (curX > destX) then
		if (curY < destY) then
			region = "Q1";
			distX = curX - destX;
			distY = destY - curY;
		else
			region = "Q2";
			distX = curX - destX;
			distY = curY - destY;
		end
	else
		if (curY > destY) then
			region = "Q3";
			distX = destX - curX;
			distY = curY - destY;
		else
			region = "Q4";
			distX = destX - curX;
			distY = destY - curY;
		end
	end

		-- Calculate distance to target
	local v1 = (destX-curX) * (destX-curX);
	local v2 = (destY-curY) * (destY-curY);
	local v3 = 30 * (sqrt((v1 + v2)));
	local DistanceToTarget = format("%d", v3);
	--DistanceToTarget = DistanceToTarget .. "ft";

	if (v3 > 10000) then
		--DistanceToTarget = "+10kft";
	end

	if (RowNo == 1) then inputDistance1:SetText(DistanceToTarget); end
	if (RowNo == 2) then inputDistance2:SetText(DistanceToTarget); end
	if (RowNo == 3) then inputDistance3:SetText(DistanceToTarget); end
	if (RowNo == 4) then inputDistance4:SetText(DistanceToTarget); end
	if (RowNo == 5) then inputDistance5:SetText(DistanceToTarget); end


	-- Calculatie text direction
		local RegionAngle = 0;
	local CompleteAngle = 0;

	if (region == "Q1") then
		RegionAngle = atan((distX/distY));
		CompleteAngle = RegionAngle;
		radians = CompleteAngle * (pi/180);
	end

	if (region == "Q2") then
		RegionAngle = atan((distY/distX));
		CompleteAngle = RegionAngle + 90;
		radians = CompleteAngle * (pi/180);
	end

	if (region == "Q3") then
		RegionAngle = atan((distX/distY));
		CompleteAngle = RegionAngle + 180;
		radians = CompleteAngle * (pi/180);
	end

	if (region == "Q4") then
		RegionAngle = atan((distY/distX));
		CompleteAngle = RegionAngle + 270;
		radians = CompleteAngle * (pi/180);
	end



end
-- ##############################################################################################################















-- ##############################################################################################################
-- ##############################################################################################################
-- Functions
-- ##############################################################################################################
-- ##############################################################################################################



-- Handle the slider GUI changes
function fSetupGUI(sliderValue)
	if (sliderValue == 1) then modHeight = 45; coordsy = -42; fDisplay(1); end
	if (sliderValue == 2) then modHeight = 64; coordsy = -69; fDisplay(2); end
	if (sliderValue == 3) then modHeight = 84; coordsy = -100; fDisplay(3); end
	if (sliderValue == 4) then modHeight = 104; coordsy = -120; fDisplay(4); end
	if (sliderValue == 5) then modHeight = 124; coordsy = -140; fDisplay(5); end

	DGPSFrame1:SetHeight(modHeight);
	--trace("Slider value: " .. sliderValue .. " modHeight: " .. modHeight);


end




-- Handle show and hide of element sets
function fDisplay(maxElementSetVisible)
	if (bVarsLoaded == false) then
		--trace("fDisplay: Vars not loaded");
		return;
	end

	if (maxElementSetVisible == 1) then
		fHideSet2(); fHideSet3(); fHideSet4(); fHideSet5();
	end
	if (maxElementSetVisible == 2) then
		fShowSet2(); fHideSet3(); fHideSet4(); fHideSet5();
	end
	if (maxElementSetVisible == 3) then
		fShowSet2(); fShowSet3(); fHideSet4(); fHideSet5();
	end
	if (maxElementSetVisible == 4) then
		fShowSet2(); fShowSet3(); fShowSet4(); fHideSet5();
	end
	if (maxElementSetVisible == 5) then
		fShowSet2(); fShowSet3(); fShowSet4(); fShowSet5();
	end

	-- Ensure checked item is visible and memory
	if (maxElementSetVisible < CoordsActive) then
		fSetCheckButtons(maxElementSetVisible)
	end
end






-- Show set 2
function fShowSet2()
	backgroundInputMapName2:Show(); inputMapName2:Show();
	backgroundInputCoordX2:Show(); inputCoordinatesX2:Show();
	backgroundInputCoordY2:Show(); inputCoordinatesY2:Show();
	backgroundTextDistance2:Show(); inputDistance2:Show();
	ActivationCheckButton2:Show();
	DGPSResetInputRow2:Show();
end
-- Show set 3
function fShowSet3()
	backgroundInputMapName3:Show(); inputMapName3:Show();
	backgroundInputCoordX3:Show(); inputCoordinatesX3:Show();
	backgroundInputCoordY3:Show(); inputCoordinatesY3:Show();
	backgroundTextDistance3:Show(); inputDistance3:Show();
	ActivationCheckButton3:Show();
	DGPSResetInputRow3:Show();
end
-- Show set 4
function fShowSet4()
	backgroundInputMapName4:Show(); inputMapName4:Show();
	backgroundInputCoordX4:Show(); inputCoordinatesX4:Show();
	backgroundInputCoordY4:Show(); inputCoordinatesY4:Show();
	backgroundTextDistance4:Show(); inputDistance4:Show();
	ActivationCheckButton4:Show();
	DGPSResetInputRow4:Show();
end
-- Show set 5
function fShowSet5()
	backgroundInputMapName5:Show(); inputMapName5:Show();
	backgroundInputCoordX5:Show(); inputCoordinatesX5:Show();
	backgroundInputCoordY5:Show(); inputCoordinatesY5:Show();
	backgroundTextDistance5:Show(); inputDistance5:Show();
	ActivationCheckButton5:Show();
	DGPSResetInputRow5:Show();
end





-- Hide set 2
function fHideSet2()
	backgroundInputMapName2:Hide(); inputMapName2:Hide();
	backgroundInputCoordX2:Hide(); inputCoordinatesX2:Hide();
	backgroundInputCoordY2:Hide(); inputCoordinatesY2:Hide();
	backgroundTextDistance2:Hide(); inputDistance2:Hide();
	ActivationCheckButton2:Hide();
	DGPSResetInputRow2:Hide();
end
-- Hide set 3
function fHideSet3()
	backgroundInputMapName3:Hide(); inputMapName3:Hide();
	backgroundInputCoordX3:Hide(); inputCoordinatesX3:Hide();
	backgroundInputCoordY3:Hide(); inputCoordinatesY3:Hide();
	backgroundTextDistance3:Hide(); inputDistance3:Hide();
	ActivationCheckButton3:Hide();
	DGPSResetInputRow3:Hide();
end
-- Hide set 4
function fHideSet4()
	backgroundInputMapName4:Hide(); inputMapName4:Hide();
	backgroundInputCoordX4:Hide(); inputCoordinatesX4:Hide();
	backgroundInputCoordY4:Hide(); inputCoordinatesY4:Hide();
	backgroundTextDistance4:Hide(); inputDistance4:Hide();
	ActivationCheckButton4:Hide();
	DGPSResetInputRow4:Hide();
end
-- Hide set 5
function fHideSet5()
	backgroundInputMapName5:Hide(); inputMapName5:Hide();
	backgroundInputCoordX5:Hide(); inputCoordinatesX5:Hide();
	backgroundInputCoordY5:Hide(); inputCoordinatesY5:Hide();
	backgroundTextDistance5:Hide(); inputDistance5:Hide();
	ActivationCheckButton5:Hide();
	DGPSResetInputRow5:Hide();
end






-- Set checkbuttons
function fSetCheckButtons(noActive)
	CoordsActive = noActive;
	trace("DGPS: Activated coordinates set " .. CoordsActive);

	if (noActive == 1) then
		ActivationCheckButton1:SetChecked(true);		ActivationCheckButton2:SetChecked(false);
		ActivationCheckButton3:SetChecked(false);		ActivationCheckButton4:SetChecked(false);
		ActivationCheckButton5:SetChecked(false);
	end

	if (noActive == 2) then
		ActivationCheckButton1:SetChecked(false);		ActivationCheckButton2:SetChecked(true);
		ActivationCheckButton3:SetChecked(false);		ActivationCheckButton4:SetChecked(false);
		ActivationCheckButton5:SetChecked(false);
	end

	if (noActive == 3) then
		ActivationCheckButton1:SetChecked(false);		ActivationCheckButton2:SetChecked(false);
		ActivationCheckButton3:SetChecked(true);		ActivationCheckButton4:SetChecked(false);
		ActivationCheckButton5:SetChecked(false);
	end

	if (noActive == 4) then
		ActivationCheckButton1:SetChecked(false);		ActivationCheckButton2:SetChecked(false);
		ActivationCheckButton3:SetChecked(false);		ActivationCheckButton4:SetChecked(true);
		ActivationCheckButton5:SetChecked(false);
	end

	if (noActive == 5) then
		ActivationCheckButton1:SetChecked(false);		ActivationCheckButton2:SetChecked(false);
		ActivationCheckButton3:SetChecked(false);		ActivationCheckButton4:SetChecked(false);
		ActivationCheckButton5:SetChecked(true);
	end
end



-- Handle slash command
function ParseSlashCommands(msg)
	if (msg == nil or msg == "" or string.find(msg, "help") ~= nil) then
		DEFAULT_CHAT_FRAME:AddMessage(" ");
		DEFAULT_CHAT_FRAME:AddMessage("DGPS commands:");
		DEFAULT_CHAT_FRAME:AddMessage(" /DGPS hide (hides the mod)");
		DEFAULT_CHAT_FRAME:AddMessage(" /DGPS show (shows the mod)");
		DEFAULT_CHAT_FRAME:AddMessage(" /DGPS setarrowscale:50  (sets arrow to 50% size)");
		DEFAULT_CHAT_FRAME:AddMessage(" /DGPS setinputscale:50  (sets input to 50% size)");
		DEFAULT_CHAT_FRAME:AddMessage(" /DGPS reset (reset the input frames x and y location)");


		DEFAULT_CHAT_FRAME:AddMessage(" ");
		return
	end

	local frame1 = getglobal("DGPSFrame1");
	local frame2 = getglobal("DirectionalArrow");


	if (msg == "show") then
		frame1:Show();
		frame2:Show();
		DGPSInputVisible = true;
		DGPSArrowVisible = true;
	end


	if (msg == "hide") then
		frame1:Hide();
		frame2:Hide();
		DGPSInputVisible = false;
		DGPSArrowVisible = false;
	end

	if (msg == "reset") then
		trace("DPGS Resetting location and scale values.");
		DGPSFrame1:SetScale(1);
		DGPSFrame1:SetPoint("TOPLEFT",100,-100);
		DirectionalArrow:SetPoint("TOPLEFT",400,-100);
		DirectionalArrow:SetScale(1);
	end


	sizeinput = string.find(msg,"setinputscale:");
	if (sizeinput ~= nil) then
		fSetInputScale(msg);
	end

	sizeinput = string.find(msg,"iscale:");
	if (sizeinput ~= nil) then
		fSetInputScale(msg);
	end


	sizearrow = string.find(msg,"setarrowscale:");
	if (sizearrow ~= nil) then
		fSetArrowScale(msg);
	end

	sizearrow = string.find(msg,"ascale:");
	if (sizearrow ~= nil) then
		fSetArrowScale(msg);
	end





end




function fSetLocation(msg)
	--DGPSFrame1:SetPoint("TOPLEFT",inputx,YLoc);
end



function fSetInputScale(msg)
		local v1,v2 = strsplit(":",msg);
		local s = tonumber(v2);
		if (s ~= null) then
			DGPSInputScale = (s/100);
			trace("DGPS: Setting [DGPSInputScale] to ["..DGPSInputScale..")");
			DGPSFrame1:SetScale(DGPSInputScale);
		end
end






function fSetArrowScale(msg)
		local v1,v2 = strsplit(":",msg);
		local s = tonumber(v2);
		if (s ~= null) then
			DGPSArrowScale = (s/100);
			trace("DGPS: Setting [DGPSArrowScale] to ["..DGPSArrowScale..")");
			DirectionalArrow:SetScale(DGPSArrowScale);
		end
end







function fDGPSToggleClick()
	local frame1 = getglobal("DGPSFrame1");
	local frame2 = getglobal("DirectionalArrow");

	if (frame1) then
			if(  frame1:IsVisible() ) then
			  frame1:Hide();
			  frame2:Hide();
			  DGPSInputVisible = false;
				DGPSArrowVisible = false;
			else
			  frame1:Show();
			  frame2:Show();
			  DGPSInputVisible = true;
				DGPSArrowVisible = true;
			end
		end

end



-- Debug function
function trace(msg)
	DEFAULT_CHAT_FRAME:AddMessage(msg);
end





-- Setup input text elements
function fSetupEditBox(element,fontsize,limit,value)
	element:SetAutoFocus(0)
	element:ClearFocus();
	if (limit>0) then
		element:SetMaxLetters(limit);
	end
	fSetupText(element,fontsize,255,255,255,value);
end





-- Setup static text elements
function fSetupText(element,fontsize,rv,gv,bv,value)
	local sFontPath = "Interface\\AddOns\\DGPS\\Fonts\\";
	element:SetFont(sFontPath.."ClearFontNumber.ttf",fontsize, "OUTLINE");
	element:SetTextColor(rv,gv,bv);

	if (value ~= null) then
		element:SetText(value);
	end

end



-- Update saved variables on tab, enter and escape
function fUpdateSavedVariable(elementTextName,value)
	if (elementTextName == "inputMapName1") then SavedVarInputMapName1 = value; trace("    Setting [SavedVarInputMapName1] to ["..value.."]"); end
	if (elementTextName == "inputMapName2") then SavedVarInputMapName2 = value; trace("    Setting [SavedVarInputMapName2] to ["..value.."]"); end
	if (elementTextName == "inputMapName3") then SavedVarInputMapName3 = value; trace("    Setting [SavedVarInputMapName3] to ["..value.."]"); end
	if (elementTextName == "inputMapName4") then SavedVarInputMapName4 = value; trace("    Setting [SavedVarInputMapName4] to ["..value.."]"); end
	if (elementTextName == "inputMapName5") then SavedVarInputMapName5 = value; trace("    Setting [SavedVarInputMapName5] to ["..value.."]"); end

	if (elementTextName == "inputCoordinatesX1") then SavedVarDefaultXCoord1 = value; trace("    Setting [SavedVarDefaultXCoord1] to ["..value.."]"); end
	if (elementTextName == "inputCoordinatesX2") then SavedVarDefaultXCoord2 = value; trace("    Setting [SavedVarDefaultXCoord2] to ["..value.."]"); end
	if (elementTextName == "inputCoordinatesX3") then SavedVarDefaultXCoord3 = value; trace("    Setting [SavedVarDefaultXCoord3] to ["..value.."]"); end
	if (elementTextName == "inputCoordinatesX4") then SavedVarDefaultXCoord4 = value; trace("    Setting [SavedVarDefaultXCoord4] to ["..value.."]"); end
	if (elementTextName == "inputCoordinatesX5") then SavedVarDefaultXCoord5 = value; trace("    Setting [SavedVarDefaultXCoord5] to ["..value.."]"); end

	if (elementTextName == "inputCoordinatesY1") then SavedVarDefaultYCoord1 = value; trace("    Setting [SavedVarDefaultYCoord1] to ["..value.."]"); end
	if (elementTextName == "inputCoordinatesY2") then SavedVarDefaultYCoord2 = value; trace("    Setting [SavedVarDefaultYCoord2] to ["..value.."]"); end
	if (elementTextName == "inputCoordinatesY3") then SavedVarDefaultYCoord3 = value; trace("    Setting [SavedVarDefaultYCoord3] to ["..value.."]"); end
	if (elementTextName == "inputCoordinatesY4") then SavedVarDefaultYCoord4 = value; trace("    Setting [SavedVarDefaultYCoord4] to ["..value.."]"); end
	if (elementTextName == "inputCoordinatesY5") then SavedVarDefaultYCoord5 = value; trace("    Setting [SavedVarDefaultYCoord5] to ["..value.."]"); end
end



-- Editbox tab function
function fTabTo(element)
	element:SetFocus(element);
end


-- Editbox exit function
function fEditBoxExit(element)
	element:SetAutoFocus(0)
	element:ClearFocus();
end


-- Set text of an element
function fSetText(element,value)
	element:SetText(value);
end




-- SetFont
function fSetFont(element,fontname,fontsize)
	local sFontPath = "Interface\\AddOns\\Drop_o_Meter\\Fonts\\";
	element:SetFont(sFontPath..fontname,fontsize, "OUTLINE");
end


-- ##############################################################################################################
-- ##############################################################################################################