local L = LibStub("AceLocale-3.0"):GetLocale("Cryolysis2")
local Cryolysis2 = LibStub("AceAddon-3.0"):GetAddon("Cryolysis2")
 
------------------------------------------------------------------------------------------------------
-- Produces a list of all spells that are valid targets for random spell casts
------------------------------------------------------------------------------------------------------
function Cryolysis2:GetSpellsWithMessages()

	Cryolysis2.messages = {
		-- Polymorph spells
		GetSpellInfo(Cryolysis2.Private.SpellId["Polymorph"]),
		
		-- Mounts - too much hassle as of now, also i don't like it :p
		
		
		-- Ritual of Refreshment
		GetSpellInfo(Cryolysis2.Private.SpellId["Ritual of Refreshment"])
	}
	
	-- Insert all the teleports
	for i = 1, #(Cryolysis2.Private.HasPortMenuTeleport), 1 do
		if Cryolysis2.Private.HasPortMenuTeleport[i] then
			table.insert(Cryolysis2.messages, Cryolysis2.Private.HasPortMenuTeleport[i])
		end
	end

	-- Insert all the portals
	for i = 1, #(Cryolysis2.Private.HasPortMenuPort), 1 do
		if Cryolysis2.Private.HasPortMenuPort[i] then
			table.insert(Cryolysis2.messages, Cryolysis2.Private.HasPortMenuPort[i])
		end
	end
end

------------------------------------------------------------------------------------------------------
-- Function that prints a random fun message upon spellcast
------------------------------------------------------------------------------------------------------
function Cryolysis2:RandomMessage(spellName, spellRank, spellTarget)

	Cryolysis2.Private.RandMessage = nil

	-- Create array of spells that have random messages
	Cryolysis2:GetSpellsWithMessages();

	local found = false
	for i = 1, #(Cryolysis2.messages), 1 do
		if Cryolysis2.messages[i] == spellName then
			found = true
			break
		end
	end
	
	if not found then
		return
	end

	local city = false
	local mount = false

	-- Do polymorph messages
	local tempName, tempRank = GetSpellInfo(Cryolysis2.Private.SpellId["Polymorph"])
	local _, pigRank = GetSpellInfo(28272)
	local _, turtleRank = GetSpellInfo(28271)
	
	if spellName == tempName then
		if Cryolysis2.db.profile.PolyMessage == true then
			-- Get what type of poly we are using
--			local _, polyType = strsplit(":", spellRank);
			
--[[ 			if polyType then
  -- 				-- Put the type on the end of the polymorph
  -- 				spellName = spellName..":"..polyType;
  -- 			end
--]]
			
			if spellRank == pigRank then
				-- Pig
				Cryolysis2:CreateRandom_Pig();

			elseif spellRank == turtleRank then
				-- Turtle
				Cryolysis2:CreateRandom_Turtle();

			else
				-- Must be sheep
				Cryolysis2:CreateRandom_Sheep();

			end
		end
	elseif spellName == GetSpellInfo(Cryolysis2.Private.SpellId["Ritual of Refreshment"]) and Cryolysis2.db.profile.RitualMessage == true then
		Cryolysis2:CreateRandom_Ritual();

	else
		-- Must be teleport/portal messages

		local teleport = false
		local portal = false
		for i = 1, #(Cryolysis2.Private.HasPortMenuTeleport), 1 do
			if spellName == Cryolysis2.Private.HasPortMenuTeleport[i] then
				if Cryolysis2.Private.englishFaction == "Alliance" then
					city = Cryolysis2.Private.AllianceLocs[i]
				else
					city = Cryolysis2.Private.HordeLocs[i]
				end
				teleport = true
				portal = false
			end
		end

		if not city then
			-- Portal, find out what city
			for i = 1, #(Cryolysis2.Private.HasPortMenuPort), 1 do
				if spellName == Cryolysis2.Private.HasPortMenuPort[i] then
					if Cryolysis2.Private.englishFaction == "Alliance" then
						city = Cryolysis2.Private.AllianceLocs[i]
					else
						city = Cryolysis2.Private.HordeLocs[i]
					end
					teleport = false
					portal = true
				end
			end
		end

		if teleport and Cryolysis2.db.profile.TeleMessage == true then
			-- Teleports
			Cryolysis2:CreateRandom_Teleport();
		elseif portal and Cryolysis2.db.profile.PortalMessage == true then
			-- Portals
			Cryolysis2:CreateRandom_Portal();
		end
	end
	
	-- Parse the random message
	if Cryolysis2.Private.RandMessage ~= nil then
		Cryolysis2:AddMessage(Cryolysis2:ParseMessage(Cryolysis2.Private.RandMessage, spellTarget, city, mount), Cryolysis2.db.profile.ChatChannel);
	end
end

------------------------------------------------------------------------------------------------------
-- Snagged this from Cryo1, it sends the message to various channels based on the type parameter
------------------------------------------------------------------------------------------------------
function Cryolysis2:AddMessage(msg, type)
	if not msg or not type then
		return
	end

	-- If the message type is "USER" then the message is displayed
	if (type == "USER") then
		-- Colorize the message
		msg = Cryolysis2:AddMsgColor(msg);
		local Intro = "|C2D47E7EECr|C2B7EECEEyo|C2AA2EFEEly|C28C6F4EEsis|CFFFFFFFF2: ";
		--[[
		if CryolysisConfig.ChatType then
			-- ...... On the first chat window
			ChatFrame1:AddMessage(Intro..msg, 0.2, 0.9, 0.95, 1.0, UIERRORS_HOLD_TIME);
		else
			-- ...... or in the middle of the screen
			UIErrorsFrame:AddMessage(Intro..msg, 0.2, 0.9, 0.95, 1.0, UIERRORS_HOLD_TIME);
		end
		]]
		DEFAULT_CHAT_FRAME:AddMessage(Intro..msg, 0.2, 0.9, 0.95, 1.0, UIERRORS_HOLD_TIME);

	elseif (type == "WORLD") then
		-- The message will be sent in raid, failing this in group, and failing this in local chat
		if (GetNumRaidMembers() > 0) then
			SendChatMessage(msg, "RAID");
		elseif (GetNumPartyMembers() > 0) then
			SendChatMessage(msg, "PARTY");
		else
			SendChatMessage(msg, "SAY");
		end

	elseif (type == "GROUP") then
		-- The message will be sent in raid, failing this in group, and failing this it will not be sent
		if (GetNumRaidMembers() > 0) then
			SendChatMessage(msg, "RAID");
		elseif (GetNumPartyMembers() > 0) then
			SendChatMessage(msg, "PARTY");
		end

	elseif (type == "PARTY") then
		-- Display to group
		if (GetNumPartyMembers() > 0) then
			SendChatMessage(msg, "PARTY");
		end

	elseif (type == "RAID") then
		-- Display to raid
		if (GetNumRaidMembers() > 0) then
			SendChatMessage(msg, "RAID");
		end

	elseif (type == "SAY") then
		-- Otherwise send to local chat
		SendChatMessage(msg, "SAY");
	end
end

------------------------------------------------------------------------------------------------------
-- Snagged this from Cryo1, it allows the user to use tags like <target> and <portal> in the fun messages table.
------------------------------------------------------------------------------------------------------
function Cryolysis2:AddMsgColor(msg)
	msg = string.gsub(msg, "<white>", "|CFFFFFFFF");
	msg = string.gsub(msg, "<lightBlue>", "|CFF99CCFF");
	msg = string.gsub(msg, "<brightGreen>", "|CFF00FF00");
	msg = string.gsub(msg, "<lightGreen2>", "|CFF66FF66");
	msg = string.gsub(msg, "<lightGreen1>", "|CFF99FF66");
	msg = string.gsub(msg, "<yellowGreen>", "|CFFCCFF66");
	msg = string.gsub(msg, "<lightYellow>", "|CFFFFFF66");
	msg = string.gsub(msg, "<darkYellow>", "|CFFFFCC00");
	msg = string.gsub(msg, "<lightOrange>", "|CFFFFCC66");
	msg = string.gsub(msg, "<dirtyOrange>", "|CFFFF9933");
	msg = string.gsub(msg, "<darkOrange>", "|CFFFF6600");
	msg = string.gsub(msg, "<redOrange>", "|CFFFF3300");
	msg = string.gsub(msg, "<red>", "|CFFFF0000");
	msg = string.gsub(msg, "<lightRed>", "|CFFFF5555");
	msg = string.gsub(msg, "<lightPurple1>", "|CFFFFC4FF");
	msg = string.gsub(msg, "<lightPurple2>", "|CFFFF99FF");
	msg = string.gsub(msg, "<purple>", "|CFFFF50FF");
	msg = string.gsub(msg, "<darkPurple1>", "|CFFFF00FF");
	msg = string.gsub(msg, "<darkPurple2>", "|CFFB700B7");
	msg = string.gsub(msg, "<close>", "|r");
	msg = string.gsub(msg, "<darkBlue>", "|C2D59E9FF");
	return msg;
end

------------------------------------------------------------------------------------------------------
-- Snagged this from Cryo1, it allows the user to use tags like <target> and <portal> in the fun messages table.
------------------------------------------------------------------------------------------------------
function Cryolysis2:ParseMessage(msg, target, portal, mount)
	msg = string.gsub(msg, "<player>", UnitName("player"));
	
	if target then
		msg = string.gsub(msg, "<target>", target);
	end
	
	if portal then
		msg = string.gsub(msg, "<portal>", portal);
	end
	
	if mount then
		msg = string.gsub(msg, "<mount>", mount);
	end
	

	return msg;
end
