local L = LibStub("AceLocale-3.0"):GetLocale("Cryolysis2")
local Cryolysis2 = LibStub("AceAddon-3.0"):GetAddon("Cryolysis2")

function Cryolysis2:PreCacheCheck()

	local items = {
		"22044", --Emerald
		"8008",  --Ruby
		"8007",  --Citrine
		"5513",  --Jade
		"5514",  --Agate
		"17056", --Light Feather
		"17031", --Rune of Teleportation
		"17032", --Rune of Portals
		"17020", --Arcane Powder
		"5350"   --Conjured Water
	}

	for i = 1, #(items), 1 do
		if (GetItemInfo(items[i]) == nil) then
			Cryolysis2.Private.AllItemsCached = false
			break
		end
	end
	
	if Cryolysis2.Private.AllItemsCached == false then
		Cryolysis2:CacheItems(1)
	end

end

function Cryolysis2:CacheItems(index)

	local items = {
		"22044", --Emerald
		"8008",  --Ruby
		"8007",  --Citrine
		"5513",  --Jade
		"5514",  --Agate
		"17056", --Light Feather
		"17031", --Rune of Teleportation
		"17032", --Rune of Portals
		"17020", --Arcane Powder
		"5350"   --Conjured Water
	}
	
	GameTooltip:SetOwner(UIParent, "CENTER")
	if (GetItemInfo(items[index]) == nil) then
		GameTooltip:SetHyperlink("item:"..items[index]..":0:0:0:0:0:0:0")
		GameTooltip:Hide()
		Cryolysis2:ScheduleTimer("CacheItems", .5, tonumber(index))
	else
		if index < 10 then
			Cryolysis2:ScheduleTimer("CacheItems", .5, tonumber(index+1))
		else
			Cryolysis2.Private.AllItemsCached = true
		end
	end
end
	
------------------------------------------------------------------------------------------------------
-- Function to find a specific spell type
------------------------------------------------------------------------------------------------------
function Cryolysis2:FindSpellType(spellName)
	for i = 1, MAX_SKILLLINE_TABS do
		local name, texture, offset, numSpells = GetSpellTabInfo(i);
		   
		if not name then
			break;
		end
		   
		for s = offset + 1, offset + numSpells do
			local spell, rank = GetSpellName(s, BOOKTYPE_SPELL);
			if spell == spellName then
				return i
			end
		end
	end
end

------------------------------------------------------------------------------------------------------
-- Function to find a specific spell id
------------------------------------------------------------------------------------------------------
function Cryolysis2:FindSpellID(findname)

	local i = 1
	if string.len(findname) > 0 then
		while true do
			local spellName, spellRank = GetSpellName(i, BOOKTYPE_SPELL)
			if not spellName then
				do break end
			end
			
			if spellName == findname then
				return i
			end
			i = i + 1
		end
	end
	return 0

end

------------------------------------------------------------------------------------------------------
-- Function used to detect what spells the mage has.
-- For food and water it also detects the highest rank the mage has.
-- This is so we can add in casting of a certain rank of the spell according to the target's level.
-- This function should be called once initially while loading in, and then anytime the mage learns a new spell.
------------------------------------------------------------------------------------------------------
function Cryolysis2:DetectSpellsAndRanks()
	
	local i = 1
	local spellRankText, spellRankNumber
	while true do
		local spellName, spellRank = GetSpellName(i, BOOKTYPE_SPELL)
		if not spellName then
			do break end
		end
	
		-- These ones are straight-forward, if we find the spell, set the corresponding value to true
		if spellName == GetSpellInfo(Cryolysis2.Private.SpellId["Arcane Intellect"]) then  --AI
			Cryolysis2.Private.HasArcaneIntellect = true
			Cryolysis2.Private.HasSpellMenuBuff[2] = true
		end
		if spellName == GetSpellInfo(Cryolysis2.Private.SpellId["Arcane Brilliance"]) then  --AB
			Cryolysis2.Private.HasArcaneBrilliance = true
			Cryolysis2.Private.HasSpellMenuBuff[2] = true
		end
		if spellName == GetSpellInfo(Cryolysis2.Private.SpellId["Frost Armor"]) then  --Frost Armor
			Cryolysis2.Private.HasFrostArmor = true
			Cryolysis2.Private.HasSpellMenuBuff[1] = true
		end
		if spellName == GetSpellInfo(Cryolysis2.Private.SpellId["Ice Armor"]) then  --Ice Armor
			Cryolysis2.Private.HasIceArmor = true
			Cryolysis2.Private.HasSpellMenuBuff[1] = true
		end
		if spellName == GetSpellInfo(Cryolysis2.Private.SpellId["Molten Armor"]) then  --Molten Armor
			Cryolysis2.Private.HasMoltenArmor = true
			Cryolysis2.Private.HasSpellMenuBuff[1] = true
		end
		if spellName == GetSpellInfo(Cryolysis2.Private.SpellId["Mage Armor"]) then  --Mage Armor
			Cryolysis2.Private.HasMageArmor = true
			Cryolysis2.Private.HasSpellMenuBuff[1] = true
		end
		if spellName == GetSpellInfo(Cryolysis2.Private.SpellId["Remove Lesser Curse"]) then  --Remove Lesser Curse
			Cryolysis2.Private.HasRemoveCurse = true
			Cryolysis2.Private.HasSpellMenuBuff[6] = true
		end
		if spellName == GetSpellInfo(Cryolysis2.Private.SpellId["Slow Fall"]) then  --Slow Fall
			Cryolysis2.Private.HasSlowFall = true
			Cryolysis2.Private.HasSpellMenuBuff[7] = true
		end
		if spellName == GetSpellInfo(Cryolysis2.Private.SpellId["Evocation"]) then  --Evocation
			Cryolysis2.Private.HasEvocation = true
		end
		if spellName == GetSpellInfo(Cryolysis2.Private.SpellId["Mana Shield"]) then  --Mana Shield
			Cryolysis2.Private.HasManaShield = true
			Cryolysis2.Private.HasSpellMenuBuff[4] = true
		end
		if spellName == GetSpellInfo(Cryolysis2.Private.SpellId["Ice Barrier"]) then  --Ice Barrier
			Cryolysis2.Private.HasIceBarrier = true
			Cryolysis2.Private.HasSpellMenuBuff[4] = true
		end
		if spellName == GetSpellInfo(Cryolysis2.Private.SpellId["Dampen Magic"]) then  --Dampen Magic
			Cryolysis2.Private.HasDampenMagic = true
			Cryolysis2.Private.HasSpellMenuBuff[3] = true
		end
		if spellName == GetSpellInfo(Cryolysis2.Private.SpellId["Amplify Magic"]) then  --Amplify Magic
			Cryolysis2.Private.HasAmplifyMagic = true
			Cryolysis2.Private.HasSpellMenuBuff[3] = true
		end
		if spellName == GetSpellInfo(Cryolysis2.Private.SpellId["Fire Ward"]) then  --Fire Ward
			Cryolysis2.Private.HasFireWard = true
			Cryolysis2.Private.HasSpellMenuBuff[5] = true
		end
		if spellName == GetSpellInfo(Cryolysis2.Private.SpellId["Frost Ward"]) then  --Frost Ward
			Cryolysis2.Private.HasFrostWard = true
			Cryolysis2.Private.HasSpellMenuBuff[5] = true
		end
		
		-- Teleports and Portals
		if spellName == GetSpellInfo(Cryolysis2.Private.SpellId["Teleport: Ironforge"]) or spellName == GetSpellInfo(Cryolysis2.Private.SpellId["Teleport: Orgrimmar"]) then  -- IF/Org
			if Cryolysis2.Private.englishFaction == "Alliance" then
				Cryolysis2.Private.HasPortMenuTeleport[1] = GetSpellInfo(Cryolysis2.Private.SpellId["Teleport: Ironforge"])
			else
				Cryolysis2.Private.HasPortMenuTeleport[1] = GetSpellInfo(Cryolysis2.Private.SpellId["Teleport: Orgrimmar"])
			end
			Cryolysis2.Private.HasATeleport = true
		end
		if spellName == GetSpellInfo(Cryolysis2.Private.SpellId["Teleport: Stormwind"]) or spellName == GetSpellInfo(Cryolysis2.Private.SpellId["Teleport: Undercity"]) then  -- SW/UC
			if Cryolysis2.Private.englishFaction == "Alliance" then
				Cryolysis2.Private.HasPortMenuTeleport[2] = GetSpellInfo(Cryolysis2.Private.SpellId["Teleport: Stormwind"])
			else
				Cryolysis2.Private.HasPortMenuTeleport[2] = GetSpellInfo(Cryolysis2.Private.SpellId["Teleport: Undercity"])
			end
			Cryolysis2.Private.HasATeleport = true
		end
		if spellName == GetSpellInfo(Cryolysis2.Private.SpellId["Teleport: Darnassus"]) or spellName == GetSpellInfo(Cryolysis2.Private.SpellId["Teleport: Thunder Bluff"]) then  -- Darn/TB
			if Cryolysis2.Private.englishFaction == "Alliance" then
				Cryolysis2.Private.HasPortMenuTeleport[3] = GetSpellInfo(Cryolysis2.Private.SpellId["Teleport: Darnassus"])
			else
				Cryolysis2.Private.HasPortMenuTeleport[3] = GetSpellInfo(Cryolysis2.Private.SpellId["Teleport: Thunder Bluff"])
			end
			Cryolysis2.Private.HasATeleport = true
		end
		if spellName == GetSpellInfo(Cryolysis2.Private.SpellId["Teleport: Exodar"]) or spellName == GetSpellInfo(Cryolysis2.Private.SpellId["Teleport: Silvermoon"]) then  -- Exodar/Silvermoon
			if Cryolysis2.Private.englishFaction == "Alliance" then
				Cryolysis2.Private.HasPortMenuTeleport[4] = GetSpellInfo(Cryolysis2.Private.SpellId["Teleport: Exodar"])
			else
				Cryolysis2.Private.HasPortMenuTeleport[4] = GetSpellInfo(Cryolysis2.Private.SpellId["Teleport: Silvermoon"])
			end
			Cryolysis2.Private.HasATeleport = true
		end
		if spellName == GetSpellInfo(Cryolysis2.Private.SpellId["Teleport: Theramore"]) or spellName == GetSpellInfo(Cryolysis2.Private.SpellId["Teleport: Stonard"]) then  -- Exodar/Silvermoon
			if Cryolysis2.Private.englishFaction == "Alliance" then
				Cryolysis2.Private.HasPortMenuTeleport[5] = GetSpellInfo(Cryolysis2.Private.SpellId["Teleport: Theramore"])
			else
				Cryolysis2.Private.HasPortMenuTeleport[5] = GetSpellInfo(Cryolysis2.Private.SpellId["Teleport: Stonard"])
			end
			Cryolysis2.Private.HasATeleport = true
		end
		if spellName == GetSpellInfo(Cryolysis2.Private.SpellId["Teleport: Shattrath"]) then  --Shat
			Cryolysis2.Private.HasPortMenuTeleport[6] = GetSpellInfo(Cryolysis2.Private.SpellId["Teleport: Shattrath"])
			Cryolysis2.Private.HasATeleport = true
		end
		
		-- Portals
		if spellName == GetSpellInfo(Cryolysis2.Private.SpellId["Portal: Ironforge"]) or spellName == GetSpellInfo(Cryolysis2.Private.SpellId["Portal: Orgrimmar"]) then  -- IF/Org
			if Cryolysis2.Private.englishFaction == "Alliance" then
				Cryolysis2.Private.HasPortMenuPort[1] = GetSpellInfo(Cryolysis2.Private.SpellId["Portal: Ironforge"])
			else
				Cryolysis2.Private.HasPortMenuPort[1] = GetSpellInfo(Cryolysis2.Private.SpellId["Portal: Orgrimmar"])
			end
			Cryolysis2.Private.HasAPort = true
		end
		if spellName == GetSpellInfo(Cryolysis2.Private.SpellId["Portal: Stormwind"]) or spellName == GetSpellInfo(Cryolysis2.Private.SpellId["Portal: Undercity"]) then  -- SW/UC
			if Cryolysis2.Private.englishFaction == "Alliance" then
				Cryolysis2.Private.HasPortMenuPort[2] = GetSpellInfo(Cryolysis2.Private.SpellId["Portal: Stormwind"])
			else
				Cryolysis2.Private.HasPortMenuPort[2] = GetSpellInfo(Cryolysis2.Private.SpellId["Portal: Undercity"])
			end
			Cryolysis2.Private.HasAPort = true
		end
		if spellName == GetSpellInfo(Cryolysis2.Private.SpellId["Portal: Darnassus"]) or spellName == GetSpellInfo(Cryolysis2.Private.SpellId["Portal: Thunder Bluff"]) then  -- Darn/TB
			if Cryolysis2.Private.englishFaction == "Alliance" then
				Cryolysis2.Private.HasPortMenuPort[3] = GetSpellInfo(Cryolysis2.Private.SpellId["Portal: Darnassus"])
			else
				Cryolysis2.Private.HasPortMenuPort[3] = GetSpellInfo(Cryolysis2.Private.SpellId["Portal: Thunder Bluff"])
			end
			Cryolysis2.Private.HasAPort = true
		end
		if spellName == GetSpellInfo(Cryolysis2.Private.SpellId["Portal: Exodar"]) or spellName == GetSpellInfo(Cryolysis2.Private.SpellId["Portal: Silvermoon"]) then  -- Exodar/Silvermoon
			if Cryolysis2.Private.englishFaction == "Alliance" then
				Cryolysis2.Private.HasPortMenuPort[4] = GetSpellInfo(Cryolysis2.Private.SpellId["Portal: Exodar"])
			else
				Cryolysis2.Private.HasPortMenuPort[4] = GetSpellInfo(Cryolysis2.Private.SpellId["Portal: Silvermoon"])
			end
			Cryolysis2.Private.HasAPort = true
		end
		if spellName == GetSpellInfo(Cryolysis2.Private.SpellId["Portal: Theramore"]) 
		or spellName == GetSpellInfo(Cryolysis2.Private.SpellId["Portal: Stonard"]) then  -- Theramore/Stonard
			if Cryolysis2.Private.englishFaction == "Alliance" then
				Cryolysis2.Private.HasPortMenuPort[5] = GetSpellInfo(Cryolysis2.Private.SpellId["Portal: Theramore"])
			else
				Cryolysis2.Private.HasPortMenuPort[5] = GetSpellInfo(Cryolysis2.Private.SpellId["Portal: Stonard"])
			end
			Cryolysis2.Private.HasAPort = true
		end
		if spellName == GetSpellInfo(Cryolysis2.Private.SpellId["Portal: Shattrath"]) then  -- Shat
			Cryolysis2.Private.HasPortMenuPort[6] = GetSpellInfo(Cryolysis2.Private.SpellId["Portal: Shattrath"])
			Cryolysis2.Private.HasAPort = true
		end

		-- Ritual of Refreshment
		if spellName == GetSpellInfo(Cryolysis2.Private.SpellId["Ritual of Refreshment"]) then  --Ritual of Refreshment
			Cryolysis2.Private.HasRitual = true
		end

		-- Mana Gems
		if spellName == GetSpellInfo(Cryolysis2.Private.SpellId["Conjure Mana Agate"]) then  --Conjure Mana Agate
			Cryolysis2.Private.CanConjureGem[1] = true
			if 1 > Cryolysis2.Private.HighestManaGemId then
				Cryolysis2.Private.HighestManaGemId = 1
			end
		end
		if spellName == GetSpellInfo(Cryolysis2.Private.SpellId["Conjure Mana Jade"]) then  --Conjure Mana Jade
			Cryolysis2.Private.CanConjureGem[2] = true
			if 2 > Cryolysis2.Private.HighestManaGemId then
				Cryolysis2.Private.HighestManaGemId = 2
			end
		end
		if spellName == GetSpellInfo(Cryolysis2.Private.SpellId["Conjure Mana Citrine"]) then  --Conjure Mana Citrine
			Cryolysis2.Private.CanConjureGem[3] = true
			if 3 > Cryolysis2.Private.HighestManaGemId then
				Cryolysis2.Private.HighestManaGemId = 3
			end
		end
		if spellName == GetSpellInfo(Cryolysis2.Private.SpellId["Conjure Mana Ruby"]) then  --Conjure Mana Ruby
			Cryolysis2.Private.CanConjureGem[4] = true
			if 4 > Cryolysis2.Private.HighestManaGemId then
				Cryolysis2.Private.HighestManaGemId = 4
			end
		end
		if spellName == GetSpellInfo(Cryolysis2.Private.SpellId["Conjure Mana Emerald"]) then  --Conjure Mana Emerald
			Cryolysis2.Private.CanConjureGem[5] = true
			if 5 > Cryolysis2.Private.HighestManaGemId then
				Cryolysis2.Private.HighestManaGemId = 5
			end
		end
		
		for i = #(Cryolysis2.Private.WaterSpellId), 1, -1 do
			if spellName == GetSpellInfo(Cryolysis2.Private.WaterSpellId[i]) then  --Conjure Water
				Cryolysis2.Private.CanConjureWater = true
				Cryolysis2.Private.HighestWaterId = i
				break
			end
		end
		for i = #(Cryolysis2.Private.FoodSpellId), 1, -1 do
			if spellName == GetSpellInfo(Cryolysis2.Private.FoodSpellId[i]) then  --Conjure Food
				Cryolysis2.Private.CanConjureFood = true
				Cryolysis2.Private.HighestFoodId = i
				break
			end
		end
		i = i + 1
	end	
end

------------------------------------------------------------------------------------------------------
-- Function to detect how much water we got in the bags
------------------------------------------------------------------------------------------------------
function Cryolysis2:CountWater()

	for i = #(Cryolysis2.Private.WaterItemId), 1, -1 do
		if GetItemCount(GetItemInfo(Cryolysis2.Private.WaterItemId[i])) > 0 then
			return GetItemCount(GetItemInfo(Cryolysis2.Private.WaterItemId[i]))
		end
	end
	return 0
	
end

------------------------------------------------------------------------------------------------------
-- Function to detect what the highest water we got in the bags
------------------------------------------------------------------------------------------------------
function Cryolysis2:WaterOnHand()

	Cryolysis2.Private.HighestWaterOnHand = 0

	for i= 1, #(Cryolysis2.Private.WaterItemId), 1 do
		if GetItemCount(GetItemInfo(Cryolysis2.Private.WaterItemId[i])) > 0 then
			Cryolysis2.Private.HighestWaterOnHand = i
		end
	end

end

------------------------------------------------------------------------------------------------------
-- Function to detect how much food we got in the bags
------------------------------------------------------------------------------------------------------
function Cryolysis2:CountFood()

	for i = #(Cryolysis2.Private.FoodItemId), 1, -1 do
		if GetItemCount(GetItemInfo(Cryolysis2.Private.FoodItemId[i])) > 0 then
			return GetItemCount(GetItemInfo(Cryolysis2.Private.FoodItemId[i]))
		end
	end
	return 0
	
end

------------------------------------------------------------------------------------------------------
-- Function to detect what the highest food we got in the bags
------------------------------------------------------------------------------------------------------
function Cryolysis2:FoodOnHand()
	
	Cryolysis2.Private.HighestFoodOnHand = 0
	
	for i= 1, #(Cryolysis2.Private.FoodItemId), 1 do
		if GetItemCount(GetItemInfo(Cryolysis2.Private.FoodItemId[i])) > 0 then
			Cryolysis2.Private.HighestFoodOnHand = i
		end
	end
	
end

function Cryolysis2:FindAllMounts()
	
	local duplicate = false
	
	for icon = 1, #(Cryolysis2.Mounts), 1 do
		for i = 1, #(Cryolysis2.Mounts[icon]), 1 do
			if GetItemCount(GetItemInfo(Cryolysis2.Mounts[icon][i])) > 0 then
				Cryolysis2.Private.HasMount = true
				if Cryolysis2.db.profile.LeftMount == "" then
					Cryolysis2.db.profile.LeftMount = 1 --GetItemInfo(Cryolysis2.Mounts[icon][i])
				end
				if Cryolysis2.db.profile.RightMount == "" then
					Cryolysis2.db.profile.RightMount = 1 --GetItemInfo(Cryolysis2.Mounts[icon][i])
				end
				for j = 1, #(Cryolysis2.Private.Mounts), 1 do
					if Cryolysis2.Private.Mounts[j] == GetItemInfo(Cryolysis2.Mounts[icon][i]) then
						duplicate = true
					end
				end
				if duplicate == false then
					table.insert(Cryolysis2.Private.Mounts, (GetItemInfo(Cryolysis2.Mounts[icon][i])))
					Cryolysis2:Print("Mount Found: "..select(2,GetItemInfo(Cryolysis2.Mounts[icon][i])))
				end
				duplicate = false
			end
		end
	end
	
	Cryolysis2.options.args.graphicalsettings.args.mountbutton.args.leftmount.values = Cryolysis2.Private.Mounts
	Cryolysis2.options.args.graphicalsettings.args.mountbutton.args.rightmount.values = Cryolysis2.Private.Mounts

end

function Cryolysis2:FindMountIcon(mountName)

	for icon = 1, #(Cryolysis2.Mounts), 1 do
		for i = 1, #(Cryolysis2.Mounts[icon]), 1 do
			if mountName == GetItemInfo(Cryolysis2.Mounts[icon][i]) then
				return icon
			end
		end
	end

end

------------------------------------------------------------------------------------------------------
-- Function to auto-trade food to target
------------------------------------------------------------------------------------------------------
function Cryolysis2:TradeFood()
	
	if (UnitExists("target") and UnitIsPlayer("target") and UnitIsFriend("player", "target") and UnitName("target") ~= UnitName("player")) then
		
		Cryolysis2:FoodOnHand()
		
		if Cryolysis2.Private.HighestFoodOnHand > 0 then
			local itemString, itemName
			for bag = 0, 4, 1 do
				for slot = 1, GetContainerNumSlots(bag), 1 do
					if (GetContainerItemLink(bag,slot)) then
						itemString = ""..GetContainerItemLink(bag,slot)
						itemName = GetItemInfo(itemString)
						_, _, locked = GetContainerItemInfo(bag, slot)
						if itemName == GetItemInfo(Cryolysis2.Private.FoodItemId[Cryolysis2.Private.HighestFoodOnHand]) and not locked then
							PickupContainerItem(bag, slot)
							if CursorHasItem() then
								if Cryolysis2.Private.TradeWindowOpen then
									DropItemOnUnit("npc");
									return
								else
									DropItemOnUnit("target");
									return
								end
							end
						end
					end
				end
			end
		else
			Cryolysis2:Print(L["No food found for trading, conjure some then try again!"])
		end
	end
end

------------------------------------------------------------------------------------------------------
-- Function to auto-trade water to target
------------------------------------------------------------------------------------------------------
function Cryolysis2:TradeWater()
	if (UnitExists("target") and UnitIsPlayer("target") and UnitIsFriend("player", "target") and UnitName("target") ~= UnitName("player")) then
		
		Cryolysis2:WaterOnHand()
		
		if Cryolysis2.Private.HighestWaterOnHand > 0 then
			local itemString, itemName
			for bag = 0, 4, 1 do
				for slot = 1, GetContainerNumSlots(bag), 1 do
					if (GetContainerItemLink(bag,slot)) then
						itemString = ""..GetContainerItemLink(bag,slot)
						itemName = GetItemInfo(itemString)
						_, _, locked = GetContainerItemInfo(bag, slot)
						if itemName == GetItemInfo(Cryolysis2.Private.WaterItemId[Cryolysis2.Private.HighestWaterOnHand]) and not locked then
							PickupContainerItem(bag, slot)
							if CursorHasItem() then
								if Cryolysis2.Private.TradeWindowOpen then
									DropItemOnUnit("npc");
									return
								else
									DropItemOnUnit("target");
									return
								end
							end
						end
					end
				end
			end
		else
			Cryolysis2:Print(L["No water found for trading, conjure some then try again!"])
		end
	end
end

------------------------------------------------------------------------------------------------------
-- Function for restocking reagents when visiting vendor
------------------------------------------------------------------------------------------------------
function Cryolysis2:RestockReagents()

	local PowderIndex, TeleportIndex, PortalsIndex
	for i = 1, GetMerchantNumItems(), 1 do
		local name, texture, price, quantity, numAvailable, isUsable, extendedCost = GetMerchantItemInfo(i)
		if name == self:GetLocalizedItemName("Arcane Powder") then
			PowderIndex = i
		end
		if name == self:GetLocalizedItemName("Rune of Teleportation") then
			TeleportIndex = i
		end
		if name == self:GetLocalizedItemName("Rune of Portals") then
			PortalsIndex = i
		end
	end

	if Cryolysis2.Private.HasArcaneBrilliance then
		local tempArcanePowder = GetItemCount(self:GetLocalizedItemName("Arcane Powder"))
		if tempArcanePowder < Cryolysis2.db.profile.RestockPowder then
			local calcAP = Cryolysis2.db.profile.RestockPowder - tempArcanePowder
			while calcAP > 20 do
				BuyMerchantItem(PowderIndex, 20)
				calcAP = calcAP - 20
			end
			BuyMerchantItem(PowderIndex, calcAP)
		end
	end
	if Cryolysis2.Private.HasATeleport then
		local tempTeleport = GetItemCount(self:GetLocalizedItemName("Rune of Teleportation"))
		if tempTeleport < Cryolysis2.db.profile.RestockTeleport then
			local calcTele = Cryolysis2.db.profile.RestockTeleport - tempTeleport
			while calcTele > 10 do
				BuyMerchantItem(TeleportIndex, 10)
				calcTele = calcTele - 10
			end
			BuyMerchantItem(TeleportIndex, calcTele)
		end
	end
	if Cryolysis2.Private.HasAPort then
		local tempPortals = GetItemCount(self:GetLocalizedItemName("Rune of Portals"))
		if tempPortals < Cryolysis2.db.profile.RestockPortals then
			local calcPort = Cryolysis2.db.profile.RestockPortals - tempPortals
			while calcPort > 10 do
				BuyMerchantItem(PortalsIndex, 10)
				calcPort = calcPort - 10
			end
			BuyMerchantItem(PortalsIndex, calcPort)
		end
	end

end

------------------------------------------------------------------------------------------------------
-- Here be dragons.
------------------------------------------------------------------------------------------------------
function Cryolysis2:Polymorph()



end