local BZ = LibStub("LibBabble-Zone-3.0"):GetLookupTable()
local Cryolysis2 = LibStub("AceAddon-3.0"):GetAddon("Cryolysis2")

function Cryolysis2:GetLocalizedItemName(englishName)
	local name = GetItemInfo(Cryolysis2.Private.ReagentId[englishName]);

	-- Fall back on the English name
	if (nil == name) then
		name = englishName;
	end

	return name;
end

function Cryolysis2:CreatePrivateVars()
	-- Private variables
	Cryolysis2.Private = {

		Language = GetLocale(),
		englishFaction = UnitFactionGroup("player"),
		InCombat = false,
		AllItemsCached = true,
		DebuffDuration = {
			[118] = 20,
			[12824] = 30,
			[12825] = 40,
			[12826] = 50,
			[28271] = 50,
			[28272] = 50
		},
		SpellId = {
			["Polymorph"] = 118,
			["Blink"] = 1953,
			["Cold Snap"] = 11958,
			["Frost Nova"] = 122,
			["Ice Barrier"] = 11426,
			["Summon Water Elemental"] = 31687,
			["Ice Block"] = 45438,
			["Cone of Cold"] = 120,
			["Icy Veins"] = 12472,
			["Arcane Intellect"] = 1459,
			["Arcane Brilliance"] = 23028,
			["Frost Armor"] = 168,
			["Ice Armor"] = 7302,
			["Molten Armor"] = 30482,
			["Mage Armor"] = 6117,
			["Remove Lesser Curse"] = 475,
			["Slow Fall"] = 130,
			["Evocation"] = 12051,
			["Mana Shield"] = 1463,
			["Ice Barrier"] = 11426,
			["Dampen Magic"] = 604,
			["Amplify Magic"] = 1008,
			["Fire Ward"] = 543,
			["Frost Ward"] = 6143,
			
			["Teleport: Ironforge"] = 3562,
			["Teleport: Orgrimmar"] = 3567,
			["Teleport: Stormwind"] = 3561,
			["Teleport: Undercity"] = 3563,
			["Teleport: Darnassus"] = 3565,
			["Teleport: Theramore"] = 49359,
			["Teleport: Thunder Bluff"] = 3566,
			["Teleport: Exodar"] = 32271,
			["Teleport: Silvermoon"] = 32272,
			["Teleport: Stonard"] = 49358,
			["Teleport: Shattrath"] = 33690,
			
			["Portal: Ironforge"] = 11416,
			["Portal: Orgrimmar"] = 11417,
			["Portal: Stormwind"] = 10059,
			["Portal: Undercity"] = 11418,
			["Portal: Darnassus"] = 11419,
			["Portal: Theramore"] = 49360,			
			["Portal: Thunder Bluff"] = 11420,
			["Portal: Exodar"] = 32266,
			["Portal: Silvermoon"] = 32267,
			["Portal: Stonard"] = 49361,
			["Portal: Shattrath"] = 33691,
			["Ritual of Refreshment"] = 43987,
			["Conjure Mana Agate"] = 759,
			["Conjure Mana Jade"] = 3552,
			["Conjure Mana Citrine"] = 10053,
			["Conjure Mana Ruby"] = 10054,
			["Conjure Mana Emerald"] = 27101
		},
		GemSpellId = {
			759,
			3552,
			10053,
			10054,
			27101
		},
		
		-- Variables for tracking the status of the mage
		TradeWindowOpen = false,
		
		ReagentId = {
			["Light Feather"] = 17056,
			["Arcane Powder"] = 17020,
			["Rune of Teleportation"] = 17031,
			["Rune of Portals"] = 17032
		},

		-- Variables for tracking whether the mage has certain spells/items
		HighestWaterId = 0,
		WaterSpellId = {
			5504,
			5505,
			5506,
			6127,
			10138,
			10139,
			10140,
			37420,
			27090
		},
		WaterItemId = {
			5350,
			2288,
			2136,
			3772,
			8077,
			8078,
			8079,
			30703,
			22018,
			34062
		},
		HighestWaterOnHand = 0,
		HighestWaterCount = 0,
		WaterName = {
			"Conjured Water",
			"Conjured Fresh Water",
			"Conjured Purified Water",
			"Conjured Spring Water",
			"Conjured Mineral Water",
			"Conjured Sparkling Water",
			"Conjured Crystal Water",
			"Conjured Mountain Spring Water",
			"Conjured Glacier Water",
			"Conjured Manna Biscuit"
		}, -- Item IDs for Mage conjured water, in order from lowest amount of mana restored to highest.  ORDER DOES MATTER
					
		WaterTex = {
			"INV_Drink_06",
			"INV_Drink_07",
			"INV_Drink_Milk_02",
			"INV_Drink_10",
			"INV_Drink_09",
			"INV_Drink_11",
			"INV_Drink_18",
			"INV_Drink_Waterskin_11",
			"INV_Drink_16",
			"INV_Misc_Food_100"
		}, -- Textures for the water button

		HighestFoodId = 0,
		FoodSpellId = {
			587,
			597,
			990,
			6129,
			10144,
			10145,
			28612,
			33717
		},
		FoodItemId = {
			5349,
			1113,
			1114,
			1487,
			8075,
			8076,
			22895,
			22019,
			34062
		},
		HighestFoodOnHand = 0,
		HighestFoodCount = 0,
		FoodName = {
			"Conjured Muffin",
			"Conjured Bread",
			"Conjured Rye",
			"Conjured Pumpernickel",
			"Conjured Sourdough",
			"Conjured Sweet Roll",
			"Conjured Cinnamon Roll",
			"Conjured Croissant",
			"Conjured Manna Biscuit"
		}, -- Item IDs for Mage conjured bread, in order from lowest amount of health restored to highest.  ORDER DOES MATTER
					
		FoodTex = {
			"INV_Misc_Food_10",
			"INV_Misc_Food_09",
			"INV_Misc_Food_12",
			"INV_Misc_Food_08",
			"INV_Misc_Food_11",
			"INV_Misc_Food_33",
			"INV_Misc_Food_73CinnamonRoll",
			"INV_Misc_Food_32",
			"INV_Misc_Food_100"
		},	-- Textures for the food button
		HighestManaGemId = 0,
		HighestManaGemOnHand = 0,
		NextConjurableManaGem = 0,
		ManaGemCooldownBool = false,
		ManaGemTex = {
			"INV_Misc_Gem_Emerald_01",
			"INV_Misc_Gem_Emerald_02",
			"INV_Misc_Gem_Opal_01",
			"INV_Misc_Gem_Ruby_01",
			"INV_Misc_Gem_Stone_01"
		},
		ManaGemName = {
			"Mana Agate",
			"Mana Jade",
			"Mana Citrine",
			"Mana Ruby",
			"Mana Emerald"
		},
		ManaGemId = {
			5514,
			5513,
			8007,
			8008,
			22044
		},
		ConjureGemName = {
			"Conjure Mana Agate",
			"Conjure Mana Jade",
			"Conjure Mana Citrine",
			"Conjure Mana Ruby",
			"Conjure Mana Emerald"
		},
		HasManaGem = {
			false,
			false,
			false,
			false,
			false
		},  -- Whether the user has a manastone conjured.  Ordered lowest to highest.
		CanConjureGem = {
			false,
			false,
			false,
			false,
			false
		},  -- Whether the user has the ability to conjure each rank of mana gem.  Ordered lowest to highest.
		GemMenu = {
			"Cryo2GemMenu1",
			"Cryo2GemMenu2",
			"Cryo2GemMenu3",
			"Cryo2GemMenu4",
			"Cryo2GemMenu5"
		},
		
		HasEvocation = false,		-- Has the mage learned Evocation yet?
		HasArcaneIntellect = false,	-- Has the mage learned AI yet?
		HasFrostArmor = false,		-- Has the mage learned Frost Armor yet?
		HasIceArmor = false,		-- Has the mage learned Ice Armor yet?
		HasMoltenArmor = false,		-- Has the mage learned Molten Armor yet?
		HasMageArmor = false,		-- Has the mage learned Mage Armor yet?
		HasFireWard = false,		-- Has the mage learned Fire Ward yet?
		HasFrostWard = false,		-- Has the mage learned Frost Ward yet?
		HasSlowFall = false,		-- Has the mage learned Slow Fall yet?
		HasRemoveCurse = false,		-- Has the mage learned Remove Lesser Curse yet?
		HasManaShield = false,		-- Has the mage learned Mana Shield yet?
		HasIceBarrier = false,		-- Has the mage learned Ice Barrier? (talent based)
		HasDampenMagic = false,		-- Has the mage learned Dampen Magic yet?
		HasAmplifyMagic = false,	-- Has the mage learned Amplify Magic yet?
		HasArcaneBrilliance = false,	-- Has the mage learned Arcane Brilliance yet?
		HasRitual = false,		-- Has the mage learned Ritual of Refreshment yet?
		
		CanConjureFood = false,		-- Used to detect what buttons to show for lower level characters
		CanConjureWater = false,	-- Used to detect what buttons to show for lower level characters
		
		--[[
		Spell Menu Info:
			1 = Armor
			2 = AI/AB
			3 = Amplify/Dampen
			4 = Ice Barrier/Mana Shield
			5 = Fire/Frost Ward
			6 = Remove Lesser Curse
			7 = Slow Fall
		]]
		HasSpellMenuBuff = {
			false,
			false,
			false,
			false,
			false,
			false,
			false
		},
		BuffMenu = {
			"Cryo2BuffMenu1",
			"Cryo2BuffMenu2",
			"Cryo2BuffMenu3",
			"Cryo2BuffMenu4",
			"Cryo2BuffMenu5",
			"Cryo2BuffMenu6",
			"Cryo2BuffMenu7"
		},
		BuffMenuVisible = false,
		
		--[[
		Teleports/Portals: 
			1 = IF/Org
			2 = SW/UC
			3 = Darn/TB
			4 = Exodar/Silvermoon
			5 = Shat
		]]
		AllianceLocs = {
			BZ["Ironforge"],
			BZ["Stormwind City"],
			BZ["Darnassus"],
			BZ["The Exodar"],
			BZ["Theramore Isle"],
			BZ["Shattrath City"],
		},
		HordeLocs = {
			BZ["Orgrimmar"],
			BZ["Undercity"],
			BZ["Thunder Bluff"],
			BZ["Silvermoon City"],
			BZ["Stonard"],
			BZ["Shattrath City"],
		},
		HasPortMenuPort = {
			false,
			false,
			false,
			false,
			false,
			false
		},
		HasPortMenuTeleport = {
			false,
			false,
			false,
			false,
			false,
			false
		},
		HasATelePort = false,
		HasAPort = false,
		PortMenu = {
			"Cryo2PortMenu1",
			"Cryo2PortMenu2",
			"Cryo2PortMenu3",
			"Cryo2PortMenu4",
			"Cryo2PortMenu5",
			"Cryo2PortMenu6"
		},
		PortMenuVisible = false,

		-- Cooldown variables
		EvocationCooldown = 0,
		EvocationCooldownText = "",
		ManastoneCooldown = 0,
		ManastoneCooldownText = "",
		ColdsnapCooldown = 0,
		ColdsnapCooldownText = "",
		IceblockCooldown = 0,
		IceblockCooldownText = "",
		
		-- Mount variables
		Mounts = {},
		LeftMountIcon = nil,
		RightMountIcon = nil,
		HasMount = false,
		MountTex = {
			"INV_Misc_Horn_01",
			"Ability_Mount_MountainRam",
			"Ability_Mount_Raptor",
			"Ability_Mount_JungleTiger",
			"Ability_Mount_Undeadhorse",
			"Ability_Mount_MechaStrider",
			"Ability_Mount_RidingHorse",
			"Ability_Mount_Kodo_03",
			"Ability_Mount_NightmareHorse",
			"Ability_Mount_Kodo_01",
			"Ability_Mount_Kodo_02",
			"Ability_Mount_WhiteDireWolf",
			"Ability_Mount_BlackDireWolf",
			"Ability_Mount_BlackPanther",
			"Ability_Mount_WhiteTiger",
			"Ability_Mount_PinkTiger",
			"INV_Misc_QirajiCrystal_05",
			"INV_Misc_Foot_Centaur",
			"Ability_Mount_RidingElekk",
			"Ability_Mount_RidingElekk_Grey",
			"Ability_Mount_RidingElekk_Purple",
			"Ability_Mount_RidingElekkElite_Blue",
			"Ability_Mount_RidingElekkElite_Green",
			"Ability_Mount_RidingElekkElite_Purple",
			"Ability_Mount_CockatriceMount_Black",
			"Ability_Mount_CockatriceMount_Blue",
			"Ability_Mount_CockatriceMount_Purple",
			"Ability_Mount_CockatriceMount",
			"Ability_Mount_CockatriceMountElite_Green",
			"Ability_Mount_CockatriceMountElite",
			"Ability_Mount_CockatriceMountElite_Purple",
			"Ability_Mount_Dreadsteed",
			"INV_Staff_08",
			"Ability_Druid_ChallangingRoar",
			"Ability_Mount_CockatriceMount_Green",
			"INV-Mount_Raven_54",
			"Ability_Mount_Gryphon_01",
			"Ability_Mount_Wyvern_01",
			"Ability_Mount_NetherdrakePurple",
			"Ability_Mount_NetherDrakeElite",
			"Ability_Hunter_Pet_NetherRay",
			"INV_Staff_08",
			"Ability_Mount_Gyrocoptor",
			"Ability_Mount_GyrocoptorElite",
			"Ability_Mount_WarHippogryph",
			"Inv_Misc_SummerFest_BrazierOrange",
			"Ability_Mount_RocketMountBlue",
			"Ability_Mount_RocketMount",
		},
		
		PolyTarget,
		PolySuccess = false,
		PolyTime,
		PolyIdUsed,
		RandMess = {
			["turtle"] = "",
			["pig"] = "",
			["sheep"] = "",
			["ritual"] = "",
			["teleport"] = "",
			["portal"] = "",
		},
		RandMessage,
		
		LastSpellCast,
		LastSpellResisted,
		SpellTimers = {},
		DebuffTimers = {},
	}
end