local L = LibStub("AceLocale-3.0"):GetLocale("Cryolysis2")
local Cryolysis2 = LibStub("AceAddon-3.0"):GetAddon("Cryolysis2")

function Cryolysis2:CreateOptions()
	-- Create array of slash commands
	Cryolysis2.slashopts = {
		type = "group",
		args = {
			menu = {
				type = "execute",
				name = L["Show Menu"],
				desc = L["Open the configuration menu."],
				func = function() Cryolysis2:OpenMenu() end
			}
		}
	}
	
	-- Create array of options
	Cryolysis2.options = {
		name = "Cryolysis 2",
		type = 'group',
		args = {
			gen = {
				type = "group",
				name = L["General Settings"],
				desc = L["Adjust various settings for Cryolysis 2."],
				order = 5,
				args = {
					lock = {
						type = "toggle",
						name = L["Lock Sphere and Buttons"],
						desc = L["Lock the main sphere and buttons so they can't be moved."],
						width = "full",
						get = function(info) return Cryolysis2.db.profile.LockSphere end,
						set = function(info, v) Cryolysis2.db.profile.LockSphere = v end,
						order = 1
					},
					constrict = {
						type = "toggle",
						name = L["Constrict Buttons to Sphere"],
						desc = L["Lock the buttons in place around the main sphere."],
						width = "full",
						get = function(info) return Cryolysis2.db.profile.LockButtons end,
						set = function(info, v) 
							Cryolysis2.db.profile.LockButtons = v 
							Cryolysis2:UpdateAllButtonPositions()
						end,
						order = 2
					},
					tooltips = {
						type = "toggle",
						name = L["Hide Tooltips"],
						desc = L["Hide the main sphere and button tooltips."],
						get = function(info) return Cryolysis2.db.profile.HideTooltips end,
						set = function(info, v) Cryolysis2.db.profile.HideTooltips = v end,
						order = 3
					}
				}
			},
			autorestock = {
				type = "group",
				name = L["Reagent Restocking"],
				desc = L["Adjust various settings for the automatic reagent restocking feature."],
				order = 10,
				args = {
					reagents = {
						type = "toggle",
						name = L["Restock Reagents"],
						desc = L["Automatically restock reagents when talking to a reagent vendor."],
						get = function(info) return Cryolysis2.db.profile.Restock end,
						set = function(info, v) Cryolysis2.db.profile.Restock = v end,
						order = 1
					},
					restockconfirm = {
						type = "toggle",
						name = L["Confirm Restocking"],
						desc = L["Pop-up a confirmation box before restocking reagents."],
						get = function(info) return Cryolysis2.db.profile.RestockConfirm end,
						set = function(info, v) Cryolysis2.db.profile.RestockConfirm = v end,
						order = 2
					},
					apamount = {
						type = "range",
						name = self:GetLocalizedItemName("Arcane Powder"),
						desc = L["Adjust the amount of Arcane Powder to restock to."],
						width = "full",
						get = function(info) return Cryolysis2.db.profile.RestockPowder end,
						set = function(info, v) Cryolysis2.db.profile.RestockPowder = v end,
						min = 0,
						max = 100,
						step = 1,
						order = 3
					},
					teleamount = {
						type = "range",
						name = self:GetLocalizedItemName("Rune of Teleportation"),
						desc = L["Adjust the amount of Runes of Teleportation to restock to."],
						width = "full",
						get = function(info) return Cryolysis2.db.profile.RestockTeleport end,
						set = function(info, v) Cryolysis2.db.profile.RestockTeleport = v end,
						min = 0,
						max = 100,
						step = 1,
						order = 4
					},
					portamount = {
						type = "range",
						name = self:GetLocalizedItemName("Rune of Portals"),
						desc = L["Adjust the amount of Runes of Portals to restock to."],
						width = "full",
						get = function(info) return Cryolysis2.db.profile.RestockPortals end,
						set = function(info, v) Cryolysis2.db.profile.RestockPortals = v end,
						min = 0,
						max = 100,
						step = 1,
						order = 5
					}
				}
			},
			timersettings = {
				type = "group",
				name = L["Timer Settings"],
				desc = L["Adjust various settings for the spell timers."],
				order = 15,
				args = {
					timertoggle = {
						type = "toggle",
						name = L["Timers On/Off"],
						desc = L["Turn timers on or off."],
						get = function(info) return Cryolysis2.db.profile.ShowSpellTimers end,
						set = function(info, v) 
						Cryolysis2.db.profile.ShowSpellTimers = v 
						Cryolysis2:UpdateHideShowSpellTimers()
						end,
						order = 16
					},
					timerlock = {
						type = "toggle",
						name = L["Lock Timer Frame"],
						desc = L["Lock the timer frame in place so it can't move."],
						get = function(info) return Cryolysis2.db.profile.LockTimers end,
						set = function(info, v) 
						Cryolysis2.db.profile.LockTimers = v end,
						order = 16.5
					},
					cooldown = {
						type = "group",
						name = L["Cooldown Timers"],
						desc = L["Select which spells have their cooldowns shown in the timer window."],
						order = 17,
						args = {
							cooldowntoggle = {
								type = "toggle",
								name = L["Cooldown Timers On/Off"],
								desc = L["Turn timers on or off."],
								width = "full",
								get = function(info) return Cryolysis2.db.profile.ShowCooldownTimers end,
								set = function(info, v) 
									Cryolysis2.db.profile.ShowCooldownTimers = v 
									Cryolysis2:UpdateHideShowSpellTimers()
								end,
								order = 16
							}
						}
					},
					debuff = {
						type = "group",
						name = L["Debuff Timers"],
						desc = L["Select which spells have their debuffs tracked in the timer window."],
						order = 18,
						args = {
							debufftoggle = {
								type = "toggle",
								name = L["Debuff Timers On/Off"],
								desc = L["Turn timers on or off."],
								get = function(info) return Cryolysis2.db.profile.ShowDebuffTimers end,
								set = function(info, v) 
									Cryolysis2.db.profile.ShowDebuffTimers = v 
									Cryolysis2:UpdateHideShowSpellTimers()
									end,
								order = 16
							}
						}
					}
				}
			},
			messagesettings = {
				type = "group",
				name = L["Message Settings"],
				desc = L["Adjust various settings for teleport, portal, and polymorph messages."],
				order = 17,
				args = {
					chattype = {
						type = "select",
						name = L["Chat Channel"],
						desc = L["Choose which chat channel messages are displayed in."],
						width = "full",
						get = function(info) return Cryolysis2.db.profile.ChatChannel end,
						set = function(info, v) Cryolysis2.db.profile.ChatChannel = v end,
						order = 2,
						values = {
							["USER"]	= L["User"],
							["SAY"]		= L["Say"],
							["PARTY"]	= L["Party"],
							["RAID"]	= L["Raid"],
							["GROUP"]	= L["Group"],
							["WORLD"]	= L["World"]
						}
					},
					sm = {
						type = "toggle",
						name = L["Short Messages"],
						desc = L["Display shortened versions of polymorph, teleport, portal, and mount messages."],
						get = function(info) return Cryolysis2.db.profile.SM end,
						set = function(info, v) Cryolysis2.db.profile.SM = v end,
						order = 5
					},
					poly = {
						type = "toggle",
						name = L["Polymorph Messages"],
						desc = L["Display a message in chat when casting polymorph."],
						get = function(info) return Cryolysis2.db.profile.PolyMessage end,
						set = function(info, v) Cryolysis2.db.profile.PolyMessage = v end,
						order = 10
					},
					polywarn = {
						type = "toggle",
						name = L["Polymorph Warning"],
						desc = L["Play a sound when polymorph is about to break."],
						get = function(info) return Cryolysis2.db.profile.PolyWarn end,
						set = function(info, v) Cryolysis2.db.profile.PolyWarn = v end,
						order = 11
					},
					polybreak = {
						type = "toggle",
						name = L["Polymorph Break"],
						desc = L["Play a sound when polymorph breaks."],
						get = function(info) return Cryolysis2.db.profile.PolyBreak end,
						set = function(info, v) Cryolysis2.db.profile.PolyBreak = v end,
						order = 13
					},
					ritual = {
						type = "toggle",
						name = L["Ritual Message"],
						desc = L["Display a message in chat when casting Ritual of Refreshment."],
						get = function(info) return Cryolysis2.db.profile.RitualMessage end,
						set = function(info, v) Cryolysis2.db.profile.RitualMessage = v end,
						order = 14
					},
					mount = {
						type = "toggle",
						name = L["Mount Messages"],
						desc = L["Display a message in chat when mounting."],
						get = function(info) return Cryolysis2.db.profile.MountMessage end,
						set = function(info, v) Cryolysis2.db.profile.MountMessage = v end,
						order = 15
					},
					tele = {
						type = "toggle",
						name = L["Teleport Messages"],
						desc = L["Display a message in chat when teleporting."],
						get = function(info) return Cryolysis2.db.profile.TeleMessage end,
						set = function(info, v) Cryolysis2.db.profile.TeleMessage = v end,
						order = 20
					},
					port = {
						type = "toggle",
						name = L["Portal Messages"],
						desc = L["Display a message in chat when opening a portal."],
						get = function(info) return Cryolysis2.db.profile.PortalMessage end,
						set = function(info, v) Cryolysis2.db.profile.PortalMessage = v end,
						order = 25
					},
					polywarntime = {
						type = "range",
						name = L["Polymorph Warning Time"],
						width = "full",
						desc = L["Set how long before polymorph breaks to play the sound."],
						get = function(info) return Cryolysis2.db.profile.PolyWarnTime end,
						set = function(info, v) Cryolysis2.db.profile.PolyWarnTime = v end,
						min = 1,
						max = 10,
						step = 1,
						order = 30
					},
                    polyblame = {
                        type = "toggle",
                        name = L["Polymorph Blaming"],
                        desc = L["Show messages blaming people for breaking your polymorph."],
                        get = function(info) return Cryolysis2.db.profile.PolyBlame end,
                        set = function(info, v) Cryolysis2.db.profile.PolyBlame = v end,
                        order = 35
                    },
                    polyblamechat = {
						type = "select",
						name = L["Polymorph Blame Chat Channel"],
						desc = L["Choose which chat channel polymorph break blame messages are displayed in."],
						width = "full",
						get = function(info) return Cryolysis2.db.profile.BlameChannel end,
						set = function(info, v) Cryolysis2.db.profile.BlameChannel = v end,
						order = 40,
						values = {
							["USER"]	= L["User"],
							["SAY"]		= L["Say"],
							["PARTY"]	= L["Party"],
							["RAID"]	= L["Raid"],
							["GROUP"]	= L["Group"],
							["WORLD"]	= L["World"]
						}
					},
				}
			},
			graphicalsettings = {
				type = "group",
				name = L["Button Settings"],
				desc = L["Adjust various settings for each button."],
				order = 20,
				args = {
					middlekey = {
						type = "select",
						name = L["Middle-Click Key"],
						desc = L["Adjusts the key used as an alternative to a middle click."],
						get = function(info) return Cryolysis2.db.profile.MiddleKey end,
						set = function(info, v)
							Cryolysis2.db.profile.MiddleKey = v 
							Cryolysis2:UpdateLeftButton(3)
							Cryolysis2:UpdateRightButton(3)
							Cryolysis2:UpdateBottomButton(3)
							Cryolysis2:UpdateBuffMenuAttributes()
							Cryolysis2:UpdateFoodButton()
							Cryolysis2:UpdateWaterButton()
							Cryolysis2:UpdateManaGemButton()
							Cryolysis2:UpdateMountButton()
						end,
						order = 1,
						values = {
							["alt"]		= L["Alt"],
							["shift"]	= L["Shift"],
							["ctrl"]	= L["Ctrl"]
						}
					},
					msbutton = {
						type = "group",
						name = L["Main Sphere"],
						desc = L["Adjust various settings for the main sphere."],
						order = 1,
						args = {
							mshide = {
								type = "toggle",
								name = L["Hide"],
								desc = L["Show or hide the main sphere."],
								width = "full",
								get = function(info) return Cryolysis2.db.profile.MSHide end,
								set = function(info, v)
								Cryolysis2.db.profile.MSHide = v
								Cryolysis2:UpdateHideShow()
								end,
								order = 1
							},
							insphere = {
								type = "select",
								name = L["Text"],
								desc = L["Adjust what information is displayed on the sphere."],
								width = "full",
								get = function(info) return Cryolysis2.db.profile.InnerSphere end,
								set = function(info, v)
									Cryolysis2.db.profile.InnerSphere = v 
									Cryolysis2:UpdateInnerSphere() 
								end,
								order = 2,
								values = {
									L["Nothing"],
									L["Food/Drink"],
									L["Drink/Food"],
									L["Current Health"],
									L["Health %"],
									L["Current Mana"],
									L["Mana %"],
									L["Mana Gem Cooldown"],
									L["Evocation Cooldown"]
								}
							},
							spheremb = {
								type = "select",
								name = L["Inner Sphere"],
								desc = L["Adjust what clicking the inner sphere does."],
								width = "full",
								get = function(info) return Cryolysis2.db.profile.MainButton end,
								set = function(info, v) 
									Cryolysis2.db.profile.MainButton = v
									Cryolysis2:UpdateSphereAttributes()
								end,
								order = 3,
								values = {
									L["Nothing"],
									L["Eat and drink"],
									GetSpellInfo(Cryolysis2.Private.SpellId["Evocation"]),
									GetSpellInfo(Cryolysis2.Private.SpellId["Polymorph"]),
									L["Use Mana Gem"],
									GetSpellInfo(Cryolysis2.Private.SpellId["Blink"])
								}
							},
							outsphere = {
								type = "select",
								name = L["Outer Sphere"],
								desc = L["Adjust what information is displayed using the outer sphere."],
								width = "full",
								get = function(info) return Cryolysis2.db.profile.OuterSphere end,
								set = function(info, v) 
									Cryolysis2.db.profile.OuterSphere = v 
									Cryolysis2:UpdateOuterSphere()
								end,
								order = 4,
								values = {
									L["Nothing"],
									L["Health"],
									L["Mana"],
									L["Mana Gem Cooldown"],
									L["Evocation Cooldown"]
								}
							},
							angleadj = {
								type = "range",
								name = L["Angle"],
								desc = L["Adjust the position of the buttons around the sphere."],
								width = "full",
								get = function(info) return Cryolysis2.db.profile.Angle end,
								set = function(info, v) 
									Cryolysis2.db.profile.Angle = v
									Cryolysis2:UpdateAllButtonPositions()
								end,
								min = 0,
								max = 360,
								step = 18,
								order = 5
							},
							scalems = {
								type = "range",
								name = L["Scale"],
								desc = L["Scale the size of the main sphere."],
								width = "full",
								get = function(info) return Cryolysis2.db.profile.MainSphereScale end,
								set = function(info, v) 
									Cryolysis2.db.profile.MainSphereScale = v 
									Cryolysis2:UpdateAllButtonPositions()
									Cryolysis2:UpdateAllButtonSizes()
								end,
								min = .5,
								max = 2,
								step = .1,
								isPercent = true,
								order = 6
							},
							scalebuttons = {
								type = "range",
								name = L["Scale All Buttons"],
								desc = L["Scale the size of all of the buttons at once."],
								width = "full",
								get = function(info) return Cryolysis2.db.profile.ButtonScale end,
								set = function(info, v) 
									Cryolysis2.db.profile.ButtonScale = v 
									Cryolysis2:UpdateAllButtonPositions()
									Cryolysis2:UpdateAllButtonSizes()
								end,
								min = .5,
								max = 2,
								step = .1,
								isPercent = true,
								order = 7
							}
						}
					},
					foodbutton = {
						type = "group",
						name = L["Food Button"],
						desc = L["Adjust various settings for the food button."],
						order = 2,
						args = {
							foodhide = {
								type = "toggle",
								name = L["Hide"],
								desc = L["Show or hide the button."],
								width = "full",
								get = function(info) return Cryolysis2.db.profile.FoodHide end,
								set = function(info, v)
								Cryolysis2.db.profile.FoodHide = v
								Cryolysis2:UpdateHideShow()
								end,
								order = 1
							},
							foodcount = {
								type = "toggle",
								name = L["Show Food Count"],
								desc = L["Show how much conjured food you have on the food button."],
								get = function(info) return Cryolysis2.db.profile.ShowFoodCountText end,
								set = function(info, v) Cryolysis2.db.profile.ShowFoodCountText = v end
							},
							scalefood = {
								type = "range",
								name = L["Scale"],
								desc = L["Scale the size of the food button."],
								width = "full",
								get = function(info) return Cryolysis2.db.profile.FoodButtonScale end,
								set = function(info, v) 
									Cryolysis2.db.profile.FoodButtonScale = v
									Cryolysis2:UpdateAllButtonPositions()
									Cryolysis2:UpdateAllButtonSizes()
								end,
								min = .5,
								max = 2,
								step = .1,
								isPercent = true
							},
							movefood = {
								type = "execute",
								name = L["Move Clockwise"],
								desc = L["Move this button one position clockwise."],
								func = function() Cryolysis2:IncrementButton("Cryo2FoodButton") end,
							}
						}
					},
					waterbutton = {
						type = "group",
						name = L["Water Button"],
						desc = L["Adjust various settings for the water button."],
						order = 3,
						args = {
							waterhide = {
								type = "toggle",
								name = L["Hide"],
								desc = L["Show or hide the button."],
								width = "full",
								get = function(info) return Cryolysis2.db.profile.WaterHide end,
								set = function(info, v)
									Cryolysis2.db.profile.WaterHide = v
									Cryolysis2:UpdateHideShow()
								end,
								order = 1
							},
							watercount = {
								type = "toggle",
								name = L["Show Water Count"],
								desc = L["Show how much conjured water you have on the water button."],
								get = function(info) return Cryolysis2.db.profile.ShowWaterCountText end,
								set = function(info, v) Cryolysis2.db.profile.ShowWaterCountText = v end
							},
							scalewater = {
								type = "range",
								name = L["Scale"],
								desc = L["Scale the size of the water button."],
								width = "full",
								get = function(info) return Cryolysis2.db.profile.WaterButtonScale end,
								set = function(info, v) 
									Cryolysis2.db.profile.WaterButtonScale = v 
									Cryolysis2:UpdateAllButtonPositions()
									Cryolysis2:UpdateAllButtonSizes()
								end,
								min = .5,
								max = 2,
								step = .1,
								isPercent = true
							},
							movewater = {
								type = "execute",
								name = L["Move Clockwise"],
								desc = L["Move this button one position clockwise."],
								func = function() Cryolysis2:IncrementButton("Cryo2WaterButton") end,
							}
						}
					},
					gembutton = {
						type = "group",
						name = L["Mana Gem Button"],
						desc = L["Adjust various settings for the mana gem button."],
						order = 4,
						args = {
							gemhide = {
								type = "toggle",
								name = L["Hide"],
								desc = L["Show or hide the button."],
								get = function(info) return Cryolysis2.db.profile.GemHide end,
								set = function(info, v)
									Cryolysis2.db.profile.GemHide = v
									Cryolysis2:UpdateHideShow()
								end,
								order = 1
							},
							portgrowleft = {
								type = "toggle",
								name = L["Grow Left"],
								desc = L["Make the menu grow left instead right."],
								get = function(info) return Cryolysis2.db.profile.GemMenuGrowLeft end,
								set = function(info, v) 
									Cryolysis2.db.profile.GemMenuGrowLeft = v
									Cryolysis2:UpdateManaGemButton()
								end,
								order = 2
							},
							gem = {
								type = "toggle",
								name = L["Show Cooldown"],
								desc = L["Show the mana gem cooldown on the mana gem button."],
								width = "full",
								get = function(info) return Cryolysis2.db.profile.ShowManaGemCooldownText end,
								set = function(info, v) 
									Cryolysis2.db.profile.ShowManaGemCooldownText = v
									Cryolysis2:Cryo2_UpdateManaGemCooldown() 
								end,
								order = 3
							},
							movegem = {
								type = "execute",
								name = L["Move Clockwise"],
								desc = L["Move this button one position clockwise."],
								func = function() Cryolysis2:IncrementButton("Cryo2ManaGemButton") end,
								order = 4
							},
							scalegem = {
								type = "range",
								name = L["Scale"],
								desc = L["Scale the size of the mana gem button."],
								width = "full",
								get = function(info) return Cryolysis2.db.profile.ManaGemButtonScale end,
								set = function(info, v)
									Cryolysis2.db.profile.ManaGemButtonScale = v
									Cryolysis2:UpdateAllButtonPositions()
									Cryolysis2:UpdateAllButtonSizes()
								end,
								min = .5,
								max = 2,
								step = .1,
								isPercent = true,
								order = 5
							},
							menuofsx = {
								type = "range",
								name = L["Menu X Offset"],
								desc = L["Adjust the left-to-right position of the menu."],
								width = "full",
								get = function(info) return Cryolysis2.db.profile.GemMenuOfsX end,
								set = function(info, v) 
									Cryolysis2.db.profile.GemMenuOfsX = v
									Cryolysis2:UpdateManaGemButton()
								end,
								min = -100,
								max = 100,
								step = 1,
								order = 6
							},
							menuofsy = {
								type = "range",
								name = L["Menu Y Offset"],
								desc = L["Adjust the left-to-right position of the menu."],
								width = "full",
								get = function(info) return Cryolysis2.db.profile.GemMenuOfsY end,
								set = function(info, v) 
									Cryolysis2.db.profile.GemMenuOfsY = v 
									Cryolysis2:UpdateManaGemButton()
								end,
								min = -100,
								max = 100,
								step = 1,
								order = 7
							}
						}
					},
					evocationbutton = {
						type = "group",
						name = L["Evocation Button"],
						desc = L["Adjust various settings for the evocation button."],
						order = 5,
						args = {
							evochide = {
								type = "toggle",
								name = L["Hide"],
								desc = L["Show or hide the button."],
								get = function(info) return Cryolysis2.db.profile.EvocHide end,
								set = function(info, v)
									Cryolysis2.db.profile.EvocHide = v
									Cryolysis2:UpdateHideShow()
								end,
								order = 1
							},
							evoc = {
								type = "toggle",
								name = L["Show Cooldown"],
								desc = L["Show evocation's cooldown on the evocation button."],
								get = function(info) return Cryolysis2.db.profile.ShowEvocationCooldownText end,
								set = function(info, v) 
									Cryolysis2.db.profile.ShowEvocationCooldownText = v
									Cryolysis2:Cryo2_UpdateEvocationCooldown()
								end,
								order = 2
							},
							moveevoc = {
								type = "execute",
								name = L["Move Clockwise"],
								desc = L["Move this button one position clockwise."],
								func = function() Cryolysis2:IncrementButton("Cryo2EvocButton") end,
								order = 3
							},
							scaleevoc = {
								type = "range",
								name = L["Scale"],
								desc = L["Scale the size of the evocation button."],
								width = "full",
								get = function(info) return Cryolysis2.db.profile.EvocationButtonScale end,
								set = function(info, v) 
									Cryolysis2.db.profile.EvocationButtonScale = v 
									Cryolysis2:UpdateAllButtonPositions()
									Cryolysis2:UpdateAllButtonSizes()
								end,
								min = .5,
								max = 2,
								step = .1,
								isPercent = true,
								order = 4

							}
						}
					},
					leftcustom = {
						type = "group",
						name = L["Left Custom Button"],
						desc = L["Adjust various settings for the left custom button."],
						order = 6,
						args = {
							lefthide = {
								type = "toggle",
								name = L["Hide"],
								desc = L["Show or hide the button."],
								width = "full",
								get = function(info) return Cryolysis2.db.profile.LeftHide end,
								set = function(info, v)
									Cryolysis2.db.profile.LeftHide = v
									Cryolysis2:UpdateHideShow()
								end,
								order = 1
							},
							moveleft = {
								type = "execute",
								name = L["Move Clockwise"],
								desc = L["Move this button one position clockwise."],
								func = function() Cryolysis2:IncrementButton("Cryo2LeftCustomButton") end,
								order = 2
							},
							buttontype = {
								type = "select",
								name = L["Button Type"],
								desc = L["Choose whether this button casts a spell, uses a macro, or uses an item."],
								width = "full",
								get = function(info) return Cryolysis2.db.profile.LeftCustomButtonType end,
								set = function(info, v) 
									Cryolysis2.db.profile.LeftCustomButtonType = v
									Cryolysis2:UpdateCustomButtonAttributes("left")
								end,
								order = 3,
								values = {["spell"] = L["Spell"], ["macro"] = L["Macro"], ["item"] = L["Item"]}
							},

							leftleftclick = {
								type = "input",
								name = L["Left Click Spell"],
								desc = L["Type in the name of the spell that will be cast when left clicking this button."],
								usage = L["Enter a spell, macro, or item name and PRESS ENTER.  Capitalization matters."],
								get = function(info) return Cryolysis2.db.profile.LeftSpellLeft end,
								set = function(info, v) 
									Cryolysis2.db.profile.LeftSpellLeft = v
									Cryolysis2:UpdateLeftButton(1) 
								end,
								order = 4
							},
							leftrightclick = {
								type = "input",
								name = L["Right Click Spell"],
								desc = L["Type in the name of the spell that will be cast when left clicking this button."],
								usage = L["Enter a spell, macro, or item name and PRESS ENTER.  Capitalization matters."],
								get = function(info) return Cryolysis2.db.profile.LeftSpellRight end,
								set = function(info, v) 
									Cryolysis2.db.profile.LeftSpellRight = v
									Cryolysis2:UpdateLeftButton(2) 
								end,
								order = 5
							},
							leftmidclick = {
								type = "input",
								name = L["Middle Click Spell"],
								desc = L["Type in the name of the spell that will be cast when left clicking this button."],
								usage = L["Enter a spell, macro, or item name and PRESS ENTER.  Capitalization matters."],
								get = function(info) return Cryolysis2.db.profile.LeftSpellMid end,
								set = function(info, v) 
									Cryolysis2.db.profile.LeftSpellMid = v 
									Cryolysis2:UpdateLeftButton(3) 
								end,
								order = 6
							},
							scaleleft = {
								type = "range",
								name = L["Scale"],
								desc = L["Scale the size of the left custom button."],
								width = "full",
								get = function(info) return Cryolysis2.db.profile.LeftCustomButtonScale end,
								set = function(info, v) 
									Cryolysis2.db.profile.LeftCustomButtonScale = v 
									Cryolysis2:UpdateAllButtonPositions()
									Cryolysis2:UpdateAllButtonSizes()
								end,
								min = .5,
								max = 2,
								order = 7,
								step = .1,
								isPercent = true
							}
						}
					},
					rightcustom = {
						type = "group",
						name = L["Right Custom Button"],
						desc = L["Adjust various settings for the right custom button."],
						order = 7,
						args = {
							righthide = {
								type = "toggle",
								name = L["Hide"],
								desc = L["Show or hide the button."],
								width = "full",
								get = function(info) return Cryolysis2.db.profile.RightHide end,
								set = function(info, v)
									Cryolysis2.db.profile.RightHide = v
									Cryolysis2:UpdateHideShow()
								end,
								order = 1
							},
							moveright = {
								type = "execute",
								name = L["Move Clockwise"],
								desc = L["Move this button one position clockwise."],
								func = function() Cryolysis2:IncrementButton("Cryo2RightCustomButton") end,
								order = 2
							},
							buttontype = {
								type = "select",
								name = L["Button Type"],
								desc = L["Choose whether this button casts a spell, uses a macro, or uses an item."],
								width = "full",
								get = function(info) return Cryolysis2.db.profile.RightCustomButtonType end,
								set = function(info, v) 
									Cryolysis2.db.profile.RightCustomButtonType = v
									Cryolysis2:UpdateCustomButtonAttributes("right")
								end,
								values = {
									["spell"] = L["Spell"],
									["macro"] = L["Macro"],
									["item"] = L["Item"]
								},
								order = 3
							},
							rightleftclick = {
								type = "input",
								name = L["Left Click Spell"],
								desc = L["Type in the name of the spell that will be cast when left clicking this button."],
								usage = L["Enter a spell, macro, or item name and PRESS ENTER.  Capitalization matters."],
								get = function(info) return Cryolysis2.db.profile.RightSpellLeft end,
								set = function(info, v) 
									Cryolysis2.db.profile.RightSpellLeft = v
									Cryolysis2:UpdateRightButton(1) 
								end,
								order = 4
							},
							rightrightclick = {
								type = "input",
								name = L["Right Click Spell"],
								desc = L["Type in the name of the spell that will be cast when left clicking this button."],
								usage = L["Enter a spell, macro, or item name and PRESS ENTER.  Capitalization matters."],
								get = function(info) return Cryolysis2.db.profile.RightSpellRight end,
								set = function(info, v) 
									Cryolysis2.db.profile.RightSpellRight = v
									Cryolysis2:UpdateRightButton(2) 
								end,
								order = 5
							},
							rightmidclick = {
								type = "input",
								name = L["Middle Click Spell"],
								desc = L["Type in the name of the spell that will be cast when left clicking this button."],
								usage = L["Enter a spell, macro, or item name and PRESS ENTER.  Capitalization matters."],
								get = function(info) return Cryolysis2.db.profile.RightSpellMid end,
								set = function(info, v) 
									Cryolysis2.db.profile.RightSpellMid = v 
									Cryolysis2:UpdateRightButton(3) 
								end,
								order = 6
							},
							scalerightcustom = {
								type = "range",
								name = L["Scale"],
								desc = L["Scale the size of the right custom button."],
								width = "full",
								get = function(info) return Cryolysis2.db.profile.RightCustomButtonScale end,
								set = function(info, v) 
									Cryolysis2.db.profile.RightCustomButtonScale = v 
									Cryolysis2:UpdateAllButtonPositions()
									Cryolysis2:UpdateAllButtonSizes()
								end,
								min = .5,
								max = 2,
								step = .1,
								isPercent = true,
								order = 7
							}
						}
					},
					bottomcustom = {
						type = "group",
						name = L["Bottom Custom Button"],
						desc = L["Adjust various settings for the bottom custom button."],
						order = 8,
						args = {
							bottomhide = {
								type = "toggle",
								name = L["Hide"],
								desc = L["Show or hide the button."],
								width = "full",
								get = function(info) return Cryolysis2.db.profile.BottomHide end,
								set = function(info, v)
									Cryolysis2.db.profile.BottomHide = v
									Cryolysis2:UpdateHideShow()
								end,
								order = 1
							},
							movebottom = {
								type = "execute",
								name = L["Move Clockwise"],
								desc = L["Move this button one position clockwise."],
								func = function()
									Cryolysis2:IncrementButton("Cryo2BottomCustomButton")
								end,
								order = 2
							},
							buttontype = {
								type = "select",
								name = L["Button Type"],
								desc = L["Choose whether this button casts a spell, uses a macro, or uses an item."],
								width = "full",
								get = function(info) return Cryolysis2.db.profile.BottomCustomButtonType end,
								set = function(info, v) 
									Cryolysis2.db.profile.BottomCustomButtonType = v
									Cryolysis2:UpdateCustomButtonAttributes("bottom")
								end,
								values = {
									["spell"] = L["Spell"],
									["macro"] = L["Macro"],
									["item"] = L["Item"]
								},
								order = 3
							},
							bottomleftclick = {
								type = "input",
								name = L["Left Click Spell"],
								desc = L["Type in the name of the spell that will be cast when left clicking this button."],
								usage = L["Enter a spell, macro, or item name and PRESS ENTER.  Capitalization matters."],
								get = function(info) return Cryolysis2.db.profile.BottomSpellLeft end,
								set = function(info, v) 
									Cryolysis2.db.profile.BottomSpellLeft = v
									Cryolysis2:UpdateBottomButton(1) 
								end,
								order = 4
							},
							bottomrightclick = {
								type = "input",
								name = L["Right Click Spell"],
								desc = L["Type in the name of the spell that will be cast when left clicking this button."],
								usage = L["Enter a spell, macro, or item name and PRESS ENTER.  Capitalization matters."],
								get = function(info) return Cryolysis2.db.profile.BottomSpellRight end,
								set = function(info, v) 
									Cryolysis2.db.profile.BottomSpellRight = v
									Cryolysis2:UpdateBottomButton(2) 
								end,
								order = 5
							},
							bottommidclick = {
								type = "input",
								name = L["Middle Click Spell"],
								desc = L["Type in the name of the spell that will be cast when left clicking this button."],
								usage = L["Enter a spell, macro, or item name and PRESS ENTER.  Capitalization matters."],
								get = function(info) return Cryolysis2.db.profile.BottomSpellMid end,
								set = function(info, v) 
									Cryolysis2.db.profile.BottomSpellMid = v 
									Cryolysis2:UpdateBottomButton(3) 
								end,
								order = 6
							},
							scalebottomcustom = {
								type = "range",
								name = L["Scale"],
								desc = L["Scale the size of the bottom custom button."],
								width = "full",
								get = function(info) return Cryolysis2.db.profile.RightCustomButtonScale end,
								set = function(info, v) 
									Cryolysis2.db.profile.BottomCustomButtonScale = v 
									Cryolysis2:UpdateAllButtonPositions()
									Cryolysis2:UpdateAllButtonSizes()
								end,
								min = .5,
								max = 2,
								step = .1,
								isPercent = true,
								order = 7
							}
						}
					},
					spellbutton = {
						type = "group",
						name = L["Buff Menu Button"],
						desc = L["Adjust various settings for the buff menu button."],
						order = 9,
						args = {
							buffhide = {
								type = "toggle",
								name = L["Hide"],
								desc = L["Show or hide the button."],
								get = function(info) return Cryolysis2.db.profile.BuffHide end,
								set = function(info, v)
									Cryolysis2.db.profile.BuffHide = v
									Cryolysis2:UpdateHideShow()
								end,
								order = 1
							},
							buffgrowleft = {
								type = "toggle",
								name = L["Grow Left"],
								desc = L["Make the menu grow left instead right."],
								get = function(info) return Cryolysis2.db.profile.BuffMenuGrowLeft end,
								set = function(info, v) 
									Cryolysis2.db.profile.BuffMenuGrowLeft = v
									Cryolysis2:UpdateSpellMenu()
								end,
								order = 2
							},
							feathers = {
								type = "toggle",
								name = L["Light Feather Count"],
								desc = L["Show how many light feathers you have on the slow fall button."],
								get = function(info) return Cryolysis2.db.profile.ShowFeatherCountText end,
								set = function(info, v) 
									Cryolysis2.db.profile.ShowFeatherCountText = v 
									Cryolysis2:ShowHideFeatherCount()
								end,
								order = 3
							},
							powder = {
								type = "toggle",
								name = L["Arcane Powder Count"],
								desc = L["Show how much arcane powder you have on the arcane intellect button."],
								get = function(info) return Cryolysis2.db.profile.ShowPowderCountText end,
								set = function(info, v)
									Cryolysis2.db.profile.ShowPowderCountText = v
									Cryolysis2:ShowHideArcanePowderCount()
								end,
								order = 4
							},
							movebuff = {
								type = "execute",
								name = L["Move Clockwise"],
								desc = L["Move this button one position clockwise."],
								func = function() Cryolysis2:IncrementButton("Cryo2BuffMenuButton") end,
								order = 5
							},
							scalespell = {
								type = "range",
								name = L["Scale"],
								desc = L["Scale the size of the spell menu button."],
								width = "full",
								get = function(info) return Cryolysis2.db.profile.SpellButtonScale end,
								set = function(info, v) 
									Cryolysis2.db.profile.SpellButtonScale = v 
									Cryolysis2:UpdateAllButtonPositions()
									Cryolysis2:UpdateAllButtonSizes()
								end,
								min = .5,
								max = 2,
								step = .1,
								isPercent = true,
								order = 6
							},
							menuofsx = {
								type = "range",
								name = L["Menu X Offset"],
								desc = L["Adjust the left-to-right position of the menu."],
								width = "full",
								get = function(info) return Cryolysis2.db.profile.BuffMenuOfsX end,
								set = function(info, v) 
									Cryolysis2.db.profile.BuffMenuOfsX = v 
									Cryolysis2:UpdateSpellMenu()
								end,
								min = -100,
								max = 100,
								step = 1,
								order = 7
							},
							menuofsy = {
								type = "range",
								name = L["Menu Y Offset"],
								desc = L["Adjust the left-to-right position of the menu."],
								width = "full",
								get = function(info) return Cryolysis2.db.profile.BuffMenuOfsY end,
								set = function(info, v) 
									Cryolysis2.db.profile.BuffMenuOfsY = v 
									Cryolysis2:UpdateSpellMenu()
								end,
								min = -100,
								max = 100,
								step = 1,
								order = 8
							}
						}
					},
					mountbutton = {
						type = "group",
						name = L["Mount Button"],
						desc = L["Adjust various settings for the mount button."],
						order = 10,
						args = {
							mounthide = {
								type = "toggle",
								name = L["Hide"],
								desc = L["Show or hide the button."],
								width = "full",
								get = function(info) return Cryolysis2.db.profile.MountHide end,
								set = function(info, v)
									Cryolysis2.db.profile.MountHide = v
									Cryolysis2:UpdateHideShow()
								end,
								order = 1
							},
							movemount = {
								type = "execute",
								name = L["Move Clockwise"],
								desc = L["Move this button one position clockwise."],
								func = function() Cryolysis2:IncrementButton("Cryo2MountButton") end,
								order = 2
							},
							leftmount = {
								type = "select",
								name = L["Left-Click Mount"],
								desc = L["Set which mount is used when left-clicking the mount button."],
								width = "full",
								get = function(info) return Cryolysis2.db.profile.LeftMount end,
								set = function(info, v) 
									Cryolysis2.db.profile.LeftMount = v
									Cryolysis2:UpdateMountButton()
								end,
								values = function() return Cryolysis2.Private.Mounts end,
								order = 3
							},
							rightmount = {
								type = "select",
								name = L["Right-Click Mount"],
								desc = L["Set which mount is used when right-clicking the mount button."],
								width = "full",
								get = function(info) return Cryolysis2.db.profile.RightMount end,
								set = function(info, v) 
									Cryolysis2.db.profile.RightMount = v
									Cryolysis2:UpdateMountButton()
								end,
								values = function() return Cryolysis2.Private.Mounts end,
								order = 4
							},
							scalemount = {
								type = "range",
								name = L["Scale"],
								desc = L["Scale the size of the mount button."],
								width = "full",
								get = function(info) return Cryolysis2.db.profile.MountButtonScale end,
								set = function(info, v) 
									Cryolysis2.db.profile.MountButtonScale = v 
									Cryolysis2:UpdateAllButtonPositions()
									Cryolysis2:UpdateAllButtonSizes()
								end,
								min = .5,
								max = 2,
								step = .1,
								isPercent = true,
								order = 5
							}
						}
					},
					teleandportbutton = {
						type = "group",
						name = L["Teleport/Portal Menu Button"],
						desc = L["Adjust various settings for the teleport/portal menu button."],
						order = 11,
						args = {
							porthide = {
								type = "toggle",
								name = L["Hide"],
								desc = L["Show or hide the button."],
								get = function(info) return Cryolysis2.db.profile.PortHide end,
								set = function(info, v)
									Cryolysis2.db.profile.PortHide = v
									Cryolysis2:UpdateHideShow()
								end,
								order = 1
							},
							portgrowleft = {
								type = "toggle",
								name = L["Grow Left"],
								desc = L["Make the menu grow left instead right."],
								get = function(info) return Cryolysis2.db.profile.PortMenuGrowLeft end,
								set = function(info, v) 
									Cryolysis2.db.profile.PortMenuGrowLeft = v
									Cryolysis2:UpdateTeleAndPortButton()
								end,
								order = 2
							},
							moveteleandport = {
								type = "execute",
								name = L["Move Clockwise"],
								desc = L["Move this button one position clockwise."],
								func = function() Cryolysis2:IncrementButton("Cryo2TeleAndPortMenuButton") end,
								order = 3
							},
							scaleteleandport = {
								type = "range",
								name = L["Scale"],
								desc = L["Scale the size of the teleport/portal button."],
								width = "full",
								get = function(info) return Cryolysis2.db.profile.TeleAndPortButtonScale end,
								set = function(info, v) 
									Cryolysis2.db.profile.TeleAndPortButtonScale = v 
									Cryolysis2:UpdateAllButtonPositions()
									Cryolysis2:UpdateAllButtonSizes()
								end,
								min = .5,
								max = 2,
								step = .1,
								isPercent = true,
								order = 4
							},
							menuofsx = {
								type = "range",
								name = L["Menu X Offset"],
								desc = L["Adjust the left-to-right position of the menu."],
								width = "full",
								get = function(info) return Cryolysis2.db.profile.PortMenuOfsX end,
								set = function(info, v) 
									Cryolysis2.db.profile.PortMenuOfsX = v 
									Cryolysis2:UpdateTeleAndPortButton()
								end,
								min = -100,
								max = 100,
								step = 1,
								order = 5
							},
							menuofsy = {
								type = "range",
								name = L["Menu Y Offset"],
								desc = L["Adjust the left-to-right position of the menu."],
								width = "full",
								get = function(info) return Cryolysis2.db.profile.PortMenuOfsY end,
								set = function(info, v) 
									Cryolysis2.db.profile.PortMenuOfsY = v 
									Cryolysis2:UpdateTeleAndPortButton()
								end,
								min = -100,
								max = 100,
								step = 1,
								order = 6
							}
						}
					}
				}
			},
			profile = {
				type = "group",
				order = 25,
				name = L["Profile Options"],
				args = {
					desc = {
						order = 1,
						type = "description",
						name = L["Cryolysis' saved variables are organized so you can have shared options across all your characters, while having different sets of custom buttons for each.  These options sections allow you to change the saved variable configurations so you can set up per-character options, or even share custom button setups between characters"],
					},
					options = LibStub("AceDBOptions-3.0"):GetOptionsTable(Cryolysis2.db)
				}
			}

		}
	}
	
	Cryolysis2.options.args.profile.args.options.name = L["Options profile"]
	Cryolysis2.options.args.profile.args.options.desc = L["Saved profile for Cryolysis options"]
	Cryolysis2.options.args.profile.args.options.order = 2

	-- Setup for the reagent restocking dialog
	StaticPopupDialogs["RESTOCK_REAGENTS"] = {
		text = L["Restock all reagents?"],
		button1 = L["Yes"],
		button2 = L["No"],
		OnAccept = function() Cryolysis2:RestockReagents(); end,
		timeout = 0,
		whileDead = 0,
		hideOnEscape = 1
	}
	
	-- Setup for the class warning dialog
	StaticPopupDialogs["CLASS_WARNING"] = {
		text = L["Cryolysis 2 has detected that you are not playing a mage.  The mod has not fully loaded, but is still taking up memory.  For the best game performance, you should disable Cryolysis 2 for this character on your addon selection screen.  This message will only appear once."],
		button1 = L["Okay"],
		OnAccept = function() Cryolysis2.db.profile.ClassWarn = false; end,
		timeout = 0,
		whileDead = 1,
		hideOnEscape = 1
	}
end