local L = LibStub("AceLocale-3.0"):GetLocale("Cryolysis2")
local Cryolysis2 = LibStub("AceAddon-3.0"):GetAddon("Cryolysis2")
--local candybar = AceLibrary("CandyBar-2.0")

------------------------------------------------------------------------------------------------------
-- Event registration function
------------------------------------------------------------------------------------------------------
function Cryolysis2:RegisterEvents()
	Cryolysis2:RegisterEvent("PLAYER_ENTERING_WORLD")
	Cryolysis2:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
	Cryolysis2:RegisterEvent("BAG_UPDATE")
	Cryolysis2:RegisterEvent("PLAYER_REGEN_DISABLED")
	Cryolysis2:RegisterEvent("PLAYER_REGEN_ENABLED")
	Cryolysis2:RegisterEvent("MERCHANT_SHOW")
	Cryolysis2:RegisterEvent("MERCHANT_CLOSED")
	Cryolysis2:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED")
	Cryolysis2:RegisterEvent("SPELL_UPDATE_COOLDOWN")
	Cryolysis2:RegisterEvent("UNIT_SPELLCAST_SENT")
	Cryolysis2:RegisterEvent("LEARNED_SPELL_IN_TAB")
	Cryolysis2:RegisterEvent("TRADE_SHOW")
	Cryolysis2:RegisterEvent("TRADE_CLOSED")
	Cryolysis2:RegisterEvent("PLAYER_LOGIN")
	Cryolysis2:RegisterEvent("UNIT_MANA")
	Cryolysis2:RegisterEvent("UNIT_HEALTH")
	Cryolysis2:RegisterEvent("CHARACTER_POINTS_CHANGED")
end

function Cryolysis2:CheckPolyWarn()

	 if Cryolysis2.db.profile.PolyWarn then
		 if Cryolysis2.Private.PolyIdUsed == 28272 then  --Polymorph: Pig
			 PlaySoundFile("Interface\\AddOns\\Cryolysis2\\sounds\\Pig01.mp3")
		 else
			 PlaySoundFile("Interface\\AddOns\\Cryolysis2\\sounds\\Sheep01.mp3")
		 end
	 end
end

function Cryolysis2:COMBAT_LOG_EVENT_UNFILTERED(info, timestamp, event, srcGUID, srcName, srcFlags, dstGUID, dstName, dstFlags, spellID, spellName, spellSchool, detail1, detail2, detail3)
    
    if event == "SPELL_CAST_SUCCESS" then
        if spellName == GetSpellInfo(Cryolysis2.Private.SpellId["Polymorph"]) and Cryolysis2.Private.PolyTarget == dstGUID and Cryolysis2.Private.PolySuccess then
            Cryolysis2:CancelTimer(Cryolysis2.Private.SheepTimer, true)
            if Cryolysis2.db.profile.ShowDebuffTimers then
				Cryolysis2.Private.PolyBar = Cryolysis2:CreateDebuffTimer(spellID, spellSchool, dstGUID)
            end
            local waittime = Cryolysis2.Private.DebuffDuration[spellID] - Cryolysis2.db.profile.PolyWarnTime
			Cryolysis2.Private.SheepTimer = Cryolysis2:ScheduleTimer("CheckPolyWarn", tonumber(waittime))
        end
    end
    if event == "SPELL_CAST_START" then
        if spellName == GetSpellInfo(Cryolysis2.Private.SpellId["Polymorph"]) and Cryolysis2.Private.PolyTarget == UnitGUID("target") and Cryolysis2.Private.PolySuccess then
            Cryolysis2.Private.LastTarget = UnitGUID("target")
            Cryolysis2.Private.LastIdUsed = spellID
            Cryolysis2.Private.LastSpellSchool = spellSchool
        end
    end
    if event == "SPELL_CAST_FAILED" then
        Cryolysis2.Private.LastTarget = nil
    end
    
    if event == "SPELL_AURA_APPLIED" then
		if spellName == GetSpellInfo(Cryolysis2.Private.SpellId["Polymorph"]) then
			    if Cryolysis2.Private.PolySuccess then
				Cryolysis2:CancelTimer(Cryolysis2.Private.SheepTimer, true)
			    end
			if Cryolysis2.db.profile.ShowDebuffTimers then
				Cryolysis2.Private.PolyBar = Cryolysis2:CreateDebuffTimer(spellID, spellSchool, dstGUID)
			end
			if Cryolysis2.Private.DebuffDuration[spellID] ~= nil then  
				local waittime = Cryolysis2.Private.DebuffDuration[spellID] - Cryolysis2.db.profile.PolyWarnTime
				Cryolysis2.Private.SheepTimer = Cryolysis2:ScheduleTimer("CheckPolyWarn", tonumber(waittime))
				 Cryolysis2.Private.PolyTarget = dstGUID
				Cryolysis2.Private.PolySuccess = true
				Cryolysis2.Private.PolyIdUsed = spellID
			end
		end
	end
	if event == "SPELL_AURA_DISPELLED" or event == "SPELL_AURA_REMOVED" then
		if dstGUID == Cryolysis2.Private.PolyTarget and spellID == Cryolysis2.Private.PolyIdUsed then
			if Cryolysis2.db.profile.PolyBreak then
				if spellID == 28272 then --Polymorph: Pig
					PlaySoundFile("Interface\\AddOns\\Cryolysis2\\sounds\\Pig02.mp3")
				else
					PlaySoundFile("Interface\\AddOns\\Cryolysis2\\sounds\\Sheep02.mp3")
				end
			end
			Cryolysis2:DebuffTimerFinished(nil, Cryolysis2.Private.PolyBar, spellName.."DB")
			Cryolysis2.Private.PolyTarget = nil
			Cryolysis2.Private.PolySuccess = false
			Cryolysis2.Private.PolyIdUsed = nil
            Cryolysis2:CancelTimer(Cryolysis2.Private.SheepTimer, true)
		end
	end
    if string.find(event, "DAMAGE") and Cryolysis2.Private.PolyTarget == dstGUID and Cryolysis2.Private.PolySuccess then
        Cryolysis2.Private.PolySuccess = false
        if Cryolysis2.db.profile.PolyBlame then
            Cryolysis2:AddMessage(srcName..L[" broke my polymorph!"], Cryolysis2.db.profile.BlameChannel)
        end
    end
	if event == "SPELL_AURA_APPLIED_DOSE" then  --Fired for stacking debuffs (fire vuln, winter's chill)
	
	end
	
end

------------------------------------------------------------------------------------------------------
-- BAG_UPDATE event
------------------------------------------------------------------------------------------------------
function Cryolysis2:BAG_UPDATE()

	Cryolysis2:UpdateWaterButton()
	Cryolysis2:UpdateFoodButton()
	Cryolysis2:EatAndDrinkUpdate()
	Cryolysis2:UpdateManaGemIcons()
	Cryolysis2:UpdateManaGemButton()
	Cryolysis2:ShowHideFeatherCount()
	Cryolysis2:ShowHideArcanePowderCount()
	Cryolysis2:FindAllMounts()
	Cryolysis2:UpdateMountButton()

end


------------------------------------------------------------------------------------------------------
-- PLAYER_ENTERING_WORLD event
------------------------------------------------------------------------------------------------------
function Cryolysis2:PLAYER_ENTERING_WORLD()

end

function Cryolysis2:StartUp()
	Cryolysis2:PreCacheCheck()
	Cryolysis2:DetectSpellsAndRanks()
	Cryolysis2:SetupSphereAndButtons()
	Cryolysis2:UpdateAllButtonPositions()
	Cryolysis2:UpdateHideShow()
	Cryolysis2:UpdateHideShowMenus()
	Cryolysis2:UpdateHideShowSpellTimers()
	Cryolysis2:UpdateSphereAttributes()
	Cryolysis2:UpdateFoodButton()
	Cryolysis2:UpdateWaterButton()
	Cryolysis2:FindAllMounts()
	Cryolysis2:UpdateMountButton()
	Cryolysis2:UpdateLeftButton(1)
	Cryolysis2:UpdateRightButton(1)
	Cryolysis2:UpdateBottomButton(1)
	Cryolysis2:UpdateLeftButton(2)
	Cryolysis2:UpdateRightButton(2)
	Cryolysis2:UpdateBottomButton(2)
	Cryolysis2:UpdateLeftButton(3)
	Cryolysis2:UpdateRightButton(3)
	Cryolysis2:UpdateBottomButton(3)
	Cryolysis2:UpdateManaGemButton()
	Cryolysis2:UpdateManaGemIcons()
	Cryolysis2:Cryo2_UpdateEvocationCooldown()
	Cryolysis2:Cryo2_UpdateManaGemCooldown()
	Cryolysis2:UpdateInnerSphere()
	Cryolysis2:UpdateOuterSphere()
	Cryolysis2:UpdateSpellMenu()
	Cryolysis2:UpdateBuffMenuAttributes()
	Cryolysis2:UpdateTeleAndPortButton()
	Cryolysis2:UpdatePortMenuAttributes()

	-- Register the Waterfall menu
	--waterfall:Register('Cryo2Waterfall', 'aceOptions', Cryolysis2.options, 'title', 'Cryolysis 2')
	
end

------------------------------------------------------------------------------------------------------
-- PLAYER_REGEN_DISABLED event
------------------------------------------------------------------------------------------------------
function Cryolysis2:PLAYER_REGEN_DISABLED()
	Cryo2FoodButtonIcon:SetDesaturated(1)
	Cryo2WaterButtonIcon:SetDesaturated(1)
	Cryo2MountButtonIcon:SetDesaturated(1)
	Cryolysis2.Private.InCombat = true
end

------------------------------------------------------------------------------------------------------
-- PLAYER_REGEN_ENABLED event
------------------------------------------------------------------------------------------------------
function Cryolysis2:PLAYER_REGEN_ENABLED()

	Cryolysis2:UpdateFoodButton()
	Cryolysis2:UpdateWaterButton()
	Cryo2MountButtonIcon:SetDesaturated(nil)
	Cryolysis2:UpdateManaGemButton()
	Cryolysis2.Private.InCombat = false

end

------------------------------------------------------------------------------------------------------
-- MERCHANT_SHOW event
------------------------------------------------------------------------------------------------------
function Cryolysis2:MERCHANT_SHOW()

	local IsReagentVendor = false
	local ReagentsMissing = false
	
	if GetItemCount(self:GetLocalizedItemName("Arcane Powder")) < Cryolysis2.db.profile.RestockPowder 
	or GetItemCount(self:GetLocalizedItemName("Rune of Teleportation")) < Cryolysis2.db.profile.RestockTeleport 
	or GetItemCount(self:GetLocalizedItemName("Rune of Portals")) < Cryolysis2.db.profile.RestockPortals then
		ReagentsMissing = true
	end

	for i = 1, GetMerchantNumItems(), 1 do
		local name, texture, price, quantity, numAvailable, isUsable, extendedCost = GetMerchantItemInfo(i)
		if name == self:GetLocalizedItemName("Arcane Powder") 
		or name == self:GetLocalizedItemName("Rune of Teleportation") 
		or name == self:GetLocalizedItemName("Rune of Portals") then
			IsReagentVendor = true
			break;
		end
	end

	if IsReagentVendor and Cryolysis2.db.profile.Restock and ReagentsMissing then
		if Cryolysis2.db.profile.RestockConfirm then
			StaticPopup_Show("RESTOCK_REAGENTS")
		else
			Cryolysis2:RestockReagents()
		end
	end

end

------------------------------------------------------------------------------------------------------
-- MERCHANT_CLOSED event
------------------------------------------------------------------------------------------------------
function Cryolysis2:MERCHANT_CLOSED()

	StaticPopup_Hide("RESTOCK_REAGENTS")
	
end

------------------------------------------------------------------------------------------------------
-- UNIT_SPELLCAST_SUCCEEDED event
------------------------------------------------------------------------------------------------------
function Cryolysis2:UNIT_SPELLCAST_SUCCEEDED(info, unit, name, rank)

	if name == GetSpellInfo(Cryolysis2.Private.SpellId["Evocation"]) then
		Cryolysis2:ScheduleTimer("Cryo2_UpdateEvocationCooldown", 0)
	end
	if name == GetSpellInfo(Cryolysis2.Private.GemSpellId[1]) --Agate
		or name == GetSpellInfo(Cryolysis2.Private.GemSpellId[2]) --Jade
		or name == GetSpellInfo(Cryolysis2.Private.GemSpellId[3]) --Citrine
		or name == GetSpellInfo(Cryolysis2.Private.GemSpellId[4]) --Ruby
		or name == GetSpellInfo(Cryolysis2.Private.GemSpellId[5]) --Emerald
	then
		Cryolysis2.Private.ManaGemCooldownBool = false
		Cryolysis2:ScheduleTimer("Cryo2_UpdateManaGemCooldown", 0)
	end
	Cryolysis2.Private.LastSpellCast = name
    
    if Cryolysis2.Private.PolySuccess and name == GetSpellInfo(Cryolysis2.Private.SpellId["Polymorph"]) and Cryolysis2.Private.LastTarget ~= nil then
        Cryolysis2:CancelTimer(Cryolysis2.Private.SheepTimer, true)
        if Cryolysis2.db.profile.ShowDebuffTimers then
            Cryolysis2.Private.PolyBar = Cryolysis2:CreateDebuffTimer(Cryolysis2.Private.LastIdUsed, Cryolysis2.Private.LastSpellSchool, Cryolysis2.Private.LastTarget)
        end
        local waittime = Cryolysis2.Private.DebuffDuration[Cryolysis2.Private.LastIdUsed] - Cryolysis2.db.profile.PolyWarnTime
        Cryolysis2.Private.SheepTimer = Cryolysis2:ScheduleTimer("CheckPolyWarn", tonumber(waittime))
    end

end

------------------------------------------------------------------------------------------------------
-- SPELL_UPDATE_COOLDOWN event
------------------------------------------------------------------------------------------------------
function Cryolysis2:SPELL_UPDATE_COOLDOWN()

	if Cryolysis2.db.profile.ShowSpellTimers and Cryolysis2.db.profile.ShowCooldownTimers then
		Cryolysis2:CreateCooldownTimer(Cryolysis2.Private.LastSpellCast)
	end

end

------------------------------------------------------------------------------------------------------
-- UNIT_SPELLCAST_SENT event
------------------------------------------------------------------------------------------------------
function Cryolysis2:UNIT_SPELLCAST_SENT(info, caster, name, rank, target)
	
	if name == GetSpellInfo(Cryolysis2.Private.SpellId["Polymorph"]) then
		-- Memorise the polymorph target
		--Cryolysis2.Private.PolyTarget = target
	end
	
	Cryolysis2:RandomMessage(name, rank, target)
	
end

------------------------------------------------------------------------------------------------------
-- LEARNED_SPELL_IN_TAB event
------------------------------------------------------------------------------------------------------
function Cryolysis2:LEARNED_SPELL_IN_TAB()
	Cryolysis2:DetectSpellsAndRanks()
	Cryolysis2:UpdateSpellMenu()
	Cryolysis2:UpdateBuffMenuAttributes()
	Cryolysis2:UpdateTeleAndPortButton()
	Cryolysis2:UpdatePortMenuAttributes()
	Cryolysis2:UpdateManaGemButton()
	Cryolysis2:UpdateManaGemIcons()
	Cryolysis2:UpdateHideShow()
end

------------------------------------------------------------------------------------------------------
-- TRADE_SHOW event
------------------------------------------------------------------------------------------------------
function Cryolysis2:TRADE_SHOW()
	Cryolysis2.Private.TradeWindowOpen = true
end

------------------------------------------------------------------------------------------------------
-- TRADE_CLOSED event
------------------------------------------------------------------------------------------------------
function Cryolysis2:TRADE_CLOSED()

	Cryolysis2:UpdateFoodButton()
	Cryolysis2:UpdateWaterButton()
	Cryolysis2.Private.TradeWindowOpen = false

end

------------------------------------------------------------------------------------------------------
-- PLAYER_LOGIN event
------------------------------------------------------------------------------------------------------
function Cryolysis2:PLAYER_LOGIN()

	-----------------------------------------------------------------------------------
	-- DON'T MOVE THIS!!!!
	-- Checks to see if the character is a mage, if it's not it disables the addon
	local _, class = UnitClass("player")
	if class ~= "MAGE" then
		if Cryolysis2.db.profile.ClassWarn then
			StaticPopup_Show("CLASS_WARNING")
		end
		Cryolysis2:ToggleActive(false)
	end
	-----------------------------------------------------------------------------------

end

------------------------------------------------------------------------------------------------------
-- UNIT_MANA event
------------------------------------------------------------------------------------------------------
function Cryolysis2:UNIT_MANA(info, unit)
	if unit ~= "player" then
		return
	end

	if tonumber(Cryolysis2.db.profile.InnerSphere) == 2 
		or tonumber(Cryolysis2.db.profile.InnerSphere) == 3 
		or tonumber(Cryolysis2.db.profile.InnerSphere) == 6 
		or tonumber(Cryolysis2.db.profile.InnerSphere) == 7
	then 
		Cryolysis2:UpdateInnerSphere()
	end

	if tonumber(Cryolysis2.db.profile.OuterSphere) == 3 then
		Cryolysis2:UpdateOuterSphere()
	end
	
	-- Workaround for mana gem not updating properly due to the '3 charges' change
	Cryolysis2:Cryo2_UpdateManaGemCooldown();
end

------------------------------------------------------------------------------------------------------
-- UNIT_HEALTH event
------------------------------------------------------------------------------------------------------
function Cryolysis2:UNIT_HEALTH(info, unit)
	if unit == "player" then
		if tonumber(Cryolysis2.db.profile.InnerSphere) == 2 
			or tonumber(Cryolysis2.db.profile.InnerSphere) == 3 
			or tonumber(Cryolysis2.db.profile.InnerSphere) == 4 
			or tonumber(Cryolysis2.db.profile.InnerSphere) == 5
		then
			Cryolysis2:UpdateInnerSphere()
		end
		if tonumber(Cryolysis2.db.profile.OuterSphere) == 2 then
			Cryolysis2:UpdateOuterSphere()
		end
	end
end

------------------------------------------------------------------------------------------------------
-- CHARACTER_POINTS_CHANGED event
------------------------------------------------------------------------------------------------------
function Cryolysis2:CHARACTER_POINTS_CHANGED(info, value)

	if value == -1 then
	   Cryolysis2:UpdateBuffMenuAttributes() 
	end

end

------------------------------------------------------------------------------------------------------
-- Cryo2_UpdateEvocationCooldown event
------------------------------------------------------------------------------------------------------
function Cryolysis2:Cryo2_UpdateEvocationCooldown()
	
	if Cryolysis2.Private.HasEvocation == true then
		local start, duration, enabled = GetSpellCooldown(GetSpellInfo(Cryolysis2.Private.SpellId["Evocation"]))
		if duration == 0 then	   -- Spell is not on cooldown
			if Cryolysis2.db.profile.ShowEvocationCooldownText then
				Cryo2EvocButtonText:SetText("")
			end
			if tonumber(Cryolysis2.db.profile.InnerSphere) == 9 then
				Cryo2MainSphereText:SetText(L["Ready"])
			end
			Cryo2EvocButtonIcon:SetDesaturated(nil)
			Cryolysis2:CancelTimer("Cryo2_UpdateEvocationCooldown", true)
		else	-- spell on cooldown
			local endtime = start + duration
			local timeleft = endtime - GetTime()
			local minutes = floor(timeleft/60)
			local seconds = floor(math.fmod(timeleft, 60))
			Cryo2EvocButtonIcon:SetDesaturated(1)
			if Cryolysis2.db.profile.ShowEvocationCooldownText then
				if minutes > 0 then
					if seconds < 10 then
						Cryo2EvocButtonText:SetText(minutes..":0"..seconds)
					else
						Cryo2EvocButtonText:SetText(minutes..":"..seconds)
					end
				else
					Cryo2EvocButtonText:SetText(floor(timeleft))
				end
			else
				Cryo2EvocButtonText:SetText("")
			end
			if tonumber(Cryolysis2.db.profile.InnerSphere) == 9 then
				if minutes > 0 then
					if seconds < 10 then
						Cryo2MainSphereText:SetText(minutes..":0"..seconds)
					else
						Cryo2MainSphereText:SetText(minutes..":"..seconds)
					end
				else
					Cryo2MainSphereText:SetText(floor(timeleft))
				end
			end
			Cryolysis2:ScheduleTimer("Cryo2_UpdateEvocationCooldown", 1)
		end
	end
end

------------------------------------------------------------------------------------------------------
-- Cryo2_UpdateManaGemCooldown event
------------------------------------------------------------------------------------------------------
function Cryolysis2:Cryo2_UpdateManaGemCooldown()
-- When BAG_UPDATE is fired, check the mage's bags against stored values of mana gems on-hand.
-- If the state of any of the gems has changed, then schedule this event to repeat.
	if Cryolysis2.Private.HighestManaGemOnHand > 0 then
		local start, duration, enabled = GetItemCooldown(GetItemInfo(Cryolysis2.Private.ManaGemId[Cryolysis2.Private.HighestManaGemOnHand]))
		if duration == 0 then	   
			-- Spell is not on cooldown and a gem is conjured
			
			if Cryolysis2.db.profile.ShowManaGemCooldownText then
				Cryo2ManaGemButtonText:SetText("")
			end

			if tonumber(Cryolysis2.db.profile.InnerSphere) == 8 then
				Cryo2MainSphereText:SetText(L["Ready"])
			end

			Cryo2ManaGemButtonIcon:SetDesaturated(nil)
			Cryolysis2:CancelTimer("Cryo2_UpdateManaGemCooldown", true)
			Cryolysis2.Private.ManaGemCooldownBool = false
		else	
			-- Spell is on cooldown
			
			local endtime = start + duration
			local timeleft = endtime - GetTime()
			local minutes = floor(timeleft/60)
			local seconds = floor(math.fmod(timeleft, 60))
			
			Cryo2ManaGemButtonIcon:SetDesaturated(1)
			Cryolysis2.Private.ManaGemCooldownBool = true
			
			if Cryolysis2.db.profile.ShowManaGemCooldownText then
				if minutes > 0 then
					if seconds < 10 then
						Cryo2ManaGemButtonText:SetText(minutes..":0"..seconds)
					else
						Cryo2ManaGemButtonText:SetText(minutes..":"..seconds)
					end
				else
					Cryo2ManaGemButtonText:SetText(floor(timeleft))
				end
			else
				Cryo2ManaGemButtonText:SetText("")
			end
			if tonumber(Cryolysis2.db.profile.InnerSphere) == 8 then
				if minutes > 0 then
					if seconds < 10 then
						Cryo2MainSphereText:SetText(minutes..":0"..seconds)
					else
						Cryo2MainSphereText:SetText(minutes..":"..seconds)
					end
				else
					Cryo2MainSphereText:SetText(floor(timeleft))
				end
			end
			Cryolysis2:ScheduleTimer("Cryo2_UpdateManaGemCooldown", 1)
		end
	else -- no gems conjured
		if Cryolysis2.db.profile.ShowManaGemCooldownText then
			Cryo2ManaGemButtonText:SetText("")
		end
		if tonumber(Cryolysis2.db.profile.InnerSphere) == 8 then
			Cryo2MainSphereText:SetText(L["Unavailable"])
		end
		Cryo2ManaGemButtonIcon:SetDesaturated(1)
	end
end

------------------------------------------------------------------------------------------------------
-- Function for creating a cooldown timer
------------------------------------------------------------------------------------------------------
function Cryolysis2:CreateCooldownTimer(spellName)
	
	if spellName ~= nil then
		if spellName == GetSpellInfo(Cryolysis2.Private.SpellId["Cold Snap"]) then --Cold Snap
			Cryolysis2:TimerFinished(nil, nil, GetSpellInfo(Cryolysis2.Private.SpellId["Ice Block"]).."CD") --Ice Block
			Cryolysis2:TimerFinished(nil, nil, GetSpellInfo(Cryolysis2.Private.SpellId["Frost Nova"]).."CD") --Frost Nova
			Cryolysis2:TimerFinished(nil, nil, GetSpellInfo(Cryolysis2.Private.SpellId["Summon Water Elemental"]).."CD") --Summon Water Elemental
			Cryolysis2:TimerFinished(nil, nil, GetSpellInfo(Cryolysis2.Private.SpellId["Ice Barrier"]).."CD") --Ice Barrier
			Cryolysis2:TimerFinished(nil, nil, GetSpellInfo(Cryolysis2.Private.SpellId["Cone of Cold"]).."CD") --Cone of Cold
			Cryolysis2:TimerFinished(nil, nil, GetSpellInfo(Cryolysis2.Private.SpellId["Icy Veins"]).."CD")  --Icy Veins
			Cryolysis2:TimerFinished(nil, nil, GetSpellInfo(Cryolysis2.Private.SpellId["Frost Ward"]).."CD") --Frost Ward
		end
	
		local start, duration, enabled = GetSpellCooldown(spellName)
		local active = Cryolysis2:TimerActive(spellName)
		local _, _, texture = GetSpellInfo(spellName)

		if duration ~= nil then
			if duration > 1.5 and enabled ~= 0 and Cryolysis2.db.profile.ShowSpellTimers and not active then
			
				local color = Cryolysis2:FindSpellType(spellName)
                local bar = Timers:NewTimerBar(spellName.."CD", spellName, duration, duration, texture)
                if color == 1 then
					--bar:SetVertexColor(0, 1, 0)
                end
				if color == 2 then
                    --bar:SetVertexColor(1, 0, 1)
				end
				if color == 3 then
                    --bar:SetVertexColor(1, 0, 0)
				end
				if color == 4 then
                    --bar:SetVertexColor(0, 0, 1)
				end

				table.insert(Cryolysis2.Private.SpellTimers, spellName.."CD")
                bar.RegisterCallback(Cryolysis2, "TimerFinished")
                
                return bar
			end
		end
	end
end

function Cryolysis2:CreateDebuffTimer(spellId, color, GUID)

	local duplicate = false
	local name, _, texture = GetSpellInfo(spellId)
	local duration = Cryolysis2.Private.DebuffDuration[spellId]
	
	if duration ~= nil then
    
        local bar = Timers:NewTimerBar(name.."DB", name, duration, duration, texture)
    
		if color == "none" then
			return
		end
		if color == 64 then  --purple
			--bar:SetVertexColor(1, 0, 1)
		end
		if color == 4 then  --red
			--bar:SetVertexColor(1, 0, 0)
		end
		if color == 16 then  --blue
			--bar:SetVertexColor(0, 0, 1)
		end
		
		table.insert(Cryolysis2.Private.DebuffTimers, name.."DB")
        bar.RegisterCallback(Cryolysis2, "DebuffTimerFinished")
        
        return bar
	end
end

------------------------------------------------------------------------------------------------------
-- Set the hide/show attribute for the spell timers
------------------------------------------------------------------------------------------------------
function Cryolysis2:UpdateHideShowSpellTimers()

	if Cryolysis2.db.profile.ShowSpellTimers then
		--Timers:Show()
	end
	if not Cryolysis2.db.profile.ShowSpellTimers then
		--Timers:Hide()
		for i = 1, #(Cryolysis2.Private.SpellTimers), 1 do
			Cryolysis2:TimerFinished(nil, nil, Cryolysis2.Private.SpellTimers[i])
		end
		for i = 1, #(Cryolysis2.Private.DebuffTimers), 1 do
			Cryolysis2:DebuffTimerFinished(nil, nil, Cryolysis2.Private.DebuffTimers[i])
		end
	end
	if not Cryolysis2.db.profile.ShowDebuffTimers then
		for i = 1, #(Cryolysis2.Private.DebuffTimers), 1 do
			Cryolysis2:DebuffTimerFinished(nil, nil, Cryolysis2.Private.DebuffTimers[i])
		end
	end
	if not Cryolysis2.db.profile.ShowCooldownTimers then
		for i = 1, #(Cryolysis2.Private.SpellTimers), 1 do
			Cryolysis2:TimerFinished(nil, nil, Cryolysis2.Private.SpellTimers[i])
		end
	end
	
end

------------------------------------------------------------------------------------------------------
-- Function for ending a spell timer
------------------------------------------------------------------------------------------------------
function Cryolysis2:TimerFinished(evt, bar, name)
	
    --bar:Fade()
	
	for i = 1, #(Cryolysis2.Private.SpellTimers), 1 do
		if Cryolysis2.Private.SpellTimers[i] == name then
			table.remove(Cryolysis2.Private.SpellTimers, i)
			return
		end
	end
	
end

function Cryolysis2:DebuffTimerFinished(evt, bar, name)

    --bar:Fade()
	
	for i = 1, #(Cryolysis2.Private.DebuffTimers), 1 do
		if Cryolysis2.Private.DebuffTimers[i] == name then
			table.remove(Cryolysis2.Private.DebuffTimers, i)
			return
		end
	end

end

------------------------------------------------------------------------------------------------------
-- Function for checking whether or not a certain timer is active
------------------------------------------------------------------------------------------------------
function Cryolysis2:TimerActive(spellName)
	for i = 1, #(Cryolysis2.Private.SpellTimers), 1 do
		if Cryolysis2.Private.SpellTimers[i] == spellName.."CD" then
			return true
		end
	end
	return false
end