local L = LibStub("AceLocale-3.0"):GetLocale("Cryolysis2")
local Cryolysis2 = LibStub("AceAddon-3.0"):GetAddon("Cryolysis2")

function Cryolysis2:CreateDefaults()
	-- Setup default settings
	Cryolysis2.defaults = {
		profile = {
			ClassWarn = true,
			ProvisionContainer = 4,				-- Where food/water is stored.  furthest bag on the left
			ProvisionSort = true,				-- Sort food and drink
			ProvisionDestroy = false,			-- Destroy Excess food and dirnk
			ShowSpellTimers = false,			-- Show spell timers
			ShowDebuffTimers = false,
			ShowCooldownTimers = false,
			HPLimit = 85,					-- Eat food when under this % of health
			MPLimit = 100,					-- Drink water when under this % of mana
			MainButton = 2,					-- Main button function.  1 = None, 2 = eat/drink, 3 = Evocation, 4 = polymorph, 5 = mana gem, 6 = blink
			OuterSphere = 3,				-- Outside sphere display.  1 = None, 2 = HP, 3 = Mana, 4 = Mana Gem CD, 5 = Evocation CD
			InnerSphere = 4,				-- Inside sphere display.  1 = none, 2 = food/drink, 3 = drink/food, 4 = Curr Health, 5 = Health %, 6 = Curr Mana, 7 = Mana %, 8 = Mana Gem CD, 9 = Evocation CD
			ShowFoodCountText = true,			-- Show food count on button
			ShowWaterCountText = true,			-- Show drink count on button
			ShowPowderCountText = false,			-- Show arcane powder count on button
			ShowFeatherCountText = true,			-- Show light feather count on button
			ShowManaGemCooldownText = false,		-- Show Mana gem cooldown on button
			ShowEvocationCooldownText = false,		-- Show evocation cooldown on button
			LockSphere = false,				-- Lock everything in place
			LockButtons = true,				-- Lock the buttons to the main sphere. (Keep them around the outside of the sphere.)
			LockTimers = false,
			CryolysisToolTip = true,			-- Show tooltips
			LeftSpellLeft,					-- Left spell button left click function: User can type in spell name
			LeftSpellMid,
			LeftSpellRight,
			LeftCustomButtonType = "spell",			-- 1 = spell, 2 = macro, 3 = item
			RightSpellLeft,					-- Right spell button left click function: User can type in spell name 
			RightSpellMid,
			RightSpellRight,
			RightCustomButtonType = "spell",		-- 1 = spell, 2 = macro, 3 = item
			BottomSpellLeft,
			BottomSpellMid,
			BottomSpellRight,
			BottomCustomButtonType = "spell",		-- 1 = spell, 2 = macro, 3 = item
			PolySounds = true,				-- Play sounds for polymorph
			ChatChannel = "SAY",			-- What chat channel to print the message in
			PolyBlame = true,
            BlameChannel = "SAY",
            SM = false,					-- Short messages
			PolyWarn = true,				-- Warn when polymorph is about to break
			PolyBreak = true,				-- Warn when polymorph breaks
			PolyWarnTime = 7,				-- How long before polymorph breaks the user is warned.
			PolyMessage = true,				-- Print messages when polymorphing
			RitualMessage = true,		   -- Print a message when casting ritual of refreshment
			TeleMessage = false,				-- Print messages when teleporting
			PortalMessage = false,				-- Print messages when portaling
			MountMessage = false,				-- Print messages when mounting up
			Restock	= true,					-- True = restock, false = don't restock
			RestockConfirm = true,				-- True = ask me first, false = don't ask me
			RestockTeleport = 10,				-- Restock to 10 Rune of Teleportation
			RestockPortals = 10,				-- Restock to 10 Rune of Portals
			RestockPowder = 20,				-- Restock to 20 Arcane Powder
			Angle = 180,
			HideTooltips = false,
			BuffMenuGrowLeft = false,
			BuffMenuOfsX = 0,
			BuffMenuOfsY = 0,
			PortMenuGrowLeft = false,
			PortMenuOfsX = 0,
			PortMenuOfsY = 0,
			GemMenuGrowLeft = false,
			GemMenuOfsX = 0,
			GemMenuOfsY = 0,

			-- Variables for scaling buttons and sphere and calculating constricted positions
			-- Radius and Scale are used for scaling.  Pos is used for switching button order.
			MainSphereScale = 1,
			ButtonScale = 1,
			FoodButtonScale = 1,
			WaterButtonScale = 1,
			ManaGemButtonScale = 1,
			LeftCustomButtonScale = 1,
			EvocationButtonScale = 1,
			RightCustomButtonScale = 1,
			SpellButtonScale = 1,
			MountButtonScale = 1,
			TeleAndPortButtonScale = 1,
			BottomCustomButtonScale = 1,
			
			LeftMount = "",
			RightMount = "",
			
			-- These need to stay in the Saved Var's because their position in the array may get changed by the user.
			Buttons = {
				"Cryo2FoodButton",
				"Cryo2WaterButton",
				"Cryo2ManaGemButton",
				"Cryo2LeftCustomButton",
				"Cryo2EvocButton",
				"Cryo2RightCustomButton",
				"Cryo2BuffMenuButton",
				"Cryo2MountButton",
				"Cryo2TeleAndPortMenuButton",
				"Cryo2BottomCustomButton"
			},
			MiddleKey = "alt",
			MSHide = false,
			FoodHide = false,
			WaterHide = false,
			MountHide = false,
			BuffHide = false,
			PortHide = false,
			LeftHide = false,
			RightHide = false,
			BottomHide = false,
			GemHide = false,
			EvocHide = false,
			
			MSx = 300,
			MSy = 300,
		}
	}
	
	-- Setup random messages
	Cryolysis2.random = {}
end