local L = LibStub("AceLocale-3.0"):GetLocale("Cryolysis2")
local Cryolysis2 = LibStub("AceAddon-3.0"):GetAddon("Cryolysis2")
 
------------------------------------------------------------------------------------------------------
-- Update the properties of the water button
------------------------------------------------------------------------------------------------------
function Cryolysis2:UpdateWaterButton()

	Cryolysis2:WaterOnHand()

	local wateramount = Cryolysis2:CountWater()

	if Cryolysis2.db.profile.ShowWaterCountText == true then
		if wateramount == 0 then
			Cryo2WaterButtonText:SetText("")
		else
			Cryo2WaterButtonText:SetText(wateramount)
		end
	end

	Cryo2WaterButton:SetAttribute("type1", "item")
	
	if Cryolysis2.Private.CanConjureWater then
		if Cryolysis2.Private.HighestWaterOnHand > 0 then
			Cryo2WaterButton:SetAttribute("item1", select(1,GetItemInfo(Cryolysis2.Private.WaterItemId[Cryolysis2.Private.HighestWaterOnHand])))
			Cryo2WaterButtonIcon:SetTexture("Interface\\Icons\\"..Cryolysis2.Private.WaterTex[Cryolysis2.Private.HighestWaterOnHand])
		else
			Cryo2WaterButtonIcon:SetTexture("Interface\\Icons\\"..Cryolysis2.Private.WaterTex[Cryolysis2.Private.HighestWaterId])
		end
		Cryo2WaterButton:SetAttribute("type2", "spell")
		Cryo2WaterButton:SetAttribute("spell2", GetSpellInfo(Cryolysis2.Private.WaterSpellId[Cryolysis2.Private.HighestWaterId]))
		if Cryolysis2.Private.HasRitual then
			Cryo2WaterButton:SetAttribute("shift-type2", "spell")
			Cryo2WaterButton:SetAttribute("shift-spell2", GetSpellInfo(Cryolysis2.Private.SpellId["Ritual of Refreshment"]))
		end
		Cryo2WaterButton:SetAttribute("type3", "Trade")
		
		Cryo2WaterButton:SetAttribute("alt-type*", "")
		Cryo2WaterButton:SetAttribute("shift-type*", "")
		Cryo2WaterButton:SetAttribute("ctrl-type*", "")
		
		Cryo2WaterButton:SetAttribute(Cryolysis2.db.profile.MiddleKey.."-type*", "Trade")
		
		Cryo2WaterButton.Trade = function() Cryolysis2:TradeWater() end
	end
	
	if wateramount == 0 then
		Cryo2WaterButtonIcon:SetDesaturated(1)
	elseif wateramount > 0 and InCombatLockdown() ~= 1 then
		Cryo2WaterButtonIcon:SetDesaturated(nil)
	end
	
end