local L = LibStub("AceLocale-3.0"):GetLocale("Cryolysis2")
local BZ = LibStub("LibBabble-Zone-3.0"):GetLookupTable()
local Cryolysis2 = LibStub("AceAddon-3.0"):GetAddon("Cryolysis2")
 
------------------------------------------------------------------------------------------------------
-- Construct the various tooltips for buttons
------------------------------------------------------------------------------------------------------
function Cryolysis2:BuildTooltip(frame, button, anchor)

	local tempName

	if Cryolysis2.db.profile.HideTooltips or Cryolysis2.Private.AllItemsCached == false then
		return
	end

	GameTooltip:SetOwner(frame, anchor)

	if button == "MS" then
		GameTooltip:SetText("Cryolysis 2", 1, 1, 1, 1)
		if Cryolysis2.Private.HighestFoodOnHand == 0 then
			GameTooltip:AddLine(L["Conjured Food"]..": ".."0")
		else
			GameTooltip:AddLine(L["Conjured Food"]..": "..GetItemCount(GetItemInfo(Cryolysis2.Private.FoodItemId[Cryolysis2.Private.HighestFoodOnHand])))
		end
		if Cryolysis2.Private.HighestWaterOnHand == 0 then
			GameTooltip:AddLine(GetItemInfo(5350)..": ".."0")  --5350 is the itemID for Conjured Water
		else
			GameTooltip:AddLine(GetItemInfo(5350)..": "..GetItemCount(GetItemInfo(Cryolysis2.Private.WaterItemId[Cryolysis2.Private.HighestWaterOnHand])))
		end
		GameTooltip:AddLine(GetItemInfo(Cryolysis2.Private.ReagentId["Arcane Powder"])..": "..GetItemCount(GetItemInfo(Cryolysis2.Private.ReagentId["Arcane Powder"])))
		GameTooltip:AddLine(L["Light Feathers"]..": "..GetItemCount(GetItemInfo(Cryolysis2.Private.ReagentId["Light Feather"])))
		GameTooltip:AddLine(L["Teleport Runes"]..": "..GetItemCount(GetItemInfo(Cryolysis2.Private.ReagentId["Rune of Teleportation"])))
		GameTooltip:AddLine(L["Portal Runes"]..": "..GetItemCount(GetItemInfo(Cryolysis2.Private.ReagentId["Rune of Portals"])))
	end
	if button == "food" then
		GameTooltip:SetText(L["Food"], 1, 1, 1, 1)
		GameTooltip:AddLine(L["Left-click to use."])
		GameTooltip:AddLine(L["Middle-click to trade."])
		GameTooltip:AddLine(L["Right-click to conjure."])
		if Cryolysis2.Private.HasRitual then
			GameTooltip:AddLine(L["Shift + right-click for Ritual of Refreshment."])
		end
	end
	if button == "water" then
		GameTooltip:SetText(L["Water"], 1, 1, 1, 1)
		GameTooltip:AddLine(L["Left-click to use."])
		GameTooltip:AddLine(L["Middle-click to trade."])
		GameTooltip:AddLine(L["Right-click to conjure."])
		if Cryolysis2.Private.HasRitual then
			GameTooltip:AddLine(L["Shift + right-click for Ritual of Refreshment."])
		end
	end
	if button == "gem" then
		GameTooltip:SetText(L["Mana Gem"], 1, 1, 1, 1)
		GameTooltip:AddLine(L["Left-click to use."])
		GameTooltip:AddLine(L["Middle-click for gem menu."])
		GameTooltip:AddLine(L["Right-click to conjure."])
		GameTooltip:AddLine(L["(Outside combat only)"])
		GameTooltip:AddLine(" ")
		for i = #(Cryolysis2.Private.CanConjureGem), 1, -1 do
			if Cryolysis2.Private.HasManaGem[i] == true then
				GameTooltip:AddLine(GetItemInfo(Cryolysis2.Private.ManaGemId[i])..": "..L["Ready"])
			else
				GameTooltip:AddLine(GetItemInfo(Cryolysis2.Private.ManaGemId[i])..": "..L["Unavailable"])
			end
		end
	end
	if button == "mount" then
		GameTooltip:SetText(L["Mount"], 1, 1, 1, 1)
		if not Cryolysis2.Private.HasMount then
			GameTooltip:AddLine(L["Click to hearth to "]..GetBindLocation())
		end
		if Cryolysis2.Private.HasMount then
			GameTooltip:AddLine(L["Left-click to use "]..Cryolysis2.Private.Mounts[Cryolysis2.db.profile.LeftMount])
			GameTooltip:AddLine(L["Middle-click to hearth to "]..GetBindLocation())
			GameTooltip:AddLine(L["Right-click to use "]..Cryolysis2.Private.Mounts[Cryolysis2.db.profile.RightMount])
		end
	end
	if button == "left" then
		GameTooltip:SetText(L["Left Custom Button"], 1, 1, 1, 1)
		if Cryolysis2.db.profile.LeftSpellLeft ~= nil and Cryolysis2.db.profile.LeftSpellLeft ~= ""  then
			GameTooltip:AddLine(L["Left-click to cast "]..Cryolysis2.db.profile.LeftSpellLeft..".")
		end
		if Cryolysis2.db.profile.LeftSpellMid ~= nil and Cryolysis2.db.profile.LeftSpellMid ~= ""  then
			GameTooltip:AddLine(L["Middle-click to cast "]..Cryolysis2.db.profile.LeftSpellMid..".")
		end
		if Cryolysis2.db.profile.LeftSpellRight ~= nil and Cryolysis2.db.profile.LeftSpellRight ~= ""  then
			GameTooltip:AddLine(L["Right-click to cast "]..Cryolysis2.db.profile.LeftSpellRight..".")
		end
		
		if Cryolysis2.db.profile.LeftSpellLeft == nil and Cryolysis2.db.profile.LeftSpellRight == nil and Cryolysis2.db.profile.LeftSpellMid == nil then
			GameTooltip:AddLine(L["No spells assigned to this button."])
			GameTooltip:AddLine(L["You can assign a spell to this button using the Cryolysis 2 menu."])
		end
	end
	if button == "right" then
		GameTooltip:SetText(L["Right Custom Button"], 1, 1, 1, 1)
		if Cryolysis2.db.profile.RightSpellLeft ~= nil and Cryolysis2.db.profile.RightSpellLeft ~= "" then
			GameTooltip:AddLine(L["Left-click to cast "]..Cryolysis2.db.profile.RightSpellLeft..".")
		end
		if Cryolysis2.db.profile.RightSpellMid ~= nil and Cryolysis2.db.profile.RightSpellMid ~= "" then
			GameTooltip:AddLine(L["Middle-click to cast "]..Cryolysis2.db.profile.RightSpellMid..".")
		end
		if Cryolysis2.db.profile.RightSpellRight ~= nil and Cryolysis2.db.profile.RightSpellRight ~= "" then
			GameTooltip:AddLine(L["Right-click to cast "]..Cryolysis2.db.profile.RightSpellRight..".")
		end
		
		if Cryolysis2.db.profile.RightSpellLeft == nil and Cryolysis2.db.profile.RightSpellRight == nil and Cryolysis2.db.profile.RightSpellMid == nil then
			GameTooltip:AddLine(L["No spells assigned to this button."])
			GameTooltip:AddLine(L["You can assign a spell to this button using the Cryolysis 2 menu."])
		end
	end
	if button == "bottom" then
		GameTooltip:SetText(L["Bottom Custom Button"], 1, 1, 1, 1)
		if Cryolysis2.db.profile.BottomSpellLeft ~= nil and Cryolysis2.db.profile.BottomSpellLeft ~= "" then
			GameTooltip:AddLine(L["Left-click to cast "]..Cryolysis2.db.profile.BottomSpellLeft..".")
		end
		if Cryolysis2.db.profile.BottomSpellMid ~= nil and Cryolysis2.db.profile.BottomSpellMid ~= "" then
			GameTooltip:AddLine(L["Middle-click to cast "]..Cryolysis2.db.profile.BottomSpellMid..".")
		end
		if Cryolysis2.db.profile.BottomSpellRight ~= nil and Cryolysis2.db.profile.RightSpellRight ~= "" then
			GameTooltip:AddLine(L["Right-click to cast "]..Cryolysis2.db.profile.BottomSpellRight..".")
		end
		
		if Cryolysis2.db.profile.BottomSpellLeft == nil and Cryolysis2.db.profile.BottomSpellRight == nil and Cryolysis2.db.profile.BottomSpellMid == nil then
			GameTooltip:AddLine(L["No spells assigned to this button."])
			GameTooltip:AddLine(L["You can assign a spell to this button using the Cryolysis 2 menu."])
		end
	end
	if button == "port" then
		GameTooltip:SetText(L["Teleport and Portal Menu"], 1, 1, 1, 1)
		GameTooltip:AddLine(L["Click to open the menu."])
	end
	if button == "buff" then
		GameTooltip:SetText(L["Buff Menu"], 1, 1, 1, 1)
		GameTooltip:AddLine(L["Click to open the menu."])
	end
	if button == "evoc" then
		tempName = GetSpellInfo(Cryolysis2.Private.SpellId["Evocation"])
		GameTooltip:SetText(tempName, 1, 1, 1, 1)
		GameTooltip:AddLine(L["Click to cast "]..tempName..".")
	end
	if button == "port1" then
		if Cryolysis2.Private.englishFaction == "Alliance" then
			GameTooltip:SetText(BZ["Ironforge"], 1, 1, 1, 1)
			GameTooltip:AddLine(L["Left-click to teleport to "]..BZ["Ironforge"]..".")
			GameTooltip:AddLine(L["Right-click to open a portal to "]..BZ["Ironforge"]..".")
		end
		if Cryolysis2.Private.englishFaction == "Horde" then
			GameTooltip:SetText(BZ["Orgrimmar"], 1, 1, 1, 1)
			GameTooltip:AddLine(L["Left-click to teleport to "]..BZ["Orgrimmar"]..".")
			GameTooltip:AddLine(L["Right-click to open a portal to "]..BZ["Orgrimmar"]..".")
		end
		GameTooltip:AddLine(L["Teleport Runes"]..": "..GetItemCount(GetItemInfo(Cryolysis2.Private.ReagentId["Rune of Teleportation"])).."   "..L["Portal Runes"]..": "..GetItemCount(GetItemInfo(Cryolysis2.Private.ReagentId["Rune of Portals"])))
	end
	if button == "port2" then
		if Cryolysis2.Private.englishFaction == "Alliance" then
			GameTooltip:SetText(BZ["Stormwind City"], 1, 1, 1, 1)
			GameTooltip:AddLine(L["Left-click to teleport to "]..BZ["Stormwind City"]..".")
			GameTooltip:AddLine(L["Right-click to open a portal to "]..BZ["Stormwind City"]..".")
		end
		if Cryolysis2.Private.englishFaction == "Horde" then
			GameTooltip:SetText(BZ["Undercity"], 1, 1, 1, 1)
			GameTooltip:AddLine(L["Left-click to teleport to "]..BZ["Undercity"]..".")
			GameTooltip:AddLine(L["Right-click to open a portal to "]..BZ["Undercity"]..".")
		end
		GameTooltip:AddLine(L["Teleport Runes"]..": "..GetItemCount(GetItemInfo(Cryolysis2.Private.ReagentId["Rune of Teleportation"])).."   "..L["Portal Runes"]..": "..GetItemCount(GetItemInfo(Cryolysis2.Private.ReagentId["Rune of Portals"])))	
	end
	if button == "port3" then
		if Cryolysis2.Private.englishFaction == "Alliance" then
			GameTooltip:SetText(BZ["Darnassus"], 1, 1, 1, 1)
			GameTooltip:AddLine(L["Left-click to teleport to "]..BZ["Darnassus"]..".")
			GameTooltip:AddLine(L["Right-click to open a portal to "]..BZ["Darnassus"]..".")
		end
		if Cryolysis2.Private.englishFaction == "Horde" then
			GameTooltip:SetText(BZ["Thunder Bluff"], 1, 1, 1, 1)
			GameTooltip:AddLine(L["Left-click to teleport to "]..BZ["Thunder Bluff"]..".")
			GameTooltip:AddLine(L["Right-click to open a portal to "]..BZ["Thunder Bluff"]..".")
		end
		GameTooltip:AddLine(L["Teleport Runes"]..": "..GetItemCount(GetItemInfo(Cryolysis2.Private.ReagentId["Rune of Teleportation"])).."   "..L["Portal Runes"]..": "..GetItemCount(GetItemInfo(Cryolysis2.Private.ReagentId["Rune of Portals"])))
	end
	if button == "port4" then
		if Cryolysis2.Private.englishFaction == "Alliance" then
			GameTooltip:SetText(BZ["The Exodar"], 1, 1, 1, 1)
			GameTooltip:AddLine(L["Left-click to teleport to "]..BZ["The Exodar"]..".")
			GameTooltip:AddLine(L["Right-click to open a portal to "]..BZ["The Exodar"]..".")
		end
		if Cryolysis2.Private.englishFaction == "Horde" then
			GameTooltip:SetText(BZ["Silvermoon City"], 1, 1, 1, 1)
			GameTooltip:AddLine(L["Left-click to teleport to "]..BZ["Silvermoon City"]..".")
			GameTooltip:AddLine(L["Right-click to open a portal to "]..BZ["Silvermoon City"]..".")
		end
		GameTooltip:AddLine(L["Teleport Runes"]..": "..GetItemCount(GetItemInfo(Cryolysis2.Private.ReagentId["Rune of Teleportation"])).."   "..L["Portal Runes"]..": "..GetItemCount(GetItemInfo(Cryolysis2.Private.ReagentId["Rune of Portals"])))
	end
	if button == "port5" then
		if Cryolysis2.Private.englishFaction == "Alliance" then
			GameTooltip:SetText(BZ["Theramore Isle"], 1, 1, 1, 1)
			GameTooltip:AddLine(L["Left-click to teleport to "]..BZ["Theramore Isle"]..".")
			GameTooltip:AddLine(L["Right-click to open a portal to "]..BZ["Theramore Isle"]..".")
		end
		if Cryolysis2.Private.englishFaction == "Horde" then
			GameTooltip:SetText(BZ["Stonard"], 1, 1, 1, 1)
			GameTooltip:AddLine(L["Left-click to teleport to "]..BZ["Stonard"]..".")
			GameTooltip:AddLine(L["Right-click to open a portal to "]..BZ["Stonard"]..".")
		end
		GameTooltip:AddLine(L["Teleport Runes"]..": "..GetItemCount(GetItemInfo(Cryolysis2.Private.ReagentId["Rune of Teleportation"])).."   "..L["Portal Runes"]..": "..GetItemCount(GetItemInfo(Cryolysis2.Private.ReagentId["Rune of Portals"])))
	end
	if button == "port6" then
		GameTooltip:SetText(BZ["Shattrath City"], 1, 1, 1, 1)
		GameTooltip:AddLine(L["Left-click to teleport to "]..BZ["Shattrath City"]..".")
		GameTooltip:AddLine(L["Right-click to open a portal to "]..BZ["Shattrath City"]..".")
		GameTooltip:AddLine(L["Teleport Runes"]..": "..GetItemCount(GetItemInfo(Cryolysis2.Private.ReagentId["Rune of Teleportation"])).."   "..L["Portal Runes"]..": "..GetItemCount(GetItemInfo(Cryolysis2.Private.ReagentId["Rune of Portals"])))
	end
	if button == "gem1" then
		GameTooltip:SetText(Cryolysis2.Private.ManaGemName[1], 1, 1, 1, 1)
		if Cryolysis2.Private.HasManaGem[1] then
			GameTooltip:AddLine(L["Conjured"])
			GameTooltip:AddLine(L["Left-click to use "]..Cryolysis2.Private.ManaGemName[1]..".")
		else
			GameTooltip:AddLine(L["Not Conjured"])
			GameTooltip:AddLine(L["Right-click to conjure "]..Cryolysis2.Private.ManaGemName[1]..".")
		end
	end
	if button == "gem2" then
		GameTooltip:SetText(Cryolysis2.Private.ManaGemName[2], 1, 1, 1, 1)
		if Cryolysis2.Private.HasManaGem[2] then
			GameTooltip:AddLine(L["Conjured"])
			GameTooltip:AddLine(L["Left-click to use "]..Cryolysis2.Private.ManaGemName[2]..".")
		else
			GameTooltip:AddLine(L["Not Conjured"])
			GameTooltip:AddLine(L["Right-click to conjure "]..Cryolysis2.Private.ManaGemName[2]..".")
		end
	end
	if button == "gem3" then
		GameTooltip:SetText(Cryolysis2.Private.ManaGemName[3], 1, 1, 1, 1)
		if Cryolysis2.Private.HasManaGem[3] then
			GameTooltip:AddLine(L["Conjured"])
			GameTooltip:AddLine(L["Left-click to use "]..Cryolysis2.Private.ManaGemName[3]..".")
		else
			GameTooltip:AddLine(L["Not Conjured"])
			GameTooltip:AddLine(L["Right-click to conjure "]..Cryolysis2.Private.ManaGemName[3]..".")
		end
	end
	if button == "gem4" then
		GameTooltip:SetText(Cryolysis2.Private.ManaGemName[4], 1, 1, 1, 1)
		if Cryolysis2.Private.HasManaGem[4] then
			GameTooltip:AddLine(L["Conjured"])
			GameTooltip:AddLine(L["Left-click to use "]..Cryolysis2.Private.ManaGemName[4]..".")
		else
			GameTooltip:AddLine(L["Not Conjured"])
			GameTooltip:AddLine(L["Right-click to conjure "]..Cryolysis2.Private.ManaGemName[4]..".")
		end
	end
	if button == "gem5" then
		GameTooltip:SetText(Cryolysis2.Private.ManaGemName[5], 1, 1, 1, 1)
		if Cryolysis2.Private.HasManaGem[5] then
			GameTooltip:AddLine(L["Conjured"])
			GameTooltip:AddLine(L["Left-click to use "]..Cryolysis2.Private.ManaGemName[5]..".")
		else
			GameTooltip:AddLine(L["Not Conjured"])
			GameTooltip:AddLine(L["Right-click to conjure "]..Cryolysis2.Private.ManaGemName[5]..".")
		end
	end
	
	if button == "buff1" then
		GameTooltip:SetText(L["Armor"], 1, 1, 1, 1)
		if Cryolysis2.Private.HasFrostArmor and not Cryolysis2.Private.HasIceArmor then
			tempName = GetSpellInfo(Cryolysis2.Private.SpellId["Frost Armor"])
			GameTooltip:AddLine(L["Left-click to cast "]..tempName..".")
		else
			tempName = GetSpellInfo(Cryolysis2.Private.SpellId["Ice Armor"])
			GameTooltip:AddLine(L["Left-click to cast "]..tempName..".")
		end
		if Cryolysis2.Private.HasMoltenArmor then
			tempName = GetSpellInfo(Cryolysis2.Private.SpellId["Molten Armor"])
			GameTooltip:AddLine(L["Middle-click to cast "]..tempName..".")
		end
		if Cryolysis2.Private.HasMageArmor then
			tempName = GetSpellInfo(Cryolysis2.Private.SpellId["Mage Armor"])
			GameTooltip:AddLine(L["Right-click to cast "]..tempName..".")
		end
	end
	if button == "buff2" then
		GameTooltip:SetText(L["Intellect"], 1, 1, 1, 1)
		if Cryolysis2.Private.HasArcaneIntellect then
			tempName = GetSpellInfo(Cryolysis2.Private.SpellId["Arcane Intellect"])
			GameTooltip:AddLine(L["Left-click to cast "]..tempName..".")
		end
		if Cryolysis2.Private.HasArcaneBrilliance then
			tempName = GetSpellInfo(Cryolysis2.Private.SpellId["Arcane Brilliance"])
			GameTooltip:AddLine(L["Right-click to cast "]..tempName..".")
		end
	end
	if button == "buff3" then
		GameTooltip:SetText(L["Magic"], 1, 1, 1, 1)
		if Cryolysis2.Private.HasDampenMagic then
			tempName = GetSpellInfo(Cryolysis2.Private.SpellId["Dampen Magic"])
			GameTooltip:AddLine(L["Left-click to cast "]..tempName..".")
		end
		if Cryolysis2.Private.HasAmplifyMagic then
			tempName = GetSpellInfo(Cryolysis2.Private.SpellId["Amplify Magic"])
			GameTooltip:AddLine(L["Right-click to cast "]..tempName..".")
		end
	end
	if button == "buff4" then
		GameTooltip:SetText(L["Damage Shields"], 1, 1, 1, 1)
		if Cryolysis2.Private.HasIceBarrier then
			tempName = GetSpellInfo(Cryolysis2.Private.SpellId["Ice Barrier"])
			GameTooltip:AddLine(L["Left-click to cast "]..tempName..".")
			tempName = GetSpellInfo(Cryolysis2.Private.SpellId["Mana Shield"])
			GameTooltip:AddLine(L["Right-click to cast "]..tempName..".")
		else
			tempName = GetSpellInfo(Cryolysis2.Private.SpellId["Mana Shield"])
			GameTooltip:AddLine(L["Left-click to cast "]..tempName..".")
		end
	end
	if button == "buff5" then
		GameTooltip:SetText(L["Magical Wards"], 1, 1, 1, 1)
		if Cryolysis2.Private.HasFireWard then
			tempName = GetSpellInfo(Cryolysis2.Private.SpellId["Fire Ward"])
			GameTooltip:AddLine(L["Left-click to cast "]..tempName..".")
		end
		if Cryolysis2.Private.HasFrostWard then
			tempName = GetSpellInfo(Cryolysis2.Private.SpellId["Frost Ward"])
			GameTooltip:AddLine(L["Right-click to cast "]..tempName..".")
		end
	end
	if button == "buff6" then
		tempName = GetSpellInfo(Cryolysis2.Private.SpellId["Remove Lesser Curse"])
		GameTooltip:SetText(tempName, 1, 1, 1, 1)
		GameTooltip:AddLine(L["Click to cast "]..tempName..".")
	end
	if button == "buff7" then
		tempName = GetSpellInfo(Cryolysis2.Private.SpellId["Slow Fall"])
		GameTooltip:SetText(tempName, 1, 1, 1, 1)
		GameTooltip:AddLine(L["Click to cast "]..tempName..".")
	end
	
	GameTooltip:Show()
end
