local L = LibStub("AceLocale-3.0"):GetLocale("Cryolysis2")
local Cryolysis2 = LibStub("AceAddon-3.0"):GetAddon("Cryolysis2")
 
------------------------------------------------------------------------------------------------------
-- Update properties of the Teleport/Portal button
------------------------------------------------------------------------------------------------------
function Cryolysis2:UpdateTeleAndPortButton()

-- Cryo2PortMenu0 inherits SecureStateHeaderTemplate
-- Cryo2TeleAndPortMenuButton inherits SecureAnchorButtonTemplate
-- Cryolysis2.Private.HasPortMenuTeleport tracks which teleport spells the user has

	Cryo2TeleAndPortMenuButton:SetAttribute("*childraise*", true)
	Cryo2TeleAndPortMenuButton:SetAttribute("*childstate*", "^click")
	Cryo2PortMenu0:SetAttribute("statemap-anchor-click", "0-1")
	Cryo2TeleAndPortMenuButton:SetAttribute("anchorchild", Cryo2PortMenu0)
	
	local lastPortAdded = 0
	for i = 1, #(Cryolysis2.Private.HasPortMenuTeleport), 1 do
		local CurrPortMenu = getglobal(Cryolysis2.Private.PortMenu[i])
		if Cryolysis2.Private.HasPortMenuTeleport[i] then   
			if lastPortAdded == 0 then
				CurrPortMenu:ClearAllPoints()
				if Cryolysis2.db.profile.PortMenuGrowLeft == true then
					CurrPortMenu:SetPoint("CENTER", "Cryo2TeleAndPortMenuButton", "CENTER", -33 + Cryolysis2.db.profile.PortMenuOfsX, Cryolysis2.db.profile.PortMenuOfsY)
				else
					CurrPortMenu:SetPoint("CENTER", "Cryo2TeleAndPortMenuButton", "CENTER", 33 + Cryolysis2.db.profile.PortMenuOfsX, Cryolysis2.db.profile.PortMenuOfsY)
				end
				CurrPortMenu:SetAttribute("showstates", "!0,*")
				Cryo2PortMenu0:SetAttribute("addchild", CurrPortMenu)
				lastPortAdded = i
			else
				CurrPortMenu:ClearAllPoints()
				if Cryolysis2.db.profile.PortMenuGrowLeft == true then
					CurrPortMenu:SetPoint("CENTER", "Cryo2PortMenu"..lastPortAdded, "CENTER", -33, 0)
				else
					CurrPortMenu:SetPoint("CENTER", "Cryo2PortMenu"..lastPortAdded, "CENTER", 33, 0)
				end
				CurrPortMenu:SetAttribute("showstates", "!0,*")
				Cryo2PortMenu0:SetAttribute("addchild", CurrPortMenu)
				lastPortAdded = i
			end
		end
	end
end

------------------------------------------------------------------------------------------------------
-- Update attributes of the Teleport/Portal sub-buttons
------------------------------------------------------------------------------------------------------
function Cryolysis2:UpdatePortMenuAttributes()
	
	if Cryolysis2.Private.englishFaction == "Alliance" then
		if Cryolysis2.Private.HasPortMenuTeleport[1] then
			Cryo2PortMenu1Icon:SetTexture("Interface\\Icons\\Spell_Arcane_TeleportIronForge")
			Cryo2PortMenu1:SetAttribute("type1", "spell")
			Cryo2PortMenu1:SetAttribute("spell1", GetSpellInfo(Cryolysis2.Private.SpellId["Teleport: Ironforge"]))
			if Cryolysis2.Private.HasPortMenuPort[1] then
				Cryo2PortMenu1:SetAttribute("type2", "spell")
				Cryo2PortMenu1:SetAttribute("spell2", GetSpellInfo(Cryolysis2.Private.SpellId["Portal: Ironforge"]))
			end
		end
		if Cryolysis2.Private.HasPortMenuTeleport[2] then
			Cryo2PortMenu2Icon:SetTexture("Interface\\Icons\\Spell_Arcane_TeleportStormWind")
			Cryo2PortMenu2:SetAttribute("type1", "spell")
			Cryo2PortMenu2:SetAttribute("spell1", GetSpellInfo(Cryolysis2.Private.SpellId["Teleport: Stormwind"]))
			if Cryolysis2.Private.HasPortMenuPort[2] then
				Cryo2PortMenu2:SetAttribute("type2", "spell")
				Cryo2PortMenu2:SetAttribute("spell2", GetSpellInfo(Cryolysis2.Private.SpellId["Portal: Stormwind"]))
			end
		end
		if Cryolysis2.Private.HasPortMenuTeleport[3] then
			Cryo2PortMenu3Icon:SetTexture("Interface\\Icons\\Spell_Arcane_TeleportDarnassus")
			Cryo2PortMenu3:SetAttribute("type1", "spell")
			Cryo2PortMenu3:SetAttribute("spell1", GetSpellInfo(Cryolysis2.Private.SpellId["Teleport: Darnassus"]))
			if Cryolysis2.Private.HasPortMenuPort[3] then
				Cryo2PortMenu3:SetAttribute("type2", "spell")
				Cryo2PortMenu3:SetAttribute("spell2", GetSpellInfo(Cryolysis2.Private.SpellId["Portal: Darnassus"]))
			end
		end
		if Cryolysis2.Private.HasPortMenuTeleport[4] then
			Cryo2PortMenu4Icon:SetTexture("Interface\\Icons\\Spell_Arcane_TeleportExodar")
			Cryo2PortMenu4:SetAttribute("type1", "spell")
			Cryo2PortMenu4:SetAttribute("spell1", GetSpellInfo(Cryolysis2.Private.SpellId["Teleport: Exodar"]))
			if Cryolysis2.Private.HasPortMenuPort[4] then
				Cryo2PortMenu4:SetAttribute("type2", "spell")
				Cryo2PortMenu4:SetAttribute("spell2", GetSpellInfo(Cryolysis2.Private.SpellId["Portal: Exodar"]))
			end
		end
		if Cryolysis2.Private.HasPortMenuTeleport[5] then
			Cryo2PortMenu5Icon:SetTexture("Interface\\Icons\\Spell_Arcane_TeleportTheramore")
			Cryo2PortMenu5:SetAttribute("type1", "spell")
			Cryo2PortMenu5:SetAttribute("spell1", GetSpellInfo(Cryolysis2.Private.SpellId["Teleport: Theramore"]))
			if Cryolysis2.Private.HasPortMenuPort[5] then
				Cryo2PortMenu5:SetAttribute("type2", "spell")
				Cryo2PortMenu5:SetAttribute("spell2", GetSpellInfo(Cryolysis2.Private.SpellId["Portal: Theramore"]))
			end
		end
	end
	if Cryolysis2.Private.englishFaction == "Horde" then
		if Cryolysis2.Private.HasPortMenuTeleport[1] then
			Cryo2PortMenu1Icon:SetTexture("Interface\\Icons\\Spell_Arcane_TeleportOrgrimmar")
			Cryo2PortMenu1:SetAttribute("type1", "spell")
			Cryo2PortMenu1:SetAttribute("spell1", GetSpellInfo(Cryolysis2.Private.SpellId["Teleport: Orgrimmar"]))
			if Cryolysis2.Private.HasPortMenuPort[1] then
				Cryo2PortMenu1:SetAttribute("type2", "spell")
				Cryo2PortMenu1:SetAttribute("spell2", GetSpellInfo(Cryolysis2.Private.SpellId["Portal: Orgrimmar"]))
			end
		end
		if Cryolysis2.Private.HasPortMenuTeleport[2] then
			Cryo2PortMenu2Icon:SetTexture("Interface\\Icons\\Spell_Arcane_TeleportUnderCity")
			Cryo2PortMenu2:SetAttribute("type1", "spell")
			Cryo2PortMenu2:SetAttribute("spell1", GetSpellInfo(Cryolysis2.Private.SpellId["Teleport: Undercity"]))
			if Cryolysis2.Private.HasPortMenuPort[2] then
				Cryo2PortMenu2:SetAttribute("type2", "spell")
				Cryo2PortMenu2:SetAttribute("spell2", GetSpellInfo(Cryolysis2.Private.SpellId["Portal: Undercity"]))
			end
		end
		if Cryolysis2.Private.HasPortMenuTeleport[3] then
			Cryo2PortMenu3Icon:SetTexture("Interface\\Icons\\Spell_Arcane_TeleportThunderBluff")
			Cryo2PortMenu3:SetAttribute("type1", "spell")
			Cryo2PortMenu3:SetAttribute("spell1", GetSpellInfo(Cryolysis2.Private.SpellId["Teleport: Thunder Bluff"]))
			if Cryolysis2.Private.HasPortMenuPort[3] then
				Cryo2PortMenu3:SetAttribute("type2", "spell")
				Cryo2PortMenu3:SetAttribute("spell2", GetSpellInfo(Cryolysis2.Private.SpellId["Portal: Thunder Bluff"]))
			end
		end
		if Cryolysis2.Private.HasPortMenuTeleport[4] then
			Cryo2PortMenu4Icon:SetTexture("Interface\\Icons\\Spell_Arcane_TeleportSilvermoon")
			Cryo2PortMenu4:SetAttribute("type1", "spell")
			Cryo2PortMenu4:SetAttribute("spell1", GetSpellInfo(Cryolysis2.Private.SpellId["Teleport: Silvermoon"]))
			if Cryolysis2.Private.HasPortMenuPort[4] then
				Cryo2PortMenu4:SetAttribute("type2", "spell")
				Cryo2PortMenu4:SetAttribute("spell2", GetSpellInfo(Cryolysis2.Private.SpellId["Portal: Silvermoon"]))
			end
		end
		if Cryolysis2.Private.HasPortMenuTeleport[5] then
			Cryo2PortMenu5Icon:SetTexture("Interface\\Icons\\Spell_Arcane_TeleportStonard")
			Cryo2PortMenu5:SetAttribute("type1", "spell")
			Cryo2PortMenu5:SetAttribute("spell1", GetSpellInfo(Cryolysis2.Private.SpellId["Teleport: Stonard"]))
			if Cryolysis2.Private.HasPortMenuPort[5] then
				Cryo2PortMenu5:SetAttribute("type2", "spell")
				Cryo2PortMenu5:SetAttribute("spell2", GetSpellInfo(Cryolysis2.Private.SpellId["Portal: Stonard"]))
			end
		end
	end
	
	-- Both factions get this one!
	if Cryolysis2.Private.HasPortMenuTeleport[6] then
		Cryo2PortMenu6Icon:SetTexture("Interface\\Icons\\Spell_Arcane_TeleportShattrath")
		Cryo2PortMenu6:SetAttribute("type1", "spell")
		Cryo2PortMenu6:SetAttribute("spell1", GetSpellInfo(Cryolysis2.Private.SpellId["Teleport: Shattrath"]))
		if Cryolysis2.Private.HasPortMenuPort[6] then
			Cryo2PortMenu6:SetAttribute("type2", "spell")
			Cryo2PortMenu6:SetAttribute("spell2", GetSpellInfo(Cryolysis2.Private.SpellId["Portal: Shattrath"]))
		end
	end
end
