local L = LibStub("AceLocale-3.0"):GetLocale("Cryolysis2")
local Cryolysis2 = LibStub("AceAddon-3.0"):GetAddon("Cryolysis2")
 
--local candybar = AceLibrary("CandyBar-2.0")
--local waterfall = AceLibrary("Waterfall-1.0")

------------------------------------------------------------------------------------------------------
-- Setup main sphere and surrounding buttons
------------------------------------------------------------------------------------------------------
function Cryolysis2:SetupSphereAndButtons()
	
	-- Main Sphere
	Cryo2MainSphere:SetClampedToScreen(true)
	Cryo2MainSphere:SetAttribute("type2", "Menu")
	Cryo2MainSphere.Menu = function() 
		--InterfaceOptionsFrame_OpenToFrame(Cryolysis2.optionsFrame)
		
		local config = LibStub("AceConfig-3.0")
		local dialog = LibStub("AceConfigDialog-3.0")
		local registered = false;

		local options

		if not registered then
			options = options or Cryolysis2.options
			config:RegisterOptionsTable("Cryolysis", options)
			dialog:SetDefaultSize("Cryolysis", 600, 500)
			registered = true
		end

		dialog:Open("Cryolysis")

	end
	
	-- Evocation Button
	if Cryolysis2.Private.HasEvocation then
		Cryo2EvocButtonIcon:SetTexture("Interface\\Icons\\Spell_Nature_Purge")
		Cryo2EvocButton:SetAttribute("type*", "spell")
		Cryo2EvocButton:SetAttribute("spell*", GetSpellInfo(Cryolysis2.Private.SpellId["Evocation"]))
	end
	
	-- Right Custom Button
	Cryolysis2.UpdateCustomButtonAttributes("right")
	
	-- Left Custom Button
	Cryolysis2.UpdateCustomButtonAttributes("left")
	
	-- Spell Menu Button
	Cryo2BuffMenuButtonIcon:SetTexture("Interface\\Icons\\INV_Staff_13")
	
	-- Mount Button
	
	-- Teleport/Portal Menu Button
	if Cryolysis2.Private.HasATeleport or Cryolysis2.Private.HasAPort then
		Cryo2TeleAndPortMenuButtonIcon:SetTexture("Interface\\Icons\\Spell_Nature_AstralRecalGroup")
	end
	
	-- Bottom Custom Button
	Cryolysis2.UpdateCustomButtonAttributes("bottom")
	
	-- Spell Timer Frame
	--Cryo2TimerFrameText:SetPoint("TOP", Cryo2TimerFrame, "TOP", 0, -5)
	--Cryo2TimerFrameText:SetText(L["Spell Timers"])
	--candybar:RegisterCandyBarGroup("Timers")
	--candybar:SetCandyBarGroupPoint("Timers", "TOPLEFT", Cryo2TimerFrame, "TOPLEFT", 5, -20)
    --Timers = Cryolysis2:NewBarGroup("Spell Timers", "LEFT", 150, 13)
    --Timers:SetFlashPeriod(0)
	
end

------------------------------------------------------------------------------------------------------
-- Update attributes for the main sphere
------------------------------------------------------------------------------------------------------
function Cryolysis2:UpdateSphereAttributes()

	local MB = tonumber(Cryolysis2.db.profile.MainButton);
	
	if MB == 1 then
		Cryo2MainSphere:SetAttribute("type1", "macro")
		Cryo2MainSphere:SetAttribute("macrotext1", "")
	end
	if MB == 2 then
		Cryolysis2:EatAndDrinkUpdate()
	end
	if MB == 3 then
		Cryo2MainSphere:SetAttribute("type1", "spell")
		Cryo2MainSphere:SetAttribute("spell1", GetSpellInfo(Cryolysis2.Private.SpellId["Evocation"]))
	end
	if MB == 4 then
		Cryo2MainSphere:SetAttribute("type1", "spell")
		Cryo2MainSphere:SetAttribute("spell1", GetSpellInfo(Cryolysis2.Private.SpellId["Polymorph"]))
	end
	if MB == 5 then
		Cryo2MainSphere:SetAttribute("type1", "macro")
		local ManaGemMacroString = "/script UIErrorsFrame:Hide()\n"
		for i = #(Cryolysis2.Private.CanConjureGem), 1, -1 do
			if Cryolysis2.Private.CanConjureGem[i] == true then
				ManaGemMacroString = ManaGemMacroString.."/use "..Cryolysis2.Private.ManaGemName[i].."\n/stopcasting \n"
			end
		end
		ManaGemMacroString = ManaGemMacroString.."/script UIErrorsFrame:Clear(); UIErrorsFrame:Show()"
		Cryo2MainSphere:SetAttribute("macrotext1", ManaGemMacroString)
	end
	if MB == 6 then
		Cryo2MainSphere:SetAttribute("type1", "spell")
		Cryo2MainSphere:SetAttribute("spell1", GetSpellInfo(Cryolysis2.Private.SpellId["Blink"]))
	end

end

------------------------------------------------------------------------------------------------------
-- Update attributes for the outer sphere
------------------------------------------------------------------------------------------------------
function Cryolysis2:UpdateOuterSphere()
	
	local OS = tonumber(Cryolysis2.db.profile.OuterSphere);
	
	-- Update outer-sphere graphic based on the chosen attribute
	if OS == 1 then  -- Show nothing
		Cryo2MainSphere:SetNormalTexture("Interface\\Addons\\Cryolysis2\\UI\\Shard16.tga")
	end
	if OS == 2 then  -- Show health
		local ChosenAttrib = (UnitHealth("player")/UnitHealthMax("player"))*100  -- Get's the player's health %
		ChosenAttrib = floor(ChosenAttrib/6.25)								 -- Divide the health % by 6.25 and round down to see how many notches the fill
		Cryo2MainSphere:SetNormalTexture("Interface\\Addons\\Cryolysis2\\UI\\Shard"..ChosenAttrib..".tga")
	end
	if OS == 3 then  -- Show mana
		local ChosenAttrib = (UnitMana("player")/UnitManaMax("player"))*100  -- Get's the player's mana %
		ChosenAttrib = floor(ChosenAttrib/6.25)							 -- Divide the mana % by 6.25 and round down to see how many notches the fill
		Cryo2MainSphere:SetNormalTexture("Interface\\Addons\\Cryolysis2\\UI\\Shard"..ChosenAttrib..".tga")
	end
	if OS == 4 then  -- Show mana gem cooldown
	
		-- All cooldown tracking is handled by using custom events the reschedule themselves until the spell is ready to use again.
		-- This allows us to avoid constant polling of information.
	
	end
	if OS == 5 then  -- Show evocation cooldown
		
		-- All cooldown tracking is handled by using custom events the reschedule themselves until the spell is ready to use again.
		-- This allows us to avoid constant polling of information.
		
	end
end

------------------------------------------------------------------------------------------------------
-- Update attributes for the inner sphere
------------------------------------------------------------------------------------------------------
function Cryolysis2:UpdateInnerSphere()
	
	local IS = tonumber(Cryolysis2.db.profile.InnerSphere);
	
	-- Update inner-sphere text based on the chosen attribute
	-- 1 = none, 2 = food/drink, 3 = drink/food, 4 = Curr Health, 5 = Health %, 6 = Curr Mana, 7 = Mana %, 8 = Mana Gem CD, 9 = Evocation CD
	if IS == 1 then
		Cryo2MainSphereText:SetText("")
	end
	if IS == 2 then
		Cryo2MainSphereText:SetTextColor(1, 1, 1, 1)
		Cryo2MainSphereText:SetText((Cryolysis2.CountFood()).."/"..(Cryolysis2.CountWater()))
	end
	if IS == 3 then
		Cryo2MainSphereText:SetTextColor(1, 1, 1, 1)
		Cryo2MainSphereText:SetText((Cryolysis2.CountWater()).."/"..(Cryolysis2.CountFood()))
	end
	if IS == 4 then
		local temphealth = UnitHealth("player")/UnitHealthMax("player")
		if temphealth >=0 and temphealth <=.5 then
			Cryo2MainSphereText:SetTextColor(1, temphealth*2, 0, 1)
		else
			Cryo2MainSphereText:SetTextColor((1-temphealth)*2, 1, 0, 1)
		end
		Cryo2MainSphereText:SetText(UnitHealth("player"))
	end
	if IS == 5 then
		local temphealth = UnitHealth("player")/UnitHealthMax("player")
		if temphealth >=0 and temphealth <=.50 then
			Cryo2MainSphereText:SetTextColor(1, temphealth*2, 0, 1)
		else
			Cryo2MainSphereText:SetTextColor((1-temphealth)*2, 1, 0, 1)
		end
		temphealth = temphealth*100
		Cryo2MainSphereText:SetText(floor(temphealth).."%")
	end
	if IS == 6 then
		Cryo2MainSphereText:SetTextColor(1, 1, 1, 1)
		Cryo2MainSphereText:SetText(UnitMana("player"))
	end
	if IS == 7 then
		Cryo2MainSphereText:SetTextColor(1, 1, 1, 1)
		local tempmana = UnitMana("player")/UnitManaMax("player")
		tempmana = tempmana*100
		Cryo2MainSphereText:SetText(floor(tempmana).."%")
	end
	if IS == 8 then
		-- All cooldown tracking is handled by using custom events the reschedule themselves until the spell is ready to use again.
		-- This allows us to avoid constant polling of information.
		Cryolysis2:Cryo2_UpdateManaGemCooldown()
	end
	if IS == 9 then
		-- All cooldown tracking is handled by using custom events the reschedule themselves until the spell is ready to use again.
		-- This allows us to avoid constant polling of information.
		Cryolysis2:Cryo2_UpdateEvocationCooldown()
	end
	
end

------------------------------------------------------------------------------------------------------
-- Function for setting Eat and Drink functionality on the main sphere
------------------------------------------------------------------------------------------------------
function Cryolysis2:EatAndDrinkUpdate()

	if tonumber(Cryolysis2.db.profile.MainButton) == 2 then
		Cryolysis2.WaterOnHand()
		Cryolysis2.FoodOnHand()
		Cryo2MainSphere:SetAttribute("type1", "macro")
		if GetItemCount(GetItemInfo(34062)) > 0 then	-- Conjured Manna Biscuit
			Cryo2MainSphere:SetAttribute("macrotext1", "/use "..GetItemInfo(34062)) -- If the mage has manna biscuits, only use 1 at a time...not 2 :)
		else
			if Cryolysis2.Private.HighestWaterOnHand > 0 and Cryolysis2.Private.HighestFoodOnHand > 0 then
				Cryo2MainSphere:SetAttribute("macrotext1", "/use "..GetItemInfo(Cryolysis2.Private.WaterItemId[Cryolysis2.Private.HighestWaterOnHand]).."\n/use "..GetItemInfo(Cryolysis2.Private.FoodItemId[Cryolysis2.Private.HighestFoodOnHand]))
			end
			if Cryolysis2.Private.HighestWaterOnHand > 0 and Cryolysis2.Private.HighestFoodOnHand == 0 then
				Cryo2MainSphere:SetAttribute("macrotext1", "/use "..GetItemInfo(Cryolysis2.Private.WaterItemId[Cryolysis2.Private.HighestWaterOnHand]))
			end
			if Cryolysis2.Private.HighestWaterOnHand == 0 and Cryolysis2.Private.HighestFoodOnHand > 0 then
				Cryo2MainSphere:SetAttribute("macrotext1", "/use "..GetItemInfo(Cryolysis2.Private.FoodItemId[Cryolysis2.Private.HighestFoodOnHand]))
			end
			if Cryolysis2.Private.HighestWaterOnHand == 0 and Cryolysis2.Private.HighestFoodOnHand == 0 then
				Cryo2MainSphere:SetAttribute("macrotext1", "")
			end
		end
	end
end