local L = LibStub("AceLocale-3.0"):GetLocale("Cryolysis2")
local Cryolysis2 = LibStub("AceAddon-3.0"):GetAddon("Cryolysis2")
 
------------------------------------------------------------------------------------------------------
-- Update properties of the right button
------------------------------------------------------------------------------------------------------
function Cryolysis2:UpdateRightButton(click)
	
	local actionName, ID, RightTex

	if click == 1 then
		actionName = Cryolysis2.db.profile.RightSpellLeft
	end
	if click == 2 then
		actionName = Cryolysis2.db.profile.RightSpellRight
	end
	if click == 3 then
		actionName = Cryolysis2.db.profile.RightSpellMid
	end
	
	-- Workaround for this not being set properly by the other function
	Cryo2RightCustomButton:SetAttribute("*type*", Cryolysis2.db.profile.RightCustomButtonType)
		
	if actionName == nil or actionName == "" then
		if click == 1 then
			Cryo2RightCustomButtonIcon:SetTexture(nil)
		end
		Cryo2RightCustomButton:SetAttribute(Cryolysis2.db.profile.RightCustomButtonType..click, actionName)
	else
		if Cryolysis2.db.profile.RightCustomButtonType == "spell" then
			ID = Cryolysis2:FindSpellID(""..actionName, BOOKTYPE_SPELL)
			if ID > 0 then
				RightTex = GetSpellTexture(ID, BOOKTYPE_SPELL)
			else
				Cryolysis2:Print(L["Invalid name, please check your spelling and try again!"])
				return false;
			end
		end
		if Cryolysis2.db.profile.RightCustomButtonType == "macro" then
			ID = GetMacroIndexByName(actionName)
			if ID > 0 then
				_, RightTex = GetMacroInfo(ID)
			else
				Cryolysis2:Print(L["Invalid name, please check your spelling and try again!"])
				return false;
			end
		end
		if Cryolysis2.db.profile.RightCustomButtonType == "item" then
			if GetItemInfo(actionName) then
				_, _, _, _, _, _, _, _, _, RightTex = GetItemInfo(actionName)
			else
				Cryolysis2:Print(L["Invalid name, please check your spelling and try again!"])
				return false;
			end
		end


		if click == 1 then
			Cryo2RightCustomButtonIcon:SetTexture(RightTex)
		end
		Cryo2RightCustomButton:SetAttribute(Cryolysis2.db.profile.RightCustomButtonType..click, actionName)
		if click == 3 then
			Cryo2RightCustomButton:SetAttribute("alt-"..Cryolysis2.db.profile.RightCustomButtonType.."*", "")
			Cryo2RightCustomButton:SetAttribute("shift-"..Cryolysis2.db.profile.RightCustomButtonType.."*", "")
			Cryo2RightCustomButton:SetAttribute("ctrl-"..Cryolysis2.db.profile.RightCustomButtonType.."*", "")
			
			Cryo2RightCustomButton:SetAttribute(Cryolysis2.db.profile.MiddleKey.."-"..Cryolysis2.db.profile.RightCustomButtonType.."*", actionName)
		end
	end
end