local L = LibStub("AceLocale-3.0"):GetLocale("Cryolysis2")
local Cryolysis2 = LibStub("AceAddon-3.0"):GetAddon("Cryolysis2")
 
------------------------------------------------------------------------------------------------------
-- Update attribute of the Mana Gem button
------------------------------------------------------------------------------------------------------
function Cryolysis2:UpdateManaGemButton()

	Cryo2ManaGemButton:SetAttribute("*childraise3", true)
	Cryo2ManaGemButton:SetAttribute("*childstate3", "^click")
	
	Cryo2ManaGemButton:SetAttribute("alt-childraise*", false)
	Cryo2ManaGemButton:SetAttribute("alt-childstate*", "")
	Cryo2ManaGemButton:SetAttribute("shift-childraise*", false)
	Cryo2ManaGemButton:SetAttribute("shift-childstate*", "")
	Cryo2ManaGemButton:SetAttribute("ctrl-childraise*", false)
	Cryo2ManaGemButton:SetAttribute("ctrl-childstate*", "")
	
	Cryo2ManaGemButton:SetAttribute(Cryolysis2.db.profile.MiddleKey.."-childraise*", true)
	Cryo2ManaGemButton:SetAttribute(Cryolysis2.db.profile.MiddleKey.."-childstate*", "^click")
	
	Cryo2GemMenu0:SetAttribute("statemap-anchor-click", "0-1")
	Cryo2ManaGemButton:SetAttribute("anchorchild", Cryo2GemMenu0)

	local lastGemAdded = 0
	for i = 1, #(Cryolysis2.Private.CanConjureGem), 1 do
		local CurrGemMenu = getglobal(Cryolysis2.Private.GemMenu[i])
		if Cryolysis2.Private.CanConjureGem[i] then
			if lastGemAdded == 0 then
				CurrGemMenu:ClearAllPoints()
				if Cryolysis2.db.profile.GemMenuGrowLeft == true then
					CurrGemMenu:SetPoint("CENTER", "Cryo2ManaGemButton", "CENTER", -33 + Cryolysis2.db.profile.GemMenuOfsX, Cryolysis2.db.profile.GemMenuOfsY)
				else
					CurrGemMenu:SetPoint("CENTER", "Cryo2ManaGemButton", "CENTER", 33 + Cryolysis2.db.profile.GemMenuOfsX, Cryolysis2.db.profile.GemMenuOfsY)
				end
				CurrGemMenu:SetAttribute("showstates", "!0,*")
				Cryo2GemMenu0:SetAttribute("addchild", CurrGemMenu)
				lastGemAdded = i
			else
				CurrGemMenu:ClearAllPoints()
				if Cryolysis2.db.profile.GemMenuGrowLeft == true then
					CurrGemMenu:SetPoint("CENTER", "Cryo2GemMenu"..lastGemAdded, "CENTER", -33, 0)
				else
					CurrGemMenu:SetPoint("CENTER", "Cryo2GemMenu"..lastGemAdded, "CENTER", 33, 0)
				end
				CurrGemMenu:SetAttribute("showstates", "!0,*")
				Cryo2GemMenu0:SetAttribute("addchild", CurrGemMenu)
				lastGemAdded = i
			end
		end
	end

	for i = 1, #(Cryolysis2.Private.GemMenu), 1 do
	local CurrGemMenu = getglobal(Cryolysis2.Private.GemMenu[i])
	local CurrGemMenuIcon = getglobal(Cryolysis2.Private.GemMenu[i].."Icon")
	CurrGemMenuIcon:SetTexture("Interface\\Icons\\"..Cryolysis2.Private.ManaGemTex[i])
		if not Cryolysis2.Private.InCombat then
			CurrGemMenu:SetAttribute("type1", "item")
			CurrGemMenu:SetAttribute("item1", GetItemInfo(Cryolysis2.Private.ManaGemId[i]))
			CurrGemMenu:SetAttribute("type2", "spell")
			local spName = GetSpellInfo(Cryolysis2.Private.SpellId[Cryolysis2.Private.ConjureGemName[i]])
			CurrGemMenu:SetAttribute("spell2", spName)
		end
	end

	
	for i = 1, #(Cryolysis2.Private.CanConjureGem), 1 do
		if Cryolysis2.Private.CanConjureGem[i] and not Cryolysis2.Private.HasManaGem[i] then
			if not Cryolysis2.Private.InCombat then
				Cryo2ManaGemButton:SetAttribute("type2", "spell")
				Cryo2ManaGemButton:SetAttribute("spell2", GetSpellInfo(Cryolysis2.Private.SpellId[Cryolysis2.Private.ConjureGemName[i]]))
			end
		end
	end

	Cryo2ManaGemButton:SetAttribute("type1", "macro")
	local gName
	local ManaGemMacroString = "/script UIErrorsFrame:Hide()\n"
	for i = #(Cryolysis2.Private.HasManaGem), 1, -1 do
		if Cryolysis2.Private.HasManaGem[i] == true then
			gName = GetItemInfo(Cryolysis2.Private.ManaGemId[i]);
			ManaGemMacroString = ManaGemMacroString.."/use "..gName.."\n/stopcasting \n"
		end
	end
	ManaGemMacroString = ManaGemMacroString.."/script UIErrorsFrame:Clear(); UIErrorsFrame:Show()"
	if not Cryolysis2.Private.InCombat then
		Cryo2ManaGemButton:SetAttribute("macrotext1", ManaGemMacroString)
	end

	
	if Cryolysis2.Private.ManaGemCooldownBool == false then
		Cryolysis2:ScheduleTimer("Cryo2_UpdateManaGemCooldown", 0)
	end

end

------------------------------------------------------------------------------------------------------
-- Update icon of the Mana Gem buttons
------------------------------------------------------------------------------------------------------
function Cryolysis2:UpdateManaGemIcons()

	for i = 1, #(Cryolysis2.Private.HasManaGem), 1 do
		local CurrGemMenuIcon = getglobal(Cryolysis2.Private.GemMenu[i].."Icon")
		if GetItemCount(GetItemInfo(Cryolysis2.Private.ManaGemId[i])) > 0 then
			Cryolysis2.Private.HasManaGem[i] = true
			Cryolysis2.Private.HighestManaGemOnHand = i
			CurrGemMenuIcon:SetDesaturated(nil)
		else
			Cryolysis2.Private.HasManaGem[i] = false
			CurrGemMenuIcon:SetDesaturated(1)
		end
	end
	
	if not Cryolysis2.Private.HasManaGem[1] and
		not Cryolysis2.Private.HasManaGem[2] and
		not Cryolysis2.Private.HasManaGem[3] and
		not Cryolysis2.Private.HasManaGem[4] and
		not Cryolysis2.Private.HasManaGem[5]
	then
		Cryolysis2.Private.HighestManaGemOnHand = 0
	end
	
	if Cryolysis2.Private.HighestManaGemOnHand > 0 then
		Cryo2ManaGemButtonIcon:SetTexture("Interface\\Icons\\"..Cryolysis2.Private.ManaGemTex[Cryolysis2.Private.HighestManaGemOnHand])
		Cryo2ManaGemButtonIcon:SetDesaturated(nil)
	elseif Cryolysis2.Private.HighestManaGemId > 0 then
		Cryo2ManaGemButtonIcon:SetTexture("Interface\\Icons\\"..Cryolysis2.Private.ManaGemTex[Cryolysis2.Private.HighestManaGemId])
		Cryo2ManaGemButtonIcon:SetDesaturated(1)
	end
	
	Cryolysis2:Cryo2_UpdateManaGemCooldown()

end
