local L = LibStub("AceLocale-3.0"):GetLocale("Cryolysis2")
local Cryolysis2 = LibStub("AceAddon-3.0"):GetAddon("Cryolysis2")
 
------------------------------------------------------------------------------------------------------
-- Update properties of the left button
------------------------------------------------------------------------------------------------------
function Cryolysis2:UpdateLeftButton(click)
	
	local actionName, ID, LeftTex

	if click == 1 then
		actionName = Cryolysis2.db.profile.LeftSpellLeft
	end
	if click == 2 then
		actionName = Cryolysis2.db.profile.LeftSpellRight
	end
	if click == 3 then
		actionName = Cryolysis2.db.profile.LeftSpellMid
	end

	-- Workaround for this not being set properly by the other function
	Cryo2LeftCustomButton:SetAttribute("*type*", Cryolysis2.db.profile.LeftCustomButtonType)
	
	if actionName == nil or actionName == "" then
		if click == 1 then
			Cryo2LeftCustomButtonIcon:SetTexture(nil)
		end
		Cryo2LeftCustomButton:SetAttribute(Cryolysis2.db.profile.LeftCustomButtonType..click, actionName)
	else
		if Cryolysis2.db.profile.LeftCustomButtonType == "spell" then
			ID = Cryolysis2:FindSpellID(""..actionName, BOOKTYPE_SPELL)
			if ID > 0 then
				LeftTex = GetSpellTexture(ID, BOOKTYPE_SPELL)
			else
				Cryolysis2:Print(L["Invalid name, please check your spelling and try again!"])
				return false;
			end
		end
		if Cryolysis2.db.profile.LeftCustomButtonType == "macro" then
			ID = GetMacroIndexByName(actionName)
			if ID > 0 then
				_, LeftTex = GetMacroInfo(ID)
			else
				Cryolysis2:Print(L["Invalid name, please check your spelling and try again!"])
				return false;
			end
		end
		if Cryolysis2.db.profile.LeftCustomButtonType == "item" then
			if GetItemInfo(actionName) then
				_, _, _, _, _, _, _, _, _, LeftTex = GetItemInfo(actionName)
			else
				Cryolysis2:Print(L["Invalid name, please check your spelling and try again!"])
				return false;
			end
		end

		if click == 1 then
			Cryo2LeftCustomButtonIcon:SetTexture(LeftTex)
		end
		Cryo2LeftCustomButton:SetAttribute(Cryolysis2.db.profile.LeftCustomButtonType..click, actionName)
		if click == 3 then
			Cryo2LeftCustomButton:SetAttribute("alt-"..Cryolysis2.db.profile.LeftCustomButtonType.."*", "")
			Cryo2LeftCustomButton:SetAttribute("shift-"..Cryolysis2.db.profile.LeftCustomButtonType.."*", "")
			Cryo2LeftCustomButton:SetAttribute("ctrl-"..Cryolysis2.db.profile.LeftCustomButtonType.."*", "")
			
			Cryo2LeftCustomButton:SetAttribute(Cryolysis2.db.profile.MiddleKey.."-"..Cryolysis2.db.profile.LeftCustomButtonType.."*", actionName)
		end
	end
end
