local L = LibStub("AceLocale-3.0"):GetLocale("Cryolysis2")
local Cryolysis2 = LibStub("AceAddon-3.0"):GetAddon("Cryolysis2")
 
------------------------------------------------------------------------------------------------------
-- Update the properties of the food button
------------------------------------------------------------------------------------------------------
function Cryolysis2:UpdateFoodButton()
	
	Cryolysis2:FoodOnHand()
	
	local foodamount = Cryolysis2:CountFood()
	
	if Cryolysis2.db.profile.ShowFoodCountText == true then
		if foodamount == 0 then
			Cryo2FoodButtonText:SetText("")
		else
			Cryo2FoodButtonText:SetText(foodamount)
		end
	end
	
	Cryo2FoodButton:SetAttribute("type1", "item")
	
	if Cryolysis2.Private.CanConjureFood then
		if Cryolysis2.Private.HighestFoodOnHand > 0 then
			Cryo2FoodButton:SetAttribute("item1", GetItemInfo(Cryolysis2.Private.FoodItemId[Cryolysis2.Private.HighestFoodOnHand]))
			Cryo2FoodButtonIcon:SetTexture("Interface\\Icons\\"..Cryolysis2.Private.FoodTex[Cryolysis2.Private.HighestFoodOnHand])
		else
			Cryo2FoodButtonIcon:SetTexture("Interface\\Icons\\"..Cryolysis2.Private.FoodTex[Cryolysis2.Private.HighestFoodId])
		end
		Cryo2FoodButton:SetAttribute("type2", "spell")
		Cryo2FoodButton:SetAttribute("spell2", GetSpellInfo(Cryolysis2.Private.FoodSpellId[Cryolysis2.Private.HighestFoodId]))
		if Cryolysis2.Private.HasRitual then
			Cryo2FoodButton:SetAttribute("shift-type2", "spell")
			Cryo2FoodButton:SetAttribute("shift-spell2", GetSpellInfo(Cryolysis2.Private.SpellId["Ritual of Refreshment"]))
		end
		Cryo2FoodButton:SetAttribute("type3", "Trade")
		
		Cryo2FoodButton:SetAttribute("alt-type*", "")
		Cryo2FoodButton:SetAttribute("shift-type*", "")
		Cryo2FoodButton:SetAttribute("ctrl-type*", "")
		
		Cryo2FoodButton:SetAttribute(Cryolysis2.db.profile.MiddleKey.."-type*", "Trade")
		
		Cryo2FoodButton.Trade = function() Cryolysis2:TradeFood() end
	end
	
	if foodamount == 0 then
		Cryo2FoodButtonIcon:SetDesaturated(1)
	elseif foodamount > 0 and InCombatLockdown() ~= 1 then
		Cryo2FoodButtonIcon:SetDesaturated(nil)
	end
	
end
