local Cryolysis2 = LibStub("AceAddon-3.0"):GetAddon("Cryolysis2")

------------------------------------------------------------------------------------------------------
-- Save position of the anchors
------------------------------------------------------------------------------------------------------
function Cryolysis2:SaveAnchorPosition()

	Cryolysis2.db.profile.MSx, Cryolysis2.db.profile.MSy = Cryo2MainSphere:GetCenter()
	Cryolysis2.db.profile.MSx = Cryolysis2.db.profile.MSx * Cryo2MainSphere:GetEffectiveScale()
	Cryolysis2.db.profile.MSy = Cryolysis2.db.profile.MSy * Cryo2MainSphere:GetEffectiveScale()
end

------------------------------------------------------------------------------------------------------
-- Load position of the anchors
------------------------------------------------------------------------------------------------------
function Cryolysis2:LoadAnchorPosition()

	local s = Cryo2MainSphere:GetEffectiveScale()
	Cryo2MainSphere:ClearAllPoints()
	Cryo2MainSphere:SetPoint("CENTER", UIParent, "BOTTOMLEFT", Cryolysis2.db.profile.MSx/s, Cryolysis2.db.profile.MSy/s)

end

------------------------------------------------------------------------------------------------------
-- Update position of all the buttons
------------------------------------------------------------------------------------------------------
function Cryolysis2:UpdateAllButtonPositions()

	local indexScale = -18
	local NBRScale = 1.1 --(1 + (Cryolysis2.db.profile.MainSphereScale - .85))
--~ 	if Cryolysis2.db.profile.MainSphereScale <= Cryolysis2.db.profile.ButtonScale then
--~ 		NBRScale = 1.1
--~ 	end

	Cryo2MainSphere:SetScale(Cryolysis2.db.profile.MainSphereScale)
	Cryolysis2.LoadAnchorPosition()

	for index=1, #(Cryolysis2.db.profile.Buttons), 1 do
		local f = getglobal(Cryolysis2.db.profile.Buttons[index])
		if Cryolysis2.db.profile.LockButtons then
			f:ClearAllPoints()
			f:SetPoint("CENTER", "Cryo2MainSphere", "CENTER", ((40 * NBRScale) * cos(Cryolysis2.db.profile.Angle-indexScale)), ((40 * NBRScale) * sin(Cryolysis2.db.profile.Angle-indexScale)))
		end
		f:SetScale(Cryolysis2.db.profile.ButtonScale)
		indexScale = indexScale + 36
	end
end

------------------------------------------------------------------------------------------------------
-- Update sizes of all buttons, but at the moment here be dragons.
------------------------------------------------------------------------------------------------------
function Cryolysis2:UpdateAllButtonSizes()

	--Cryo2FoodButton:SetScale(Cryolysis2.db.profile.FoodButtonScale)
	--Cryo2WaterButton:SetScale(Cryolysis2.db.profile.WaterButtonScale)
	--Cryo2MountButton:SetScale(Cryolysis2.db.profile.MountButtonScale)
	--Cryo2ManaGemButton:SetScale(Cryolysis2.db.profile.ManaGemButtonScale)
	--Cryo2LeftCustomButton:SetScale(Cryolysis2.db.profile.LeftCustomButtonScale)
	--Cryo2RightCustomButton:SetScale(Cryolysis2.db.profile.RightCustomButtonScale)
	--Cryo2EvocButton:SetScale(Cryolysis2.db.profile.EvocationButtonScale)
	--Button:SetScale(Cryolysis2.db.profile.SpellButtonScale)
	--Cryo2TeleAndPortMenuButton:SetScale(Cryolysis2.db.profile.TeleAndPortButtonScale)
	--Cryo2BottomCustomButton:SetScale(Cryolysis2.db.profile.BottomCustomButtonScale)
	--Cryo2MainSphere:SetWidth(Cryolysis2.db.profile.MainSphereRadius * Cryolysis2.db.profile.MainSphereScale)
	--Cryo2FoodButton:SetWidth(Cryolysis2.db.profile.DefaultButtonRadius * Cryolysis2.db.profile.FoodButtonScale)
	--Cryo2WaterButton:SetWidth(Cryolysis2.db.profile.DefaultButtonRadius * Cryolysis2.db.profile.WaterButtonScale)
	--Cryo2MountButton:SetWidth(Cryolysis2.db.profile.DefaultButtonRadius * Cryolysis2.db.profile.MountButtonScale)
	--Cryo2ManaGemButton:SetWidth(Cryolysis2.db.profile.DefaultButtonRadius * Cryolysis2.db.profile.ManaGemButtonScale)
	--Cryo2LeftCustomButton:SetWidth(Cryolysis2.db.profile.DefaultButtonRadius * Cryolysis2.db.profile.LeftButtonScale)
	--Cryo2RightCustomButton:SetWidth(Cryolysis2.db.profile.DefaultButtonRadius * Cryolysis2.db.profile.RightButtonScale)
	--Cryo2EvocButton:SetWidth(Cryolysis2.db.profile.DefaultButtonRadius * Cryolysis2.db.profile.EvocationButtonScale)
	
	--Cryo2MainSphere:SetHeight(Cryolysis2.db.profile.MainSphereRadius * Cryolysis2.db.profile.MainSphereScale)
	--Cryo2FoodButton:SetHeight(Cryolysis2.db.profile.DefaultButtonRadius * Cryolysis2.db.profile.FoodButtonScale)
	--Cryo2WaterButton:SetHeight(Cryolysis2.db.profile.DefaultButtonRadius * Cryolysis2.db.profile.WaterButtonScale)
	--Cryo2MountButton:SetHeight(Cryolysis2.db.profile.DefaultButtonRadius * Cryolysis2.db.profile.MountButtonScale)
	--Cryo2ManaGemButton:SetHeight(Cryolysis2.db.profile.DefaultButtonRadius * Cryolysis2.db.profile.ManaGemButtonScale)
	--Cryo2LeftCustomButton:SetHeight(Cryolysis2.db.profile.DefaultButtonRadius * Cryolysis2.db.profile.LeftButtonScale)
	--Cryo2RightCustomButton:SetHeight(Cryolysis2.db.profile.DefaultButtonRadius * Cryolysis2.db.profile.RightButtonScale)
	--Cryo2EvocButton:SetHeight(Cryolysis2.db.profile.DefaultButtonRadius * Cryolysis2.db.profile.EvocationButtonScale)

end

------------------------------------------------------------------------------------------------------
-- Moves the button up the array by 1 spot
-- button = a string
------------------------------------------------------------------------------------------------------
function Cryolysis2:IncrementButton(button)
	
	local buttonswap
	local buttonIndex
   
	for i = 1, #(Cryolysis2.db.profile.Buttons), 1 do
		if Cryolysis2.db.profile.Buttons[i] == button then
			buttonIndex = i
			break;
		end
	end
	
	if buttonIndex < 10 then
		buttonswap = Cryolysis2.db.profile.Buttons[buttonIndex+1]
		Cryolysis2.db.profile.Buttons[buttonIndex+1] = Cryolysis2.db.profile.Buttons[buttonIndex]
		Cryolysis2.db.profile.Buttons[buttonIndex] = buttonswap
	elseif buttonIndex == 10 then
		buttonswap = Cryolysis2.db.profile.Buttons[1]
		Cryolysis2.db.profile.Buttons[1] = Cryolysis2.db.profile.Buttons[buttonIndex]
		Cryolysis2.db.profile.Buttons[buttonIndex] = buttonswap
	end
	
	Cryolysis2.UpdateAllButtonPositions()
	
end

------------------------------------------------------------------------------------------------------
-- Update attributes of the three custom buttons
------------------------------------------------------------------------------------------------------
function Cryolysis2:UpdateCustomButtonAttributes(button)
	if button == "left" then
		Cryo2LeftCustomButton:SetAttribute("type*", Cryolysis2.db.profile.LeftCustomButtonType)
	end
	
	if button == "right" then
		Cryo2RightCustomButton:SetAttribute("type*", Cryolysis2.db.profile.RightCustomButtonType)
	end
	
	if button == "bottom" then
		Cryo2BottomCustomButton:SetAttribute("type*", Cryolysis2.db.profile.BottomCustomButtonType)
	end
end

------------------------------------------------------------------------------------------------------
-- Sets the hide/show attributes on various buttons based on configuration
------------------------------------------------------------------------------------------------------
function Cryolysis2:UpdateHideShow()

	if Cryolysis2.db.profile.MSHide then
		Cryo2MainSphere:Hide()
	else
		Cryo2MainSphere:Show()
	end
	
	if Cryolysis2.db.profile.FoodHide or not Cryolysis2.Private.CanConjureFood then
		Cryo2FoodButton:Hide()
	else
		Cryo2FoodButton:Show()
	end

	if Cryolysis2.db.profile.WaterHide or not Cryolysis2.Private.CanConjureWater then
		Cryo2WaterButton:Hide()
	else
		Cryo2WaterButton:Show()
	end
	
	if Cryolysis2.db.profile.GemHide or not Cryolysis2.Private.CanConjureGem[1] then
		Cryo2ManaGemButton:Hide()
	else
		Cryo2ManaGemButton:Show()
	end
	
	if Cryolysis2.db.profile.EvocHide or not Cryolysis2.Private.HasEvocation then
		Cryo2EvocButton:Hide()
	else
		Cryo2EvocButton:Show()
	end
	
	if Cryolysis2.db.profile.PortHide or (not Cryolysis2.Private.HasATeleport and not Cryolysis2.Private.HasAPort) then
		Cryo2TeleAndPortMenuButton:Hide()
	else
		Cryo2TeleAndPortMenuButton:Show()
	end
	
	if Cryolysis2.db.profile.BuffHide then
		Cryo2BuffMenuButton:Hide()
	else
		Cryo2BuffMenuButton:Show()
	end
	
	if Cryolysis2.db.profile.MountHide then
		Cryo2MountButton:Hide()
	else
		Cryo2MountButton:Show()
	end
	
	if Cryolysis2.db.profile.LeftHide then
		Cryo2LeftCustomButton:Hide()
	else
		Cryo2LeftCustomButton:Show()
	end
	
	if Cryolysis2.db.profile.RightHide then
		Cryo2RightCustomButton:Hide()
	else
		Cryo2RightCustomButton:Show()
	end
	
	if Cryolysis2.db.profile.BottomHide then
		Cryo2BottomCustomButton:Hide()
	else
		Cryo2BottomCustomButton:Show()
	end
end

------------------------------------------------------------------------------------------------------
-- Set hide/show of the menus of the various buttons based on what you click
------------------------------------------------------------------------------------------------------
function Cryolysis2:UpdateHideShowMenus()

	for i=1, #(Cryolysis2.Private.HasSpellMenuBuff), 1 do
		local f = getglobal(Cryolysis2.Private.BuffMenu[i])
		if Cryolysis2.Private.HasSpellMenuBuff[i] == false then
			f:Hide()
		else
			f:Show()
		end
	end
	
	for i=1, #(Cryolysis2.Private.PortMenu), 1 do
		local f = getglobal(Cryolysis2.Private.PortMenu[i])
		if Cryolysis2.Private.HasPortMenuTeleport[i] == false and Cryolysis2.Private.HasPortMenuPort[i] == false then
			f:Hide()
		else
			f:Show()
		end
	end
	
	for i=1, #(Cryolysis2.Private.CanConjureGem), 1 do
		local f = getglobal(Cryolysis2.Private.GemMenu[i])
		if Cryolysis2.Private.CanConjureGem[i] == false then
			f:Hide()
		else
			f:Show()
		end
	end
	
end

------------------------------------------------------------------------------------------------------
-- Set hide/show Light Feather count
------------------------------------------------------------------------------------------------------
function Cryolysis2:ShowHideFeatherCount()

	if Cryolysis2.db.profile.ShowFeatherCountText == true then
		Cryo2BuffMenu7Text:SetText(GetItemCount(GetItemInfo(Cryolysis2.Private.ReagentId["Light Feather"])))
	else
		Cryo2BuffMenu7Text:SetText("")
	end
	
end

------------------------------------------------------------------------------------------------------
-- Set hide/show Arcane Powder count
------------------------------------------------------------------------------------------------------
function Cryolysis2:ShowHideArcanePowderCount()

	if Cryolysis2.db.profile.ShowPowderCountText == true then
		Cryo2BuffMenu2Text:SetText(GetItemCount(GetItemInfo(Cryolysis2.Private.ReagentId["Arcane Powder"])))
	else
		Cryo2BuffMenu2Text:SetText("")
	end
	
end

