local L = LibStub("AceLocale-3.0"):GetLocale("Cryolysis2")
local Cryolysis2 = LibStub("AceAddon-3.0"):GetAddon("Cryolysis2")
 
------------------------------------------------------------------------------------------------------
-- Update spell button attributes
------------------------------------------------------------------------------------------------------
function Cryolysis2:UpdateBuffMenuAttributes()
	-- Armor Button
	if Cryolysis2.Private.HasIceArmor == false and Cryolysis2.Private.HasFrostArmor then
		Cryo2BuffMenu1:SetAttribute("type1", "spell")
		Cryo2BuffMenu1:SetAttribute("spell1", GetSpellInfo(Cryolysis2.Private.SpellId["Frost Armor"]))
	elseif Cryolysis2.Private.HasIceArmor and Cryolysis2.Private.HasFrostArmor then
		Cryo2BuffMenu1:SetAttribute("type1", "spell")
		Cryo2BuffMenu1:SetAttribute("spell1", GetSpellInfo(Cryolysis2.Private.SpellId["Ice Armor"]))
	end
	Cryo2BuffMenu1Icon:SetTexture("Interface\\Icons\\Spell_Frost_FrostArmor02")
	
	if Cryolysis2.Private.HasMageArmor then
		Cryo2BuffMenu1:SetAttribute("type2", "spell")
		Cryo2BuffMenu1:SetAttribute("spell2", GetSpellInfo(Cryolysis2.Private.SpellId["Mage Armor"]))
	end
	
	if Cryolysis2.Private.HasMoltenArmor then
		Cryo2BuffMenu1:SetAttribute("type3", "spell")
		Cryo2BuffMenu1:SetAttribute("spell3", GetSpellInfo(Cryolysis2.Private.SpellId["Molten Armor"]))
		
		Cryo2BuffMenu1:SetAttribute("alt-type*", "")
		Cryo2BuffMenu1:SetAttribute("alt-spell*", "")
		Cryo2BuffMenu1:SetAttribute("shift-type*", "")
		Cryo2BuffMenu1:SetAttribute("shift-spell*", "")
		Cryo2BuffMenu1:SetAttribute("ctrl-type*", "")
		Cryo2BuffMenu1:SetAttribute("ctrl-spell*", "")
		
		Cryo2BuffMenu1:SetAttribute(Cryolysis2.db.profile.MiddleKey.."-type*", "spell")
		Cryo2BuffMenu1:SetAttribute(Cryolysis2.db.profile.MiddleKey.."-spell*", GetSpellInfo(Cryolysis2.Private.SpellId["Molten Armor"]))
	end
	
	-- AI/AB
	Cryo2BuffMenu2Icon:SetTexture("Interface\\Icons\\Spell_Holy_MagicalSentry")
	if Cryolysis2.Private.HasArcaneIntellect then
		Cryo2BuffMenu2:SetAttribute("type1", "spell")
		Cryo2BuffMenu2:SetAttribute("spell1", GetSpellInfo(Cryolysis2.Private.SpellId["Arcane Intellect"]))
	end
	if Cryolysis2.Private.HasArcaneBrilliance then
		Cryo2BuffMenu2:SetAttribute("type2", "spell")
		Cryo2BuffMenu2:SetAttribute("spell2", GetSpellInfo(Cryolysis2.Private.SpellId["Arcane Brilliance"]))
	end
	
	-- Amplify/Dampen
	Cryo2BuffMenu3Icon:SetTexture("Interface\\Icons\\Spell_Nature_AbolishMagic")
	if Cryolysis2.Private.HasDampenMagic then
		Cryo2BuffMenu3:SetAttribute("type1", "spell")
		Cryo2BuffMenu3:SetAttribute("spell1", GetSpellInfo(Cryolysis2.Private.SpellId["Dampen Magic"]))
	end
	
	if Cryolysis2.Private.HasAmplifyMagic then
		Cryo2BuffMenu3:SetAttribute("type2", "spell")
		Cryo2BuffMenu3:SetAttribute("spell2", GetSpellInfo(Cryolysis2.Private.SpellId["Amplify Magic"]))
	end
	
	-- Ice Barrier/Mana Shield
	if Cryolysis2.Private.HasIceBarrier then
		Cryo2BuffMenu4:SetAttribute("type1", "spell")
		Cryo2BuffMenu4:SetAttribute("spell1", GetSpellInfo(Cryolysis2.Private.SpellId["Ice Barrier"]))
		Cryo2BuffMenu4Icon:SetTexture("Interface\\Icons\\Spell_Ice_Lament")
	else
		Cryo2BuffMenu4:SetAttribute("type1", "spell")
		Cryo2BuffMenu4:SetAttribute("spell1", GetSpellInfo(Cryolysis2.Private.SpellId["Mana Shield"]))
		Cryo2BuffMenu4Icon:SetTexture("Interface\\Icons\\Spell_Shadow_DetectLesserInvisibility")
	end
	
	if Cryolysis2.Private.HasManaShield then
		Cryo2BuffMenu4:SetAttribute("type2", "spell")
		Cryo2BuffMenu4:SetAttribute("spell2", GetSpellInfo(Cryolysis2.Private.SpellId["Mana Shield"]))
	end
	
	-- Fire/Frost Ward
	Cryo2BuffMenu5Icon:SetTexture("Interface\\Icons\\Spell_Fire_FireArmor")
	if Cryolysis2.Private.HasFireWard then
		Cryo2BuffMenu5:SetAttribute("type1", "spell")
		Cryo2BuffMenu5:SetAttribute("spell1", GetSpellInfo(Cryolysis2.Private.SpellId["Fire Ward"]))
	end
	
	if Cryolysis2.Private.HasFrostWard then
		Cryo2BuffMenu5:SetAttribute("type2", "spell")
		Cryo2BuffMenu5:SetAttribute("spell2", GetSpellInfo(Cryolysis2.Private.SpellId["Frost Ward"]))
	end
	
	-- Remove Lesser Curse
	Cryo2BuffMenu6Icon:SetTexture("Interface\\Icons\\Spell_Nature_RemoveCurse")
	if Cryolysis2.Private.HasRemoveCurse then
		Cryo2BuffMenu6:SetAttribute("type*", "spell")
		Cryo2BuffMenu6:SetAttribute("spell*", GetSpellInfo(Cryolysis2.Private.SpellId["Remove Lesser Curse"]))
	end
	
	-- Slow Fall
	Cryo2BuffMenu7Icon:SetTexture("Interface\\Icons\\Spell_Magic_FeatherFall")
	if Cryolysis2.Private.HasSlowFall then
		Cryo2BuffMenu7:SetAttribute("type*", "spell")
		Cryo2BuffMenu7:SetAttribute("spell*", GetSpellInfo(Cryolysis2.Private.SpellId["Slow Fall"]))
	end
end