local L = LibStub("AceLocale-3.0"):GetLocale("Cryolysis2")
local Cryolysis2 = LibStub("AceAddon-3.0"):GetAddon("Cryolysis2")
 
------------------------------------------------------------------------------------------------------
-- Update properties of the left button
------------------------------------------------------------------------------------------------------
function Cryolysis2:UpdateBottomButton(click)

	local actionName, ID, BottomTex

	if click == 1 then
		actionName = Cryolysis2.db.profile.BottomSpellLeft
	end
	if click == 2 then
		actionName = Cryolysis2.db.profile.BottomSpellRight
	end
	if click == 3 then
		actionName = Cryolysis2.db.profile.BottomSpellMid
	end

	-- Workaround for this not being set properly by the other function
	Cryo2BottomCustomButton:SetAttribute("*type*", Cryolysis2.db.profile.BottomCustomButtonType)
	
	if actionName == nil or actionName == "" then
		if click == 1 then
			Cryo2BottomCustomButtonIcon:SetTexture(nil)
		end
		Cryo2BottomCustomButton:SetAttribute(Cryolysis2.db.profile.BottomCustomButtonType..click, actionName)
	else
		if Cryolysis2.db.profile.BottomCustomButtonType == "spell" then
			ID = Cryolysis2:FindSpellID(""..actionName, BOOKTYPE_SPELL)
			if ID > 0 then
				BottomTex = GetSpellTexture(ID, BOOKTYPE_SPELL)
			else
				Cryolysis2:Print(L["Invalid name, please check your spelling and try again!"])
				return false;
			end
		end
		if Cryolysis2.db.profile.BottomCustomButtonType == "macro" then
			ID = GetMacroIndexByName(actionName)
			if ID > 0 then
				_, BottomTex = GetMacroInfo(ID)
			else
				Cryolysis2:Print(L["Invalid name, please check your spelling and try again!"])
				return false;
			end
		end
		if Cryolysis2.db.profile.BottomCustomButtonType == "item" then
			if GetItemInfo(actionName) then
				_, _, _, _, _, _, _, _, _, BottomTex = GetItemInfo(actionName)
			else
				Cryolysis2:Print(L["Invalid name, please check your spelling and try again!"])
				return false;
			end
		end

		if click == 1 then
			Cryo2BottomCustomButtonIcon:SetTexture(BottomTex)
		end
		Cryo2BottomCustomButton:SetAttribute(Cryolysis2.db.profile.BottomCustomButtonType..click, actionName)
		if click == 3 then
			Cryo2BottomCustomButton:SetAttribute("alt-"..Cryolysis2.db.profile.BottomCustomButtonType.."*", "")
			Cryo2BottomCustomButton:SetAttribute("shift-"..Cryolysis2.db.profile.BottomCustomButtonType.."*", "")
			Cryo2BottomCustomButton:SetAttribute("ctrl-"..Cryolysis2.db.profile.BottomCustomButtonType.."*", "")
			
			Cryo2BottomCustomButton:SetAttribute(Cryolysis2.db.profile.MiddleKey.."-"..Cryolysis2.db.profile.BottomCustomButtonType.."*", actionName)
		end
	end
end