﻿------------------------------------------------------------------------------------------------------
-- Initialise the addon and required libraries
------------------------------------------------------------------------------------------------------
--local waterfall = AceLibrary("Waterfall-1.0")

------------------------------------------------------------------------------------------------------
-- Initialise the variable we will be working with
------------------------------------------------------------------------------------------------------
Cryolysis2 = LibStub("AceAddon-3.0"):NewAddon("Cryolysis2", "AceConsole-3.0", "AceEvent-3.0", "AceTimer-3.0"--[[, "LibBars-1.0"]])
local L = LibStub("AceLocale-3.0"):GetLocale("Cryolysis2")

------------------------------------------------------------------------------------------------------
-- What happens when the addon is first loaded
------------------------------------------------------------------------------------------------------
function Cryolysis2:OnInitialize()
	
	-- Create defaults
	Cryolysis2:CreateDefaults();
		
	-- Register the database
	Cryolysis2.db = LibStub("AceDB-3.0"):New("Cryolysis2DB", Cryolysis2.defaults, "Default")
	
	-- Create various variables
	Cryolysis2:CreatePrivateVars();
	Cryolysis2:CreateOptions();
	Cryolysis2:CreateMounts();
	
	-- Register these created variables
   
	local config = LibStub("AceConfig-3.0")
	local dialog = LibStub("AceConfigDialog-3.0")
	local registered = false;

	local options

	SLASH_CRYOLYSIS1 = "/cryolysis"
	SLASH_CRYOLYSIS2 = "/cryolysis2"
	SLASH_CRYOLYSIS3 = "/cryo"
	SLASH_CRYOLYSIS4 = "/cryo2"
	SlashCmdList["CRYOLYSIS"] = function(msg)
		if not registered then
			options = options or Cryolysis2.options
			config:RegisterOptionsTable("Cryolysis", options)
			dialog:SetDefaultSize("Cryolysis", 600, 500)
			registered = true
		end

		dialog:Open("Cryolysis")
	end

	local build = select(2, GetBuildInfo())
	if tonumber(build) > 8000 then
		local hijack = CreateFrame("Frame", nil, InterfaceOptionsFrame)
		hijack:SetScript("OnShow", function()
			hijack:Hide()
			options = Cryolysis2.options;

			config:RegisterOptionsTable("Cryolysis-Bliz", {
				name = "Cryolysis",
				type = "group",
				args = {
					help = {
						type = "description",
						name = "Cryolysis is an all-purpose Mage AddOn.",
					},
				},
			})
			dialog:SetDefaultSize("Cryolysis-Bliz", 600, 400)
			dialog:AddToBlizOptions("Cryolysis-Bliz", "Cryolysis")


			-- General Options
			config:RegisterOptionsTable("Cryolysis-General", options.args.gen)
			dialog:AddToBlizOptions("Cryolysis-General", options.args.gen.name, "Cryolysis")
			
			-- Auto Restock Options
			config:RegisterOptionsTable("Cryolysis-AutoRestock", options.args.autorestock)
			dialog:AddToBlizOptions("Cryolysis-AutoRestock", options.args.autorestock.name, "Cryolysis")

			-- Timer Options
			config:RegisterOptionsTable("Cryolysis-Timer", options.args.timersettings)
			dialog:AddToBlizOptions("Cryolysis-TimerSettings", options.args.timersettings.name, "Cryolysis")

			-- Message Options
			config:RegisterOptionsTable("Cryolysis-Message", options.args.messagesettings)
			dialog:AddToBlizOptions("Cryolysis-Message", options.args.messagesettings.name, "Cryolysis")

			-- Button Options
			config:RegisterOptionsTable("Cryolysis-Button", options.args.graphicalsettings)
			dialog:AddToBlizOptions("Cryolysis-Button", options.args.graphicalsettings.name, "Cryolysis")
			
			-- Profile Options
			local p_options = options.args.profile.args.options
			config:RegisterOptionsTable("Cryolysis-Profiles-Options", p_options)
			dialog:AddToBlizOptions("Cryolysis-Profiles-Options", p_options.name, "Cryolysis")
		end
		)
	end


	--[[
	LibStub("AceConfig-3.0"):RegisterOptionsTable("Cryolysis2", Cryolysis2.options)
	Cryolysis2.optionsFrame = LibStub("AceConfigDialog-3.0"):AddToBlizOptions("Cryolysis2", "Cryolysis 2")
	LibStub("AceConfig-3.0"):RegisterOptionsTable("Cryolysis2", Cryolysis2.options, "cryolysis")
	]]
	
	--Cryolysis2:RegisterChatCommand("cryolysis", "ChatCommand")
	--Cryolysis2:RegisterChatCommand("cryo", "ChatCommand")
	--Cryolysis2:RegisterDefaults("profile", Cryolysis2.defaults)
	
	-- Enable the addon
	--Cryolysis2:ToggleActive(true);
end

------------------------------------------------------------------------------------------------------
-- What happens when the addon is enabled
------------------------------------------------------------------------------------------------------
function Cryolysis2:OnEnable()
	-- Register various events
	Cryolysis2:RegisterEvents();
    Cryolysis2:StartUp()

	--Cryolysis2:PLAYER_ENTERING_WORLD() -- Inefficient, but allows the class check to work properly
end

------------------------------------------------------------------------------------------------------
-- What happens when the addon is disabled
------------------------------------------------------------------------------------------------------
function Cryolysis2:OnDisable()

	local f;

	Cryo2MainSphere:Hide();

	for i = 1, #(Cryolysis2.db.profile.Buttons), 1 do
		f = getglobal(Cryolysis2.db.profile.Buttons[i])
		f:Hide()
	end
	for i = 1, #(Cryolysis2.Private.BuffMenu), 1 do
		f = getglobal(Cryolysis2.Private.BuffMenu[i])
		f:Hide()
	end
	for i = 1, #(Cryolysis2.Private.GemMenu), 1 do
		f = getglobal(Cryolysis2.Private.GemMenu[i])
		f:Hide()
	end

	for i = 1, #(Cryolysis2.Private.PortMenu), 1 do
		f = getglobal(Cryolysis2.Private.PortMenu[i])
		f:Hide()
	end

end