TITAN_CRITLINEPET_ID = "CritlinePet";
----------------------------------------------------------------
function TitanPanelCritlinePetButton_OnLoad()
	this.registry = {
		id = TITAN_CRITLINEPET_ID,
		category = "Combat",
		version = CRITLINE_VERSION,
		menuText = "Critline Pet",
		buttonTextFunction = "TitanPanelCritlinePetButton_GetButtonText", 
		tooltipTitle = "Critline Pet", 
		tooltipTextFunction = "TitanPanelCritlinePetButton_GetTooltipText",
		icon = "Interface\\AddOns\\Critline\\Icons\\CritlinePet",	
		iconWidth = 16,
		savedVariables = {
			ShowIcon = 1,
			ShowLabelText = 1,
			ShowColoredText = 1,
		}
	};

	--Subscribe to Critline_OnUpdate event.
	Critline_OnUpdateRegister(TitanPanelCritlinePetButton_OnUpdate);
end
----------------------------------------------------------------
function TitanPanelCritlinePetButton_OnClick(button)
	if CritlineSettings_Frame:IsVisible() then
		CritlineSettings_Frame:Hide();
	else
		CritlineSettings_Frame:Show();
	end
end
----------------------------------------------------------------
function TitanPanelCritlinePetButton_GetButtonText(id)
	labelText = "P: ";
	local amountcrit = Critline_Color(HEADER_TEXT_COLOR,Critline_GetHighest("PET", "CRIT"));
	local amountnorm = Critline_Color(HEADER_TEXT_COLOR,Critline_GetHighest("PET", "NORM"));
	rtfText = amountnorm.."/"..amountcrit;
	return labelText, rtfText;
end
----------------------------------------------------------------
function TitanPanelCritlinePetButton_GetTooltipText()
    return Critline_GetSummaryRichText("PET");
end
----------------------------------------------------------------
function TitanPanelRightClickMenu_PrepareCritlinePetMenu()
	TitanPanelRightClickMenu_AddTitle(TitanPlugins[TITAN_CRITLINEPET_ID].menuText);
	TitanPanelRightClickMenu_AddToggleIcon(TITAN_CRITLINEPET_ID);
	TitanPanelRightClickMenu_AddToggleLabelText(TITAN_CRITLINEPET_ID);
	TitanPanelRightClickMenu_AddToggleColoredText(TITAN_CRITLINEPET_ID);
	
	TitanPanelRightClickMenu_AddSpacer();
	TitanPanelRightClickMenu_AddCommand("Settings", TITAN_CRITLINEPET_ID, "CritlineSettings_ShowSettings");
	TitanPanelRightClickMenu_AddSpacer();
	TitanPanelRightClickMenu_AddCommand(TITAN_PANEL_MENU_HIDE, TITAN_CRITLINEPET_ID, TITAN_PANEL_MENU_FUNC_HIDE);
end
----------------------------------------------------------------
--This is the callback method Critline_OnUpdate will call when Critline DB has been updated.
function TitanPanelCritlinePetButton_OnUpdate()
	TitanPanelButton_UpdateButton(TITAN_CRITLINEPET_ID)
end