TITAN_CRITLINEHEAL_ID = "CritlineHeal";
----------------------------------------------------------------
function TitanPanelCritlineHealButton_OnLoad()
	this.registry = {
		id = TITAN_CRITLINEHEAL_ID,
		category = "Combat",
		version = CRITLINE_VERSION,
		menuText = "Critline Heal",
		buttonTextFunction = "TitanPanelCritlineHealButton_GetButtonText", 
		tooltipTitle = "Critline Heal", 
		tooltipTextFunction = "TitanPanelCritlineHealButton_GetTooltipText",
		icon = "Interface\\AddOns\\Critline\\Icons\\CritlineHeal",	
		iconWidth = 16,
		savedVariables = {
			ShowIcon = 1,
			ShowLabelText = 1,
			ShowColoredText = 1,
		}
	};	
	--Subscribe to Critline_OnUpdate event.
	Critline_OnUpdateRegister(TitanPanelCritlineHealButton_OnUpdate);
end
----------------------------------------------------------------
function TitanPanelCritlineHealButton_OnClick(button)
	if CritlineSettings_Frame:IsVisible() then
		CritlineSettings_Frame:Hide();
	else
		CritlineSettings_Frame:Show();
	end
end
----------------------------------------------------------------
function TitanPanelCritlineHealButton_GetButtonText(id)
	labelText = "H: ";
	local amountcrit = Critline_Color(HEADER_TEXT_COLOR,Critline_GetHighest("HEAL", "CRIT"));
	local amountnorm = Critline_Color(HEADER_TEXT_COLOR,Critline_GetHighest("HEAL", "NORM"));
	rtfText = amountnorm.."/"..amountcrit;
	return labelText, rtfText;
end
----------------------------------------------------------------
function TitanPanelCritlineHealButton_GetTooltipText()
    return Critline_GetSummaryRichText("HEAL");
end
----------------------------------------------------------------
function TitanPanelRightClickMenu_PrepareCritlineHealMenu()
	TitanPanelRightClickMenu_AddTitle(TitanPlugins[TITAN_CRITLINEHEAL_ID].menuText);
	TitanPanelRightClickMenu_AddToggleIcon(TITAN_CRITLINEHEAL_ID);
	TitanPanelRightClickMenu_AddToggleLabelText(TITAN_CRITLINEHEAL_ID);
	TitanPanelRightClickMenu_AddToggleColoredText(TITAN_CRITLINEHEAL_ID);
	
	TitanPanelRightClickMenu_AddSpacer();
	TitanPanelRightClickMenu_AddCommand("Settings", TITAN_CRITLINEHEAL_ID, "CritlineSettings_ShowSettings");
	TitanPanelRightClickMenu_AddSpacer();
	TitanPanelRightClickMenu_AddCommand(TITAN_PANEL_MENU_HIDE, TITAN_CRITLINEHEAL_ID, TITAN_PANEL_MENU_FUNC_HIDE);
end
----------------------------------------------------------------
--This is the callback method Critline_OnUpdate will call when Critline DB has been updated.
function TitanPanelCritlineHealButton_OnUpdate()
	TitanPanelButton_UpdateButton(TITAN_CRITLINEHEAL_ID)
end